#include "Graph_subgraph.h"

void initiate_Supertig_bank( Graph_bank &tig_bank, Supertig_bank &bank )
{
	bank.Supertig_Set = tig_bank.tigset;
	map< Tig_id, Tig >::iterator Ite;
	for ( Ite = tig_bank.tigmap.begin(); Ite != tig_bank.tigmap.end(); ++Ite ) {
		Supertig suptig;
		suptig.length = Ite->second.len;
		suptig.single_tig = true;
		bank.Supertig_Map.insert( make_pair( Ite->first, suptig ) );
	}

	map< Tig_id, Tig_Edge_Link >::iterator Ite_edgemap;
	for ( Ite_edgemap = tig_bank.edge_map.begin(); Ite_edgemap != tig_bank.edge_map.end(); ++Ite_edgemap ) {
		Supertig_Overlap_Link ov_link;
		ov_link.head_links = Ite_edgemap->second.head_links;
		ov_link.Head_Id_Ov_Ma = Ite_edgemap->second.Head_Id_Ov_Ma;
		ov_link.tail_links = Ite_edgemap->second.tail_links;
		ov_link.Tail_Id_Ov_Ma = Ite_edgemap->second.Tail_Id_Ov_Ma;
		bank.Supertig_Overlap_Link_Map.insert( make_pair( Ite_edgemap->first, ov_link ) );
	}

	map< Mate_gap_id, Mate_Gap >::iterator Ite_mate;
	for ( Ite_mate = tig_bank.Mate_gap_map.begin(); Ite_mate != tig_bank.Mate_gap_map.end(); ++Ite_mate ) {
		Scaffold_Gap scf;
		scf.drct_type = Ite_mate->second.drct_type;
		scf.ida = Ite_mate->second.ida;
		scf.idb = Ite_mate->second.idb;
		scf.lowb = Ite_mate->second.lowb;
		scf.upb = Ite_mate->second.upb;
		scf.mean = Ite_mate->second.mean;
		scf.len_ve = Ite_mate->second.len_ve;
		
	}

	bank.Pair_Scaffold_map = tig_bank.Pair_mates;
	bank.tig_len = tig_bank.tig_len;
}

Forb Supertig::gettigforb( Supertig_id id ) 
{
	size_t vsize = Tig_Ve.size();
	for ( size_t i = 0; i < vsize; ++i ) {
		for ( size_t j = 0; j < Tig_Ve[i].size(); ++j ) {
			if ( id == Tig_Ve[i][j] ) {
				return Tig_F_Ve[i][j];
			}
		}
	}
	return -1;
}

pair< int, int > Supertig::gettigpos( Supertig_id id )
{
	size_t vsize = Tig_Ve.size();
	for ( size_t i = 0; i < vsize; ++i ) {
		for ( size_t j = 0; j < Tig_Ve[i].size(); ++j ) {
			if ( id == Tig_Ve[i][j] ) {
				return Tig_P_Ve[i][j];
			}
		}
	}
	pair<int, int> nulp;
	return nulp;
}

bool Supertig::tigfind( Supertig_id id )
{
	size_t vsize = Tig_Ve.size();
	for ( size_t i = 0; i < vsize; ++i ) {
		for ( size_t j = 0; j < Tig_Ve[i].size(); ++j ) {
			if ( id == Tig_Ve[i][j] ) {
				return true;
			}
		}
	}
	return false;
}

Supertig_id Supertig::getfrontid()
{
	return Tig_Ve[0][0];
}

Forb Supertig::getfrontforb()
{
	return Tig_F_Ve[0][0];
}

pair<int,int> Supertig::getfrontpos()
{
	return Tig_P_Ve[0][0];
}

Supertig_id Supertig::getbackid()
{
	size_t vesize = Tig_Ve.size();
	size_t subvesize = Tig_Ve[vesize-1].size();
	return Tig_Ve[vesize-1][subvesize-1];
}

Forb Supertig::getbackforb()
{
	size_t vesize = Tig_Ve.size();
	size_t subvesize = Tig_Ve[vesize-1].size();
	return Tig_F_Ve[vesize-1][subvesize-1];
}

pair< int, int > Supertig::getbackpos()
{
	size_t vesize = Tig_Ve.size();
	size_t subvesize = Tig_Ve[vesize-1].size();
	return Tig_P_Ve[vesize-1][subvesize-1];
}

void bulb_bridge::calculate_gap_length( Supertig &tig )
{
	if ( Left_lk_len == 0 || Right_lk_len == 0 )
		return;
	int va = tig.length - Left_lk_len - Right_lk_len;
	if ( va < 0 ) {
		cerr << "Warning in bulb_bridge::calculate_gap_length: length < 0 !"<<endl;
	//	return;
	}

	gap_length = va;
}

bool Supertig::gettigpath( vector< pair< Supertig_id, Forb > > &pathve )
{
	if ( bubble )
		return false;

	size_t vesize = Tig_Ve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		pathve.push_back( make_pair( Tig_Ve[i][0], Tig_F_Ve[i][0] ) );
	}
	return true;
}

bool Supertig::gettigset( set< Supertig_id > &tigset )
{
	size_t vesize = Tig_Ve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		tigset.insert( Tig_Ve[i][0] );
	}
	return true;
}

bool Supertig::getrelposfromtig( Supertig_id ida, Supertig_id idb, Forb fba, Forb fbb, pair< int, int > &pos )
{
	if ( !tigfind( ida ) || !tigfind( idb ) )
		return false;
	
	pair< int, int > posa = gettigpos( ida );
	pair< int, int > posb = gettigpos( idb );
	if ( gettigforb( ida ) == fba ) {
		
		pos.first = posb.first - posa.second;
		pos.second = posb.second - posa.second;
		
	} else {
		pos.first = posa.first - posb.second;
		pos.second = posa.first - posb.first;
		
	}

	
	return true;
	
}

bool Supertig::gettigpath( list< pair< Supertig_id, Forb > > &pathve )
{
	if ( bubble )
		return false;

	size_t vesize = Tig_Ve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		pathve.push_back( make_pair( Tig_Ve[i][0], Tig_F_Ve[i][0] ) );
	}
	return true;
}

void Scaffold_Gap::calculate_conf()
{
	set< Supertig_id > len_set;
	for ( size_t i = 0; i < len_ve.size(); ++i ) {
		len_set.insert( len_ve[i] );
	}
	conf = (int)len_set.size();
}

void Supertig_bank::backup_ovlkmap()
{
	fdm_ovlkmap = Supertig_Overlap_Link_Map;
	
}

void Supertig_bank::backup_scf()
{
	Basic_Scaffold_map = Scaffold_map;
	Basic_Pair_Scaffold_map = Pair_Scaffold_map;



}

void Supertig_bank::backup_singletig()
{
	map< Supertig_id, Supertig >::iterator Ite;
	for ( Ite = Supertig_Map.begin(); Ite != Supertig_Map.end(); ++Ite ) {
		
		Single_tig_Set.insert( Ite->first );
	}
}

void Supertig_bank::backup_basictig()
{
	map< Supertig_id, Supertig >::iterator Ite;
	for ( Ite = Supertig_Map.begin(); Ite != Supertig_Map.end(); ++Ite ) {
		Basic_tig_set.insert( Ite->first );
		
	}
}

void mark_recur_tig( Supertig_id id, Supertig_bank &tig_bank )
{
	if ( tig_bank.Supertig_Map[id].single_tig ) {
		tig_bank.Supertig_Map[id].recurrence = true;
	} else {
		size_t vesize = tig_bank.Supertig_Map[id].Tig_Ve.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			for ( size_t k = 0; k < tig_bank.Supertig_Map[id].Tig_Ve[i].size(); ++k ) {
				mark_recur_tig( tig_bank.Supertig_Map[id].Tig_Ve[i][k], tig_bank );
			}
		}
	}
}

int cal_bulbbridgelen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap )
{
	int val = 0;
	map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
	int maxleft = 0;
	int maxright = 0;
	int maxgap = 0;
	
	for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
		if ( Ite->second.Left_lk_len > maxleft )
			maxleft = Ite->second.Left_lk_len;
		if ( Ite->second.Right_lk_len > maxright )
			maxright = Ite->second.Right_lk_len;
		if ( Ite->second.gap_length > maxgap )
			maxgap = Ite->second.gap_length;
		
	}
	if ( maxgap == 0 )
		return 0;

	val = maxleft + maxright + maxgap;
	
	return val;
}


int cal_bulbbridgelen_fr_tig( map< pair< Supertig_id, Forb >, Bridge > &bridgemap, Supertig_bank &tig_bank )
{
	int val = 0;
	int maxleft = 0;
	int maxright = 0;
	map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
	for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
		if ( Ite->second.Left_lk_len > maxleft )
			maxleft = Ite->second.Left_lk_len;
		if ( Ite->second.Right_lk_len > maxright )
			maxright = Ite->second.Right_lk_len;
	}

	if ( maxleft == 0 && maxright == 0 ) {
		for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
			if ( tig_bank.Supertig_Map[Ite->first.first].length > val )
				val = tig_bank.Supertig_Map[Ite->first.first].length;
		}
		return val;
	} else if ( maxleft == 0 && maxright > 0 ) {
		int maxbody = 0;
		for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
			int body = tig_bank.Supertig_Map[Ite->first.first].length - Ite->second.Right_lk_len;
			if ( body > maxbody )
				maxbody = body;
		}
		return maxbody + maxright;
	} else if ( maxleft > 0 && maxright == 0 ) {
		int maxbody = 0;
		for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
			int body = tig_bank.Supertig_Map[Ite->first.first].length - Ite->second.Left_lk_len;
			if ( body > maxbody )
				maxbody = body;
		}
		return maxbody + maxleft;
	} else {
		int maxbody = 0;
		for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
			int body = tig_bank.Supertig_Map[Ite->first.first].length - Ite->second.Left_lk_len - Ite->second.Right_lk_len;
			if ( body > maxbody )
				maxbody = body;
		}
		return maxbody + maxleft + maxright;
	}
}

int cal_bulbbridge_left_ovlen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap )
{
	
	map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
	int maxleft = 0;
	
	for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
		if ( Ite->second.Left_lk_len > maxleft )
			maxleft = Ite->second.Left_lk_len;
		
	}
	
	return maxleft;
}

int cal_bulbbridge_right_ovlen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap )
{
	map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
	int maxright = 0;
	
	for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
		if ( Ite->second.Right_lk_len > maxright )
			maxright = Ite->second.Right_lk_len;
		
	}
	
	return maxright;
}

map< pair< Supertig_id, Forb >, Bridge > reversebulbbridgemap( map< pair< Supertig_id, Forb >, Bridge > &bridgemap )
{
	map< pair< Supertig_id, Forb >, Bridge > n_bmap;
	map< pair< Supertig_id, Forb >, Bridge >::iterator Ite;
	for ( Ite = bridgemap.begin(); Ite != bridgemap.end(); ++Ite ) {
		Bridge nb;
		nb = reversebridge( Ite->second );
		n_bmap.insert( make_pair( reversepht( Ite->first ), nb ) );
	}

	return n_bmap;
}

Bridge reversebridge( Bridge &bridge )
{
	Bridge nb;
	nb.b_tig = reversepht( bridge.b_tig );
	nb.Left_lk_len = bridge.Right_lk_len;
	nb.Right_lk_len = bridge.Left_lk_len;
	nb.Left_lk_tig = reversepht( bridge.Right_lk_tig );
	nb.Right_lk_tig = reversepht( bridge.Left_lk_tig );
	nb.cover_area = bridge.cover_area;
	nb.cover_rate = bridge.cover_rate;
	nb.gap_length = bridge.gap_length;
	nb.matehit = bridge.matehit;

	return nb;
}

bool get_back_basic_tig( Supertig_id id, Supertig_bank &tig_bank, pair< Supertig_id, Forb > &backp  )
{
	Supertig_id t_id = -1;
	Forb t_fb = -1;
	t_id = tig_bank.Supertig_Map[id].getbackid();
	t_fb = tig_bank.Supertig_Map[id].getbackforb();
	while ( tig_bank.Basic_tig_set.find( t_id ) == tig_bank.Basic_tig_set.end() ) {
		Supertig_id n_id = -1;
		Forb n_fb = -1;
		if ( t_fb == 0 ) {
			n_id = tig_bank.Supertig_Map[t_id].getbackid();
			n_fb = tig_bank.Supertig_Map[t_id].getbackforb();
		} else {
			n_id = tig_bank.Supertig_Map[t_id].getfrontid();
			n_fb = reverseforb( tig_bank.Supertig_Map[t_id].getfrontforb() );
		}
		if ( n_id == t_id ) {
			return false;
		}
		t_id = n_id;
		t_fb = n_fb;
	}

	backp = make_pair( t_id, t_fb );
	return true;

}

bool get_front_basic_tig( Supertig_id id, Supertig_bank &tig_bank, pair< Supertig_id, Forb > &frontp )
{
	Supertig_id t_id = -1;
	Forb t_fb = -1;
	t_id = tig_bank.Supertig_Map[id].getfrontid();
	t_fb = tig_bank.Supertig_Map[id].getfrontforb();
	while ( tig_bank.Basic_tig_set.find( t_id ) == tig_bank.Basic_tig_set.end() ) {
		Supertig_id n_id = -1;
		Forb n_fb = -1;
		if ( t_fb == 0 ) {
			n_id = tig_bank.Supertig_Map[t_id].getfrontid();
			n_fb = tig_bank.Supertig_Map[t_id].getfrontforb();
		} else {
			n_id = tig_bank.Supertig_Map[t_id].getbackid();
			n_fb = reverseforb( tig_bank.Supertig_Map[t_id].getbackforb() );
		}
		if ( n_id == t_id ) {
			return false;
		}
		t_id = n_id;
		t_fb = n_fb;
	}

	frontp = make_pair( t_id, t_fb );
	return true;
}

