#ifndef GRAPH_SUBGRAPH_H
#define GRAPH_SUBGRAPH_H

#include "Graph_Bank.h"

#include <deque>
#include <vector>


using namespace std;

typedef int Supertig_id;

class Supertig_Overlap_Link
{
public:
	set<pair<Supertig_id, Forb> > head_links;
	set<pair<Supertig_id, Forb> > tail_links;
	map<pair<Supertig_id, Forb>, int > Head_Id_Ov_Ma;
	map<pair<Supertig_id, Forb>, int> Tail_Id_Ov_Ma;
	

};

class Bridge
{
public:
	pair< Supertig_id, Forb > b_tig;
	pair< Supertig_id, Forb > Left_lk_tig;
	pair< Supertig_id, Forb > Right_lk_tig;
	int Left_lk_len;
	int Right_lk_len;
	int gap_length;

	int matehit;    // val == 1,true; val == 0, ambi; val == -1, false
	vector< pair< int, int > > cover_area;       // mate covered area by stem.
	double cover_rate;

	Bridge()
	{
		Left_lk_len = 0;
		Right_lk_len = 0;
		gap_length = 0;
		cover_rate = 0;
	}


	
};

class Supertig
{
public:
	// first dimension store the element in series(´®j), second dimension store the elements in parallel(²¢j).
	// one supertig is either in series or in paraller. that means the tigs is in one dimension, either (1, x) or (x, 1).
	vector< vector< Supertig_id > > Tig_Ve;              // tig ve in order                   
	Tig_id tig_s;                                        // exist if it is the single tig
	bool single_tig;                                     // single tig or not 
//	bool simple_bubble;                                  // simple bubble or not
	bool recurrence;                                     // assemblerd in more supertigs or not
	bool bubble;                                         // bubble or not
	bool series;                                         // series or not
	bool allseries;                                      // series all subtig is single
	bool bulbin;                                         // series but the subtig has bulb
	int hangingmate;                                    // have mate hit not matched
	
	vector< vector< Forb > > Tig_F_Ve;                   // Forb
	vector< vector< pair< int, int > > > Tig_P_Ve;       // Position
	int length;

	bool Structed;        // final structed supertig

	Supertig()
	{
		single_tig = false;
	//	simple_bubble = false;
		recurrence = false;
		bubble = false;
		series = false;
		Structed = false;
		allseries = false;
		bulbin = false;
		hangingmate = 0;

	}

	set< size_t > branch_tig;                            // for component tig which has branch off the supertig.
	map< size_t, map< pair< Supertig_id, Forb >, Bridge > > bulbmap;

	int semi_bulb;                                       // val == 1 if it is true.

	int resvcutlink;                                     // val == 1 if it has Resv_Cut_link.
	Supertig_Overlap_Link Resv_Cut_link;                 // Cut spurious link before it merged into another supertig

	Supertig_Overlap_Link super_checked_Link;            // ambiguity link. 

	Forb gettigforb( Supertig_id id );
	pair< int, int > gettigpos( Supertig_id id );
	bool tigfind( Supertig_id id );

	Supertig_id getfrontid();
	Forb getfrontforb();
	pair< int, int > getfrontpos();

	Supertig_id getbackid();
	Forb getbackforb();
	pair< int, int > getbackpos();

	bool gettigpath( vector< pair< Supertig_id, Forb > > &pathve );     //for series only. if bubble return false.
	bool gettigpath( list< pair< Supertig_id, Forb > > &pathve );
	bool gettigset( set< Supertig_id > &tigset );

	bool getrelposfromtig( Supertig_id ida, Supertig_id idb, Forb fba, Forb fbb, pair< int, int > &pos );     // rel pos of idb to ida.

	/////////////////////for final supertig////////////////////////
	


};

int cal_bulbbridgelen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap );
int cal_bulbbridge_left_ovlen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap );
int cal_bulbbridge_right_ovlen( map< pair< Supertig_id, Forb >, Bridge > &bridgemap );

typedef int Scaffold_gap_id;

class Scaffold_Gap
{
public:
	Supertig_id ida;       // paired id of tig a and b 
	Supertig_id idb;
//	pair<int, int> drct;  // direction of tig a and b:  ( 0,0 ) == ( -->, --> ); ( 0,1 ) == ( -->, <-- ); ( 1,0 ) == ( <--, --> ); ( 1,1 ) == ( <--, <-- )
	int drct_type;        //                                  type 1                    type 2                  type 3                     type 4
	int lowb;             // lower bound of the gap length
	int upb;              // upper bound of the gap length
	int mean;             // mean value of the gap length
	double conf;          // confidance score
	vector< int > len_ve; // this contains all the componant mate pairs' length contributed scaffold gap.
	
	void calculate_conf();
	
};

//    It stores the fished (walked) nodes in the superpath searching 
//    It can warn of the bubbles in the searching process avoiding repetively
//    walking along the same paths as walked before. It can also be useful when
//    doing the bubble assembling.
class fished_bait            
{
public:
	map< pair< Supertig_id, Forb >, set< int > > bait_length_map;             //  the length indecate the distance between the seed and the bait supertig_id.
	map< pair< Supertig_id, Forb >, set< int > > bubble_bait_length_map;      
};

class Scaffold_subset
{
public:
	int gap_length_bound;
	map< Supertig_id, map< Supertig_id, vector< Scaffold_gap_id > > > Pair_map;
	set< Supertig_id > incomplete_paired_id;    // some paired scaffolds may be out of this subset. it is useful when caculating spurious branchs. 
	set< Supertig_id > seeds;
	map< pair< Supertig_id, Forb >, fished_bait > seed_bait_map;
	vector< list< pair< Supertig_id, Forb > > > superpath;
};

class subgraph
{
public:
	map< Supertig_id, Supertig_Overlap_Link > Supertig_Overlap_Link_Map;
	set< pair<Supertig_id, Forb> > brink_set;

//	map< Supertig_id, Supertig_Overlap_Link > fdm_ovlkmap;

	map< Supertig_id, Supertig_Overlap_Link > Strong_ovlkmap;
	map< Supertig_id, Supertig_Overlap_Link > Week_ovlkmap;

	vector< list< pair< Supertig_id, Forb > > > circles_subpath;

	Scaffold_subset scf_s;
//	vector< list< pair< Supertig_id, Forb > > > superpath;
	set< Supertig_id > active_tig;                   // i.e. the tig still in the graph, i.e. not merged in another supertig.  As the graph updates, it updates simultaneously.
	
	 
};

class repeat_domain
{
public:
	vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > traverse_path;
	set< pair< Supertig_id, Forb > > left_branch;
	set< pair< Supertig_id, Forb > > right_branch;
};

class bulb_bridge:public Bridge
{
public:


	bulb_bridge()
	{
		Left_lk_len = 0;
		Right_lk_len = 0;
		gap_length = 0;
	} 


	void calculate_gap_length( Supertig &tig );
};

class graph_bulb
{
public:
	map< pair< Supertig_id, Forb >, bulb_bridge > bridgemap;
};

class Supertig_bank
{
public:
	map< Supertig_id, Supertig > Supertig_Map;
	set< Supertig_id > Supertig_Set;

	map< Supertig_id, map< Supertig_id, vector< Scaffold_gap_id > > > Pair_Scaffold_map;           // some supertig pairs may have more than one scaffold forms.
	map< Scaffold_gap_id, Scaffold_Gap > Scaffold_map;
	map< Supertig_id, Supertig_Overlap_Link > Supertig_Overlap_Link_Map;

	set< Supertig_id > Basic_tig_set;
	map< Scaffold_gap_id, Scaffold_Gap > Basic_Scaffold_map;
	map< Supertig_id, map< Supertig_id, vector< Scaffold_gap_id > > > Basic_Pair_Scaffold_map; 
	map< Supertig_id, Supertig_Overlap_Link > fdm_ovlkmap;
	set< Supertig_id > Single_tig_Set;

	set< Supertig_id > inner_active_tig;                 // the used component tig in the structured supertig (i.e. contain bulb)

	set< Supertig_id > Structed_supertig;

	set< Supertig_id > breaked_tig;

	set< Supertig_id > bigbulb;

	set< Supertig_id > active_tig;

	set< Supertig_id > newly_transfered_tig;          // transfer bulb to series;

	vector< list< pair< Supertig_id, Forb > > > final_path;
	vector< list< pair< Supertig_id, Forb > > > con_pathve;
	vector< vector< list< pair< Supertig_id, Forb > > > > broken_pathve;
	vector< vector< pair< pair< Supertig_id, Forb >, pair< Supertig_id, Forb > > > > broken_p_ve;
	vector< vector< int > > broken_gap_ve;

	void backup_ovlkmap();
	void backup_scf();
	void backup_singletig();
	void backup_basictig();
	int tig_len;
	int mate_len;
	int mate_var;
	int min_stem_lenthr_opt;
	int max_path_len_opt;
	double min_cover_rate_opt;
//	int scf_gap_mean;
//	int scf_gap_upb;

	map< Supertig_id, Supertig_Overlap_Link > Strong_link;
	map< Supertig_id, Supertig_Overlap_Link > gray_link;
	set< Scaffold_gap_id > scfset;
	set< Supertig_id > bridge_id;

};

//void initiate_Supertig_bank( Graph_bank &tig_bank );

void mark_recur_tig( Supertig_id id, Supertig_bank &tig_bank );

int cal_bulbbridgelen_fr_tig( map< pair< Supertig_id, Forb >, Bridge > &bridgemap, Supertig_bank &tig_bank );

map< pair< Supertig_id, Forb >, Bridge > reversebulbbridgemap( map< pair< Supertig_id, Forb >, Bridge > &bridgemap );

Bridge reversebridge( Bridge &bridge );

bool get_back_basic_tig( Supertig_id id, Supertig_bank &tig_bank, pair< Supertig_id, Forb > &backp );
bool get_front_basic_tig( Supertig_id id, Supertig_bank &tig_bank, pair< Supertig_id, Forb > &frontp );


#endif

