#include "Graph_superpath.h"
#include <iostream>

void Supath_find( map< Supertig_id, Supertig_Overlap_Link > &ov_link, Scaffold_subset &scf_s, subgraph &graph_t, Supertig_bank &bank )
{
	int max_ovlen = bank.tig_len;
	set< Supertig_id >::iterator Ite;
	for ( Ite = scf_s.seeds.begin(); Ite != scf_s.seeds.end(); ++Ite ) {

	
		
		map< pair< Supertig_id, Forb >, int > seed_max_gap;
		get_max_gap_len( *Ite, seed_max_gap, scf_s, bank );

		
		pair< Supertig_id, Forb > seed_f = make_pair( *Ite, 0 );
		if ( seed_max_gap.find( seed_f ) != seed_max_gap.end() ) {
			vector< pair < list< pair< Supertig_id, Forb > >, list< int>  > > pl_t;
			map< pair< Supertig_id, Forb >, vector<int> > abd_node;
			int max_elon_len = seed_max_gap[seed_f] + max_ovlen;
		
			if ( path_elg( pl_t, ov_link, seed_f, 0, seed_max_gap[seed_f], max_elon_len, seed_f, abd_node, scf_s, bank ) ) {
				for ( size_t i = 0; i < pl_t.size(); ++i ) {
					list< pair< Supertig_id, Forb > > pl = pl_t[i].first;
					pl.push_front( seed_f );
				
					scf_s.superpath.push_back( pl );

				}
			}
		} 

		pair< Supertig_id, Forb > seed_b = make_pair( *Ite, 1 );
		if ( seed_max_gap.find( seed_b ) != seed_max_gap.end() ) {
			vector< pair < list< pair< Supertig_id, Forb > >, list< int>  > > pl_t;
			map< pair< Supertig_id, Forb >, vector<int> > abd_node;
			int max_elon_len = seed_max_gap[seed_b] + max_ovlen;
		
			if ( path_elg( pl_t, ov_link, seed_b, 0, seed_max_gap[seed_b], max_elon_len, seed_b, abd_node, scf_s, bank ) ) {
				for ( size_t i = 0; i < pl_t.size(); ++i ) {
					list< pair< Supertig_id, Forb > > pl = pl_t[i].first;
					pl.push_front( seed_b );
				
					scf_s.superpath.push_back( pl );
				}
			}
		} 
	
	
	}


	if ( !scf_s.superpath.empty() ) {
		reduceredunpl_t( scf_s.superpath );
		reduce_circle_in_superpath( scf_s.superpath, graph_t );
		reduceredunpl_t( scf_s.superpath );
	}

	simplify_baitmap( scf_s );

	int var_len = bank.tig_len;
	adjust_bulb_baitmap( scf_s, graph_t, bank, var_len );

}


bool path_elg( vector< pair < list< pair< Supertig_id, Forb > >, list< int>  > > &pl_t,
			  map< Supertig_id, Supertig_Overlap_Link > &lmap, 
			  pair< Supertig_id, Forb > prep, 
			  int inelen,
			  int max_gap_len,
			  int max_elon_len,
			  pair< Supertig_id, Forb > seed,
			  map< pair< Supertig_id, Forb >, vector<int> >& abd_node,
			  Scaffold_subset &scf_s, 
			  Supertig_bank &bank )
{
	int var_len = max( bank.tig_len, 500 );
	pl_t.clear();
	int elen = inelen;
	int gap_len = 0;
	
	if( prep.second == 0) {
		set< pair< Supertig_id, Forb > >::iterator Iteh;
		for ( Iteh = lmap[prep.first].head_links.begin(); Iteh != lmap[prep.first].head_links.end(); ++Iteh ) {
			pair< Supertig_id, Forb > tp = *Iteh;
			int ovlen = lmap[prep.first].Head_Id_Ov_Ma[tp];
			elen = inelen + bank.Supertig_Map[tp.first].length - ovlen;
			int elengap = inelen - ovlen;


			//   if the tp has been fished before, i.e. be found in the bait class, then it has formed a bubble, and the remaining 
			//   paths is not necessary to go on to walk along.
			if ( bait_check( seed, reversepht( tp ), scf_s, elengap, var_len ) ) {
				scf_s.seed_bait_map[seed].bubble_bait_length_map[reversepht( tp )].insert( elengap );

				list< pair< int, int > > pl;
				pl.push_back( reversepht( tp ) );
				
				list< int > ovl;
				ovl.push_back( ovlen );

				vector<pair<list<pair<int, int> >, list<int> > > plv;
				plv.push_back( make_pair( pl, ovl ) );

				pl_t.insert( pl_t.end(), plv.begin(), plv.end() );
			
				continue;
			}
			
			//   if the tp has been visited before, and tp has no super path follow it, the remaining paths is not necessary to go on to visit.
			if ( abd_check( reversepht(tp), abd_node, elengap, var_len ) ) {
			
				continue;
			}

			gap_len = inelen - ovlen;

			if ( gap_len > max_gap_len ) 
				continue;

			vector<pair<list<pair<int, int> >, list<int> > > plv;
			
			int state = 0;
			if ( pair_scf_check( seed, reversepht( tp ), gap_len, scf_s, bank ) ) {

			
				state = 1;
			}
			int tag = 0;
			
			if ( tp.second == 0 ) {
				if ( lmap[tp.first].tail_links.empty() )
					tag = 1;
			} else {
				if ( lmap[tp.first].head_links.empty() )
					tag = 1;
			}
			
			if ( elen > max_elon_len )
				tag = 1;


			
			
			if ( tag == 0 ) {
				
				
				if ( path_elg( plv, lmap, reversepht(tp), elen, max_gap_len, max_elon_len, seed, abd_node, scf_s, bank ) ) {
				
					for ( size_t i = 0; i < plv.size(); ++i ) {
						plv[i].first.push_front( reversepht(tp) );
						plv[i].second.push_front( ovlen );
					
					}
					scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );
				} else {
					if ( state == 1 ) {
						list< pair< int, int > > pl;
						pl.push_back( reversepht( tp ) );
						
						list< int > ovl;
						ovl.push_back( ovlen );
						plv.push_back( make_pair( pl, ovl ) );
					
						scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );

					} else {
						abd_node[reversepht(tp)].push_back( elengap );
					}
				}
				
					
				
			} else {
				if ( state == 1 ) {
					list< pair< int, int > > pl;
					pl.push_back( reversepht( tp ) );
					
					list< int > ovl;
					ovl.push_back( ovlen );
					plv.push_back( make_pair( pl, ovl ) );

				
					scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );
				} else {
					abd_node[reversepht(tp)].push_back( elengap );
				}
			}

			if ( !plv.empty() ) {
				pl_t.insert( pl_t.end(), plv.begin(), plv.end() );
			}
		}
		

	}else{    // prep.second == 0
		set< pair< Supertig_id, Forb > >::iterator Itet;
		for ( Itet = lmap[prep.first].tail_links.begin(); Itet != lmap[prep.first].tail_links.end(); ++Itet ) {
			pair< Supertig_id, Forb > tp = *Itet;
			int ovlen = lmap[prep.first].Tail_Id_Ov_Ma[tp];
			elen = inelen + bank.Supertig_Map[tp.first].length - ovlen;
			int elengap = inelen - ovlen;

		
			//   if the tp has been fished before, i.e. be found in the bait class, then it has formed a bubble, and the remaining 
			//   paths is not necessary to go on to walk along.
			if ( bait_check( seed, reversepht( tp ), scf_s, elengap, var_len ) ) {
				scf_s.seed_bait_map[seed].bubble_bait_length_map[reversepht( tp )].insert( elengap );

				list< pair< int, int > > pl;
				pl.push_back( reversepht( tp ) );
				
				list< int > ovl;
				ovl.push_back( ovlen );

				vector<pair<list<pair<int, int> >, list<int> > > plv;
				plv.push_back( make_pair( pl, ovl ) );

				pl_t.insert( pl_t.end(), plv.begin(), plv.end() );
			
				continue;
			}

			//   if the tp has been visited before, and tp has no super path follow it, the remaining paths is not necessary to go on to visit.
			if ( abd_check( reversepht(tp), abd_node, elengap, var_len ) ) {
				continue;
			}

			gap_len = inelen - ovlen;

			if ( gap_len > max_gap_len )
				continue;

			vector<pair<list<pair<int, int> >, list<int> > > plv;

			int state = 0;
			if ( pair_scf_check( seed, reversepht( tp ), gap_len, scf_s, bank ) ) {
			
				state = 1;
			}	

			int tag = 0;
			
			if ( tp.second == 0 ) {
				if ( lmap[tp.first].tail_links.empty() )
					tag = 1;
			} else {
				if ( lmap[tp.first].head_links.empty() )
					tag = 1;
			}
			
			if ( elen > max_elon_len )
				tag = 1;

			if( tag == 0 ) {

			
				if ( path_elg( plv, lmap, reversepht(tp), elen, max_gap_len, max_elon_len, seed, abd_node, scf_s, bank ) ) {
				
					for ( size_t i = 0; i < plv.size(); ++i ) {
						
						plv[i].first.push_front( reversepht(tp) );
						plv[i].second.push_front( ovlen );
					
					}
					scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );
				} else {
					if ( state == 1 ) {
						list< pair< int, int > > pl;
						pl.push_back( reversepht( tp ) );
						
						list< int > ovl;
						ovl.push_back( ovlen );
						plv.push_back( make_pair( pl, ovl ) );

					
						scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );

					} else {
						abd_node[reversepht(tp)].push_back( elengap );
					}
				}
			}else {
				if ( state == 1 ) {
					list< pair< int, int > > pl;
					pl.push_back( reversepht( tp ) );
					
					list< int > ovl;
					ovl.push_back( ovlen );
					plv.push_back( make_pair( pl, ovl ) );

					scf_s.seed_bait_map[seed].bait_length_map[reversepht(tp)].insert( elengap );
				} else {
					abd_node[reversepht(tp)].push_back( elengap );
				}
			}

			if ( !plv.empty() ) {
			
				pl_t.insert( pl_t.end(), plv.begin(), plv.end() );
			}
		}

		
	}
	if ( !pl_t.empty() )
		return true;
	else 
		return false;
}

bool bait_check( pair< Supertig_id, Forb > seed, pair< Supertig_id, Forb > tp, Scaffold_subset &scf_s, int inelengap, int max_var_len )
{
	if ( scf_s.seed_bait_map.find( seed ) == scf_s.seed_bait_map.end() )
		return false;
	if ( scf_s.seed_bait_map[seed].bait_length_map.find( tp ) == scf_s.seed_bait_map[seed].bait_length_map.end() )
		return false;
	set< int >::iterator Ite;
	for ( Ite = scf_s.seed_bait_map[seed].bait_length_map[tp].begin(); Ite != scf_s.seed_bait_map[seed].bait_length_map[tp].end(); ++Ite ) {
		if ( abs( inelengap - *Ite ) <= max_var_len )
			return true;
	}
	return false;
}

bool abd_check( pair< Supertig_id, Forb > tp,  map< pair< Supertig_id, Forb >, vector<int> >& abd_node, int inelengap, int max_var_len )
{
	if ( abd_node.find( tp ) == abd_node.end() ) 
		return false;
	for ( size_t i = 0; i < abd_node[tp].size(); ++i ) {
		if ( abs( abd_node[tp][i] - inelengap ) <= max_var_len )
			return true;
	}
	return false;
}

bool pair_scf_check( pair< Supertig_id, Forb > pa, 
					pair< Supertig_id, Forb > pb, 
					int gap_len, 
					Scaffold_subset &scf_s, 
					Supertig_bank &bank )
{
	if ( scf_s.Pair_map.find( pa.first ) == scf_s.Pair_map.end() ) {
		cerr<<"Warning in pair_scf_check: pa not found in scf_map!"<<endl;
		return false;
	}
	if ( scf_s.Pair_map[pa.first].find( pb.first ) == scf_s.Pair_map[pa.first].end() )
		return false;

	for ( size_t i = 0; i < scf_s.Pair_map[pa.first][pb.first].size(); ++i ) {
		if ( pair_scf_check_t( pa, pb, gap_len, bank.Scaffold_map[scf_s.Pair_map[pa.first][pb.first][i]]) )
			return true;
	}

	return false;


}

bool pair_scf_check_t( pair< Supertig_id, Forb > pa, 
					  pair< Supertig_id, Forb > pb, 
					  int gap_len, 
					  Scaffold_Gap &scf )
{
	if ( scf.ida == pa.first ) {
		if ( !scf_drc_check( pa.second, pb.second, scf.drct_type ) )
			return false;
		
	} else if ( scf.ida == pb.first ) {
		if ( !scf_drc_check( pb.second, pa.second, scf.drct_type ) ) 
			return false;

	} else {
		cerr <<" Warning in pair_scf_check: id uncorrespond! " <<scf.ida<< ","<<pa.first<<","<<pb.first<< endl;
		return false;
	}

	if ( !scf_len_check( gap_len, scf.lowb, scf.upb ) )
		return false;
	else
		return true;
}

bool scf_drc_check( Forb fa, Forb fb, int drc_type )
{
	if ( fa == 0 && fb == 0 ) {
		if ( drc_type == 1 )
			return true;
		else 
			return false;
	} else if ( fa == 0 && fb == 1 ) {
		if ( drc_type == 2 )
			return true;
		else 
			return false;
	} else if ( fa == 1 && fb == 0 ) {
		if ( drc_type == 3 )
			return true;
		else 
			return false;
	} else if ( fa == 1 && fb == 1 ) {
		if ( drc_type == 4 )
			return true;
		else 
			return false;
	} else {
		cerr << " Warning in scf_drc_check: unexpected forb!  " << fa<<", "<<fb <<endl;
		return false;
	}
}

bool scf_len_check( int gap_len, int lowb, int upb )
{
	if ( gap_len >= lowb && gap_len <= upb )
		return true;
	else
		return false;
}

void get_max_gap_len( Supertig_id seed, map< pair< Supertig_id, Forb >, int > &seed_max_gap, Scaffold_subset &scf_s, Supertig_bank &bank )
{

	map< Supertig_id, vector< Scaffold_gap_id > >::iterator Ite;
	for ( Ite = scf_s.Pair_map[seed].begin(); Ite != scf_s.Pair_map[seed].end(); ++Ite ) {
		for ( size_t i = 0; i < Ite->second.size(); ++i ) {
			
			get_max_gap_len_t( seed, seed_max_gap, bank.Scaffold_map[Ite->second[i]] );
		}
	}
	

}

void get_max_gap_len_t( Supertig_id seed, map< pair< Supertig_id, Forb >, int > &seed_max_gap, Scaffold_Gap &scf )
{
	Forb forb = 0;
	if ( scf.ida == seed ) {
		if ( scf.drct_type == 1 || scf.drct_type == 2 )
			forb = 0;
		else 
			forb = 1;
	} else if ( scf.idb == seed ) {
		if ( scf.drct_type == 2 || scf.drct_type == 4 )
			forb = 0;
		else
			forb = 1;
	} else {
		cout <<"Warning in get_max_gap_len_t: seed not in scf "<<endl;
		return;
	}
	

	pair< Supertig_id, Forb > seed_f = make_pair( seed, 0 );
	pair< Supertig_id, Forb > seed_b = make_pair( seed, 1 );
	if ( forb == 0 ) {
		
		if ( seed_max_gap.find( seed_f ) == seed_max_gap.end() ) {
			
			seed_max_gap.insert( make_pair( seed_f, scf.upb ) );
		} else {
			if ( scf.upb > seed_max_gap[seed_f] ) {
				seed_max_gap[seed_f] = scf.upb;
			} 
		}
	} else {
		if ( seed_max_gap.find( seed_b ) == seed_max_gap.end() ) {
			
			seed_max_gap.insert( make_pair( seed_b, scf.upb ) );
		} else {
			if ( scf.upb > seed_max_gap[seed_b] ) {
				seed_max_gap[seed_b] = scf.upb;
			}
		}
	}
	
}

void simplify_baitmap( Scaffold_subset &scf_s )
{
	map< pair< Supertig_id, Forb >, fished_bait >::iterator Ite;
	vector< pair< Supertig_id, Forb > > eraseve;
	for ( Ite = scf_s.seed_bait_map.begin(); Ite != scf_s.seed_bait_map.end(); ++Ite ) {
		if ( Ite->second.bubble_bait_length_map.empty() ) {
			eraseve.push_back( Ite->first );
		} else {
			Ite->second.bait_length_map.clear();
		}
	}
	size_t vesize = eraseve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		scf_s.seed_bait_map.erase( eraseve[i] );
	}
}

void reduce_circle_in_superpath( vector< list< pair< Supertig_id, Forb > > > &pathve, subgraph &graph_t )
{
	for ( size_t i = 0; i < pathve.size(); ++i ) {
	
		reduce_circle_in_superpath_t( pathve[i], graph_t );
	
	}
}

void reduce_circle_in_superpath_t( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t )
{
	list< pair< Supertig_id, Forb > >::iterator Iteli = path.begin();

	list< pair< Supertig_id, Forb > >::iterator Itefind;

	while ( Iteli != path.end() ) {
		pair< Supertig_id, Forb > tail = *Iteli;
		++Iteli;
		if ( Iteli == path.end() )
			break;
		Itefind = find( Iteli, path.end(), tail );
		if ( Itefind != path.end() ) {
			list< pair< Supertig_id, Forb > > circle_path;
			list< pair< Supertig_id, Forb > >::iterator iteh = Iteli;
			list< pair< Supertig_id, Forb > >::iterator itet = Itefind;
		
			iteh--;
			circle_path.insert( circle_path.end(), iteh, itet );

			list< pair< Supertig_id, Forb > >::iterator pathite = Itefind;
			
			list< pair< Supertig_id, Forb > >::iterator tempite;
			list< pair< Supertig_id, Forb > > al_path;
			al_path.insert( al_path.end(), path.begin(), pathite );

			list< pair< Supertig_id, Forb > >::iterator last_eat_ite;

			bool taileat = false;
			bool taileat_once = false;
			do {
				taileat = false;
				bool taileat_t = true;
				for ( tempite = circle_path.begin(); tempite != circle_path.end(); ++tempite ) {
					if ( pathite == path.end() ) {
						taileat_t = false;
						break;
					}
					if ( *pathite != *tempite ) {
						taileat_t = false;
						break;
					}
					++pathite;
				}
				if ( taileat_t ) {
					last_eat_ite = pathite;
					taileat_once = true;
					taileat = true;
				} 
					
			} while ( taileat );

			if ( taileat_once ) {
				pathve_insert( graph_t.circles_subpath, circle_path );
				al_path.insert( al_path.end(), last_eat_ite, path.end() );
				path = al_path;
				Iteli = path.begin();
			
			}

			
		}

		
	}
	
}

void pathve_insert( vector< list< pair< Supertig_id, Forb > > > &pathve, list< pair< Supertig_id, Forb > > &pl )
{

	if ( pathve.empty() ) {
		pathve.push_back( pl );
		return;
	}

	bool exist = false;
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		if ( plistequalcheck( pathve[i], pl ) ) {
			exist = true;
			break;
		}
	}
	if ( !exist ) {
		pathve.push_back( pl );
	}
}

void adjust_bulb_baitmap( Scaffold_subset &scf_s, subgraph &graph_t, Supertig_bank &tig_bank, int var_len )
{

	map< pair< Supertig_id, Forb >, fished_bait > al_baitmap;
	for ( size_t i = 0; i < scf_s.superpath.size(); ++i ) {

		list< pair< Supertig_id, Forb > >::iterator Ite = scf_s.superpath[i].begin();

		while( Ite != scf_s.superpath[i].end() ) {
			pair< Supertig_id, Forb > seed = *Ite;
		
			if ( scf_s.seed_bait_map.find( seed ) == scf_s.seed_bait_map.end() ) {
				++Ite;
				continue;
			}
			

			int gaplen = 0;
			int elen = 0;
			list< pair< Supertig_id, Forb > >::iterator Iteli = Ite;
			pair< Supertig_id, Forb > prep = seed;
			++Iteli;
			for ( ; Iteli != scf_s.superpath[i].end(); ++Iteli ) {
				pair< Supertig_id, Forb > tp = *Iteli;
				int ovlen = get_ovlen_fr_cnct_nodes( prep, reversepht( tp ), graph_t );
				if ( ovlen == -1000 ) {
					break;
				}
				gaplen = elen - ovlen;
				elen = gaplen + tig_bank.Supertig_Map[tp.first].length;
			
				if ( scf_s.seed_bait_map[seed].bubble_bait_length_map.find( tp ) != scf_s.seed_bait_map[seed].bubble_bait_length_map.end() ) {
					al_baitmap[seed].bubble_bait_length_map[tp].insert( gaplen );
				}
				prep = tp;
			}
			++Ite;
		}


	}


	map< pair< Supertig_id, Forb >, fished_bait >::iterator Iteb;
	for ( Iteb = al_baitmap.begin(); Iteb != al_baitmap.end(); ++Iteb ) {
		map< pair< Supertig_id, Forb >, set< int > >::iterator subite;
		for ( subite = Iteb->second.bubble_bait_length_map.begin(); subite != Iteb->second.bubble_bait_length_map.end(); ++subite ) {
			len_set_cluster( subite->second, var_len );
		}
	}

	scf_s.seed_bait_map = al_baitmap;


}

void len_set_cluster( set< int > &len_set, int var_len )
{
	set< int >::iterator Ite = len_set.begin();
	set< int > clu;
	set< int > clu_mean_set;
	int edge = *Ite;
	clu.insert( edge );
	++Ite;
	for ( ; Ite != len_set.end(); ++Ite ) {
		if ( *Ite - edge > 2 * var_len ) {
			int mean = get_mean( clu );
		
			clu_mean_set.insert( mean );
			clu.clear();
			clu.insert( *Ite );
			edge = *Ite;
		} else {
			clu.insert( *Ite );
		}
		
	}
	if ( !clu.empty() ) {
		int mean = get_mean( clu );
		clu_mean_set.insert( mean );
	}

	len_set = clu_mean_set;
}

int get_mean( set< int > &len_set )
{
	if ( len_set.empty())
		return 0;
	set< int >::iterator Ite;
	int add = 0;
	for ( Ite = len_set.begin(); Ite != len_set.end(); ++Ite ) {
		add += *Ite;
	}
	return (int)( add / (int)len_set.size() );
}


