#ifndef GRAPH_SUPERPATH_H
#define GRAPH_SUPERPATH_H

#include "Graph_subgraph.h"
#include "Graph_Suptig_Assbl.h"


using namespace std;

//////////////////////////////////////////////////
// 
// Super_paths indecates the paths that connect two sides of the scaffold.
// Here the scaffold means two oriented tigs with the gap or overlap whose
// length are determined by mate pairs in the two sides of the scaffold.
//
// As one side of the scaffold were marked as seed in advance, super path starts at the  
// seed and walks along the overlap linked graph until the other side of the scaffold is
// reached. Because the scaffold may not be one-to-one relationship in most case, i.e. one
// tig may combine more than one other tigs to form more than one scaffolds. Thus, the super
// path walking procedure ends at the longest scaffold side confined in a certain area. One
// super path may pass or say connect more than one scaffolds.
// 
// The seeds of the super paths were chosen so that as less as possible seeds were included
// and each scaffold has at least one seed included.
// 
// We follow the tree searching strategy. One path may fork at one node, and become more 
// paths walking forward. Sometimes, different paths converge at one node to form a bubble. 
// Then, the paths except the first one to pass the node end at that node, and the node is 
// marked as a bubble node.
// 
// Only paths that ends at the scaffolds' side are validated super path. Paths walking is
// terminated when the walking length reached the upper bound of the searching length defined
// in advance, as usually the minimun of the longest scaffold length and a threshold, no matter
// whether the last node is scaffold side or not.
// 
// Finding the super paths is the most important step in the graph process, since the reliability of the
// structure formed afterwards is rely to the super paths. In fact, the super paths replace the overlap
// links as the role of backbone of the graph.
////////////////////////////////////////////////////


void Supath_find( map< Supertig_id, Supertig_Overlap_Link > &ov_link, Scaffold_subset &scf_s, subgraph &graph_t, Supertig_bank &bank );


bool path_elg( vector< pair < list< pair< Supertig_id, Forb > >, list< int>  > > &pl_t,
			  map< Supertig_id, Supertig_Overlap_Link > &lmap, 
			  pair< Supertig_id, Forb > prep, 
			  int inelen, 
			  int max_gap_len,
			  int max_elon_len,
			  pair< Supertig_id, Forb > seed,
			  map< pair< Supertig_id, Forb >, vector<int> >& abd_node,
			  Scaffold_subset &scf_s, 
			  Supertig_bank &bank );

bool bait_check( pair< Supertig_id, Forb > seed, pair< Supertig_id, Forb > tp, Scaffold_subset &scf_s, int inelen, int var_len );

bool abd_check( pair< Supertig_id, Forb > tp,  map< pair< Supertig_id, Forb >, vector<int> >& abd_node, int inelengap, int max_var_len );

bool pair_scf_check( pair< Supertig_id, Forb > ida, 
					pair< Supertig_id, Forb > idb, 
					int gap_len, 
					Scaffold_subset &scf_s, 
					Supertig_bank &bank );

bool pair_scf_check_t( pair< Supertig_id, Forb > ida, 
					  pair< Supertig_id, Forb > idb, 
					  int gap_len, 
					  Scaffold_Gap &scf );

bool scf_drc_check( Forb fa, Forb fb, int drc_type );

bool scf_len_check( int gap_len, int lowb, int upb );

void get_max_gap_len( Supertig_id seed, map< pair< Supertig_id, Forb >, int > &seed_max_gap, Scaffold_subset &scf_s, Supertig_bank &bank );

void get_max_gap_len_t( Supertig_id seed, map< pair< Supertig_id, Forb >, int > &seed_max_gap, Scaffold_Gap &scf );

void simplify_baitmap( Scaffold_subset &scf_s );

void reduce_circle_in_superpath( vector< list< pair< Supertig_id, Forb > > > &pathve, subgraph &graph_t );

void reduce_circle_in_superpath_t( list< pair< Supertig_id, Forb > > &path, subgraph &graph_t );

void pathve_insert( vector< list< pair< Supertig_id, Forb > > > &pathve, list< pair< Supertig_id, Forb > > &pl );

void adjust_bulb_baitmap( Scaffold_subset &scf_s, subgraph &graph_t, Supertig_bank &tig_bank, int var_len );

void len_set_cluster( set< int > &len_set, int var_len );

int get_mean( set< int > &len_set );


#endif
