#include "Graph_unp_Stig.h"

bool unpack_series_t( Supertig_id tig_id, Forb fb, Supertig_bank &tig_bank, list< pair< Supertig_id, Forb > > &path )
{
	
	if ( tig_bank.Supertig_Map.find( tig_id ) == tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in unpack_supertig_t: tig_id not found in bank! "<<endl;
		return false;
	}

	if ( tig_bank.Supertig_Map[tig_id].single_tig ) {
	
		pair< Supertig_id, Forb > single_p = make_pair( tig_bank.Supertig_Map[tig_id].Tig_Ve[0][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[0][0] );
		
		if ( fb == 0 )
			path.push_back( single_p );
		else 
			path.push_back( reversepht( single_p ) );
		

		return true;
		
		
	} else if ( tig_bank.Supertig_Map[tig_id].bubble ) {
		if ( fb == 0 )
			path.push_back( make_pair( tig_id, 0 ) );
		else 
			path.push_back( make_pair( tig_id, 1 ) );

		return true;
	}

	if ( !tig_bank.Supertig_Map[tig_id].series ) {
		cerr << "Warning in unpath_supertig_t: wrong tig_type of the supertig! "<<endl;
		return false;
	}


	if ( tig_bank.Supertig_Map[tig_id].resvcutlink == 1 ) {       ////////////////////////for reserve cut link inherit//////////
		
		if ( !unpack_series_t_inherit_t( tig_id, fb, tig_bank, path ) )
			return false;
	} else {
		
		if ( !unpack_series_t_t( tig_id, fb, tig_bank, path ) )
			return false;
		
	}
	
	return true;


}

bool unpack_series_t_t( Supertig_id tig_id, Forb fb, Supertig_bank &tig_bank, list< pair< Supertig_id, Forb > > &path )
{
	size_t vesize = tig_bank.Supertig_Map[tig_id].Tig_Ve.size();
	if ( fb == 0 ) {
		for ( size_t i = 0; i < vesize; ++i ) {
			
			if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0], tig_bank, path ) ) {
				
				return false;
			}
			
		}
	} else {
		for ( size_t i = vesize - 1; i >= 0; --i ) {
			if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], reverseforb( tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0] ), tig_bank, path ) )
				return false;
			if ( i == 0 )
					break;
		}
	}
	return true;
}

bool unpack_series_t_inherit_t( Supertig_id tig_id, Forb fb, Supertig_bank &tig_bank, list< pair< Supertig_id, Forb > > &path )
{
	Supertig_Overlap_Link left_link;
	Supertig_Overlap_Link right_link;
	if ( fb == 0 ) {
		left_link.tail_links = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.tail_links;
		left_link.Tail_Id_Ov_Ma = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.Tail_Id_Ov_Ma;
		right_link.head_links = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.head_links;
		right_link.Head_Id_Ov_Ma = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.Head_Id_Ov_Ma;
	} else {

		left_link.tail_links = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.head_links;
		left_link.Tail_Id_Ov_Ma = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.Head_Id_Ov_Ma;
		right_link.head_links = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.tail_links;
		right_link.Head_Id_Ov_Ma = tig_bank.Supertig_Map[tig_id].Resv_Cut_link.Tail_Id_Ov_Ma;
	}

	size_t vesize = tig_bank.Supertig_Map[tig_id].Tig_Ve.size();

	if ( fb == 0 ) {
		for ( size_t i = 0; i < vesize; ++i ) {
			if ( i == 0 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0], tig_bank, path, left_link ) )
					return false;
				
			}
			if ( i == vesize-1 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0], tig_bank, path, right_link ) )
					return false;
				
			}
			if ( i != 0 && i != vesize-1 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0], tig_bank, path ) )
					return false;
			}
		}
	} else {
		for ( size_t i = vesize - 1; i >= 0; --i ) {
			if ( i == vesize - 1 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], reverseforb( tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0] ), tig_bank, path, left_link ) )
					return false;

			}
			if ( i == 0 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], reverseforb( tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0] ), tig_bank, path, right_link ) )
					return false;
			}
			if ( i != 0 && i != vesize-1 ) {
				if ( !unpack_series_t( tig_bank.Supertig_Map[tig_id].Tig_Ve[i][0], reverseforb( tig_bank.Supertig_Map[tig_id].Tig_F_Ve[i][0] ), tig_bank, path ) )
					return false;
			}

			if ( i == 0 )
					break;
		}
	}
	return true;
}

bool unpack_series_t( Supertig_id tig_id, Forb fb, Supertig_bank &tig_bank, list< pair< Supertig_id, Forb > > &path, Supertig_Overlap_Link &Resv_Cut_link )
{

	if ( tig_bank.Supertig_Map.find( tig_id ) == tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in unpack_supertig_t: tig_id not found in bank! "<<endl;
		return false;
	}

	if ( tig_bank.Supertig_Map[tig_id].single_tig ) {
		pair< Supertig_id, Forb > single_p = make_pair( tig_bank.Supertig_Map[tig_id].Tig_Ve[0][0], tig_bank.Supertig_Map[tig_id].Tig_F_Ve[0][0] );

		if ( fb == 0 ) {
			path.push_back( single_p );
			unp_seri_assgn_rescl( single_p, tig_bank, Resv_Cut_link );
		} else {
			path.push_back( reversepht( single_p ) );
			unp_seri_assgn_rescl( reversepht( single_p ), tig_bank, Resv_Cut_link );
		}
		
		return true;
		
	} else if ( tig_bank.Supertig_Map[tig_id].bubble ) {
		if ( fb == 0 ) {
			path.push_back( make_pair( tig_id, 0 ) );
			unp_seri_assgn_rescl( make_pair( tig_id, 0 ), tig_bank, Resv_Cut_link );
		} else {
			path.push_back( make_pair( tig_id, 1 ) );
			unp_seri_assgn_rescl( make_pair( tig_id, 1 ), tig_bank, Resv_Cut_link );
		}

		return true;
	}

	if ( !tig_bank.Supertig_Map[tig_id].series ) {
		cerr << "Warning in unpath_supertig_t: wrong tig_type of the supertig! "<<endl;
		return false;
	}

	size_t vesize = tig_bank.Supertig_Map[tig_id].Tig_Ve.size();

	////////////////////////////// for resv_cut_link////////////////////
	unp_seri_assgn_rescl( make_pair( tig_id, fb ), tig_bank, Resv_Cut_link );
	tig_bank.Supertig_Map[tig_id].resvcutlink = 1;

	if ( !unpack_series_t_inherit_t( tig_id, fb, tig_bank, path) )
		return false;

	return true;


}



void recons_suptig( Supertig_id tig_id, subgraph &graph_t, Supertig_bank &tig_bank, vector< pair< Supertig_id, Forb > > &path )
{


	Supertig n_tig;
	n_tig.series = true;
	if ( !supertig_in_seri_form( n_tig, path, tig_bank.fdm_ovlkmap, tig_bank ) ) {
		cerr << "Warning in subpath_supertig_ass!"<<endl;
		exit(1);
	}

	tig_bank.Supertig_Map[tig_id] = n_tig;

	suptig_scf_replace( tig_id, n_tig, tig_bank );

}


void recons_suptig( Supertig_id tig_id, subgraph &graph_t, Supertig_bank &tig_bank, list< pair< Supertig_id, Forb > > &path )
{

	vector< pair< Supertig_id, Forb >  > series_ve;
	list< pair< Supertig_id, Forb >  >::iterator Iteli;
	for ( Iteli = path.begin(); Iteli != path.end(); ++Iteli ) {
		series_ve.push_back( *Iteli );
	}

	Supertig n_tig;
	n_tig.series = true;
	n_tig.allseries = true;
	n_tig.bulbin = false;

	if ( !supertig_in_seri_form( n_tig, series_ve, tig_bank.fdm_ovlkmap, tig_bank ) ) {
		cerr << "Warning in subpath_supertig_ass!"<<endl;
		exit(1);
	}

	tig_bank.Supertig_Map[tig_id] = n_tig;


}

void recons_suptig_bulbin( Supertig_id tig_id, Supertig_bank &tig_bank, vector< pair< Supertig_id, Forb > > &tig_path )
{

	Supertig n_tig;
	n_tig.series = true;
	n_tig.allseries = false;
	n_tig.bulbin = true;
	for ( size_t i = 0; i < tig_path.size(); ++i ) {
		vector< Supertig_id > single_id_ve;
		vector< Forb > single_forb_ve;
		single_id_ve.push_back( tig_path[i].first );
		single_forb_ve.push_back( tig_path[i].second );
		n_tig.Tig_Ve.push_back( single_id_ve );
		n_tig.Tig_F_Ve.push_back( single_forb_ve );
		vector< pair<int, int > > single_pos;
		if ( i == 0 ) {
			single_pos.push_back( make_pair(1, tig_bank.Supertig_Map[tig_path[i].first].length ) );
		} else {
		
			int ovlen = get_ovlen_from_lk_tig( tig_path[i-1], reversepht( tig_path[i] ), tig_bank );
			if ( ovlen == -1000 ) {
				cout<<"no ovlen! "<<endl;  exit(1);
			}
			
			pair<int, int > posp;
			posp.first = n_tig.Tig_P_Ve[i-1][0].second - ovlen + 1;
			posp.second = n_tig.Tig_P_Ve[i-1][0].second - ovlen + tig_bank.Supertig_Map[tig_path[i].first].length;
			single_pos.push_back( posp );
		}
		n_tig.Tig_P_Ve.push_back( single_pos );
	}
	
	n_tig.length = n_tig.Tig_P_Ve[tig_path.size()-1][0].second;
	tig_bank.Supertig_Map[tig_id] = n_tig;
	
}

// if have no bulb, return false, else return true.
bool unp_merge_subpath( Supertig_id tig_id,
					   list< pair< Supertig_id, Forb > > &path, 
					   vector< pair< Supertig_id, Forb > > &tig_path, 
					   subgraph &graph_t, 
					   Supertig_bank &tig_bank )
{
	bool bulbtg = false;
	bool mergetg = false;

	
	vector< pair< Supertig_id, Forb > > subpath;
	list< pair< Supertig_id, Forb > >::iterator Itel;
	for ( Itel = path.begin(); Itel != path.end(); ++Itel ) {
		if ( tig_bank.Supertig_Map[Itel->first].bubble ) {
			bulbtg = true;
			if ( !subpath.empty() ) {
				if ( (int)subpath.size() == 1 )
					tig_path.push_back( subpath[0] );
				else {
					Supertig_id n_id = subpath_supertig_ass( subpath, graph_t, tig_bank );
					mergetg = true;
					if ( n_id == -1 ) {
						cerr << "Error in unp_merge_subpath: cannot ass new supertig!"<<endl;
						exit(1);
					} else {
						tig_path.push_back( make_pair( n_id, 0 ) );
					}
				}
				subpath.clear();
			}
			tig_path.push_back( *Itel );
			
			continue;
		} else {
			subpath.push_back( *Itel );
		}

	}
	if ( bulbtg ) {
		
		if ( !subpath.empty() ) {
			if ( (int)subpath.size() == 1 )
				tig_path.push_back( subpath[0] );
			else {
				Supertig_id n_id = subpath_supertig_ass( subpath, graph_t, tig_bank );
				mergetg = true;
				if ( n_id == -1 ) {
					cerr << "Error in unp_merge_subpath: cannot ass new supertig!"<<endl;
					exit(1);
				} else {
					tig_path.push_back( make_pair( n_id, 0 ) );
				}
			}
		}

		//////////revised for greedy//////////////////////////
		if ( (int)tig_path.size() > 1 ) {
		
			recons_suptig_bulbin( tig_id, tig_bank, tig_path );
		} else {
		
			tig_bank.Supertig_Map[tig_id].allseries = false;
		}
		
		///////////////revised for greedy/////////////////////
		

		return true;
	} else {
		return false;
	}

	return true;
}


void unp_seri_assgn_rescl( pair< Supertig_id, Forb > p, Supertig_bank &tig_bank, Supertig_Overlap_Link &Resv_Cut_link )
{
	if ( p.second == 0 ) {
		tig_bank.Supertig_Map[p.first].Resv_Cut_link = Resv_Cut_link;
		tig_bank.Supertig_Map[p.first].resvcutlink = 1;
	} else {
		tig_bank.Supertig_Map[p.first].Resv_Cut_link.head_links = Resv_Cut_link.tail_links;
		tig_bank.Supertig_Map[p.first].Resv_Cut_link.tail_links = Resv_Cut_link.head_links;

		tig_bank.Supertig_Map[p.first].Resv_Cut_link.Head_Id_Ov_Ma = Resv_Cut_link.Tail_Id_Ov_Ma;
		tig_bank.Supertig_Map[p.first].Resv_Cut_link.Tail_Id_Ov_Ma = Resv_Cut_link.Head_Id_Ov_Ma;

		tig_bank.Supertig_Map[p.first].resvcutlink = 1;

	}

}

Supertig_id subpath_supertig_ass( vector< pair< Supertig_id, Forb > > &path, subgraph &graph_t, Supertig_bank &tig_bank )
{

	
	Supertig n_tig;
	if ( !supertig_in_seri_form( n_tig, path, tig_bank.fdm_ovlkmap, tig_bank ) ) {
		cerr << "Warning in subpath_supertig_ass!"<<endl;
		
		
		return -1;
	}

	Supertig_id n_id = tig_bank.Supertig_Map.rbegin()->first + 1;
	if( tig_bank.Supertig_Map.find( n_id ) != tig_bank.Supertig_Map.end() ) {
		cerr << "Warning in  func simple_bubble_assbl: n_id already exist in tig_bank.Supertig_Map " <<endl;
		return -1;
	}

	tig_bank.Supertig_Map.insert( make_pair ( n_id, n_tig ) );

	suptig_scf_replace( n_id, n_tig, tig_bank );

	unp_rm_inner_act( n_tig, tig_bank );

	tig_bank.inner_active_tig.insert( n_id );


	return n_id;
}

void unp_rm_inner_act( Supertig &n_tig, Supertig_bank &tig_bank )
{
	size_t vesize = n_tig.Tig_Ve.size();
	for ( size_t i = 0; i < vesize; ++i ) {
		for ( size_t j = 0; j < n_tig.Tig_Ve[i].size(); ++j ) {
			if ( tig_bank.inner_active_tig.find( n_tig.Tig_Ve[i][j] ) != tig_bank.inner_active_tig.end() )
				tig_bank.inner_active_tig.erase( n_tig.Tig_Ve[i][j] );
		}
	}
}

