#include "Trans_to_graph.h"

void trans_to_graph( map<int, C_Link> &lmap, 
					map< int, Contig > &idconmap, 
					map<int, pair<int, pair<int, int> > > &Pairs,
					int tig_len,
					int mate_len,
					int mate_var,
					int mate_type,
					Supertig_bank &bank,
					map< Supertig_id, int > & rev_trans_map,
					Graph_parameter &para )
{

	map< int, Supertig_id > trans_map;

	
	map< int, C_Link >::iterator Ite;
	Supertig_id t_id = 0;
	for ( Ite = lmap.begin(); Ite != lmap.end(); ++Ite ) {
		
		t_id += 1;
		bank.Supertig_Set.insert( t_id );
		Supertig tig;
		tig.length = idconmap[Ite->first].getheadpos().second;
		tig.single_tig = true;
		
		bank.Supertig_Map.insert( make_pair( t_id, tig ) );
		trans_map.insert( make_pair( Ite->first, t_id ) );
		rev_trans_map.insert( make_pair( t_id, Ite->first ) );
		
	}

	
	
	
	trans_ov_link( lmap, trans_map, bank );

	
	map< int, int > read_con_map;
	map< int, Contig >::iterator Itec;
	for ( Itec = idconmap.begin(); Itec != idconmap.end(); ++Itec ) {
		list< int >::iterator Itel;
		
		for ( Itel = Itec->second.ReadidList.begin(); Itel != Itec->second.ReadidList.end(); ++Itel ) {

			read_con_map[*Itel] = Itec->first;

			
		}
	}
	
	trans_scf( Pairs, mate_type, read_con_map, idconmap, trans_map, rev_trans_map, bank );

	

	ini_tig_bank( bank );

	if ( bank.Scaffold_map.empty() ) {
		return;
	}

	Graph_structure stru;


	

	bank.tig_len = tig_len;
	bank.mate_len = mate_len;
	bank.mate_var = mate_var;
	bank.min_stem_lenthr_opt = para.min_stem_lenthr_opt;
	bank.max_path_len_opt = para.max_path_len_opt;
	bank.min_cover_rate_opt = para.min_cover_rate_opt;

	graph_stru_pro( stru, bank );



}

void ini_tig_bank( Supertig_bank &bank )
{
	
	map< Supertig_id, Supertig >::iterator Ite;
	for ( Ite = bank.Supertig_Map.begin(); Ite != bank.Supertig_Map.end(); ++Ite ) {

		vector< Supertig_id > tigve;
		tigve.push_back( Ite->first );
		Ite->second.Tig_Ve.push_back( tigve );
		vector< Forb > fbve;
		fbve.push_back( 0 );
		Ite->second.Tig_F_Ve.push_back( fbve );
		vector< pair< int, int > > posve;
		posve.push_back( make_pair( 1, Ite->second.length ) );
		Ite->second.Tig_P_Ve.push_back( posve );

	}

	bank.backup_ovlkmap();
	bank.backup_scf();
	bank.backup_singletig();
	bank.backup_basictig();
	
}

void trans_ov_link( map< int, C_Link > &lmap, map< int, Tig_id > &trans_map, Supertig_bank &bank )
{
	map< int, C_Link >::iterator Itel;
	for ( Itel = lmap.begin(); Itel != lmap.end(); ++Itel ) {
		set< pair< int, int > >::iterator Iteh;
		for ( Iteh = Itel->second.head_links.begin(); Iteh != Itel->second.head_links.end(); ++Iteh ) {
			pair< Supertig_id, Forb > p = make_pair( trans_map[Iteh->first], Iteh->second );
			bank.Supertig_Overlap_Link_Map[trans_map[Itel->first]].head_links.insert( p );
			bank.Supertig_Overlap_Link_Map[trans_map[Itel->first]].Head_Id_Ov_Ma.insert( make_pair( p, Itel->second.Head_Id_Ov_Ma[*Iteh] ) );
		}
		set< pair< int, int > >::iterator Itet;
		for ( Itet = Itel->second.tail_links.begin(); Itet != Itel->second.tail_links.end(); ++Itet ) {
			pair< Supertig_id, Forb > p = make_pair( trans_map[Itet->first], Itet->second );
			bank.Supertig_Overlap_Link_Map[trans_map[Itel->first]].tail_links.insert( p );
			bank.Supertig_Overlap_Link_Map[trans_map[Itel->first]].Tail_Id_Ov_Ma.insert( make_pair( p, Itel->second.Tail_Id_Ov_Ma[*Itet] ) );
		}
	}
}


void trans_scf( map<int, pair<int, pair<int, int> > > &Pairs,
			   int mate_type,
			   map< int, int > read_con_map,
			   map< int, Contig > &idconmap,
			   map< int, Supertig_id > &trans_map,
			   map< Supertig_id, int > &rev_trans_map,
			   Supertig_bank &bank )
{
	set< Supertig_id >::iterator Ite;
	for ( Ite = bank.Supertig_Set.begin(); Ite != bank.Supertig_Set.end(); ++Ite ) {

	
		Supertig_id t_ida = *Ite;
		map< Supertig_id, vector< Scaffold_Gap > > sca_map;

		int c_ida = rev_trans_map[t_ida];

		list< int >::iterator Itel;
		for ( Itel = idconmap[c_ida].ReadidList.begin(); Itel != idconmap[c_ida].ReadidList.end(); ++Itel ) {
			if ( Pairs.find( *Itel ) == Pairs.end() )
				continue;

			int rb = Pairs[*Itel].first;
			if ( read_con_map.find( rb ) == read_con_map.end() ) {
				bank.Supertig_Map[t_ida].hangingmate += 1;
				continue;
			}

			int c_idb = read_con_map[rb];
			if ( c_idb == c_ida )
				continue;

			Supertig_id t_idb = trans_map[c_idb];
			if ( t_idb < t_ida )
				continue;
		
			trans_scf_create( *Itel, c_ida, rb, c_idb, idconmap, t_idb, Pairs[*Itel].second.first, Pairs[*Itel].second.second, mate_type, sca_map );
			

		}

		map< Supertig_id, vector< Scaffold_Gap > >::iterator Iteca;
		for ( Iteca = sca_map.begin(); Iteca != sca_map.end(); ++Iteca ) {
			vector< Scaffold_Gap > c_scf_ve;
			vector< Scaffold_Gap > p_scf_ve = Iteca->second;
			if ( (int)p_scf_ve.size() > 1 ) {
				int p_ve_size = 0;
				int c_ve_size = 0;
				do {
					p_ve_size = (int)p_scf_ve.size();
					scf_merge( p_scf_ve, c_scf_ve );
					c_ve_size = (int)c_scf_ve.size();

					p_scf_ve = c_scf_ve;
					c_scf_ve.clear();

				} while ( p_ve_size != c_ve_size && c_ve_size > 1 );
			}
		

			add_scf( *Ite, Iteca->first, p_scf_ve, bank );
		}

	}

}

void trans_scf_create( int ra, int ca, int rb, int cb,
				   map< int, Contig > &idconmap, 
				   Supertig_id tb,
				   int mate_e, int mate_v, int mate_type,
				   map< Supertig_id, vector< Scaffold_Gap > > &sca_map )
{

	Scaffold_Gap scf;
	scf.drct_type = trans_scf_get_drct( idconmap[ca].read_forbMap[ra], idconmap[cb].read_forbMap[rb], mate_type );

	trans_scf_get_gap( scf.drct_type, idconmap[ca].read_relposMap[ra], idconmap[cb].read_relposMap[rb], idconmap[ca].getheadpos().second, idconmap[cb].getheadpos().second, mate_e, mate_v, scf );
	scf.calculate_conf();
	sca_map[tb].push_back( scf );
	

}

int trans_scf_get_drct( int fa, int fb, int mate_type )
{
	if ( mate_type == 2 ) {
		if ( fa == 0 && fb == 0 )
			return 2;
		if ( fa == 0 && fb == 1 )
			return 1;
		if ( fa == 1 && fb == 0 )
			return 4;
		if ( fa == 1 && fb == 1 )
			return 3;
	} else if ( mate_type == 3 ) {
		if ( fa == 0 && fb == 0 )
			return 3;
		if ( fa == 0 && fb == 1 )
			return 4;
		if ( fa == 1 && fb == 0 )
			return 1;
		if ( fa == 1 && fb == 1 )
			return 2;
	}
	
	return -1;
}

void trans_scf_get_gap( int drct, pair< int, int > pa, pair< int, int > pb, int lena, int lenb, int mate_e, int mate_v, Scaffold_Gap &scf )
{
	int upb = mate_e + 5 * mate_v;
	int lowb = mate_e - 5 * mate_v;
	int shif = 0;
	if ( drct == 1 ) {
		shif = lena - pa.first + pb.second - 1;
	} else if ( drct == 2 ) {
		shif = lena - pa.first + lenb - pb.first;
	} else if ( drct == 3 ) {
		shif = pa.second - 1 + pb.second - 1;
	} else if ( drct == 4 ) {
		shif = pa.second - 1 + lenb - pb.first;
	} else {
		cerr<<"Warning in trans_scf_get_gap: unexpected drct: "<<drct<<endl;   exit(1);
	}
	scf.mean = mate_e - shif;
	scf.lowb = lowb - shif;
	scf.upb = upb - shif;
	scf.len_ve.push_back( scf.mean );
}


bool rev_trans_pl( list< pair< Supertig_id, Forb > > &pl, map< Supertig_id, int > &rev_trans_map, list< pair< int, int > > &n_pl )
{

	list< pair< Supertig_id, Forb > >::iterator Ite;
	for ( Ite = pl.begin(); Ite != pl.end(); ++Ite ) {
		if ( rev_trans_map.find( Ite->first ) == rev_trans_map.end() ) {
			cerr << "Warning in rev_trans_pl: id not found!"<<Ite->first<<endl;
			return false;
		}
		n_pl.push_back( make_pair( rev_trans_map[Ite->first], Ite->second ) );
	}
	return true;
}



