#ifndef TRANS_TO_GRAPH_H
#define TRANS_TO_GRAPH_H

#include "Graph_Bank.h"
#include "Graph_subgraph.h"
#include "link.h"
#include "contig.h"
#include "Graph_Scf_rpl.h"
#include "Graph_structure.h"
#include "output.h"
#include "assemblybank.h"

using namespace std;

class Graph_parameter
{
public:

	int min_stem_lenthr_opt;
	int max_path_len_opt;
	double min_cover_rate_opt;
};

class Read_info_in_Contig
{
public:
	int contig_id;
	int forb;
	pair< int, int > pos;
};

void trans_to_graph( map<int, C_Link> &lmap, 
					map< int, Contig > &idconmap, 
					map<int, pair<int, pair<int, int> > > &Pairs,
					int tig_len,
					int mate_len,
					int mate_var,
					int mate_type,
					Supertig_bank &bank,
					map< Supertig_id, int > &rev_trans_map,
					Graph_parameter &para );

void ini_tig_bank( Supertig_bank &bank );

void trans_ov_link( map< int, C_Link > &lmap, map< int, Supertig_id > &trans_map, Supertig_bank &bank );

void trans_scf( map<int, pair<int, pair<int, int> > > &Pairs,
			   int mate_type,
			   map< int, int > read_con_map,
			   map< int, Contig > &idconmap,
			   map< int, Supertig_id > &trans_map,
			   map< Supertig_id, int > &rev_trans_map,
			   Supertig_bank &bank );

void trans_scf_create( int ra, int ca, int rb, int cb,
				   map< int, Contig > &idconmap, 
				   Supertig_id tb,
				   int mate_e, int mate_v, int mate_type,
				   map< Supertig_id, vector< Scaffold_Gap > > &sca_map );

int trans_scf_get_drct( int fa, int fb, int mate_type );

void trans_scf_get_gap( int drct, pair< int, int > pa, pair< int, int > pb, int lena, int lenb, int mate_e, int mate_v, Scaffold_Gap &scf );


bool rev_trans_pl( list< pair< Supertig_id, Forb > > &pl, map< Supertig_id, int > &rev_trans_map, list< pair< int, int > > &n_pl );



#endif


