#ifndef ASSEMBLYBANK_H
#define ASSEMBLYBANK_H

#include "contig.h"
#include "Graph_subgraph.h"
#include "link.h"
#include "Mate_Pair.h"

using namespace std;

typedef int Contig_id;
typedef int Aln_id;



class Contig_bank
{
public:
	list< pair< int, int > > path_from_graph;
	vector< pair< int, int > > ovlen_in_path;   // pair< overlap_type, overlap_length >,  ovlap_type: 0, 1, 2, 3
	Contig contig;
	bool single;
//	bool recurrance;

	Contig_bank()
	{
		single = false;
	}
};

class Bridge_a
{
public:
	pair< Contig_id, int > b_tig;
	pair< Contig_id, int > Left_lk_tig;
	pair< Contig_id, int > Right_lk_tig;
	int Left_lk_len;
	int Right_lk_len;
	int gap_length;

	int matehit;    // val == 1,true; val == 0, ambi; val == -1, false
	vector< pair< int, int > > cover_area;       // mate covered area by stem.
	double cover_rate;

	Bridge_a()
	{
		Left_lk_len = 0;
		Right_lk_len = 0;
		gap_length = 0;
		cover_rate = 0;
	}



};

class Structed_tig
{
public:
	vector< Contig_id > Tig_Ve;
	vector< int > Tig_F_Ve;                   // Forb
	vector< pair< int, int > > Tig_P_Ve;       // Position
	int length;

	map< size_t, map< pair< Contig_id, int >, Bridge_a > > bulbmap;
};

class Tig_ovlink
{
public:

	map< pair< Contig_id, int >, int > Head_Id_Ov_Ma;
	map< pair< Contig_id, int >, int > Tail_Id_Ov_Ma;

};

class Scaffold
{
public:
	Contig_id ida;       // paired id of tig a and b
	Contig_id idb;
//	pair<int, int> drct;  // direction of tig a and b:  ( 0,0 ) == ( -->, --> ); ( 0,1 ) == ( -->, <-- ); ( 1,0 ) == ( <--, --> ); ( 1,1 ) == ( <--, <-- )
	int drct_type;        //                                  type 1                    type 2                  type 3                     type 4
	int mean;             // mean value of the gap length

};

class Assembly_bank
{
public:
	map< Contig_id, Contig_bank > Contig_map;
	set< Contig_id > singlet_set;
	set< Contig_id > Structed_idset;
	map< Contig_id, Structed_tig > Structed_tig_map;   //including Structed and bridged tig from tig_bank.       
	map< Contig_id, Structed_tig > bridge_tig_map;
	map< Contig_id, Tig_ovlink > strong_ovlink_map;
	map< int, Scaffold > scf_map;
	map< Contig_id, map< Contig_id, vector< int > > > Pair_Scaffold_map;
//	map<>
	
	Assembly_bank()
	{
		
	}
};


class short_assembly_bank
{
public:

	int ov_len_th;
	double er_thr;
	int wl;
	int ini;
	int begin_rid;
	int end_rid;

	vector<int> readid_ve;

	map< Aln_id, Calignment > Aln_Map;
	map< int, map< int, Aln_id > > IdAliMap;
	map< int, map<int, multimap<int, Aln_id, greater<int> > > > MulIdAliMap;
	map< int, C_Link > clmap;
	multimap<int, Aln_id> InalignMap;
	set< pair<int, int> > mismatch;      //id1, id2 , id1<id2
//	map< int, Calignment > AliMap;

	vector< Contig > ConVe;

	Assembly_bank assbank;
	MP_bank mp_bank;

	void clear_all()
	{
		readid_ve.clear();
		Aln_Map.clear();
		IdAliMap.clear();
		MulIdAliMap.clear();
		clmap.clear();
		InalignMap.clear();
		mismatch.clear();
	}

};


#endif

