#include "calignment.h"
#include "sequencetransform.h"
#include <vector>
#include <map>
#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

void Calignment::alignreverse()
{
	reverse(alignseq.begin(),alignseq.end());
	for_each( alignseq.begin(), alignseq.end(),	
			SequenceTransform_T::ToOppRule_T() );

	if(r==1||r==0){
		int mid;
		mid = id1;
		id1 =id2;
		id2 = mid;
	}

	if( r == 1 || r == 0 ){
		int mhort;
		mhort = hort1;
		hort1 = hort2;
		hort2 = mhort;
	}

	if(r==1||r==0){
		int mforb;
		mforb = forb1;
		forb1 = forb2;
		forb2 = mforb;
	}
	if(forb1==0)
		forb1 = 1;
	else
		forb1 = 0;
	if(forb2==0)
		forb2 = 1;
	else
		forb2 = 0;

	if(r==0||r==1){
		int i = idx_i;
		int j = idx_j;
		idx_i = seq2Len - j +1;
		idx_j = seq1Len - i +1;
	}else{
		if ( r == 2 ) {
			int i = idx_i;
			int j = idx_j;
			idx_i = seq1Len - j + 1;
			idx_j = seq1Len - i + 1;
		} else {
			int i = idx_i;
			int j = idx_j;
			idx_i = seq2Len - j + 1;
			idx_j = seq2Len - i + 1;
		}
	}

	if(r==0||r==1){
		int mLen;
		mLen = seq1Len;
		seq1Len = seq2Len;
		seq2Len = mLen;
	}
	

	if(!misp.empty()){
	
		deque<pair<pair<char, char>, pair<int,int> > > newmisp;
		deque<pair<pair<char, char>, pair<int,int> > >::iterator ite;
	//	deque<pair<int,int> > newmisqs;
	//	deque<pair<int,int> >::iterator itemq = misqs.begin();
	
		if(r == 0||r == 1){
			
			for(ite= misp.begin(); ite!=misp.end(); ++ite){
				
				int a, b;
				if(ite->first.second == '-'){
					a = seq1Len-ite->second.second;
				}else
					a = seq1Len-ite->second.second+1;
				if(ite->first.first == '-'){
					b = seq2Len-ite->second.first;
				}else
					b = seq2Len-ite->second.first+1;
				newmisp.push_front(make_pair(make_pair( SequenceTransform_T::complement(ite->first.second), SequenceTransform_T::complement(ite->first.first)), make_pair(a,b)));
			
			//	newmisqs.push_front(make_pair(itemq->second, itemq->first));

			//	++itemq;
			}
		}else{
			for(ite= misp.begin(); ite!=misp.end(); ++ite){
				
				int a, b;
				if(ite->first.first == '-'){
					a = seq1Len-ite->second.first;
				

				}else
					a = seq1Len-ite->second.first+1;
				if(ite->first.second == '-'){
					b = seq2Len-ite->second.second;
					
				}else
					b = seq2Len-ite->second.second+1;
				newmisp.push_front(make_pair(make_pair( SequenceTransform_T::complement(ite->first.first), SequenceTransform_T::complement(ite->first.second)), make_pair(a,b)));
			
			//	newmisqs.push_front(make_pair(itemq->first, itemq->second));
			//	++itemq;
		
			}

		}
		misp =newmisp;
	//	misqs = newmisqs;
	

	}

	int m = left;
	left = right;
	right = m;
	
}

void Calignment::alignupdown()
{
	int mid;
	mid = id1;
	id1 =id2;
	id2 = mid;

	int mhort;
	mhort = hort1;
	hort1 = hort2;
	hort2 = mhort;

	int mforb;
	mforb = forb1;
	forb1 = forb2;
	forb2 = mforb;  
	
	int midx;
	midx = idx_i;
	idx_i = idx_j;
	idx_j = midx;

	int mLen;
	mLen = seq1Len;
	seq1Len = seq2Len;
	seq2Len = mLen;

	if(r==0){
		r = 1;
	}else{
		r=0;
	}

	if(!misp.empty()){
		deque<pair<pair<char, char>, pair<int,int> > > newmisp;
		deque<pair<pair<char, char>, pair<int,int> > >::iterator ite;
		deque<pair<Str,Str> > newsubstr;
	
		for(ite= misp.begin(); ite!=misp.end(); ++ite){
			newmisp.push_back(make_pair(make_pair(ite->first.second,ite->first.first), make_pair(ite->second.second,ite->second.first)));
		
		
		}
		misp =newmisp;
	
	}
}

void Calignment::self_calculate_read_len()
{
	int bar_n_1 = 0;
	int bar_n_2 = 0;
	deque<pair<pair<char, char>, pair<int,int> > >::iterator Ited;
	for ( Ited = misp.begin(); Ited != misp.end(); ++Ited ) {
		if ( Ited->first.first == '-' )
			bar_n_1 += 1;
		if ( Ited->first.second == '-' )
			bar_n_2 += 1;
	}

	if ( r == 0 ) {
		seq1Len = left + middle - bar_n_1;
		seq2Len = middle + right - bar_n_2;
	} else if ( r == 1 ) {
		seq1Len = middle + right - bar_n_1;
		seq2Len = left + middle - bar_n_2;
	} else if ( r == 2 ) {
		seq1Len = left + middle + right - bar_n_1;
		seq2Len = middle - bar_n_2;
	} else if ( r == 3 ) {
		seq1Len = middle - bar_n_1;
		seq2Len = left + middle + right - bar_n_2;
	} else {
		cout<<"error in Calignment::self_calculate_read_len() r = "<<r<<endl;  exit(1);
	}
}

void Calignment::self_calculate_hort()
{
	if ( r == 0 ) {
		if ( forb1 == 0 )
			hort1 = 0;
		else
			hort1 = 1;
		if ( forb2 == 0 )
			hort2 = 1;
		else
			hort2 = 0;
	} else if ( r == 1 ) {
		if ( forb1 == 0 ) 
			hort1 = 1;
		else
			hort1 = 0;
		if ( forb2 == 0 )
			hort2 = 0;
		else
			hort2 = 1;
	}
}


bool filteralign( Calignment &ob, double thr_error_pvalue, double thr_hq_error_pvalue )
{
	if ( ob.error_pvalue < thr_error_pvalue )
		return false;
//	if ( ob.hq_error_pvalue < thr_hq_error_pvalue )
//		return false;
	return true;
}

bool filteralign( int ovlenthr, double errorthr, double thr_100, double thr_50, double snprate, Calignment &ob )
{

	if( ob.score < ovlenthr ) {
		return false;
	}
	double thr_all = errorthr + snprate;
	double thr_medium = max( 0.05, errorthr);
	double thr_high = snprate;

	double thr_overall = thr_all;
	double thr_medium_overall = thr_medium;
	double thr_high_overall = thr_high;
	if ( ob.score <= 80 ) {
		thr_overall = max( thr_overall, thr_50 );
		thr_medium_overall = max( thr_medium_overall, thr_50 );
	} else if ( ob.score  <= 150 ) {
		thr_overall = max( thr_overall, thr_100 );
		thr_medium_overall = max( thr_medium_overall, thr_100 );
	}

	if ( ob.ov_er_rate > thr_overall )
		return false;

	if ( ob.high_qual_mis_rate > thr_high_overall ) 
		return false;

	if ( ob.medium_qual_mis_rate + ob.high_qual_mis_rate > thr_medium_overall )
		return false;

	if ( ob.ov_er_rate_100 > max( thr_all, thr_100 ) )
		return false;
	
	if ( ob.high_qual_mis_rate_100 > thr_high )
		return false;

	if ( ob.medium_qual_mis_rate_100 + ob.high_qual_mis_rate_100 > max ( thr_medium + thr_high, thr_100 ) )
		return false;

	if ( ob.ov_er_rate_50 >   max( 1.333 * thr_all, thr_50 ) ) 
		return false;

	if ( ob.high_qual_mis_rate_50 > 1.333 * thr_high )
		return false;

	if ( ob.medium_qual_mis_rate_50 + ob.high_qual_mis_rate_50 > max( 1.333 * (thr_medium + thr_high), thr_50 ) )
		return false;

	return true;
}


void Align::process( int tip )
{

	kmers = getseed(seq1, seq2, wl);

	seeds = extend(kmers, wl, seq1, seq2);

	map<int, vector<Seed_a> >::iterator Ites;

	paths = findpath(seeds, seq1, seq2, 5, 10);



	if(!paths.empty()){
		for(int i = 0; i < (int)paths.size(); ++i){
			Calignment a_ob = makealign(paths[i], seq1, seq2, qul1, qul2, ovlenthr, tip );
			if(a_ob.score >= ovlenthr){
				alive.insert(make_pair(a_ob.score, a_ob));
			
			
			}
				
		
		}
	}


}

void Align::process2(set<pair<int, int> > &match)
{
	

	seeds = extendfrommac(match, wl, seq1, seq2);

	

	paths = findpath(seeds, seq1, seq2, 5, wl);

	if(!paths.empty()){
		for(int i = 0; i < (int)paths.size(); ++i){
			Calignment a_ob = makealign(paths[i], seq1, seq2, qul1, qul2, ovlenthr, 0);
		
				if(a_ob.score >= ovlenthr){
				
						alive.insert(make_pair(a_ob.score, a_ob));
					

				}
		
		
		}
	}


}

map<int, vector<int> > Align::getseed(string &se1, string &se2, int l)
{
	map<int, vector<int> > mer;

	int seq1Len = (int)se1.size();
	int seq2Len = (int)se2.size();

	int tag = 0;
	int i = 0;
	for(; i<=seq1Len-1; ++i){

		vector<int> smer;
		string s1 = se1.substr(i, min(seq2Len, seq1Len-i));
		string s2 = se2.substr(0, min(seq1Len-i, seq2Len));

		int j;
		for (j=1; j<=(int)s1.size() - l + 1; ){
		
				if(s1.substr(j-1,l)==s2.substr(j-1,l)){
					smer.push_back(j);
					j = j+l;
					continue;
				}else{
					j++;
					continue;
				}

		
		}

		if(!smer.empty()){
			mer.insert(make_pair(i, smer));
		}
		smer.erase(smer.begin(), smer.end());
	}

	for(i=-1; i>=1-seq2Len; --i){

		vector<int> smer;
		string s1 = se1.substr(0, min(seq1Len, seq2Len+i));
		string s2 = se2.substr(-i, min(seq1Len, seq2Len+i));
		

		int j;
		for (j=1; j<=(int)s1.size() - l + 1; ){
		
				if(s1.substr(j-1,l)==s2.substr(j-1,l)){
					smer.push_back(j-i);
					j = j+l;
					continue;
				}else{
					j++;
					continue;
				}

		
		}

		if(!smer.empty()){
			mer.insert(make_pair(i, smer));
		}
		smer.erase(smer.begin(), smer.end());
	}

	return mer;

}

map<int, vector<Seed_a> > Align::extend(map<int, vector<int> > &inkmers, int l, string &se1, string &se2)
{
	map<int, vector<Seed_a> > reva;

	map<int, vector<int> >::iterator Itek;

	int h = 0;
	for(Itek = inkmers.begin(); Itek != inkmers.end(); ++Itek){
		h+=1;

		vector<int> ve = Itek->second;
		int dif = Itek->first;
		Seed_a sob;
		sob.idx_i = dif + ve[0];
		sob.idx_j = ve[0];
		sob.length = l;
		for(int i = 1; i < (int)ve.size(); ++i){
			if(ve[i] == sob.idx_j + sob.length){
				sob.length += l;
				continue;
			}else{
				int size = min((int)se1.size()-sob.idx_i-sob.length+1, (int)se2.size()-sob.idx_j-sob.length+1);
				int idx_i = sob.idx_i+sob.length;
				int idx_j = sob.idx_j+sob.length;
				for(int j = 0; j < size; ++j){
					
					if(se1[idx_i-1+j] == se2[idx_j-1+j])
						sob.length += 1;				
					else
						break;
				}
				if(reva.find(dif) != reva.end())
					reva[dif].push_back(sob);
				else{
					vector<Seed_a> sve;
					sve.push_back(sob);
					reva.insert(make_pair(dif, sve));
				}

				sob.idx_i = dif + ve[i];
				sob.idx_j = ve[i];
				sob.length = l;
			}
		}

		int size = min((int)se1.size()-sob.idx_i-sob.length+1, (int)se2.size()-sob.idx_j-sob.length+1);
		int idx_i = sob.idx_i+sob.length;
		int idx_j = sob.idx_j+sob.length;
		for(int j = 0; j < size; ++j){
			
			if(se1[idx_i-1+j] == se2[idx_j-1+j])
				sob.length += 1;				
			else
				break;
		}
		if(reva.find(dif) != reva.end())
			reva[dif].push_back(sob);
		else{
			vector<Seed_a> sve;
			sve.push_back(sob);
			reva.insert(make_pair(dif, sve));
		}
	}

	return reva;
}

map<int, vector<Seed_a> > Align::extendfrommac(std::set<pair<int,int> > &match, int l, std::string &se1, std::string &se2)
{
	map<int, vector<Seed_a> > va;
	map<int, set<int> > tmp;
	
	set<pair<int, int> >::iterator Item;
	for(Item = match.begin(); Item != match.end(); ++Item){
		int dif = Item->first - Item->second;
		tmp[dif].insert(Item->first);
	}
	
	map<int, set<int> >::iterator Itet;
	for(Itet = tmp.begin(); Itet != tmp.end(); ++Itet){
		vector<Seed_a> vsa;
		set<int>::iterator Ites;
		for(Ites = Itet->second.begin(); Ites != Itet->second.end(); ++Ites){
			int idx_i = *Ites;
			if(!vsa.empty()){
				int bi = vsa.back().idx_i + vsa.back().length;
				if(idx_i <= bi)
					continue;
			}
			Seed_a s_ob;
			s_ob.idx_i = idx_i;
			s_ob.idx_j = idx_i - Itet->first;
			s_ob.length = l;
			int mit = min(s_ob.idx_i, s_ob.idx_j);
			for(int i = 1; i < mit; ++i){
				if(se1[s_ob.idx_i-2] == se2[s_ob.idx_j-2]){
					s_ob.idx_i -= 1;
					s_ob.idx_j -= 1;
					s_ob.length += 1;
				}else
					break;
			}
			
		
			int mat = min((int)se1.size()-s_ob.idx_i-s_ob.length+1, (int)se2.size()-s_ob.idx_j-s_ob.length+1);
			for(int i = 0; i < mat; ){
				int ii = s_ob.idx_i + s_ob.length;
				int jj = s_ob.idx_j + s_ob.length;
				if(Itet->second.find(ii) != Itet->second.end()){
					s_ob.length += l;
				
					i += l;
					continue;
				}else{
					if(se1[ii-1] == se2[jj-1]){
						s_ob.length += 1;
						i++;
						continue;
					}else
						break;
				}
				
			}

			vsa.push_back(s_ob);
		}

		va.insert(make_pair(Itet->first, vsa));
		vsa.clear();
	}

	return va;

}

vector<map<pair<int, int>, int > > Align::findpath(map<int, vector<Seed_a> > &inseed, string &se1, string &se2, int w, int sl)
{
	vector<map<pair<int, int>, int > > va;
	set<int> used;

	vector<vector<Seed_a> > Sve;
	map<int, vector<Seed_a> >::iterator Ites;
	for(Ites = inseed.begin(); Ites != inseed.end(); ++Ites){
		vector<Seed_a> ve;
		if(used.find(Ites->first) != used.end())
			continue;
		for(int i = 0; i <= w; ++i){
			if(inseed.find(Ites->first + i) != inseed.end()){
				ve.insert(ve.end(), inseed[Ites->first+i].begin(), inseed[Ites->first+i].end());
				used.insert(Ites->first + i);
			}
		}
		Sve.push_back(ve);
	}


	for(int i = 0; i < (int)Sve.size(); ++i){
		multimap<int, Seed_a, greater<int> > seem;
	
		for(int j = 0; j < (int)Sve[i].size(); ++j){
			seem.insert(make_pair(Sve[i][j].length, Sve[i][j]));
		}
		int dif = 0;
	
		map<pair<int, int>, Seed_a> seem_se;
		multimap<int, Seed_a, greater<int> >::iterator Items;
		for(Items = seem.begin(); Items != seem.end(); ++Items){
			Seed_a sob = Items->second;
			int state = 0;

			if(seem_se.empty()){
				seem_se.insert(make_pair(make_pair(sob.idx_i, sob.idx_j), sob));
				dif = sob.idx_i - sob.idx_j;
			}else{
				map<pair<int, int>, Seed_a >::iterator Itese;
				for(Itese = seem_se.begin(); Itese != seem_se.end(); ++Itese){
					state = checkhybrid(Itese->second, sob);
					if(state == 1)
						continue;
					else
						break;
				}
			}
			if(state != 0){
				seem_se.insert(make_pair(make_pair(sob.idx_i, sob.idx_j), sob));
			}
		}

	

		multimap<int, Seed_a, greater<int> > addseem;
		map<pair<int, int>, Seed_a >::iterator Itese;
		for(Itese = seem_se.begin(); Itese != seem_se.end(); ++Itese){
			if(Itese == seem_se.begin()){
				int tlen = min(Itese->first.first-1, Itese->first.second-1);
				if(tlen >= sl){
					int start_i = Itese->first.first-1-tlen;
					int start_j = Itese->first.second-1-tlen;
					string ts1 = se1.substr(start_i, tlen);
					string ts2 = se2.substr(start_j, tlen);
					map<int, vector<int> > t_seed = getseed(ts1,ts2,sl);
					if(!t_seed.empty()){
						addseemf(addseem, t_seed, sl, ts1, ts2, start_i, start_j);
					}
				}
			}
			map<pair<int, int>, Seed_a >::iterator Itese_2 = Itese;
			++Itese_2;
			if(Itese_2 == seem_se.end()){
				int idx_i = Itese->first.first + Itese->second.length;
				int idx_j = Itese->first.second + Itese->second.length;
				int tlen = min((int)se1.size()-idx_i+1, (int)se2.size()-idx_j+1);
				if(tlen >= sl){
					string ts1 = se1.substr(idx_i-1, tlen);
					string ts2 = se2.substr(idx_j-1, tlen);
					map<int, vector<int> > t_seed = getseed(ts1,ts2,sl);
					if(!t_seed.empty()){
						addseemf(addseem, t_seed, sl, ts1, ts2, idx_i-1, idx_j-1);
					}
				}
			}else{
				int idx_i = Itese->first.first + Itese->second.length;
				int idx_j = Itese->first.second + Itese->second.length;
				int tlen = min(Itese_2->first.first-idx_i, Itese_2->first.second-idx_j);
				if(tlen >= sl){
					string ts1 = se1.substr(idx_i-1, tlen);
					string ts2 = se2.substr(idx_j-1, tlen);
					map<int, vector<int> > t_seed = getseed(ts1,ts2,sl);
					if(!t_seed.empty()){
						addseemf(addseem, t_seed, sl, ts1, ts2, idx_i-1, idx_j-1);
					}
				}
			}
		}
		
		if(!addseem.empty()){
			for(Items = addseem.begin(); Items != addseem.end(); ++Items){
				Seed_a sob = Items->second;
				int state = 0;
				if(seem_se.empty()){
					seem_se.insert(make_pair(make_pair(sob.idx_i, sob.idx_j), sob));
				}else{
					map<pair<int, int>, Seed_a >::iterator Itese;
					for(Itese = seem_se.begin(); Itese != seem_se.end(); ++Itese){
						state = checkhybrid(Itese->second, sob);
						if(state == 1)
							continue;
						else
							break;
					}
				}
				if(state != 0){
					seem_se.insert(make_pair(make_pair(sob.idx_i, sob.idx_j), sob));
				}
			}
		}

		map<pair<int, int>, int> vam;
		int adlen = 0;
	
		for(Itese = seem_se.begin(); Itese != seem_se.end(); ++Itese){
			vam.insert(make_pair(Itese->first, Itese->second.length));
			adlen += Itese->second.length;
		
		}
		
		int start = 1 + dif;
		if(start <= 1)
			start = 1;
		int end = (int)se2.size() + dif;
		if(end >= (int)se1.size())
			end = (int)se1.size();
		int ov = end - start + 1;
		if(ov>0){
			double ra = double(adlen)/ov;
			if(ra >= 0.3)
				va.push_back(vam);
		//	else if ( ra >= 0.7 && ov < 200 ) 
		//		va.push_back(vam);
		//	else if ( ra >= 0.6 && ov < 100 )
		//		va.push_back(vam);
		//	else if ( ra >= 0.5 && ov < 50 )
		//		va.push_back( vam );
		}
	}

	return va;
}

void Align::addseemf(multimap<int, Seed_a, greater<int> > &addseem, map<int, vector<int> > &t_seed, int sl, string &ts1, string &ts2, int i1, int i2)
{
	map<int, vector<int> >::iterator Itet;
	vector<int> era;
	for(Itet = t_seed.begin(); Itet != t_seed.end(); ++Itet){
		if(Itet->first<-1 || Itet->first>1)
			era.push_back(Itet->first);
	}
	for(int e = 0; e < (int)era.size(); ++e){
		t_seed.erase(era[e]);
	}
	if(!t_seed.empty()){
		map<int, vector<Seed_a> > t_se = extend(t_seed, sl, ts1, ts2);
		map<int, vector<Seed_a> >::iterator itets;
		for(itets = t_se.begin(); itets != t_se.end(); ++itets){
			vector<Seed_a> ve = itets->second;
			for(int h = 0; h < (int)ve.size(); ++h){
				Seed_a sob;
				sob.length = ve[h].length;
				sob.idx_i = ve[h].idx_i + i1;
				sob.idx_j = ve[h].idx_j + i2;
				addseem.insert(make_pair(sob.length, sob));
			}
		}
	}
}

int Align::checkhybrid(Seed_a &sob1, Seed_a &sob2)   // if return 0, overlap, if return 1, sob1 beahead sob2, if return -1, sob1 follow sob2
{
	int c1 = 0;
	
	int idx_i_1 = sob1.idx_i;
	int idx_i_2 = sob1.idx_i + sob1.length;
	int idx_i_3 = sob2.idx_i;
	int idx_i_4 = sob2.idx_i + sob2.length;
	if(idx_i_3 > idx_i_2){
		c1 = 1;
	}else if(idx_i_4 < idx_i_1){
		c1 = -1;
	}else
		c1 = 0;

	if(c1 == 0)
		return 0;

	int c2 = 0;
	int idx_j_1 = sob1.idx_j;
	int idx_j_2 = sob1.idx_j + sob1.length;
	int idx_j_3 = sob2.idx_j;
	int idx_j_4 = sob2.idx_j + sob2.length;
	if(idx_j_3 > idx_j_2){
		c2 = 1;
	}else if(idx_j_4 < idx_j_1){
		c2 = -1;
	}else
		c2 = 0;

	if(c2 == 0)
		return 0;

	if(c1 > 0 && c2 > 0)
		return 1;
	else if(c1 < 0 && c2 < 0)
		return 2;
	else{
		cout<<"warning in checkhybrid"<<endl;
		return 0;
	}
}


Calignment Align::makealign(std::map<pair<int,int>,int> &path, string &se1, string &se2, vector<int> &scve1, vector<int> &scve2, int ovlen, int tip)   // tip = 1 ɣ tip = 0 
{

	if((int)se1.size() != (int)scve1.size() || (int)se2.size() != (int)scve2.size()){
		cout<<"error (int)se1.size() != (int)scve1.size() " <<endl;    exit(2);
	}

	Calignment ob;
	ob.id1 = id1;
	ob.id2 = id2;
	ob.forb1 = forb1;
	ob.forb2 = forb2;
	int score = 0;
	ob.score = score;

	int seq1Len = (int)se1.size();
	int seq2Len = (int)se2.size();

	ob.seq1Len = seq1Len;
	ob.seq2Len = seq2Len;

	map<pair<int, int>,int>::iterator Itep;
	Itep = path.begin();

	string sequen;
	string overlap;
	int thescore=0;
	int misnum=0;
	int theleft = 0;
	int theright = 0;
	int themiddle = 0;
	int r_head = 0;
	int r_tail = 0;
	int bretag = 0;

//	vector<int> aliqul1;
//	vector<int> aliqul2;

	int indelsize = 0;

	if((Itep->first.first != 1)&&(Itep->first.second != 1)){

		string s1 = se1.substr(0,Itep->first.first);
		string s2 = se2.substr(0,Itep->first.second);
	
	//	vector<int> sv1;
	//	vector<int> sv2;
	
	//	sv1.insert(sv1.end(), scve1.begin(), scve1.begin()+Itep->first.first);
	//	sv2.insert(sv2.end(), scve2.begin(), scve2.begin()+Itep->first.second);
	
		Localalign L_ob;
	
	//	L_ob.headalign(s1, s2, sv1, sv2);
		L_ob.headalign(s1, s2);
	
		thescore += L_ob.score;
	
		if(thescore <= -50 )
			return ob;
		sequen += L_ob.alignseq.substr(0,(int)L_ob.alignseq.size()-1);
		theleft = L_ob.leftlen;
		if(theleft>=(int)sequen.size())
			return ob;
		r_head = L_ob.r;
		overlap += sequen.substr(theleft);
	//	ob.ovqlve1.insert(ob.ovqlve1.end(), L_ob.aliqul1.begin(), L_ob.aliqul1.end());
	//	ob.ovqlve2.insert(ob.ovqlve2.end(), L_ob.aliqul2.begin(), L_ob.aliqul2.end());

		if(!L_ob.misp.empty()){
			misnum += (int)L_ob.misp.size();
			deque<pair<pair<char, char>, pair<int,int> > >::iterator ite;
		//	deque<pair<int,int> >::iterator iteqs = L_ob.misqs.begin();
			for(ite=L_ob.misp.begin(); ite!=L_ob.misp.end(); ++ite){
				int a = ite->second.first;
				int b = ite->second.second;
				ob.misp.push_back(make_pair(ite->first,make_pair(a,b)));
			//	ob.misqs.push_back(*iteqs);
				
			
				if(ite->first.first == '-' || ite->first.second == '-')
					indelsize += 1;
			//	++iteqs;
				
			}
		}

	}
	else{
						
		if((Itep->first.second == 1)&&(Itep->first.first != 1)){
			
			sequen += se1.substr(0,Itep->first.first-1);	
			theleft = (int)sequen.size();
			r_head = 1;

		
		}else{
			if((Itep->first.second != 1)&&(Itep->first.first == 1)){
				
				sequen += se2.substr(0,Itep->first.second-1);
				theleft = (int)sequen.size();
				r_head = 2;

			
			}
		}

	}

	for(Itep = path.begin(); Itep != path.end(); ++Itep){
		
		map<pair<int, int>,int>::iterator Itep_2 = Itep;
		Itep_2++;
		if(Itep_2 == path.end()){
			 
			sequen += se1.substr(Itep->first.first-1, Itep->second);
		
			overlap += se1.substr(Itep->first.first-1, Itep->second);
		/*	for(int i = Itep->first.first-1; i < (Itep->first.first-1 + Itep->second); ++i){
			
				ob.ovqlve1.push_back(scve1[i]);
				
			}
			for(int i = Itep->first.second-1; i < (Itep->first.second-1 + Itep->second); ++i){
			
				ob.ovqlve2.push_back(scve2[i]);
			}
			*/
	
			thescore += Itep->second;
			break;
		}else{
			if(((Itep_2->first.second-Itep->first.second)==Itep->second)&&((Itep_2->first.first-Itep->first.first)==Itep->second)){
				sequen += se1.substr(Itep->first.first-1, Itep->second);
			
				overlap+= se1.substr(Itep->first.first-1, Itep->second);
			/*	int h = Itep->first.first-1 + Itep->second;
				for(int i = Itep->first.first-1; i < h; ++i){
				
					ob.ovqlve1.push_back(scve1[i]);
					
				}
				h = Itep->first.second-1 + Itep->second;
				for(int i = Itep->first.second-1; i < h; ++i){
				
					ob.ovqlve2.push_back(scve2[i]);
				} */
				thescore+=wl;
			
				continue;
			}else{
				sequen += se1.substr(Itep->first.first-1, Itep->second);
			
				overlap+= se1.substr(Itep->first.first-1, Itep->second);
			/*	int h = Itep->first.first-1 + Itep->second;
				for(int i = Itep->first.first-1; i < h; ++i){
				
					ob.ovqlve1.push_back(scve1[i]);
					
				}
				h = Itep->first.second-1 + Itep->second;
				for(int i = Itep->first.second-1; i < h; ++i){
				
					ob.ovqlve2.push_back(scve2[i]);
				}  */
				thescore+=Itep->second;
			

				string s1 = se1.substr(Itep->first.first+Itep->second-2, Itep_2->first.first-Itep->first.first-Itep->second+2);
				string s2 = se2.substr(Itep->first.second+Itep->second-2, Itep_2->first.second-Itep->first.second-Itep->second+2);								
					
			
			
			//	vector<int> sv1;
			//	vector<int> sv2;
	
			//	sv1.insert(sv1.end(), scve1.begin()+Itep->first.first+Itep->second-2, scve1.begin()+Itep_2->first.first);
			//	sv2.insert(sv2.end(), scve2.begin()+Itep->first.second+Itep->second-2, scve2.begin()+Itep_2->first.second);
			
				Localalign L_ob;
			
			//	L_ob.midalign(s1,s2,sv1,sv2);	
				L_ob.midalign(s1,s2);	
			
				if(L_ob.score <= -50){
					
					bretag=1;
					break;
				}
				thescore+=L_ob.score-2;
				
				sequen += L_ob.alignseq.substr(1,(int)L_ob.alignseq.size()-2);
			
				
				overlap += L_ob.alignseq.substr(1,(int)L_ob.alignseq.size()-2);
			//	ob.ovqlve1.insert(ob.ovqlve1.end(), L_ob.aliqul1.begin(), L_ob.aliqul1.end());
			//	ob.ovqlve2.insert(ob.ovqlve2.end(), L_ob.aliqul2.begin(), L_ob.aliqul2.end());
				if(!L_ob.misp.empty()){
					misnum += (int)L_ob.misp.size();
					deque<pair<pair<char, char>, pair<int,int> > >::iterator ite;
				//	deque<pair<int,int> >::iterator iteqs = L_ob.misqs.begin();
					for(ite=L_ob.misp.begin(); ite!=L_ob.misp.end(); ++ite){
						int a = Itep->first.first+Itep->second-2+ite->second.first;
						int b = Itep->first.second+Itep->second-2+ite->second.second;
						ob.misp.push_back(make_pair(ite->first,make_pair(a,b)));
					//	ob.misqs.push_back(*iteqs);
					
						if(ite->first.first == '-' || ite->first.second == '-')
							indelsize += 1;
					//	++iteqs;
								
					}

				}
				
			}

		}
	}
	

	if(bretag==1)
		return ob;

	if(Itep->first.first+Itep->second<=seq1Len && Itep->first.second+Itep->second<=seq2Len){

		string s1 = se1.substr(Itep->first.first+Itep->second-2);
		string s2 = se2.substr(Itep->first.second+Itep->second-2);
	

	//	vector<int> sv1;
	//	vector<int> sv2;
	
	//	sv1.insert(sv1.end(), scve1.begin()+Itep->first.first+Itep->second-2, scve1.end());
	//	sv2.insert(sv2.end(), scve2.begin()+Itep->first.second+Itep->second-2, scve2.end());
	
		Localalign L_ob;
	
	//	L_ob.tailalign(s1,s2,sv1,sv2);
		L_ob.tailalign(s1,s2);
	
		
		thescore+=L_ob.score;
	
		if(L_ob.score<=-50){
	
			return ob;
		}
		sequen += L_ob.alignseq.substr(1);
	
		theright = L_ob.rightlen;

		overlap += L_ob.alignseq.substr(1,(int)L_ob.alignseq.size()-theright-1);	 
	//	ob.ovqlve1.insert(ob.ovqlve1.end(), L_ob.aliqul1.begin(), L_ob.aliqul1.end());
	//	ob.ovqlve2.insert(ob.ovqlve2.end(), L_ob.aliqul2.begin(), L_ob.aliqul2.end());
		r_tail=L_ob.r;
	
		if(!L_ob.misp.empty()){
			misnum += (int)L_ob.misp.size();
			deque<pair<pair<char, char>, pair<int,int> > >::iterator ite;
		//	deque<pair<int,int> >::iterator iteqs = L_ob.misqs.begin();
			for(ite=L_ob.misp.begin(); ite!=L_ob.misp.end(); ++ite){
				int a = Itep->first.first+Itep->second-2+ite->second.first;
				int b = Itep->first.second+Itep->second-2+ite->second.second;
			
				ob.misp.push_back(make_pair(ite->first,make_pair(a,b)));
			//	ob.misqs.push_back(*iteqs);
			
				if(ite->first.first == '-' || ite->first.second == '-')
					indelsize += 1;
			//	++iteqs;
		
			}
		}
	
		

	}else{						

		if(seq1Len-Itep->first.first > seq2Len-Itep->first.second ){
			sequen += se1.substr(Itep->first.first+(seq2Len-Itep->first.second));
		
			theright = (int)se1.substr(Itep->first.first+(seq2Len-Itep->first.second)).size();
			r_tail = 3;
		}else if(seq2Len-Itep->first.second > seq1Len-Itep->first.first){
			sequen += se2.substr(Itep->first.second+(seq1Len-Itep->first.first));
		
			theright = (int)se2.substr(Itep->first.second+(seq1Len-Itep->first.first)).size();
			r_tail = 4;
		}
	}
	
	if(!overlap.empty())
		themiddle = (int)overlap.size();		

	double lam = themiddle * (2*(thr+snprate));
	int k = misnum;
	ob.error_pvalue = poissonf( lam, k );
//	int hq_error_num = ob.calculate_hq_mis();
//	double lam_hq = themiddle * (2*snprate);
//	k = hq_error_num;
//	ob.hq_error_pvalue = poissonf( lam_hq, k );

	if ( ob.error_pvalue == 0  ) {
		if ( (thr+snprate) < 0.002 )
			return ob;
		if ( ob.score > 100 )
			return ob;
	//	if ( hq_error_num > 2 )
	//		return ob;
		if ( misnum > 10 )
			return ob;
		if ( misnum <= 80 && misnum > 8 )
			return ob;
		if ( misnum <= 40 && misnum > 7 )
			return ob;
		if ( misnum <= 30 && misnum > 6 )
			return ob;
	}

	if ( themiddle > 100 ) {
		if ( misnum > lam )
			return ob;
	}

		
			ob.score = themiddle;
			ob.left = theleft;
			ob.right = theright;
			ob.middle = themiddle;
		
			if((r_head==1||r_head==0)&&(r_tail==3||r_tail==0)){//seq2 contained in seq1
				ob.r = 2;
				
				ob.idx_i = ob.left+1;
				ob.idx_j = seq1Len - ob.right;

			}else{
				if(r_head==1&&r_tail==4){
					ob.r = 0;
					ob.idx_i = ob.left+1;
					ob.idx_j = seq2Len - theright;
					if(forb1 == 0)
						ob.hort1 = 0;
					else
						ob.hort1 = 1;

					if(forb2 == 0)
						ob.hort2 = 1;
					else
						ob.hort2 = 0;

				}else{
					if(r_head==2&&r_tail==3){
						ob.r=1;
						ob.idx_i = seq1Len - theright;
						ob.idx_j = ob.left + 1;

						if(forb1 == 0)
							ob.hort1 = 1;
						else
							ob.hort1 = 0;

						if(forb2 == 0)
							ob.hort2 = 0;
						else
							ob.hort2 = 1;

					}else{
						ob.r = 3;                         //seq1 contained in seq2?
						ob.idx_i = ob.left+1;
						ob.idx_j = seq2Len - theright;
					}
				}
			}

		
	
	return ob;
}


