#ifndef CALIGNMENT_H
#define CALIGNMENT_H

#include "typedefbase.h"
#include <deque>
#include <map>
#include "sequencetransform.h"
#include <vector>
#include <map>
#include <iostream>
#include <fstream>
#include <set>
#include <string>
#include <math.h>
#include <algorithm>
#include "localalign.h"
#include "probfunc.h"
#include "poperate.h"


using namespace std;

class Calignment
{
public:
	int id1;
	int id2;
	int forb1;
	int forb2;
	int r;
	int hort1;   // hort1 and hort2 repreasent the phase of reads after alignment. 0 indicates the tail hangs vs. 1 indecates the head hangs.
	int hort2;
    int score;
	Str alignseq;
	int idx_i;
	int idx_j;
	double error_pvalue;
//	double hq_error_pvalue;
	double ov_er_rate;
	double low_qual_mis_rate;
	double medium_qual_mis_rate;
	double high_qual_mis_rate;
	double ov_er_rate_100;
	double low_qual_mis_rate_100;    //errp > 0.05 by default   
	double medium_qual_mis_rate_100; //
	double high_qual_mis_rate_100;   //errp < 0.005 by default
	double ov_er_rate_50;
	double low_qual_mis_rate_50;    //errp > 0.05 by default   
	double medium_qual_mis_rate_50; //
	double high_qual_mis_rate_50;   //errp < 0.005 by default
	vector<int> ovqlve1;
	vector<int> ovqlve2;
//	double pro;
//	double pro2;
//	double local_pro1;
//	double local_pro2;
//	double ave_pro;

	deque<pair<pair<char, char>, pair<int,int> > > misp;

	deque<pair<int,int> > misqs;
	deque<double> misersc;

	int left;
	int middle;
	int right;
	int seq1Len;
	int seq2Len;

	void alignreverse();
	void alignupdown();
	void self_calculate_read_len();
	void self_calculate_hort();
//	int calculate_hq_mis();
};


class Seed_a
{
public:
	int idx_i;
	int idx_j;
	int length;
};

class Align
{
private:
	int id1;
	int id2;
	int forb1;
	int forb2;
	string seq1;
	string seq2;
	vector<int> qul1;
	vector<int> qul2;
	int wl;
	double thr;   //error rate
	double thr_100;
	double thr_50;
	double snprate;  //snp rate
	int ovlenthr;


public:
	
	map<int, vector<int> > kmers;
	map<int, vector<Seed_a> > seeds;
	vector<map<pair<int, int>, int > > paths;
	multimap<int, Calignment, greater<int> > alive;


	Align(int inid1, int inid2, string inseq1, string inseq2, vector<int> inqul1, vector<int> inqul2, int inforb1, int inforb2, int inwl,  int inovlenthr, double inthr, double in_thr_100, double in_thr_50, double insnprate)
	{
		id1 = inid1;
		id2 = inid2;
		seq1 = inseq1;
		seq2 = inseq2;
		qul1 = inqul1;
		qul2 = inqul2;
		forb1 = inforb1;
		forb2 = inforb2;
		wl = inwl;
		
		ovlenthr = inovlenthr;
		thr = inthr;
		thr_100 = in_thr_100;
		thr_50 = in_thr_50;
		snprate = insnprate;
	
		if((int)seq1.size() != (int)qul1.size() ){
			cout<<"(int)seq1.size() != (int)qul1.size()"<<seq1.size()<<","<<qul1.size()<<endl;  exit(1);
		}
		if((int)seq2.size() != (int)qul2.size() ){
			cout<<"(int)seq2.size() != (int)qul2.size()"<<seq2.size()<<","<<qul2.size()<<endl;  exit(1);
		}
	}

	map<int, vector<int> > getseed(string &s1, string &s2, int l);
	map<int, vector<Seed_a> > extend(map<int, vector<int> > &inkmers, int l, string &se1, string &se2);
	map<int, vector<Seed_a> > extendfrommac(set<pair<int, int> > &match, int l, string &se1, string &se2);
	vector<map<pair<int, int>, int > > findpath(map<int, vector<Seed_a> > &inseed, string &se1, string &se2, int w, int sl);
	void addseemf(multimap<int, Seed_a, greater<int> > &addseem, map<int, vector<int> > &t_seed, int sl, string &ts1, string &ts2, int i1, int i2);
	int checkhybrid(Seed_a &sob1, Seed_a &sob2);
	Calignment makealign(map<pair<int, int>, int > &path, string &se1, string &se2, vector<int> &scve1, vector<int> &scve2, int ovlen, int tip);
	
	
	int tmpf(double d);
	void process( int tip );
	void process2(set<pair<int, int> > &match);
};

bool filteralign( int ovlenthr, double errorthr, double thr_100, double thr_50, double snprate, Calignment &aln );
bool filteralign( Calignment &ob, double thr_error_pvalue, double thr_hq_error_pvalue );


#endif
