//this is C++ code for consensus.
#ifndef CONS_H
#define CONS_H
#include <iostream>
#include <string>
#include <map>
#include <list>
#include <vector>
#include <set>


using namespace std;

typedef int Read_id;
typedef int Seg_sub_id;   // Except a few cases specially declared, Seg_sub_id is the begining position of that Segment on read Read_id.

//the segment of the read sequence. three integers are sufficient, 
//that is (1)the id of the read; (2)the beginning position of the 
//read; (3)the length of the segment.
class Segment
{
public:
	int id;
	int bgn;
	int len;
	
};

//each read consist of segments which are disjoint and adjacent; 
//segments ids are stored in list stl
//map<int, list<int> > Read_Seg_List_Map;
//map<pair<int, int>, Segment> Seg_Map;


//the match of the segments in pair-wise alignment.
class Seg_Match
{
public:
	pair<Read_id, Seg_sub_id> Sega;
	pair<Read_id, Seg_sub_id> Segb;
	int len;
	double score;
};

typedef int Seg_Match_id;

typedef map< Read_id, Seg_sub_id > Seg_Mul_Aln_Node;
typedef vector< Seg_Mul_Aln_Node > Seg_Mul_Alnmt; 


typedef int Cut_site;
class Segmented_Read
{
public:
	vector< pair<Read_id, Seg_sub_id> > Read_Seg_Ve;
	set< Cut_site > Read_Cut_site;
	map< Cut_site, set< pair< Read_id, Seg_sub_id > > > Read_Seg_Cut_site_contn_Map;
	map< pair< Read_id, Seg_sub_id >, set< Cut_site > > Read_Seg_Cut_site_rvcontn_Map;
	map< pair< Cut_site, Cut_site >, pair< Read_id, Seg_sub_id > > Seg_Interval_Map;

	// < bgn, vector< Read_Seg_id_pair > >, temp variable, used in layout_cons_exchange stage.
	map< int, vector< pair<Read_id, Seg_sub_id> > > bgn_seg_Map;

};

class Cons_Bank
{
public:
	map< pair< Read_id, Seg_sub_id >, Segment > Seg_Map;   
	map< Read_id, string > Read_Str_Map;
	map< Read_id, vector< int > > Read_Sc_Map;
};


#endif
