#include "contig.h"

void Iter::plusite()
{ 
	++Iterl;
	++Iterf;
	++Iterp;
}

void Contig::AddIn(Calignment& alignment)
{
	if ( alignment.r == 2 ) {
		if(MultiReadMap.find(alignment.id1) != MultiReadMap.end())
			return;

		if(ReadidSet.find(alignment.id2) != ReadidSet.end()){
			if(inreadmap.find(alignment.id2) == inreadmap.end())
				inreadmap.insert(make_pair(alignment.id2, alignment.id1));
			return;
		}

		
		inreadmap.insert(make_pair(alignment.id2, alignment.id1));

		list<int>::iterator Iterl;
		list<pair<int, int> >::iterator Iterp = RelposList.begin();
		list<int>::iterator Itef = ForbList.begin();

		if(read_forbMap[alignment.id1]!=alignment.forb1){
			alignment.alignreverse();
		}

		for(Iterl= ReadidList.begin(); Iterl!= ReadidList.end(); ++Iterl){
			if(*Iterl==alignment.id1){
				int a = Iterp->first + alignment.idx_i - 1;
				int b = Iterp->first + alignment.idx_j - 1;
				if(b > Iterp->second)
					b = Iterp->second - 1;
				list<int>::iterator lastpos = ReadidList.end();
				--lastpos;
				if(Iterl == ReadidList.begin() || Iterl != lastpos){
					++Iterl;
					++Iterp;
					++Itef;
				}
				ReadidList.insert(Iterl, alignment.id2);

			//	int a = read_relposMap[alignment.id1].first+alignment.idx_i-1;
			//	int b = read_relposMap[alignment.id1].first+alignment.idx_j-1;
				
				read_relposMap.insert(make_pair(alignment.id2, make_pair(a, b)));
				RelposList.insert(Iterp, make_pair(a, b));

				read_forbMap.insert(make_pair(alignment.id2, alignment.forb2));
				ForbList.insert(Itef, alignment.forb2);

				

				break;
			}
			++Iterp;
			++Itef;
		}

		ReadidSet.insert(alignment.id2);

	} else if ( alignment.r == 3 ) {    

		if(MultiReadMap.find(alignment.id2) != MultiReadMap.end())
			return;

		if(ReadidSet.find(alignment.id1) != ReadidSet.end()){
			if(inreadmap.find(alignment.id1) == inreadmap.end())
				inreadmap.insert(make_pair(alignment.id1, alignment.id2));
			return;
		}

		inreadmap.insert(make_pair(alignment.id1, alignment.id2));

		list<int>::iterator Iterl;
		list<pair<int, int> >::iterator Iterp = RelposList.begin();
		list<int>::iterator Itef = ForbList.begin();

		if(read_forbMap[alignment.id2]!=alignment.forb2){
			alignment.alignreverse();
		}

		for(Iterl= ReadidList.begin(); Iterl!= ReadidList.end(); ++Iterl){
			if(*Iterl==alignment.id2){
				int a = Iterp->first + alignment.idx_i - 1;
				int b = Iterp->first + alignment.idx_j - 1;
			//	cout<<"a = "<<Iterp->first <<" + "<< alignment.idx_i <<" - 1;"<<endl;
			//	cout<<"b = "<<Iterp->first <<" + "<< alignment.idx_j <<" - 1;"<<endl;
				if(b > Iterp->second)
					b = Iterp->second - 1;
				list<int>::iterator lastpos = ReadidList.end();
				--lastpos;
				if(Iterl == ReadidList.begin() || Iterl != lastpos){
					++Iterl;
					++Iterp;
					++Itef;
				}
				ReadidList.insert(Iterl, alignment.id1);

			//	int a = read_relposMap[alignment.id1].first+alignment.idx_i-1;
			//	int b = read_relposMap[alignment.id1].first+alignment.idx_j-1;
				
				read_relposMap.insert(make_pair(alignment.id1, make_pair(a, b)));
				RelposList.insert(Iterp, make_pair(a, b));

				read_forbMap.insert(make_pair(alignment.id1, alignment.forb1));
				ForbList.insert(Itef, alignment.forb1);

			//	cout<<"add alignment "<<alignment.id1<<", "<<alignment.forb1<<", ("<<a<<","<<b<<")"<<endl;

				break;
			}
			++Iterp;
			++Itef;
		}
		ReadidSet.insert(alignment.id1);

	}

	
}

void Contig::reverse()
{
/*	std::reverse( contig.begin(), contig.end() );	//зת
	std::for_each( contig.begin(), contig.end(),	//תΪ
			SequenceTransform_T::ToOppRule_T() );*/

//	if(tag_pos<-1000 || tag_pos > 100000)
//		tag_pos = 0;
	int consize = RelposList.back().second;
	list<int>::reverse_iterator Riterl = ReadidList.rbegin();
	list<pair<int, int> >::reverse_iterator Riterp = RelposList.rbegin();
	for(; Riterl != ReadidList.rend(); ++Riterl){
		if(inreadmap.find(*Riterl) != inreadmap.end()){
			++Riterp;
			continue;
		}else{
			consize = Riterp->second;
			break;
		}
		
	}

	ReadidList.reverse();

//	int a = righthang;
//	int b = lefthang;
//	lefthang = a;
//	righthang = b;

	
	map< int, pair<int,int> >::iterator ite;
	for(ite=read_relposMap.begin(); ite!=read_relposMap.end(); ++ite)
	{
		int a = consize - (ite->second.second) +1;
		int b = consize - (ite->second.first) +1;
	//	int a = (int)contig.size() - (ite->second.second+tag_pos) +1;
	//	int b = (int)contig.size() - (ite->second.first+tag_pos) +1;
		ite->second.first = a;
		ite->second.second = b;
	}
	list<pair<int, int> > newrp;
	list<pair<int, int> >::iterator Iterp;
	for(Iterp = RelposList.begin(); Iterp != RelposList.end(); ++Iterp){
		int a = consize - (Iterp->second) +1;
		int b = consize - (Iterp->first) +1;
	//	int a = (int)contig.size() - (Iterp->second+tag_pos) +1;
	//	int b = (int)contig.size() - (Iterp->first+tag_pos) +1;
		newrp.push_front(make_pair(a, b));
	}
	RelposList = newrp;

//	int newleftidx = read_relposMap[ReadidList.front()].second - rightidx + 1;
//	int newrightidx = read_relposMap[ReadidList.back()].second - read_relposMap[ReadidList.back()].first + 1 - leftidx + 1;
//	leftidx = newleftidx;
//	rightidx = newrightidx;

	map< int, int > newread_forbMap;
	map< int, int >::iterator fite;
	for(fite=read_forbMap.begin(); fite!=read_forbMap.end(); ++fite){
		if(fite->second == 1){
			newread_forbMap.insert(make_pair(fite->first, 0 ));
		}else{
			newread_forbMap.insert(make_pair(fite->first, 1 ));
		}
	}
	read_forbMap = newread_forbMap;  

	list<int> newf;
	list<int>::iterator Itef;
	for(Itef = ForbList.begin(); Itef != ForbList.end(); ++Itef){
		if(*Itef == 0)
			newf.push_front(1);
		else
			newf.push_front(0);
	}
	ForbList = newf;

	tag_pos = 0;
}

void Contig::singletocontig(int id, Str seq)
{
	tag_pos = 0;
	ReadidSet.insert(id);
	ReadidList.push_back(id);
	contig = seq;
	read_relposMap.insert(make_pair(id, make_pair(1, (int)seq.size())));
	RelposList.push_back(make_pair(1, (int)seq.size()));
	read_forbMap.insert(make_pair(id, 0));
	ForbList.push_back(0);
}

void Contig::getcoverage()
{
	int L_read = 1000;
	coverage = (double)ReadidList.size() / ((double)contig.size()/L_read);
}

int Contig::getheadid()
{
	int va;
	list<int>::reverse_iterator Ritel;
	for(Ritel = ReadidList.rbegin(); Ritel != ReadidList.rend(); ++Ritel){
		if(inreadmap.find(*Ritel) != inreadmap.end())
			continue;
		va = *Ritel;
		return va;
	}
	va = ReadidList.back();
	return va;
}
int Contig::getheadhort()
{
	int va;
	list<int>::reverse_iterator Ritel;
	list<int>::reverse_iterator Ritef = ForbList.rbegin();
	for(Ritel = ReadidList.rbegin(); Ritel != ReadidList.rend(); ++Ritel){
		if(inreadmap.find(*Ritel) != inreadmap.end()){
			++Ritef;
			continue;
		}
		va = *Ritef;
		return va;
	}
	va = ForbList.back();
	return va;
}
pair<int,int> Contig::getheadpos()
{
	pair<int, int> va;
	list<int>::reverse_iterator Ritel;
	list<pair<int, int> >::reverse_iterator Ritep = RelposList.rbegin();
	for(Ritel = ReadidList.rbegin(); Ritel != ReadidList.rend(); ++Ritel){
		if(inreadmap.find(*Ritel) != inreadmap.end()){
			++Ritep;
			continue;
		}
		va = make_pair(Ritep->first, Ritep->second);
		return va;
	}
	va = RelposList.back();
	return va;
}
int Contig::gettailid()
{
	int va;
	list<int>::iterator Itel;
	for(Itel = ReadidList.begin(); Itel != ReadidList.end(); ++Itel){
		if(inreadmap.find(*Itel) != inreadmap.end()){
			continue;
		}
		va = *Itel;
		return va;
	}
	va = ReadidList.front();
	return va;
}
int Contig::gettailhort()
{
	int va;
	list<int>::iterator Itel;
	list<int>::iterator Itef = ForbList.begin();
	for(Itel = ReadidList.begin(); Itel != ReadidList.end(); ++Itel){
		if(inreadmap.find(*Itel) != inreadmap.end()){
			++Itef;
			continue;
		}
		va = *Itef;
		return va;
	}
	va = ForbList.front();
	return va;
}
pair<int, int> Contig::gettailpos()
{
	pair<int,int> va;
	list<int>::iterator Itel;
	list<pair<int, int> >::iterator Itep = RelposList.begin();
	for(Itel = ReadidList.begin(); Itel != ReadidList.end(); ++Itel){
		if(inreadmap.find(*Itel) != inreadmap.end()){
			++Itep;
			continue;
		}
		va = make_pair(Itep->first, Itep->second);
		return va;
	}
	va = RelposList.front();
	return va;
}

Contig merge2contigs(Contig &con1, Contig &con2, int len)   //ֻ
{
	
	Contig n_contig;
	n_contig.ReadidList.insert(n_contig.ReadidList.end(), con1.ReadidList.begin(), con1.ReadidList.end());
	n_contig.ReadidList.insert(n_contig.ReadidList.end(), con2.ReadidList.begin(), con2.ReadidList.end());
	n_contig.RelposList.insert(n_contig.RelposList.end(), con1.RelposList.begin(), con1.RelposList.end());
//	n_contig.RelposList.insert(n_contig.RelposList.end(), con2.RelposList.begin(), con2.RelposList.end());
	n_contig.ForbList.insert(n_contig.ForbList.end(), con1.ForbList.begin(), con1.ForbList.end());
	n_contig.ForbList.insert(n_contig.ForbList.end(), con2.ForbList.begin(), con2.ForbList.end());
	n_contig.ReadidSet.insert(con1.ReadidSet.begin(), con1.ReadidSet.end());
	n_contig.ReadidSet.insert(con2.ReadidSet.begin(), con2.ReadidSet.end());
	
//	int con1size = con1.RelposList.back().second;
	int con1size = con1.getheadpos().second;
	int hang1;
	
//	if(con1.RelposList.rbegin()->second - con1.RelposList.rbegin()->first +1 <= len){
	//	hang1 = con1.RelposList.rbegin()->first;
	if(con1.getheadpos().second - con1.getheadpos().first + 1 <= len){
		hang1 = con1.getheadpos().first;
	}else
		hang1 = con1size - len;
	int hang2;
//	if(con2.RelposList.begin()->second + hang1 <= con1.RelposList.rbegin()->second){
	//	hang2 = con1.RelposList.rbegin()->second - con2.RelposList.begin()->second + 1;
	if(con2.gettailpos().second + hang1 <= con1.getheadpos().second + 1 ){
		hang2 = con1.getheadpos().second - con2.gettailpos().second + 1;
	}else
		hang2 = hang1;
	
	list<pair<int, int> >::iterator Iteli;
	for(Iteli = con2.RelposList.begin(); Iteli != con2.RelposList.end(); ++Iteli){
	
		

		int pos1;
		if(Iteli == con2.RelposList.begin())
			pos1 = Iteli->first + hang1;
		else
			pos1 = Iteli->first + hang2;
		int pos2 = Iteli->second + hang2;
		n_contig.RelposList.push_back(make_pair(pos1, pos2));
	}
	
	n_contig.tag_pos = con1.tag_pos;

	n_contig.MultiReadMap.insert(con1.MultiReadMap.begin(), con1.MultiReadMap.end());

	n_contig.read_relposMap.insert(con1.read_relposMap.begin(), con1.read_relposMap.end());
	n_contig.read_forbMap.insert(con1.read_forbMap.begin(), con1.read_forbMap.end());
	map<int, pair<int,int> >::iterator Ite;
	for(Ite = con2.read_relposMap.begin(); Ite != con2.read_relposMap.end(); ++Ite){
	
		int pos1 = Ite->second.first + hang2;
		int pos2 = Ite->second.second + hang2;
		if(n_contig.read_relposMap.find(Ite->first) != n_contig.read_relposMap.end()){
			if(n_contig.MultiReadMap.find(Ite->first)==n_contig.MultiReadMap.end()){
				set<pair<pair<int, int>, int > > ms;
				ms.insert(make_pair(make_pair(n_contig.read_relposMap[Ite->first].first, n_contig.read_relposMap[Ite->first].second), n_contig.read_forbMap[Ite->first]));
				ms.insert(make_pair(make_pair(pos1, pos2), con2.read_forbMap[Ite->first]));
				n_contig.MultiReadMap.insert(make_pair(Ite->first, ms));
			}else{
				n_contig.MultiReadMap[Ite->first].insert(make_pair(make_pair(pos1, pos2), con2.read_forbMap[Ite->first]));
			}
		}else{
			n_contig.read_relposMap.insert(make_pair(Ite->first, make_pair(pos1, pos2)));
			n_contig.read_forbMap.insert(make_pair(Ite->first, con2.read_forbMap[Ite->first]));
		}
	}
	
	map<int, set<pair<pair<int, int>, int > > >::iterator Itemu;
	for(Itemu = con2.MultiReadMap.begin(); Itemu != con2.MultiReadMap.end(); ++Itemu){
		set<pair<pair<int, int>, int > > newset;
		set<pair<pair<int, int>, int > >::iterator Itese;
		for(Itese = Itemu->second.begin(); Itese != Itemu->second.end(); ++Itese){
			
		
			int pos1 = Itese->first.first + hang2;
			int pos2 = Itese->first.second + hang2;
			newset.insert(make_pair(make_pair(pos1, pos2), Itese->second));
		}
		if(n_contig.MultiReadMap.find(Itemu->first) != n_contig.MultiReadMap.end()){
			n_contig.MultiReadMap[Itemu->first].insert(newset.begin(), newset.end());
		}else{
			n_contig.MultiReadMap.insert(make_pair(Itemu->first, newset));

		}
	}
	
	n_contig.tag_pos = 0;

	if(!con1.overlens.empty())
		n_contig.overlens.insert(con1.overlens.begin(), con1.overlens.end());
	if(!con2.overlens.empty())
		n_contig.overlens.insert(con2.overlens.begin(), con2.overlens.end());
	n_contig.overlens.insert(len);
	
	n_contig.inreadmap.insert(con1.inreadmap.begin(), con1.inreadmap.end());
	n_contig.inreadmap.insert(con2.inreadmap.begin(), con2.inreadmap.end());

	return n_contig;
	
}

Contig simple_merge2contig(Contig &con1, Contig &con2, int len)   //ֻ
{
	Contig n_contig;
	n_contig.ReadidList.insert(n_contig.ReadidList.end(), con1.ReadidList.begin(), con1.ReadidList.end());
	n_contig.ReadidList.insert(n_contig.ReadidList.end(), con2.ReadidList.begin(), con2.ReadidList.end());
	n_contig.RelposList.insert(n_contig.RelposList.end(), con1.RelposList.begin(), con1.RelposList.end());
//	n_contig.RelposList.insert(n_contig.RelposList.end(), con2.RelposList.begin(), con2.RelposList.end());
	n_contig.ForbList.insert(n_contig.ForbList.end(), con1.ForbList.begin(), con1.ForbList.end());
	n_contig.ForbList.insert(n_contig.ForbList.end(), con2.ForbList.begin(), con2.ForbList.end());

	int con1size = con1.getheadpos().second;
	int hang1;
	
//	if(con1.RelposList.rbegin()->second - con1.RelposList.rbegin()->first +1 <= len){
	//	hang1 = con1.RelposList.rbegin()->first;
	if(con1.getheadpos().second - con1.getheadpos().first + 1 <= len){
		hang1 = con1.getheadpos().first;
	}else
		hang1 = con1size - len;
	int hang2;
//	if(con2.RelposList.begin()->second + hang1 <= con1.RelposList.rbegin()->second){
	//	hang2 = con1.RelposList.rbegin()->second - con2.RelposList.begin()->second + 1;
	if(con2.gettailpos().second + hang1 <= con1.getheadpos().second + 1 ){
		hang2 = con1.getheadpos().second - con2.gettailpos().second + 1;
	}else
		hang2 = hang1;
	
	list<pair<int, int> >::iterator Iteli;
	for(Iteli = con2.RelposList.begin(); Iteli != con2.RelposList.end(); ++Iteli){
	
		

		int pos1;
		if(Iteli == con2.RelposList.begin())
			pos1 = Iteli->first + hang1;
		else
			pos1 = Iteli->first + hang2;
		int pos2 = Iteli->second + hang2;
		n_contig.RelposList.push_back(make_pair(pos1, pos2));
	}

	n_contig.inreadmap.insert(con1.inreadmap.begin(), con1.inreadmap.end());
	n_contig.inreadmap.insert(con2.inreadmap.begin(), con2.inreadmap.end());

	return n_contig;

}

void pludge_read2contig(Contig &con1, int id, int forb, pair<int, int> pos )
{

	list<int>::reverse_iterator Ritel = con1.ReadidList.rbegin();
	list<int>::reverse_iterator Ritef = con1.ForbList.rbegin();
	list<pair<int,int> >::reverse_iterator Ritep = con1.RelposList.rbegin();

	
	for ( ; Ritel != con1.ReadidList.rend(); ++Ritel ) {
		if ( con1.inreadmap.find( *Ritel ) != con1.inreadmap.end() ) {
			++Ritef;
			++Ritep;
			continue;
		}
		if ( Ritep->first <= pos.first ) {
			if ( pos.second <= Ritep->second ) {
				con1.inreadmap.insert( make_pair( id, *Ritel ) );
			}
			break;
		}
	}

	list<int>::iterator Itel(Ritel.base());
	list<int>::iterator Itef(Ritef.base());
	list<pair<int, int > >::iterator Itep(Ritep.base());
	con1.ReadidList.insert( Itel, id );
	con1.ForbList.insert( Itef, forb );
	con1.RelposList.insert( Itep, pos );

	con1.ReadidSet.insert( id );

	if(con1.read_relposMap.find(id) != con1.read_relposMap.end()){
		if(con1.MultiReadMap.find(id)==con1.MultiReadMap.end()){
			set<pair<pair<int, int>, int > > ms;
			ms.insert(make_pair(con1.read_relposMap[id], con1.read_forbMap[id]) );
			ms.insert(make_pair(pos, forb) );
			con1.MultiReadMap.insert(make_pair(id, ms) );
		}else{
			con1.MultiReadMap[id].insert(make_pair(pos, forb) );
		}
	}else{
		con1.read_relposMap.insert(make_pair(id, pos) );
		con1.read_forbMap.insert(make_pair(id, forb) );
	}


}

void merge2contigs(Contig &con1, Contig &con2, pair<int,int> lenp)
{
	int con1size = con1.getheadpos().second;
	int hang = 0;
	if ( lenp.first == 0 ) {
		hang = con1size - lenp.second;
	} else if ( lenp.first == 1 ) {
		int con2size = con2.getheadpos().second;
		hang = lenp.second - con2size;
	} else if ( lenp.first == 2 ) {
		hang = con1size - lenp.second;
	} else {
		hang = con1size - lenp.second;
	}

	list<int>::iterator Itel = con2.ReadidList.begin();
	list<int>::iterator Itef = con2.ForbList.begin();
	list<pair<int, int> >::iterator Itep = con2.RelposList.begin();
	vector< pair< pair<int, int>, pair<int, int > > > inread;
	for ( ; Itel != con2.ReadidList.end(); ++Itel ) {
		pair<int, int> pos = make_pair( Itep->first + hang, Itep->second + hang );
		int id = *Itel;
		int forb = *Itef;

		if ( con2.inreadmap.find( *Itel ) != con2.inreadmap.end() ) {
			inread.push_back( make_pair( make_pair( id, forb ), pos ) );
			++Itef;
			++Itep;
			continue;
		}
		
		pludge_read2contig( con1, id, forb, pos );
		++Itef;
		++Itep;
	}

	for ( size_t i = 0; i < inread.size(); ++i ) {
		pludge_read2contig( con1, inread[i].first.first, inread[i].first.second, inread[i].second );
	}
}

vector<Contig> deleterereadoffcon(Contig &con, set<pair<int, int> > &discard)
{
/*	ofstream De("deleteoff.txt");
	list<int>::iterator Itelic;
	list<pair<int, int> >::iterator Iterpc = con.RelposList.begin();
	list<int>::iterator Itefc = con.ForbList.begin();
	for(Itelic = con.ReadidList.begin(); Itelic != con.ReadidList.end(); ++Itelic){
		De<<"<"<<*Itelic<<",<"<<Iterpc->first<<","<<Iterpc->second<<">, "<<*Itefc<<">"<<endl;
		++Iterpc;
		++Itefc;
	}
	De<<endl;
	De<<"inmapread: "<<endl;
	map<int, int>::iterator Iteim;
	for(Iteim = con.inreadmap.begin(); Iteim != con.inreadmap.end(); ++Iteim){
		De<<Iteim->first<<endl;
	}
	De<<endl;
	De<<"discard: "<<endl;
	set<pair<int, int> >::iterator ite;
	for(ite = discard.begin(); ite != discard.end(); ++ite){
		De <<ite->first<<","<<ite->second<<endl;
	}*/

	int consize = con.RelposList.back().second;
	vector<Contig> newcons;
	list<int>::iterator Iterl = con.ReadidList.begin();
	list<pair<int, int> >::iterator Iterp = con.RelposList.begin();
	list<int>::iterator Iterf = con.ForbList.begin();

	list<pair<int, int> > poslist = con.RelposList;
//	De<<"start poslist:";
//	list<pair<int, int> >::iterator Itel;
//	for(Itel = poslist.begin(); Itel != poslist.end(); ++Itel){
//		pair<int, int> p = *Itel;
//		De << "\t("<<p.first<<","<<p.second<<")";
//	}
//	De<<endl;

	set<pair<int, int> >::iterator Iteds;
	int h = 0;
	for(Iteds = discard.begin(); Iteds != discard.end(); ++Iteds){
		h += 1;
	//	De<<"h = "<<h<<":\t"<<Iteds->first<<","<<Iteds->second<<endl;

		list<pair<int, int> >::iterator Iterp_f;
		Iterp_f = find(poslist.begin(), poslist.end(), *Iteds);
		if(Iterp_f == poslist.end()){
			cout<<"error1 in  deleterepeat: not found pos: "<<Iteds->first<<","<<Iteds->second<<endl;  exit(1);
		}
		if(Iterp_f == poslist.begin()){
		//	De <<">>point to begin()"<<endl;
			++Iterl;
			++Iterp;
			++Iterf;
			
		}else{
			Contig n_con;
			list<pair<int, int> >::iterator ite = poslist.begin();
			for(; ite != Iterp_f; ++ite){
				if(Iterl == con.ReadidList.end()){
					cout<<"error2-1 in deleterepeat: Iterl == con.ReadidList.end()"<<endl;  exit(1);
				}
				if(Iterp == con.RelposList.end()){
					cout<<"error2-2 in deleterepeat: Iterp == con.RelposList.end()"<<endl;  exit(1);
				}
				if(Iterf == con.ForbList.end()){
					cout<<"error2-3 in deleterepeat: Itef == con.ForbList.end()"<<endl;  exit(1);
				}
				if(con.inreadmap.find(*Iterl) == con.inreadmap.end()){
					n_con.ReadidList.push_back(*Iterl);
					n_con.ReadidSet.insert(*Iterl);
					n_con.RelposList.push_back(*Iterp);
					n_con.ForbList.push_back(*Iterf);
				}
				++Iterl;
				++Iterp;
				++Iterf;
			}
			if(!n_con.ReadidList.empty()){
			//	De <<">>new_con add in"<<endl;
				newcons.push_back(n_con);
			}
			++Iterl;
			++Iterp;
			++Iterf;
			
		}

		++Iterp_f;
		list<pair<int, int> > al_poslist;
		al_poslist.insert(al_poslist.end(), Iterp_f, poslist.end());
		poslist = al_poslist;
	//	De<<"poslist:";
	//	for(Itel = poslist.begin(); Itel != poslist.end(); ++Itel){
		//	pair<int, int> p = *Itel;
		//	De << "\t("<<p.first<<","<<p.second<<")";
	//	}
	//	De<<endl;
	}

	if(!poslist.empty()){
		Contig n_con;
		list<pair<int, int> >::iterator ite = poslist.begin();
		for(; ite != poslist.end(); ++ite){
			if(Iterl == con.ReadidList.end()){
				cout<<"error3-1 in deleterepeat: Iterl == con.ReadidList.end()"<<endl;  exit(1);
			}
			if(Iterp == con.RelposList.end()){
				cout<<"error3-2 in deleterepeat: Iterp == con.RelposList.end()"<<endl;  exit(1);
			}
			if(Iterf == con.ForbList.end()){
				cout<<"error3-3 in deleterepeat: Itef == con.ForbList.end()"<<endl;  exit(1);
			}
			if(con.inreadmap.find(*Iterl) == con.inreadmap.end()){
				n_con.ReadidList.push_back(*Iterl);
				n_con.ReadidSet.insert(*Iterl);
				n_con.RelposList.push_back(*Iterp);
				n_con.ForbList.push_back(*Iterf);
			}
			++Iterl;
			++Iterp;
			++Iterf;
		}
		newcons.push_back(n_con);
	}

/*	De<<"new contig: "<<endl;
	for(int i = 0; i < (int)newcons.size(); ++i){
		Contig con_t = newcons[i];
		De<<">"<<i+1<<endl;
		Itelic = con_t.ReadidList.begin();
		Iterpc = con_t.RelposList.begin();
		Itefc = con_t.ForbList.begin();
		for(Itelic = con_t.ReadidList.begin(); Itelic != con_t.ReadidList.end(); ++Itelic){
			De<<"<"<<*Itelic<<",<"<<Iterpc->first<<","<<Iterpc->second<<">, "<<*Itefc<<">"<<endl;
			++Iterpc;
			++Itefc;
		}
		De<<endl;
	}
	De<<endl;*/

//	De <<"complement.."<<endl;

	for(int i = 0; i < (int)newcons.size(); ++i){
		int pos1 = newcons[i].RelposList.front().first;
		int pos2 = newcons[i].RelposList.back().second;
		if(pos1 < 1 || pos1 > pos2 || pos2 > consize){
			cout<< "error4 in deleterepeat: "<<pos1<<","<<pos2<<","<<consize<<endl;   exit(1);
		}
	//	newcons[i].contig = con.contig.substr(pos1-1, pos2-pos1+1);
		list<pair<int, int> >::iterator Iterp = newcons[i].RelposList.begin();
		list<int>::iterator Iterl = newcons[i].ReadidList.begin();
		list<int>::iterator Iterf = newcons[i].ForbList.begin();
		for(; Iterl != newcons[i].ReadidList.end(); ++Iterl){
			if(con.inreadmap.find(*Iterl) != con.inreadmap.end()){
				if(newcons[i].ReadidSet.find(con.inreadmap[*Iterl]) != newcons[i].ReadidSet.end()){
					newcons[i].inreadmap.insert(make_pair(*Iterl, con.inreadmap[*Iterl]));
				}
			}
			Iterp->first = Iterp->first - pos1 + 1;
			Iterp->second = Iterp->second - pos1 + 1;
			if(newcons[i].read_forbMap.find(*Iterl) != newcons[i].read_forbMap.end()){
				if(newcons[i].MultiReadMap.find(*Iterl) == newcons[i].MultiReadMap.end()){
					set<pair<pair<int, int>, int > > readset;
					readset.insert(make_pair(newcons[i].read_relposMap[*Iterl], newcons[i].read_forbMap[*Iterl]));
					readset.insert(make_pair(make_pair(Iterp->first, Iterp->second), *Iterf));
					newcons[i].MultiReadMap.insert(make_pair(*Iterl, readset));
				}else
					newcons[i].MultiReadMap[*Iterl].insert(make_pair(make_pair(Iterp->first, Iterp->second), *Iterf));
			}else{
				newcons[i].read_forbMap.insert(make_pair(*Iterl, *Iterf));
				newcons[i].read_relposMap.insert(make_pair(*Iterl, *Iterp));
			}
			++Iterp;
			++Iterf;
		}
	}

/*	De<<"new contig: "<<endl;
	for(int i = 0; i < (int)newcons.size(); ++i){
		Contig con_t = newcons[i];
		Itelic = con_t.ReadidList.begin();
		Iterpc = con_t.RelposList.begin();
		Itefc = con_t.ForbList.begin();
		for(Itelic = con_t.ReadidList.begin(); Itelic != con_t.ReadidList.end(); ++Itelic){
			De<<"<"<<*Itelic<<",<"<<Iterpc->first<<","<<Iterpc->second<<">, "<<*Itefc<<">"<<endl;
			++Iterpc;
			++Itefc;
		}
	}
	De<<endl;*/

//	system("pause");
	return newcons;
}

void Siteinfo::getcominfo(char inbase, int inqsc, int inforb)
{
	base = inbase;
	qsc = inqsc;
	forb = inforb;
}

void Contig::erase_redun_read()
{
	if ( ReadidList.size() == 1 )
		return;

	list<int>::iterator Iterl = ReadidList.begin();
	list<int>::iterator Iterf = ForbList.begin();
	list< pair<int, int > >::iterator Iterp = RelposList.begin();

	list<int> alidlist;
	list<int> alforblist;
	list< pair<int, int > > alposlist;

	alidlist.push_back( *Iterl );
	alforblist.push_back( *Iterf );
	alposlist.push_back( *Iterp );

	++Iterl;
	++Iterf;
	++Iterp;

	for ( ; Iterl != ReadidList.end(); ++Iterl ) {
		list< int >::reverse_iterator rali = alidlist.rbegin();
		list< pair<int, int> >::reverse_iterator ralp = alposlist.rbegin();
		bool redun = false;
		for (; rali != alidlist.rend(); ++rali ) {
			if ( Iterp->first > ralp->second )
				break;
			if ( *rali == *Iterl ) {
				redun = true;
				break;
			}

			++ralp;
		}

		if ( !redun ) {
			alidlist.push_back( *Iterl );
			alforblist.push_back( *Iterf );
			alposlist.push_back( *Iterp );
		}
		++Iterf;
		++Iterp;
	}

	ReadidList = alidlist;
	ForbList = alforblist;
	RelposList = alposlist;
	
}

Contig subcontig( Contig &con, int hort, int ovlen )
{

	multimap< pair< int, int >, pair< int, int > > posmap;      // < <pos.first, pos.second>, <id, forb> >
	set< int > idset;
	set< int > inreadset;

	if ( hort == 0 ) {     //head
		Iter iter_con;
		iter_con.Iterl = con.ReadidList.begin();
		iter_con.Iterf = con.ForbList.begin();
		iter_con.Iterp = con.RelposList.begin();
		
		int length = con.getheadpos( ).second;
		
		while ( iter_con.Iterl != con.ReadidList.end() ) {
			if ( iter_con.Iterp->second > length - ovlen ) {
				posmap.insert( make_pair( *iter_con.Iterp, make_pair( *iter_con.Iterl, *iter_con.Iterf ) ) );
				idset.insert( *iter_con.Iterl );
				if ( con.inreadmap.find( *iter_con.Iterl ) != con.inreadmap.end() )
					inreadset.insert( *iter_con.Iterl );
			}

			iter_con.plusite();
		}
	} else {   // tail
		Iter iter_con;
		iter_con.Iterl = con.ReadidList.begin();
		iter_con.Iterf = con.ForbList.begin();
		iter_con.Iterp = con.RelposList.begin();

		while ( iter_con.Iterl != con.ReadidList.end() ) {
			if ( iter_con.Iterp->first <= ovlen ) {
				posmap.insert( make_pair( *iter_con.Iterp, make_pair( *iter_con.Iterl, *iter_con.Iterf ) ) );
				idset.insert( *iter_con.Iterl );
				if ( con.inreadmap.find( *iter_con.Iterl ) != con.inreadmap.end() )
					inreadset.insert( *iter_con.Iterl );
			}
			iter_con.plusite();

		}
	}

	set< int > era;
	set< int >::iterator Itei;
	for ( Itei = inreadset.begin(); Itei != inreadset.end(); ++Itei ) {
		int outid = con.inreadmap[ *Itei ];
		if ( idset.find( outid ) == idset.end() )
			era.insert( *Itei );
	}

	int tag_pos = 0;
	multimap< pair< int, int >, pair< int, int > >::iterator Itep;
	for ( Itep = posmap.begin(); Itep != posmap.end(); ++Itep ) {
		if ( era.empty() ) {
			tag_pos = Itep->first.first - 1;
			break;
		} else {
			if ( era.find( Itep->second.first ) == era.end() ) {
				tag_pos = Itep->first.first - 1;
				break;
			}
		}
	}

	Contig ctg;
	for ( Itep = posmap.begin(); Itep != posmap.end(); ++Itep ) {
		if ( era.find( Itep->second.first ) == era.end() ) {
			ctg.ReadidList.push_back( Itep->second.first );
			ctg.RelposList.push_back( make_pair( Itep->first.first - tag_pos, Itep->first.second - tag_pos ) );
			ctg.ForbList.push_back( Itep->second.second );
		//	cout<<"insert "<<Itep->second.first<<","<<Itep->first.first<<","<<Itep->first.second<<", tag_pos:"<<tag_pos<<endl;
		}
	}

	for ( Itei = inreadset.begin(); Itei != inreadset.end(); ++Itei ) {
		if ( era.find( *Itei ) == era.end() ) 
			ctg.inreadmap.insert( make_pair( *Itei, con.inreadmap[*Itei] ) );
	}
//	system("pause");

	return ctg;

}

