#include "correct_err.h"

void correct_err_ctg( Contig &con, 
					 map< Aln_id, Calignment > &Aln_Map,
					 map< int, map< int, Aln_id > > &IdAliMap,
					 map< int, map<int, multimap<int, Aln_id, greater<int> > > > &MulIdAliMap,
					 set< int > &revs_read,
					 map< int, read_crt_info > &read_crt_info_map,
					 set< Aln_id > &revsed,
					 int ovlen_thr,
					 vector< pair<string, string > >& IdSeqVe, 
					 vector< vector<int> > &Qualve,
					 int crt_str,
					 bool revs_read_aln )
{

	map< int, map< int, pair< char, int > > > crt_in_read_map;
	map< int, Mul_Aln_Site >::iterator Itesnp;
	vector< int > correctedsnp;
	map< int, Mul_Aln_Site > left_snp_map;
	for ( Itesnp = con.snp.begin(); Itesnp != con.snp.end(); ++Itesnp ) {
		Mul_Aln_Site correct_mas;
	
		if ( correct_err_ctg_site_t( con, Itesnp->first, Itesnp->second, correct_mas, crt_in_read_map, crt_str ) ) {
			correctedsnp.push_back( Itesnp->first );
		} else {
			left_snp_map.insert( make_pair( Itesnp->first, correct_mas ) );
		}
		
	}

	
	if ( !crt_in_read_map.empty() ) {
		if ( revs_read_aln ) {
			map< int, map< int, pair< char, int > > >::iterator Itec;
			for ( Itec = crt_in_read_map.begin(); Itec != crt_in_read_map.end(); ++Itec ) {
				revs_read.insert( Itec->first );
			}
			 
			correct_err_read( con, crt_in_read_map, read_crt_info_map, IdSeqVe, Qualve );

			
			revise_ctg_aln( con, crt_in_read_map, left_snp_map, Aln_Map, IdAliMap, ovlen_thr,  revsed );


			
		}
		
	}


	con.snp = left_snp_map;

	

}

bool correct_err_ctg_site_t( Contig &con, int k, Mul_Aln_Site &mas, Mul_Aln_Site &correct_mas, map< int, map< int, pair< char, int > > > &crt_in_read_map, int stringant )
//                                                                         
//                                                                        |                  |           
//                                                                     read_id           contig site     
//  if all the snp are corrected, return true, else snp leaves, return false.
//  under the condition of robusst consensus, if stringant == 0, low stringant:   if the score of snp A > 20 || the number of snp A > 1, left; else correct.
//  under the condition of robusst consensus, if stringant == 1, high stringant:  if the score of snp A > 20 && the number of snp A > 1, left; else correct.
//  if the consensus is week, all the snp left.
{
	
	map<char, pair<int, int> > bmap;
	Mul_Aln_Site::iterator Ite_site;
	for ( Ite_site = mas.begin(); Ite_site != mas.end(); ++Ite_site ) {
		if(bmap.find( Ite_site->second.first ) == bmap.end()){
			bmap.insert( make_pair( Ite_site->second.first, make_pair( 1, Ite_site->second.second ) ) );
		}else{
			bmap[Ite_site->second.first].first += 1;
			if( bmap[Ite_site->second.first].second < Ite_site->second.second )
				bmap[Ite_site->second.first].second = Ite_site->second.second;
		}
	}

	char cns_base = con.contig[k-1];
	int cns_sc = con.qualsc[k-1];

	
	bool consrob = false;

	if ( bmap[cns_base].first > 2 && bmap[cns_base].second >= 20 )
		consrob = true;

	map< char, pair< int, int > >::iterator Iteb;
	map< char, int > left_snp;

	for ( Iteb = bmap.begin(); Iteb != bmap.end(); ++Iteb ) {
		if ( Iteb->first == cns_base )
			continue;
		if ( consrob ) {
			if ( !( bmap[cns_base].first >= 4 && Iteb->second.first == 1 ) ) {
				if ( stringant == 0 ) {
					if ( Iteb->second.second > 15 || Iteb->second.first > 1 ) {
						left_snp.insert( make_pair( Iteb->first, Iteb->second.second ) );
					
					}
				} else {
					if ( Iteb->second.second >= 20 && Iteb->second.first > 1 ) {
						left_snp.insert( make_pair( Iteb->first, Iteb->second.second ) );
					
					}
				}
			}
		} else {
			left_snp.insert( make_pair( Iteb->first, Iteb->second.second ) );
		}
	}

	if ( left_snp.empty() ) {
		for (  Ite_site = mas.begin(); Ite_site != mas.end(); ++Ite_site  ) {
			if ( Ite_site->second.first != cns_base ) {
				crt_in_read_map[Ite_site->first].insert( make_pair( k, make_pair( cns_base, cns_sc ) ) );
			
			} 
		}
		return true;
	} else {
		correct_mas = mas;
		for (  Ite_site = correct_mas.begin(); Ite_site != correct_mas.end(); ++Ite_site  ) {
			if ( left_snp.find( Ite_site->second.first ) == left_snp.end() && Ite_site->second.first != cns_base ) {
				Ite_site->second.first = cns_base;
				Ite_site->second.second = cns_sc;
				crt_in_read_map[Ite_site->first].insert( make_pair( k, make_pair( cns_base, cns_sc ) ) );

			}
		}
		return false;
	}

}

void correct_err_read( Contig &con,
					  map< int, map< int, pair< char, int > > > &crt_in_read_map,              //<read_id, < con_site, < crt_base, crt_sc > > >
					  map< int, read_crt_info > &read_crt_info_map,
					  vector< pair<string, string > >& IdSeqVe, 
					  vector< vector<int> > &Qualve )
{
	Iter iter;
	iter.Iterl = con.ReadidList.begin();
	iter.Iterf = con.ForbList.begin();
	iter.Iterp = con.RelposList.begin();

	map< int, read_crt_info > crt_read_map;

	while ( iter.Iterl != con.ReadidList.end() ) {

		if ( crt_in_read_map.find( *iter.Iterl ) != crt_in_read_map.end() ) {
			int read_len = (int)IdSeqVe[*iter.Iterl - 1].second.size();
			correct_err_read_t( con, *iter.Iterl, *iter.Iterf, *iter.Iterp, read_len, crt_in_read_map[*iter.Iterl], crt_read_map );
		}

		iter.plusite();
	}


	map< int, read_crt_info >::iterator Itecrt;
	for ( Itecrt = crt_read_map.begin(); Itecrt != crt_read_map.end(); ++Itecrt ) {
	
		if ( (int)IdSeqVe.size() < Itecrt->first ) {
			cout<<"error in correct_err_read 1 "<<Itecrt->first<<","<<IdSeqVe.size()<<endl;  exit(1);
		}
		crt_read_err_t( IdSeqVe[Itecrt->first - 1].second, Qualve[Itecrt->first - 1], Itecrt->second );
	}

	read_crt_info_map.insert( crt_read_map.begin(), crt_read_map.end() );
}

pair< char, int > rev_base( pair< char, int > bs )
{
	char rc;
	switch(bs.first )
	{
	case 'A' : case 'a' : rc = 'T';  break;
	case 'C' : case 'c' : rc = 'G';  break;
	case 'G' : case 'g' : rc = 'C';  break;
	case 'T' : case 't' : rc = 'A';  break;
	case '0' : rc = '3'; break;
	case '1' : rc = '2'; break;
	case '2' : rc = '1'; break;
	case '3' : rc = '0'; break;
	default :
		assert("!UNEXPECTED nucleotide acid! in rev_base ");
		exit(1);
	}
	return make_pair( rc, bs.second );
}

char rev_base( char a )
{
	char rc;
	switch(a )
	{
	case 'A' : case 'a' : rc = 'T';  break;
	case 'C' : case 'c' : rc = 'G';  break;
	case 'G' : case 'g' : rc = 'C';  break;
	case 'T' : case 't' : rc = 'A';  break;
	case '0' : rc = '3'; break;
	case '1' : rc = '2'; break;
	case '2' : rc = '1'; break;
	case '3' : rc = '0'; break;
	default :
		assert("!UNEXPECTED nucleotide acid! in rev_base ");
		exit(1);
	}
	return rc;
}

void correct_err_read_t( Contig &con, int id, int forb, pair<int, int> pos, int read_len,
						map< int, pair< char, int > > &crt_in_read,
						map< int, read_crt_info > &crt_read_map )
{
	int bar_numb = 0;
	map< int, Mul_Aln_Site >::iterator Itesnp;
	for ( Itesnp = con.snp.begin(); Itesnp != con.snp.end(); ++Itesnp ) {
		if ( Itesnp->first < pos.first ) 
			continue;
		if ( Itesnp->first > pos.second )
			break;

		if ( Itesnp->second.find( id ) != Itesnp->second.end() ) {
			if ( Itesnp->second[id].first == '-' ) {
				bar_numb += 1;
			}

			int key_A = -1;
			if ( forb == 0 ) {
				key_A = Itesnp->first - pos.first - bar_numb + 1;
			} else {
				key_A = read_len - Itesnp->first + pos.first + bar_numb;
			}
			if ( crt_in_read.find( Itesnp->first ) != crt_in_read.end() ) {

				///////////////////////////for test///////////////////////////////
				if ( Itesnp->second[id].first == crt_in_read[Itesnp->first].first ) {
					cout<<"error crt_in_read is the same as the formar snp "<<Itesnp->second[id].first<<endl;   exit(1);
				}
				if ( Itesnp->second[id].first == '-' ) {
					if ( forb == 0 )
						crt_read_map[id].insert_t[key_A].push_back( crt_in_read[Itesnp->first] );
					
					else
						crt_read_map[id].insert_t[key_A-1].push_front( rev_base( crt_in_read[Itesnp->first] ) );        // reverse direction, the site of read shift back 1.
					
				} else if ( crt_in_read[Itesnp->first].first == '-' ) {
					crt_read_map[id].delete_t.insert( key_A );
				} else {
					if ( forb == 0 )
						crt_read_map[id].replace.push_back( make_pair( key_A, crt_in_read[Itesnp->first] ) );
					else
						crt_read_map[id].replace.push_back( make_pair( key_A, rev_base( crt_in_read[Itesnp->first] ) ) );
				}
			}
		}
	}

}


void crt_read_err_t( string &seq, vector< int > &qual, read_crt_info &crt_info )
{

	if ( !crt_info.replace.empty() ) {
		size_t vesize = crt_info.replace.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			
			if ( seq[crt_info.replace[i].first-1] != crt_info.replace[i].second.first ) {
				seq[crt_info.replace[i].first-1] = crt_info.replace[i].second.first;
				qual[crt_info.replace[i].first-1] = crt_info.replace[i].second.second;
			} else {
				if ( qual[crt_info.replace[i].first-1] < crt_info.replace[i].second.second )
					qual[crt_info.replace[i].first-1] = crt_info.replace[i].second.second;
			}
		}

	}

	if ( !crt_info.delete_t.empty() || !crt_info.insert_t.empty() ) {

		vector< int > al_qual;
		size_t vesize = qual.size();
		for ( size_t i = 0; i < vesize; ++i ) {
			if ( crt_info.delete_t.find( (int)i+1 ) == crt_info.delete_t.end() ) {
				al_qual.push_back( qual[i] );
			}
			if ( crt_info.insert_t.find( (int)i+1 ) != crt_info.insert_t.end() ) {
				list< pair< char, int > >::iterator ite;
				for ( ite = crt_info.insert_t[(int)i+1].begin(); ite != crt_info.insert_t[(int)i+1].end(); ++ite )
					al_qual.push_back( ite->second );
			}
		}

		qual = al_qual;

		int shift = 0;
		set< int > siteset;

		set< int >::iterator Ited;
		for ( Ited = crt_info.delete_t.begin(); Ited != crt_info.delete_t.end(); ++Ited ) {
			siteset.insert( *Ited );
		}

		map< int, list< pair< char, int > > >::iterator Itei;
		for ( Itei = crt_info.insert_t.begin(); Itei != crt_info.insert_t.end(); ++Itei ) {
			siteset.insert( Itei->first );
		}

		map< int, int > insert_key_map;
		set< int >::iterator Ites;
		for ( Ites = siteset.begin(); Ites != siteset.end(); ++Ites ) {
			if ( crt_info.delete_t.find( *Ites ) != crt_info.delete_t.end() ) {
				int key_A = *Ites + shift;
				seq.erase( key_A-1, 1 );
			
				shift -= 1;
			} 
			if ( crt_info.insert_t.find( *Ites ) != crt_info.insert_t.end() ) {
				int key_A = *Ites + shift;
				insert_key_map.insert( make_pair( *Ites, key_A ) );
			}
		}
		
		shift = 0;
		for ( Itei = crt_info.insert_t.begin(); Itei != crt_info.insert_t.end(); ++Itei ) {
			int key_A = insert_key_map[Itei->first] + shift;
			int ins_n = 0;
			list< pair< char, int > >::iterator subite;
			for ( subite = Itei->second.begin(); subite != Itei->second.end(); ++subite ) {
				seq.insert( key_A+ins_n, 1, subite->first );
				ins_n += 1;
			
				shift += 1;
			}
		}
	}
}

void revise_ctg_aln( Contig &con, 
					map< int, map< int, pair< char, int > > > &crt_in_read_map, 
					map< int, Mul_Aln_Site > &left_snp,
					map< Aln_id, Calignment > &Aln_Map,
					map< int, map< int, Aln_id > > &IdAliMap,
					int ovlen_thr,
					set< Aln_id > &revsed )
{
	Iter itera;
	itera.Iterl = con.ReadidList.begin();
	itera.Iterf = con.ForbList.begin();
	itera.Iterp = con.RelposList.begin();

	while ( itera.Iterl != con.ReadidList.end() ) {
		Iter iterb;
		iterb = itera;
		iterb.plusite();
		set<int> revs_id_b;
	
		while ( iterb.Iterl != con.ReadidList.end() ) {
			if ( iterb.Iterp->first < itera.Iterp->second && itera.Iterp->first < iterb.Iterp->second ) {
				if ( crt_in_read_map.find( *itera.Iterl ) != crt_in_read_map.end() 
					|| crt_in_read_map.find( *iterb.Iterl ) != crt_in_read_map.end() ) {
					

						map< int, pair< char, int > > crt_in_read_a;
						map< int, pair< char, int > > crt_in_read_b;
						if ( crt_in_read_map.find( *itera.Iterl ) != crt_in_read_map.end() )
							crt_in_read_a = crt_in_read_map[*itera.Iterl];
						if ( crt_in_read_map.find( *iterb.Iterl ) != crt_in_read_map.end() )
							crt_in_read_b = crt_in_read_map[*iterb.Iterl];

						if ( IdAliMap[*itera.Iterl].find( *iterb.Iterl ) != IdAliMap[*itera.Iterl].end() ) {
							Calignment cob;
							
							read_aln_fr_maln( itera, iterb, con, left_snp, crt_in_read_a, crt_in_read_b, cob );
							Aln_Map[IdAliMap[*itera.Iterl][*iterb.Iterl]] = cob;
							revsed.insert( IdAliMap[*itera.Iterl][*iterb.Iterl] );
						
						} else {
							int ovlen = calculate_ovlen( itera.Iterp->first, itera.Iterp->second, iterb.Iterp->first, iterb.Iterp->second );
							if ( ovlen >= ovlen_thr ) {
								Calignment cob;
								
								read_aln_fr_maln( itera, iterb, con, left_snp, crt_in_read_a, crt_in_read_b, cob );
								Aln_id nid = Aln_Map.rbegin()->first + 1;
								Aln_Map.insert( make_pair( nid, cob ) );
								IdAliMap[*itera.Iterl][*iterb.Iterl] = nid;
								IdAliMap[*iterb.Iterl][*itera.Iterl] = nid;
								revsed.insert( nid );
							}
						}
						revs_id_b.insert( *iterb.Iterl );
				}
			}
			if ( iterb.Iterp->first > itera.Iterp->second ) {
				if ( con.inreadmap.find( *iterb.Iterl ) == con.inreadmap.end() )
					break;
			}
			iterb.plusite();
		}

	
		itera.plusite();
	}
	
}



int calculate_ovlen( int a1, int a2, int b1, int b2 )
{
	int l = max( a1, b1 );
	int u = min( a2, b2 );
	return u - l + 1;
}

////usded(overloaded) only in func: read_aln_fr_maln(). 
/// if the base is a bar(meant delete at that pos), return true, else return false.
bool check_bar_after_con( int pos, Contig &con, map< int, pair< char, int > > &crt_in_read, int id )     
{
	if ( con.snp.find( pos ) != con.snp.end() ) {
		if ( crt_in_read.find( pos ) != crt_in_read.end() ) {
			if ( crt_in_read[pos].first == '-' ) 
				return true;
			else
				return false;

		} else {
			if ( con.snp[pos].find( id ) != con.snp[pos].end() ) {
				if ( con.snp[pos][id].first == '-' )
					return true;
				else
					return false;
			} else {
				cout<<"Error in check_bar_after_con 000 "<<pos<<","<<id<<endl;  exit(1);
			}
		}
	} else
		return false;
}

void read_aln_fr_maln( Iter &itera, Iter &iterb, Contig &con, 
					  map< int, Mul_Aln_Site > &left_snp, 
					  map< int, pair< char, int > > &crt_in_read_a,
					  map< int, pair< char, int > > &crt_in_read_b, 
					  Calignment &aln )
{
	int ida = *itera.Iterl;
	int idb = *iterb.Iterl;


	int ra_pos_start = itera.Iterp->first;
	int ra_pos_end = itera.Iterp->second;
	int rb_pos_start = iterb.Iterp->first;
	int rb_pos_end = iterb.Iterp->second;
	while ( check_bar_after_con( ra_pos_start, con, crt_in_read_a, ida ) ) {
		ra_pos_start += 1;
		if ( ra_pos_start >= ra_pos_end ) {
			cout<<"Error in read_aln_fr_maln 000 "<<endl;
			exit(1);
		}
	}
	while ( check_bar_after_con( rb_pos_start, con, crt_in_read_b, idb ) ) {
		rb_pos_start += 1;
		if ( rb_pos_start >= rb_pos_end ) {
			cout<<"Error in read_aln_fr_maln 001 "<<endl;
			exit(1);
		}
	}
	while ( check_bar_after_con( ra_pos_end, con, crt_in_read_a, ida ) ) {
		ra_pos_end -= 1;
		if ( ra_pos_start >= ra_pos_end ) {
			cout<<"Error in read_aln_fr_maln 002 "<<endl;
			exit(1);
		}
	}
	while ( check_bar_after_con( rb_pos_end, con, crt_in_read_b, idb ) ) {
		rb_pos_end -= 1;
		if ( rb_pos_start >= rb_pos_end ) {
			cout<<"Error in read_aln_fr_maln 003 "<<endl;
			exit(1);
		}
	}

	int lpos = min( ra_pos_start, rb_pos_start );
	int upos = max( ra_pos_end, rb_pos_end );

	set<int> keypointsite;
	map< int, Mul_Aln_Site >::iterator Itesnp;

	
	for ( Itesnp = con.snp.begin(); Itesnp != con.snp.end(); ++Itesnp ) {
		if ( Itesnp->first < lpos )
			continue;
		if ( Itesnp->first > upos )
			break;

		keypointsite.insert( Itesnp->first );
	}
	keypointsite.insert( ra_pos_start );
	keypointsite.insert( rb_pos_start );
	keypointsite.insert( ra_pos_end );
	keypointsite.insert( rb_pos_end );

	int bar_num_a = 0;
	int bar_num_b = 0;
	int insert_a = 0;
	int insert_b = 0;
	int delete_a = 0;
	int delete_b = 0;
	int bar_num_a_ov = 0;
	int bar_num_b_ov = 0;
	int delete_a_ov = 0;
	int delete_b_ov = 0;
	int left_bar_num_a_ov = 0;
	int left_bar_num_b_ov = 0;

	deque<pair<pair<char, char>, pair<int,int> > > misp;
	deque<pair<int,int> > misqs;
	set<int>::iterator Itek;

	int key_A_pjct_start_b = 0;
	int key_B_pjct_start_a = 0;
	int key_A_pjct_end_b = 0;
	int key_B_pjct_end_a = 0;
	int key_A_pjct_end_a = 0;
	int key_B_pjct_end_b = 0;

	bool A_bar_start_ov = false;
	bool B_bar_start_ov = false;
	bool A_bar_end_ov = false;
	bool B_bar_end_ov = false;

	int cons_pos_ov_start = 0;
	int cons_pos_ov_end = 0;

	
	for ( Itek = keypointsite.begin(); Itek != keypointsite.end(); ++Itek ) {

		if ( *Itek == ra_pos_start ) {
			if ( rb_pos_start < *Itek ) {
				key_B_pjct_start_a = *Itek - rb_pos_start + 1 - bar_num_b - delete_b + insert_b;
			}
		}
		if ( *Itek == rb_pos_start ) {
			if ( ra_pos_start <= *Itek ) {
				key_A_pjct_start_b = *Itek - ra_pos_start + 1 - bar_num_a - delete_a + insert_a;
			}
		}
		if ( *Itek == ra_pos_end ) {
			if ( rb_pos_end > *Itek ) {
				key_B_pjct_end_a = *Itek - rb_pos_start + 1 - bar_num_b - delete_b + insert_b;
			}
			key_A_pjct_end_a = *Itek - ra_pos_start + 1 - bar_num_a - delete_a + insert_a;
		}
		if ( *Itek == rb_pos_end ) {
			if ( ra_pos_end >= *Itek ) {
				key_A_pjct_end_b = *Itek - ra_pos_start + 1 - bar_num_a - delete_a + insert_a;
			}
			key_B_pjct_end_b = *Itek - rb_pos_start + 1 - bar_num_b - delete_b + insert_b;
		}
		if ( con.snp.find( *Itek ) != con.snp.end() ) {
			
			if ( con.snp[*Itek].find( ida ) != con.snp[*Itek].end() ) {
				if ( con.snp[*Itek][ida].first == '-' ) {
					bar_num_a += 1;
					if ( *Itek >= ra_pos_start && *Itek >= rb_pos_start && *Itek <= ra_pos_end && *Itek <= rb_pos_end ) {
						if ( crt_in_read_a.find( *Itek ) == crt_in_read_a.end() )
							bar_num_a_ov += 1;
					}
				}
				if ( crt_in_read_a.find( *Itek ) != crt_in_read_a.end() ) {
					if ( con.snp[*Itek][ida].first == '-' ) {
						insert_a += 1;
					} else if ( crt_in_read_a[*Itek].first == '-' ) {
						delete_a += 1;
						if ( *Itek >= ra_pos_start && *Itek >= rb_pos_start && *Itek <= ra_pos_end && *Itek <= rb_pos_end )
							delete_a_ov += 1;
					}
				}
			}
			if ( con.snp[*Itek].find( idb ) != con.snp[*Itek].end() ) {
				if ( con.snp[*Itek][idb].first == '-' ) {
					bar_num_b += 1;
					if ( *Itek >= ra_pos_start && *Itek >= rb_pos_start && *Itek <= ra_pos_end && *Itek <= rb_pos_end ) {
						if ( crt_in_read_b.find( *Itek ) == crt_in_read_b.end() )
							bar_num_b_ov += 1;
					}
				}
				if ( crt_in_read_b.find( *Itek ) != crt_in_read_b.end() ) {
					if ( con.snp[*Itek][idb].first == '-' ) {
						insert_b += 1;
					} else if ( crt_in_read_b[*Itek].first == '-' ) {
						delete_b += 1;
						if ( *Itek >= ra_pos_start && *Itek >= rb_pos_start && *Itek <= ra_pos_end && *Itek <= rb_pos_end )
							delete_b_ov += 1;
					}
				}
			}
			
			if ( *Itek >= ra_pos_start && *Itek >= rb_pos_start && *Itek <= ra_pos_end && *Itek <= rb_pos_end ) {
				if ( left_snp.find( *Itek ) != left_snp.end() ) {
				
					if ( left_snp[*Itek].find( ida ) != left_snp[*Itek].end() && left_snp[*Itek].find( idb ) != left_snp[*Itek].end() ) {
				
						if ( left_snp[*Itek][ida].first != left_snp[*Itek][idb].first ) {
							
						
							int key_A = *Itek - ra_pos_start + 1 - bar_num_a - delete_a + insert_a;
							int key_B = *Itek - rb_pos_start + 1 - bar_num_b - delete_b + insert_b;
							aln.misp.push_back( make_pair( make_pair( left_snp[*Itek][ida].first, left_snp[*Itek][idb].first ), make_pair( key_A, key_B ) ) );
							aln.misqs.push_back( make_pair( left_snp[*Itek][ida].second, left_snp[*Itek][idb].second ) );
							if ( left_snp[*Itek][ida].first == '-' ) {
								left_bar_num_a_ov += 1;
								if ( *Itek == rb_pos_start ){
									A_bar_start_ov = true;
									cons_pos_ov_start = *Itek;
								} else if ( *Itek == rb_pos_end ) {
									A_bar_end_ov = true;
									cons_pos_ov_end = *Itek;
								} 
							}
							if ( left_snp[*Itek][idb].first == '-' ) {
								left_bar_num_b_ov += 1;
								if ( *Itek == ra_pos_start ) {
									B_bar_start_ov = true;
									cons_pos_ov_start = *Itek;
								} else if ( *Itek == ra_pos_end ) {
									B_bar_end_ov = true;
									cons_pos_ov_end = *Itek;
								} 
							}
								
						
						}
					}
				}
			}
		}
	}
	int mis_num_a = bar_num_a_ov + delete_a_ov - left_bar_num_a_ov;
	int mis_num_b = bar_num_b_ov + delete_b_ov - left_bar_num_b_ov;
	if ( mis_num_a != mis_num_b ) {
		cout<<"error in read_aln_fr_maln: misbara != misbarb "<<mis_num_a <<","<<mis_num_b<<","<<bar_num_a_ov <<","<<left_bar_num_a_ov<<","<<bar_num_b_ov<<","<<left_bar_num_b_ov
			<<","<<delete_a_ov<<","<<delete_b_ov<<endl;      exit(1);
	}

	aln.id1 = ida;
	aln.id2 = idb;
	aln.forb1 = *itera.Iterf;
	aln.forb2 = *iterb.Iterf;
	aln.seq1Len = key_A_pjct_end_a;
	aln.seq2Len = key_B_pjct_end_b;
	if ( key_A_pjct_start_b > 0 && key_B_pjct_end_a > 0 ) {
		aln.r = 0;
		int left_shift = 0;
		if ( A_bar_start_ov ) {
			pair< char, int > imple_base;
			imple_base = get_start_imple_base( cons_pos_ov_start, ida, con, left_snp, aln );
		
			if ( aln.misp.front().first.second != imple_base.first ) {
				aln.misp.front().first.first = imple_base.first;
				aln.misqs.front().first = imple_base.second;
			} else {
				aln.misp.pop_front();
				aln.misqs.pop_front();
			}
			left_shift += 1;
		}
		if ( B_bar_end_ov ) {
			pair< char, int > imple_base;
			imple_base = get_end_imple_base( cons_pos_ov_end, idb, con, left_snp, aln );
			if ( aln.misp.back().first.first != imple_base.first ) {
				aln.misp.back().first.second = imple_base.first;
				aln.misqs.back().second = imple_base.second;
			} else {
				aln.misp.pop_back();
				aln.misqs.pop_back();
			}
		}
		aln.idx_i = key_A_pjct_start_b - left_shift;
		aln.idx_j = key_B_pjct_end_a;
		aln.left = aln.idx_i - 1;
		aln.right = key_B_pjct_end_b - aln.idx_j;
		aln.middle = ra_pos_end - rb_pos_start + 1 - mis_num_a;
		aln.score = aln.middle;
		if ( aln.forb1 == 0 ) {
			aln.hort1 = 0;
		} else
			aln.hort1 = 1;
		if ( aln.forb2 == 0 ) {
			aln.hort2 = 1;
		} else
			aln.hort2 = 0;
	} else if ( key_B_pjct_start_a > 0 && key_A_pjct_end_b > 0 ) {
		aln.r = 1;
		int left_shift = 0;
		if ( B_bar_start_ov ) {
			pair< char, int > imple_base;
			imple_base = get_start_imple_base( cons_pos_ov_start, idb, con, left_snp, aln );
			if ( aln.misp.front().first.first != imple_base.first ) {
				aln.misp.front().first.second = imple_base.first;
				aln.misqs.front().second = imple_base.second;
			} else {
				aln.misp.pop_front();
				aln.misqs.pop_front();
			}
			left_shift += 1;
		}
		if ( A_bar_end_ov ) {
			pair< char, int > imple_base;
			imple_base = get_end_imple_base( cons_pos_ov_end, ida, con, left_snp, aln );
			if ( aln.misp.back().first.second != imple_base.first ) {
				aln.misp.back().first.first = imple_base.first;
				aln.misqs.back().first = imple_base.second;
			} else {
				aln.misp.pop_back();
				aln.misqs.pop_back();
			}
		}
		aln.idx_i = key_A_pjct_end_b;
		aln.idx_j = key_B_pjct_start_a - left_shift;
		aln.left = aln.idx_j - 1;
		aln.right = key_A_pjct_end_a - aln.idx_i;
		aln.middle = rb_pos_end - ra_pos_start + 1 - mis_num_a;
		aln.score = aln.middle;
		if ( aln.forb1 == 0 ) {
			aln.hort1 = 1;
		} else
			aln.hort1 = 0;
		if ( aln.forb2 == 0 ) {
			aln.hort2 = 0;
		} else
			aln.hort2 = 1;
	} else if ( key_A_pjct_start_b > 0 && key_A_pjct_end_b > 0 ) {
		aln.r = 2;
		int left_shift = 0;
		if ( A_bar_start_ov ) {
			pair< char, int > imple_base;
			imple_base = get_start_imple_base( cons_pos_ov_start, ida, con, left_snp, aln );
		
			if ( aln.misp.front().first.second != imple_base.first ) {
				aln.misp.front().first.first = imple_base.first;
				aln.misqs.front().first = imple_base.second;
			} else {
				aln.misp.pop_front();
				aln.misqs.pop_front();
			}
			left_shift += 1;
		}
		if ( A_bar_end_ov ) {
			pair< char, int > imple_base;
			imple_base = get_end_imple_base( cons_pos_ov_end, ida, con, left_snp, aln );
			if ( aln.misp.back().first.second != imple_base.first ) {
				aln.misp.back().first.first = imple_base.first;
				aln.misqs.back().first = imple_base.second;
			} else {
				aln.misp.pop_back();
				aln.misqs.pop_back();
			}
		}
		aln.idx_i = key_A_pjct_start_b - left_shift;
		aln.idx_j = key_A_pjct_end_b;
		aln.left = aln.idx_i - 1;
		aln.right = key_A_pjct_end_a - aln.idx_j;
		aln.middle = rb_pos_end - rb_pos_start + 1 - mis_num_a;
		aln.score = aln.middle;
	} else if ( key_B_pjct_start_a > 0 && key_B_pjct_end_a > 0 ) {
		aln.r = 3;
		int left_shift = 0;
		if ( B_bar_start_ov ) {
			pair< char, int > imple_base;
			imple_base = get_start_imple_base( cons_pos_ov_start, idb, con, left_snp, aln );
			if ( aln.misp.front().first.first != imple_base.first ) {
				aln.misp.front().first.second = imple_base.first;
				aln.misqs.front().second = imple_base.second;
			} else {
				aln.misp.pop_front();
				aln.misqs.pop_front();
			}
			left_shift += 1;
		}
		if ( B_bar_end_ov ) {
			pair< char, int > imple_base;
			imple_base = get_end_imple_base( cons_pos_ov_end, idb, con, left_snp, aln );
			if ( aln.misp.back().first.first != imple_base.first ) {
				aln.misp.back().first.second = imple_base.first;
				aln.misqs.back().second = imple_base.second;
			} else {
				aln.misp.pop_back();
				aln.misqs.pop_back();
			}
		}
		aln.idx_i = key_B_pjct_start_a - left_shift;
		aln.idx_j = key_B_pjct_end_a;
		aln.left = aln.idx_i - 1;
		aln.right = key_B_pjct_end_b - aln.idx_j;
		aln.middle = ra_pos_end - ra_pos_start + 1 - mis_num_a;
		aln.score = aln.middle;
	} else {
		cout<<"error in read_aln_fr_maln: A_s_b "<<key_A_pjct_start_b
			<<" A_e_b "<<key_A_pjct_end_b
			<<" B_s_a "<<key_B_pjct_start_a
			<<" B_e_a "<<key_B_pjct_end_a<<endl;
		exit(1);
	}

	aln.self_calculate_read_len();

	aln.ov_er_rate = (double)aln.misp.size() / aln.score;



}

pair< char, int > get_start_imple_base( int cons_pos_ov_start, int rid, Contig &con, map< int, Mul_Aln_Site > &left_snp, Calignment &aln )
{
	pair< char, int > imple_base;
	bool retreat = false;
	do {
		cons_pos_ov_start -= 1;
		retreat = false;
		if ( left_snp.find( cons_pos_ov_start ) != left_snp.end() ) {
			if ( left_snp[cons_pos_ov_start][rid].first == '-' )
				retreat = true;
			else
				imple_base = left_snp[cons_pos_ov_start][rid];
		} else {
			if ( con.contig[cons_pos_ov_start-1] == '-' ) {
				retreat = true;
			} else
				imple_base = make_pair( con.contig[cons_pos_ov_start-1], con.qualsc[cons_pos_ov_start-1] );
		}
	} while ( retreat ); 
	return imple_base;
}

pair< char, int > get_end_imple_base( int cons_pos_ov_end, int rid, Contig &con, map< int, Mul_Aln_Site > &left_snp, Calignment &aln )
{
	pair< char, int > imple_base;
	bool goon = false;
	do {
		cons_pos_ov_end += 1;
		goon = false;
		if ( left_snp.find( cons_pos_ov_end ) != left_snp.end() ) {
			if ( left_snp[cons_pos_ov_end][rid].first == '-' )
				goon = true;
			else
				imple_base = left_snp[cons_pos_ov_end][rid];
		} else {
			if ( con.contig[cons_pos_ov_end-1] == '-' ) {
				goon = true;
			} else
				imple_base = make_pair( con.contig[cons_pos_ov_end-1], con.qualsc[cons_pos_ov_end-1] );
		}
	} while ( goon ); 
	return imple_base;
}




