#ifndef CORRECT_ERR_H
#define CORRECT_ERR_H

#include "contig.h"
#include "calignment.h"
#include "assemblybank.h"
#include "Trans.h"

using namespace std;

class read_crt_info
{
public:
	vector< pair< int, pair< char, int > > > replace;
	map< int, list< pair< char, int > > > insert_t;
	set< int > delete_t;
};
class crt_info_site
	{
	public:
		int _key;    // pos at read.
		int ctype;   // 0 replace, 1 insert, 2 delete
		pair< char, int > rep_base;
		list< pair< char, int > > ins_base;
	};

void correct_err_ctg( Contig &con, 
					 map< Aln_id, Calignment > &Aln_Map,
					 map< int, map< int, Aln_id > > &IdAliMap,
					 map< int, map<int, multimap<int, Aln_id, greater<int> > > > &MulIdAliMap,
					 set< int > &revs_read,
					 map< int, read_crt_info > &read_crt_info_map,
					 set< Aln_id > &revsed,
					 int ovlen_thr,
					 vector< pair<string, string > >& IdSeqVe, 
					 vector< vector<int> > &Qualve,
					 int crt_str,
					 bool revs_read_aln );

bool correct_err_ctg_site_t( Contig &con, int k, Mul_Aln_Site &mas, Mul_Aln_Site &correct_mas, map< int, map< int, pair< char, int > > > &crt_in_read_map, int stringant );

void correct_err_read( Contig &con,
					  map< int, map< int, pair< char, int > > > &crt_in_read_map, 
					  map< int, read_crt_info > &read_crt_info_map,
					  vector< pair<string, string > >& IdSeqVe, 
					  vector< vector<int> > &Qualve );

pair< char, int > rev_base( pair< char, int > bs );
char rev_base( char a );

void correct_err_read_t( Contig &con, int id, int forb, pair<int, int> pos, int read_len,
						map< int, pair< char, int > > &crt_in_read,
						map< int, read_crt_info > &crt_read_map );

void crt_read_err_t( string &seq, vector< int > &qual, read_crt_info &crt_info );

void revise_ctg_aln( Contig &con, 
					map< int, map< int, pair< char, int > > > &crt_in_read_map, 
					map< int, Mul_Aln_Site > &left_snp,
					map< Aln_id, Calignment > &Aln_Map,
					map< int, map< int, Aln_id > > &IdAliMap,
					int ovlen_thr,
					set< Aln_id > &revsed );

class hangs_struct
{
public:
	int index_left;
	int index_right;
	int length;
};

int calculate_ovlen( int a1, int a2, int b1, int b2 );

bool check_bar_after_con( int pos, Contig &con, map< int, pair< char, int > > &crt_in_read, int id );    

void read_aln_fr_maln( Iter &itera, Iter &iterb, Contig &con, 
					  map< int, Mul_Aln_Site > &left_snp, 
					  map< int, pair< char, int > > &crt_in_read_a,
					  map< int, pair< char, int > > &crt_in_read_b, 
					  Calignment &aln );

pair< char, int > get_start_imple_base( int cons_pos_ov_start, int rid, Contig &con, map< int, Mul_Aln_Site > &left_snp, Calignment &aln );
pair< char, int > get_end_imple_base( int cons_pos_ov_end, int rid, Contig &con, map< int, Mul_Aln_Site > &left_snp, Calignment &aln );


#endif

