#include "domain.h"

void Domain::getdomain()
{
	vector<vector<int> > domainVe_0;
	vector<int> e_Ve;
	for(int i = 0; i < (int)e_linkVe.size(); ++i)
		e_Ve.push_back(i);

	domainVe = getdomainfromelink(e_Ve);
                     


}

vector<vector<int> > Domain::getdomainfromelink(vector<int> & e_Ve)
{
	vector<vector<int> > value;
	set<int> reserve;
	for(int i = 0; i < (int)e_Ve.size(); i++){
		reserve.insert(e_Ve[i]);
	}

	while(!reserve.empty()){
		vector<int> subdo;
		int a = *reserve.begin();
		subdo.push_back(a);
		reserve.erase(a);

		set<pair<int, int> > elongset;
		pair<int, int> p1 = make_pair(e_linkVe[a].id1, e_linkVe[a].ht1);
		pair<int, int> p2 = make_pair(e_linkVe[a].id2, e_linkVe[a].ht2);
		elongset.insert(p1);
		elongset.insert(p2);

		while(1){
			int s1 = (int)reserve.size();

			for(int i = 0; i < (int)e_linkVe.size(); i++){
				if(reserve.find(i) == reserve.end())
					continue;
				p1 = make_pair(e_linkVe[i].id1, e_linkVe[i].ht1);
				p2 = make_pair(e_linkVe[i].id2, e_linkVe[i].ht2);

				if(elongset.find(p1)!=elongset.end() || elongset.find(p2)!=elongset.end()){
					subdo.push_back(i);
					reserve.erase(i);
					if(elongset.find(p1)==elongset.end())
						elongset.insert(p1);
					if(elongset.find(p2)==elongset.end())
						elongset.insert(p2);
				}
			}

			if((int)reserve.size() == s1)
				break;
		}
		value.push_back(subdo);

	}
	return value;
}


void Domain::getmatrix()
{
	for(int i = 0; i < (int)domainVe.size(); ++i){
		if((int)domainVe[i].size()==1 || (int)domainVe[i].size() > 14){
			continue;
		}

		set<pair<int, int> > row;
		set<pair<int, int> > arr;
		set<int> remain;

		for(int j = 0; j < (int)domainVe[i].size(); ++j){
			remain.insert(domainVe[i][j]);
		
		}
		row.insert(make_pair(e_linkVe[domainVe[i][0]].id1, e_linkVe[domainVe[i][0]].ht1));
		arr.insert(make_pair(e_linkVe[domainVe[i][0]].id2, e_linkVe[domainVe[i][0]].ht2));
		remain.erase(domainVe[i][0]);

		while(!remain.empty()){
			int si = (int)remain.size();
			for(int j = 1; j < (int)domainVe[i].size(); ++j){
				if(remain.find(domainVe[i][j]) != remain.end()){
					pair<int, int> p1 = make_pair(e_linkVe[domainVe[i][j]].id1, e_linkVe[domainVe[i][j]].ht1);
					pair<int, int> p2 = make_pair(e_linkVe[domainVe[i][j]].id2, e_linkVe[domainVe[i][j]].ht2);

					if(row.find(p1)!=row.end()){
						arr.insert(p2);
						remain.erase(domainVe[i][j]);
						continue;

					}
					if(row.find(p2)!=row.end()){
						arr.insert(p1);
						remain.erase(domainVe[i][j]);
						continue;

					}
					if(arr.find(p1)!=arr.end()){
						row.insert(p2);
						remain.erase(domainVe[i][j]);
						continue;

					}
					if(arr.find(p2)!=arr.end()){
						row.insert(p1);
						remain.erase(domainVe[i][j]);
						continue;
					}

				}
			}

			if((int)remain.size() == si && !remain.empty()){
				cout<< "error001: in Domain::getmatrix()" <<endl;
				exit(1);
			}

		}

		map<pair<int, int>, int> rowmap;
		map<pair<int, int>, int> arrmap;
		map<int, pair<int, int> > rrowmap;
		map<int, pair<int, int> > rarrmap;
		set < pair<int, int> >::iterator Ite;
		int t = 0;
		for(Ite = row.begin(); Ite!=row.end(); ++Ite){
			rowmap.insert(make_pair(*Ite, t));
			rrowmap.insert(make_pair(t, *Ite));
			++t;
		}
		t = 0;
		for(Ite = arr.begin(); Ite!=arr.end(); ++Ite){
			arrmap.insert(make_pair(*Ite, t));
			rarrmap.insert(make_pair(t, *Ite));
			++t;
		}

		vector<vector<int> > ma;
		for(int r = 0; r < (int)rowmap.size(); r++){
			vector<int> v;
			for(int a = 0; a < (int)arrmap.size(); a++){
				v.push_back(0);
			}
			ma.push_back(v);
		}

	
		for(int j = 0; j < (int)domainVe[i].size(); ++j){
			pair<int, int> p1 = make_pair(e_linkVe[domainVe[i][j]].id1, e_linkVe[domainVe[i][j]].ht1);
			pair<int, int> p2 = make_pair(e_linkVe[domainVe[i][j]].id2, e_linkVe[domainVe[i][j]].ht2);

			if(rowmap.find(p1) != rowmap.end() && arrmap.find(p2) != arrmap.end()){
			
				ma[rowmap[p1]][arrmap[p2]] = 1;
			}else if(rowmap.find(p2) != rowmap.end() && arrmap.find(p1) != arrmap.end()){
			
				ma[rowmap[p2]][arrmap[p1]] = 1;
			}else{
				cout<< "error ))8"<<endl;
				exit(1);
			}
		}
	

		Matrix ob;
		ob.matrix = ma;
		ob.arrmap = arrmap;
		ob.rarrmap = rarrmap;
		ob.rowmap = rowmap;
		ob.rrowmap = rrowmap;

		Ma_Map.insert(make_pair(i, ob));
	}
}



void Domain::getoption()
{
	map<int, Matrix>::iterator IteM;
	int t = 0;
	for(IteM = Ma_Map.begin(); IteM != Ma_Map.end(); ++IteM){
		t +=1;
	
		int m = (int)IteM->second.rowmap.size();
		int n = (int)IteM->second.arrmap.size();

		if(m > 7 || n > 7)
			continue;

		vector<vector<pair<int, int> > > sol = sol_ob.getsol(m, n);
		int size = 0;
		vector<map<pair<int, int>, int> > trackset;
		for(int i = 0; i < (int)sol.size(); i++){
			map<pair<int, int>, int> track;
			for(int j = 0; j < (int)sol[i].size(); j++){
				int row = sol[i][j].first;
				int arr = sol[i][j].second;
				if((int)IteM->second.matrix.size() < row+1){
					cout<< "IteM->second.matrix.size() > row+1"<<", "<<IteM->second.matrix.size()<<","<<row<<endl;  exit(1);
				}
				if((int)IteM->second.matrix[row].size() < arr+1){
					cout<< "IteM->second.matrix[row].size() > arr+1" << ", " << IteM->second.matrix[row].size() <<","<<arr<<endl;  exit(1);
				}
				if(IteM->second.matrix[row][arr]!=0){
					track.insert(make_pair(sol[i][j], IteM->second.matrix[row][arr]));
				}
			}
		
			if((int)track.size() > size)
				size = (int)track.size();
			trackset.push_back(track);
			track.erase(track.begin(), track.end());
		}

		vector<map<pair<int, int>, int> > trackVe;
		for(int g = 0; g < (int)trackset.size(); g++){
	
				trackVe.push_back(trackset[g]);
		
		}

		
	
		set<int> optionlinks;
	
	
			multimap<int, set<int>, greater<int> > Sc_Tr;
		
			for(int i = 0; i < (int)trackVe.size(); ++i){
				set<int> links;
				map<pair<int, int>, int>::iterator Itet;
				for(Itet = trackVe[i].begin(); Itet != trackVe[i].end(); ++Itet){
					int row = Itet->first.first;
					int arr = Itet->first.second;
					pair<int, int> p1 = IteM->second.rrowmap[row];
					pair<int, int> p2 = IteM->second.rarrmap[arr];

					int tg = 0;
					for(int j = 0; j < (int)domainVe[IteM->first].size(); ++j){
						pair<int, int> pa1 = make_pair(e_linkVe[domainVe[IteM->first][j]].id1, e_linkVe[domainVe[IteM->first][j]].ht1);
						pair<int, int> pa2 = make_pair(e_linkVe[domainVe[IteM->first][j]].id2, e_linkVe[domainVe[IteM->first][j]].ht2);
						if( (p1 == pa1 && p2 ==pa2) || (p1 == pa2 && p2 == pa1)){
							links.insert(domainVe[IteM->first][j]);
							tg = 1;
							break;
						}
					}
					
				}

				int score = getscore(links);

				Sc_Tr.insert(make_pair(score, links));
			

			}
		
			multimap<int, set<int>, greater<int> >::iterator IteST = Sc_Tr.begin();
			
			set<int> tr1 = IteST->second;
			int s1 = (int)tr1.size();
			double score1 = (double)IteST->first/s1;
			optionlinks = tr1;
			++IteST;

			for ( ; IteST != Sc_Tr.end(); ++IteST ) {
				bool opt = true;
				set<int> tr2 = IteST->second;
				int s2 = (int)tr2.size();
				double score2 = (double)IteST->first/s2;
				if ( score1 > score2 && s1 > s2 )
					opt = false;
			
				if ( opt ) {
					optionlinks.insert(tr2.begin(), tr2.end());
				}
			}
		


		if(!optionlinks.empty())
			Op_Map.insert(make_pair(IteM->first, optionlinks) );
	
	}

}

int Domain::getscore(std::set<int> &links)
{
	int score = 0;
	set<int>::iterator Ite;
	for(Ite = links.begin(); Ite != links.end(); ++Ite){
		int idx = *Ite;
		score += e_linkVe[idx].overlap_length;
	}

	return score;
}

void Domain::getdeletelink()
{
	
	map<int, set<int> >::iterator IteO;
	for(IteO = Op_Map.begin(); IteO != Op_Map.end(); ++IteO){

		int s1 = 0;
		for(int i = 0; i < (int)domainVe[IteO->first].size(); ++i){
			if( IteO->second.find(domainVe[IteO->first][i]) == IteO->second.end() ){
			
					deletelink.push_back(e_linkVe[domainVe[IteO->first][i]]);
				s1 += 1;
			}

		}
		
	}
}

void Domain::process()
{

	getdomain();



	getmatrix();


	getoption();

	getdeletelink();

}
