#ifndef KMER_H
#define KMER_H

#include<iostream>
#include<fstream>
#include "Trans.h"
#include<vector>
#include <map>
#include <set>
#include<list>
#include<iomanip>
#include<string>
#include<stdio.h>
#include <time.h>
#include "contig.h"

using namespace std;

class Matchseed
{
public:
	set<pair<int, int> > fwmatch;
	set<pair<int, int> > revmatch;

	void reversep();
};

set<pair<int, int> > antimatch(set<pair<int, int> > &match, int size, int wl);

class Kmer
{
public:

	vector< string > WholeRead;
	vector<int> ReadLenVe;
	map<long long, int> kmerfreqs;
	map<long long, map<int, set<pair<int, int> > > > keykmermap;
	map<int, map<int, Matchseed> > MatchMatrix;
	map<int, vector<string> > tempfiles;

	vector<map<int, map<int, Matchseed> > > final;

	int len;
	int kmernum;

	Kmer( int inlen, int inkmernum )
	{
	
		len = inlen;
		kmernum = inkmernum;
	}

	~Kmer()
	{
		WholeRead.clear();
		ReadLenVe.clear();
		kmerfreqs.clear();
		keykmermap.clear();
		MatchMatrix.clear();
		tempfiles.clear();
	}



	int getkeykmer_t( int ii, string &read, int kmer_len, map<long long, map<int, set<pair<int, int> > > > &keykmermap, set<long long> &abund, int si );
	int readin_kmerfile1( int n, int si, int file_n, int numb,
						 map<long long, map<int, set<pair<int, int> > > > &keykmermap, 
						 map<int, vector<string> > &tempfiles,
						 vector<long long> &cutline );
	int readin_kmerfile2( int file_n, int numb, 
						 map<long long, map<int, set<pair<int, int> > > > &keykmermap, 
						 map<int, vector<string> > &tempfiles,
						 vector<long long> &cutline);

	int getkeykmer2(vector<pair<string, string > > &wholeread, int numb );

	int syplifymatrix();

	int getmatrix();
	int getfinalcluster();
	
	double kmerinfo(string &str);
	
	bool filtmatchseed(Matchseed &match, int len1, int len2);
	
	void filtmatrix();

	void ma();

};



#endif

