#include "layout_cons_exchange.h"
#include "sequencetransform.h"


void Layout_To_Cons( Contig &con, 
					map< int, map<int, Aln_id> > & IdAliMap, 
					map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
					map< Aln_id, Calignment > &AlnMap,
					vector< pair<string, string > >& IdSeqVe, 
					vector< vector<int> > &Qualve,
					Cons_Data_Bank & C_bank, 
					map< Read_id, Read_t_in_Con > & read_t_map )
{
	list< int >::iterator Iterl;
	list< pair < int, int > >::iterator Iterp = con.RelposList.begin();
	list< int >::iterator Iterf = con.ForbList.begin();

	list< Read_id > Read_id_List;

	Read_id id = 0;
	for ( Iterl = con.ReadidList.begin(); Iterl != con.ReadidList.end(); ++Iterl ) {
		id += 1;
		Read_t_in_Con R_ob;
		R_ob.forb = *Iterf;
		R_ob.id = *Iterl;
		read_t_map.insert( make_pair ( id, R_ob ) );
		Read_id_List.push_back( id );
	
		if(*Iterf == 0){
			C_bank.bank.Read_Sc_Map.insert( make_pair( id, Qualve[*Iterl-1] ) );
			C_bank.bank.Read_Str_Map.insert( make_pair( id, IdSeqVe[*Iterl-1].second ) );
		}else{
			vector< int > scve = Qualve[*Iterl-1];
			reverse( scve.begin(), scve.end() );
			C_bank.bank.Read_Sc_Map.insert( make_pair( id, scve ) );
			string seq = IdSeqVe[*Iterl-1].second;
			reverse( seq.begin(), seq.end() );
			for_each( seq.begin(), seq.end(),	
					SequenceTransform_T::ToOppRule_T() );
			C_bank.bank.Read_Str_Map.insert( make_pair( id, seq ) );
		
		}
		++Iterf;
	}

	list< Read_id >::iterator Ite_Rid = Read_id_List.begin();
	Iterf = con.ForbList.begin();
	for ( Iterl = con.ReadidList.begin(); Iterl != con.ReadidList.end(); ++Iterl ) {

		int id1 = *Iterl;
		int forb1 = *Iterf;
		Read_id rid1 = *Ite_Rid;
	

		list< int >::iterator Iterl_sec = Iterl;
		list< pair < int, int > >::iterator Iterp_sec = Iterp;
		list< int >::iterator Iterf_sec = Iterf;
		list< Read_id >::iterator Ite_Rid_sec = Ite_Rid;
		++Iterl_sec;
		++Iterp_sec;
		++Iterf_sec;
		++Ite_Rid_sec;
		for ( ; Iterp_sec != con.RelposList.end(); ++Iterp_sec ) {
			if ( Iterp_sec->first > Iterp->second ) {
				if ( con.inreadmap.find( *Iterl_sec ) != con.inreadmap.end() ) {
					++Iterl_sec;
					++Iterf_sec;
					++Ite_Rid_sec;
					continue;
				}else
					break;
			}

			int id2 = *Iterl_sec;
			int forb2 = *Iterf_sec;
			Read_id rid2 = *Ite_Rid_sec;
			int ovlen = 0;
		
			ovlen = min( Iterp_sec->second, Iterp->second ) - max( Iterp_sec->first, Iterp->first ) + 1;
		
			if( IdAliMap[id1].find( id2 ) != IdAliMap[id1].end() ) {
				Calignment cob;
				if( selectalign( id1, id2, forb1, forb2, ovlen, cob, IdAliMap, MulIdAliMap, AlnMap ) ) {
				
					Caln_To_Cons_Data ( cob, C_bank, read_t_map, rid1, rid2 );

				}
			}

			++Iterl_sec;
			++Iterf_sec;
			++Ite_Rid_sec;
		}


		++Iterp;
		++Iterf;
		++Ite_Rid;
	}

	map< Read_id, Segmented_Read >::iterator Ite_rm;
	for ( Ite_rm = C_bank.Seg_Read_Map.begin(); Ite_rm != C_bank.Seg_Read_Map.end(); ++Ite_rm ) {
		C_bank.graph.Seg_Ve.insert(C_bank.graph.Seg_Ve.end(), Ite_rm->second.Read_Seg_Ve.begin(), Ite_rm->second.Read_Seg_Ve.end() );
	}


	
}



bool selectalign(int id1, int id2, int forb1, int forb2, int ovlen, Calignment &ali,
				 map< int, map<int, Aln_id> > & IdAliMap,
				 map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
				 map< Aln_id, Calignment > &AlnMap )
{

	if(IdAliMap[id1].find(id2) == IdAliMap[id1].end())
		return false;
	Calignment cob = AlnMap[IdAliMap[id1][id2]];

	int tag = 0;
	if((forb1 == forb2 && cob.forb1 == cob.forb2) || (forb1 != forb2 && cob.forb1 != cob.forb2)){
		
		ali = cob;

		int var = abs(ovlen-cob.score);
		if(var < 10 )
			return true;

		if(MulIdAliMap.find(id1) != MulIdAliMap.end()){
			if(MulIdAliMap[id1].find(id2) != MulIdAliMap[id1].end()){
				multimap<int, Aln_id, greater<int> >::iterator ite;
				multimap<int, Calignment> alim;
				for(ite = MulIdAliMap[id1][id2].begin(); ite != MulIdAliMap[id1][id2].end(); ++ite){
					cob = AlnMap[ite->second];
					if((forb1 == forb2 && cob.forb1 == cob.forb2) || (forb1 != forb2 && cob.forb1 != cob.forb2)){
						int var = abs(ovlen-cob.score);
						if(var < 10 ){
							ali = cob;
						
							return true;
						}
						alim.insert(make_pair(var, cob) );
							
					}
				}
				if(!alim.empty()){
					if(alim.begin()->first < 10){
						ali = alim.begin()->second;
						return true;
					}
				}
			}
		}
			
	}

	if(MulIdAliMap.find(id1) != MulIdAliMap.end()){
		if(MulIdAliMap[id1].find(id2) != MulIdAliMap[id1].end()){
			multimap<int, Aln_id, greater<int> >::iterator ite;
			multimap<int, Calignment> alim;
			for(ite = MulIdAliMap[id1][id2].begin(); ite != MulIdAliMap[id1][id2].end(); ++ite){
				cob = AlnMap[ite->second];
				if((forb1 == forb2 && cob.forb1 == cob.forb2) || (forb1 != forb2 && cob.forb1 != cob.forb2)){
					
					if(ovlen == 0){
						ali = cob;
					
						return true;
					}
					int var = abs(ovlen-cob.score);
					if(var < 10 ){
						ali = cob;
					
						return true;
					}
					alim.insert(make_pair(var, cob) );
					
				}
			}
			if(!alim.empty()){
				if(alim.begin()->first < 10){
					ali = alim.begin()->second;
				
					return true;
				}
			}
		}
	}


	return false;
	
}

void Caln_To_Cons_Data( Calignment &ali, Cons_Data_Bank & C_bank, map< Read_id, Read_t_in_Con > & read_t_map, Read_id rid1, Read_id rid2 )
{

	int state = 0;  // if state == 1, rid1 == ali.id1; if state == 2, rid2 == ali.id2. 

	if ( read_t_map[rid1].id == ali.id1 ) {
		if ( read_t_map[rid1].forb != ali.forb1 ) {
			ali.alignreverse();
			if ( ali.r == 0 || ali.r == 1 )
				state = 2;
			else 
				state = 1;
		}else
			state = 1;
	} else {
		if ( read_t_map[rid1].forb != ali.forb2 ) {
			ali.alignreverse();
			if ( ali.r == 0 || ali.r == 1 )
				state = 1;
			else 
				state = 2;
		}else 
			state = 2;
	}

	if ( state == 1 ) {
		Caln_To_Cons_Data_tf( ali, C_bank, rid1, rid2 );

	}else 
		Caln_To_Cons_Data_tf( ali, C_bank, rid2, rid1 );
	

}

void Caln_To_Cons_Data_tf( Calignment &ali, Cons_Data_Bank & C_bank, Read_id rid1, Read_id rid2 )
{

	int bgn_1 = 1;
	int bgn_2 = 1;

	// add the left hanging segment:
	if ( ali.r == 0 || ali.r == 2 ) {
		if ( ali.left > 0 ) {
			add_seg( C_bank, rid1, 1, ali.left );
			bgn_1 += ali.left;
		}
	} else if ( ali.r == 1 || ali.r == 3 ) {
		if ( ali.left > 0 ) {
			add_seg( C_bank, rid2, 1, ali.left );
			bgn_2 += ali.left;
		}
	}

	vector< Cut_site > Cut_site_rid1;
	vector< Cut_site > Cut_site_rid2;

	int state = 0;  // three state, 0: match; 1: rid1 miss; 2: rid2 miss
	int mis = 0;
	int indel_idx_1 = -1;
	int indel_idx_2 = -1;
	int indel_len = 0; 
	deque<pair<pair<char, char>, pair<int,int> > >::iterator Ite_misp;
	for ( Ite_misp = ali.misp.begin(); Ite_misp != ali.misp.end(); ++Ite_misp ) {
	
		if ( state == 0 ) {
			if ( Ite_misp->first.first == '-' ) {
				int len = Ite_misp->second.first - bgn_1 + 1;
				if( len > 0 ) {
					double score = ( len - mis ) * match_base_score + mis * mismatch_base_score;
					add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
				}
				bgn_1 = Ite_misp->second.first + 1;
				bgn_2 = Ite_misp->second.second;
				mis = 0;
				indel_idx_1 = Ite_misp->second.first;
				indel_len = 1;
				state = 1;
			
			} else if ( Ite_misp->first.second == '-' ) {
				int len = Ite_misp->second.second - bgn_2 + 1;
				if( len > 0 ) {
					double score = ( len - mis ) * match_base_score + mis * mismatch_base_score;
					add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
				}
			
				bgn_1 = Ite_misp->second.first;
				bgn_2 = Ite_misp->second.second + 1;
				mis = 0;
				indel_idx_2 = Ite_misp->second.second;
				indel_len = 1;
				state = 2;
			} else {
				mis += 1;
			}
		} else if ( state == 1 ) {
			if ( Ite_misp->first.first == '-' ) {
				if ( Ite_misp->second.first == indel_idx_1 ) {
					indel_len += 1;
					continue;
				} else {
					// add last seg of rid2 which relate to the last indel of rid1.
					add_seg( C_bank, rid2, bgn_2, indel_len );
				
				
					// add the match after last indel.
					bgn_2 = bgn_2 + indel_len;
					int len = Ite_misp->second.first - bgn_1 + 1;
					if( len > 0 ) {
						double score = len * match_base_score;
						add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
					}
					bgn_1 = Ite_misp->second.first + 1;
					bgn_2 = Ite_misp->second.second;
					mis = 0;
					indel_idx_1 = Ite_misp->second.first;
					indel_len = 1;
				

				}
			} else if ( Ite_misp->first.second == '-' ) {
				// add last seg of rid2 which relate to the last indel of rid1.
				add_seg( C_bank, rid2, bgn_2, indel_len );

				// add the match after last indel if it exist
				bgn_2 = bgn_2 + indel_len;
				int len = Ite_misp->second.second - bgn_2 + 1;
				if( len > 0 ) {
					double score = len * match_base_score;
					add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
				}
				bgn_1 = Ite_misp->second.first;
				bgn_2 = Ite_misp->second.second + 1;
				mis = 0;
				indel_idx_2 = Ite_misp->second.second;
				indel_len = 1;
				state = 2;
			
			} else {
				add_seg( C_bank, rid2, bgn_2, indel_len );
				bgn_2 = bgn_2 + indel_len;

				mis += 1;
				state = 0;
			}
		} else { //state == 2
			if ( state != 2 ) {
				cerr << "state != 2, state = "<<state <<endl;
			}
			if (  Ite_misp->first.second == '-' ) {
				if ( Ite_misp->second.second == indel_idx_2 ) {
					indel_len += 1;
					continue;
				} else {
					// add last seg of rid1 which relates to the last indel of rid2
					add_seg( C_bank, rid1, bgn_1, indel_len );
					
				
					// add the match after last indel.
					bgn_1 = bgn_1 + indel_len;
					int len = Ite_misp->second.second - bgn_2 + 1;
					if( len > 0 ) {
						double score = len * match_base_score;
						add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
					}
					bgn_1 = Ite_misp->second.first;
					bgn_2 = Ite_misp->second.second + 1;
					mis = 0;
					indel_idx_2 = Ite_misp->second.second;
					indel_len = 1;
				
				}
			} else if ( Ite_misp->first.first == '-' ) {

				// add last seg of rid1 which relates to the last indel of rid2
				add_seg( C_bank, rid1, bgn_1, indel_len );

			
				//add the match after last indel if it exist
				bgn_1 = bgn_1 + indel_len;
				int len = Ite_misp->second.second - bgn_2 + 1;
				if ( len > 0 ) {
					double score = len * match_base_score;
					add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
				}

				bgn_1 = Ite_misp->second.first + 1;
				bgn_2 = Ite_misp->second.second;
				mis = 0;
				indel_idx_1 = Ite_misp->second.first;
				indel_len = 1;
				state = 1;
			

			} else {
				add_seg( C_bank, rid1, bgn_1, indel_len );
				bgn_1 = bgn_1 + indel_len;

				mis += 1;
				state = 0;
			}
		}
	}

	if ( state == 0 ) {

		if ( ali.r == 0 || ali.r == 3 ) {
			int len = ali.seq1Len - bgn_1 + 1;
			if( len > 0 ) {
				double score = ( len - mis ) * match_base_score + mis * mismatch_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_2 = bgn_2 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid2, bgn_2, ali.right );
			}
		} else if ( ali.r == 1 || ali.r == 2 ) {
			int len = ali.seq2Len - bgn_2 + 1;
			if( len > 0 ) {
				double score = ( len - mis ) * match_base_score + mis * mismatch_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_1 = bgn_1 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid1, bgn_1, ali.right );
			}
		}
	} else if ( state == 1 ) {

	
		add_seg( C_bank, rid2, bgn_2, indel_len );
		bgn_2 = bgn_2 + indel_len;

	
		if ( ali.r == 0 || ali.r == 3 ) {
			int len = ali.seq1Len - bgn_1 + 1;
			if( len > 0 ) {
				double score = len * match_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_2 = bgn_2 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid2, bgn_2, ali.right );
			}

		} else if ( ali.r == 1 || ali.r == 2 ) {
			int len = ali.seq2Len - bgn_2 + 1;
			if( len > 0 ) {
				double score =  len * match_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_1 = bgn_1 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid1, bgn_1, ali.right );
			}
		}
	} else {  // state == 2
	
		add_seg( C_bank, rid1, bgn_1, indel_len );
		bgn_1 = bgn_1 + indel_len;

	
		if ( ali.r == 0 || ali.r == 3 ) {
			int len = ali.seq1Len - bgn_1 + 1;
			if( len > 0 ) {
				double score = len * match_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_2 = bgn_2 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid2, bgn_2, ali.right );
			}
		}else if ( ali.r == 1 || ali.r == 2 ) {
			int len = ali.seq2Len - bgn_2 + 1;
			if( len > 0 ) {
				double score =  len * match_base_score;
				add_match_to_data( C_bank, rid1, bgn_1, rid2, bgn_2, len, score );
			}

			bgn_1 = bgn_1 + len;
			if ( ali.right > 0 ) {
				add_seg( C_bank, rid1, bgn_1, ali.right );
			}
		}
	}

}

void erase_bgn_Seg_Map( Segmented_Read & read )
{
	read.bgn_seg_Map.clear();
}

void clean_bank ( Cons_Data_Bank & C_bank )
{
	map< Read_id, Segmented_Read >::iterator Ite;
	for ( Ite = C_bank.Seg_Read_Map.begin(); Ite != C_bank.Seg_Read_Map.end(); ++Ite ) {
		erase_bgn_Seg_Map( Ite->second );
	}
}

pair< Read_id, Seg_sub_id > add_seg( Cons_Data_Bank &C_bank, Read_id rid, int bgn, int len )
{
	

	if ( C_bank.Seg_Read_Map[rid].bgn_seg_Map.find( bgn ) != C_bank.Seg_Read_Map[rid].bgn_seg_Map.end() ) {
		size_t vs = C_bank.Seg_Read_Map[rid].bgn_seg_Map[bgn].size();
		for ( size_t i = 0; i < vs; ++i ) {
			if ( C_bank.bank.Seg_Map[C_bank.Seg_Read_Map[rid].bgn_seg_Map[bgn][i]].len == len ) {
				
				return C_bank.Seg_Read_Map[rid].bgn_seg_Map[bgn][i];
			}
		}
	}

	
	Segment ob;
	ob.id = rid;
	ob.bgn = bgn;
	ob.len = len;
	Seg_sub_id sub_id = (int)C_bank.Seg_Read_Map[rid].Read_Seg_Ve.size() + 1;
	C_bank.Seg_Read_Map[rid].Read_Seg_Ve.push_back( make_pair ( rid, sub_id ) );
	C_bank.Seg_Read_Map[rid].bgn_seg_Map[bgn].push_back( make_pair( rid, sub_id ) );
	C_bank.bank.Seg_Map.insert( make_pair ( make_pair ( rid, sub_id ), ob ) );
	return make_pair ( rid, sub_id );
	
}

void add_match_to_data( Cons_Data_Bank & C_bank, Read_id rid_a, int bgn_a, Read_id rid_b, int bgn_b, int len, double score )
{

	pair< Read_id, Seg_sub_id > seg_id_a = add_seg( C_bank, rid_a, bgn_a, len );
	pair< Read_id, Seg_sub_id > seg_id_b = add_seg( C_bank, rid_b, bgn_b, len );

	Seg_Match match;
	if( rid_a < rid_b ){
		match.Sega = seg_id_a;
		match.Segb = seg_id_b;
	} else {
		match.Sega = seg_id_b;
		match.Segb = seg_id_a;
	}
	match.len = len;
	match.score = score;
	Seg_Match_id match_id = (int) C_bank.graph.Seg_Match_Map.size() + 1;
	C_bank.graph.Seg_Match_Map.insert( make_pair ( match_id, match ) );
	C_bank.graph.Match_pair_Map[seg_id_a][seg_id_b] = match_id;
	C_bank.graph.Match_pair_Map[seg_id_b][seg_id_a] = match_id;


}

void Cons_To_Ctg( Contig &con,
				 string &ctg, 
				 vector<int> &sc_ve,
				 vector<int> &cvg_ve,
				 Layout &lay, 
				 map< Read_id, Read_t_in_Con > & read_t_map )
{

	list< int > rl;
	list< pair< int, int > > pl;
	list< int > fl;
	list< Read_id >::iterator Ite_Rid;

	for ( Ite_Rid = lay.Read_List.begin(); Ite_Rid != lay.Read_List.end(); ++Ite_Rid ) {

		rl.push_back( read_t_map[*Ite_Rid].id );
		pl.push_back( lay.Read_Pos_Map[*Ite_Rid] );
		fl.push_back( read_t_map[*Ite_Rid].forb );
	}

	con.contig = ctg;
	con.qualsc = sc_ve;
	con.cvgve = cvg_ve;
	con.ReadidList = rl;
	con.RelposList = pl;
	con.ForbList = fl;
	

}


void Lay_Cons( Contig &con,
			  map< int, map<int, Aln_id> > & IdAliMap,
			  map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
			  map< Aln_id, Calignment > &AlnMap,
			  vector< pair<string, string > >& IdSeqVe, 
			  vector< vector<int> > &Qualve )
{

	Cons_Data_Bank C_bank;

	map< Read_id, Read_t_in_Con > read_t_map;

	Layout_To_Cons( con, IdAliMap, MulIdAliMap, AlnMap, IdSeqVe, Qualve, C_bank, read_t_map );

	string ctg;
	vector<int> sc_ve;
	vector< int > cvgve;
	Layout lay;

	Cons_Mulaln( C_bank, ctg, sc_ve, cvgve, lay );


	Cons_To_Ctg( con, ctg, sc_ve, cvgve, lay, read_t_map );

	
}

void erase_indels_off_ctg( Contig &con )
{
	vector< int > indeladdve;
	int indeladd = 0;
	size_t csize = con.contig.size();
	string alcontig;
	vector<int> alqualsc;
	vector<int> alcvgve;
	set<int> indelpoint;
	for ( size_t i = 0; i < csize; ++i ) {
		bool indel = false;
		if ( con.contig[i] == '-' ) {
			if ( con.snp.find((int)i+1) == con.snp.end() ) {
				indeladd += 1;
				indeladdve.push_back( indeladd );
				indelpoint.insert((int)i+1);
				indel = true;
			}
		} 
		if ( !indel ) {
			alcontig += con.contig[i];
			if ( con.qualsc.size() <= i ) {
				cout<<"error in erase_indels_off_ctg con.qualsc.size() <= i "<<con.qualsc.size()<<","<<i<<endl;  exit(1);
			}
			alqualsc.push_back( con.qualsc[i] );
			if ( !con.cvgve.empty() ) {
				if ( con.cvgve.size() > i )
					alcvgve.push_back( con.cvgve[i] );
			}
			indeladdve.push_back( indeladd );
		}
	}
	con.contig = alcontig;
	con.qualsc = alqualsc;
	con.cvgve = alcvgve;

	if ( indeladd > 0 ) {

		list< pair<int, int > >::iterator Itep;
		for ( Itep = con.RelposList.begin(); Itep != con.RelposList.end(); ++Itep ) {
			int fp = Itep->first;
			if ( (int)indeladdve.size() < fp ) {
				cout<<"error in erase_indels_off_ctg: "<<indeladdve.size()<<","<<fp<<endl;  exit(1);
			}
			Itep->first = fp - indeladdve[fp-1];
			if ( Itep->first == 0 )
				Itep->first = 1;
			int bp = Itep->second;
			if ( (int)indeladdve.size() < bp ) {
				cout<<"error in erase_indels_off_ctg: "<<indeladdve.size()<<","<<bp<<endl;  exit(1);
			}
			Itep->second = bp - indeladdve[bp-1];
		}

		if ( !con.snp.empty() ) {
			map< int, Mul_Aln_Site > alsnp;
			map< int, Mul_Aln_Site >::iterator Itesnp;
			for ( Itesnp = con.snp.begin(); Itesnp != con.snp.end(); ++Itesnp ) {
				if ( indelpoint.find( Itesnp->first ) == indelpoint.end() ) {
					if ( (int)indeladdve.size() < Itesnp->first ) {
						cout<<"error in erase_indels_off_ctg(snp): "<<indeladdve.size()<<","<<Itesnp->first<<endl;  exit(1);
					}
					int alk = Itesnp->first - indeladdve[Itesnp->first-1];
					if ( alk == 0 )
						alk = 1;
					alsnp.insert( make_pair( alk, Itesnp->second ) );
				}
			}
			con.snp = alsnp;
		}
	}
}

