#ifndef LAYOUT_CONS_EXCHANGE_H
#define LAYOUT_CONS_EXCHANGE_H


#include "Cons_mulaln.h"
#include "calignment.h"
#include "contig.h"
#include "assemblybank.h"

using namespace std;

const double match_base_score = 2;
const double mismatch_base_score = -3;

class Read_t_in_Con
{
public:
	int id;
	int forb;
};



void Layout_To_Cons( Contig &con, 
					map< int, map<int, Aln_id> > & IdAliMap, 
					map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
					map< Aln_id, Calignment > &AlnMap,
					vector< pair<string, string > >& IdSeqVe, 
					vector< vector<int> > &Qualve,
					Cons_Data_Bank & C_bank, 
					map< Read_id, Read_t_in_Con > & read_t_map );

void Cons_To_Ctg( Contig &con,
				 string &ctg, 
				 vector<int> &sc_ve,
				 vector<int> &cvg_ve,
				 Layout &lay, 
				 map< Read_id, Read_t_in_Con > & read_t_map );


bool selectalign(int id1, int id2, int forb1, int forb2, int ovlen, Calignment &ali,
				 map< int, map<int, Aln_id> > & IdAliMap,
				 map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
				 map< Aln_id, Calignment > &AlnMap );

void Caln_To_Cons_Data( Calignment &ali, Cons_Data_Bank & C_bank, map< Read_id, Read_t_in_Con > & read_t_map, Read_id rid1, Read_id rid2 );

void Caln_To_Cons_Data_tf( Calignment &ali, Cons_Data_Bank & C_bank, Read_id rid1, Read_id rid2 );

pair< Read_id, Seg_sub_id > add_seg( Cons_Data_Bank &C_bank, Read_id rid, int bgn, int len );

void add_match_to_data( Cons_Data_Bank & C_bank, Read_id rid_a, int bgn_a, Read_id rid_b, int bgn_b, int len, double score );

void erase_bgn_Seg_Map( Segmented_Read & read );
void clean_bank ( Cons_Data_Bank & C_bank );


void Lay_Cons( Contig &con,
			  map< int, map<int, Aln_id> > & IdAliMap,
			  map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
			  map< Aln_id, Calignment > &AlnMap,
			  vector< pair<string, string > >& IdSeqVe, 
			  vector< vector<int> > &Qualve );


void erase_indels_off_ctg( Contig &con );

#endif

