#ifndef LINK_H
#define LINK_H

#include <set>
#include <string>
#include <map>
#include "typedefbase.h"
#include "mates.h"

using namespace std;

class Link        // For read: head link --> the host read's head links i.e. head overlaps. tail link --> the tail overlaps;
{				  // For contig: head link --> the link to the last read in the ReadList

public:
		set<int> head_links;    // key <-- id, value <-- overlap length,
		set<int> tail_links;
		multimap<int, int> Head_Len_Id_Ma;    // key <-- length, value <-- id.   length means that exceeds the self seq
		multimap<int, int> Tail_Len_Id_Ma;
		map<int, int> Head_Id_Len_Ma;         // key <-- id, value <-- length.   length means the overlap's length between two seqs
		map<int, int> Tail_Id_Len_Ma;
		map<int, int> Head_Id_Ov_Ma;
		map<int, int> Tail_Id_Ov_Ma;
		map<int, pair<int, int> > Head_Id_Ov_Amma;   //ambiguity
		map<int, pair<int, int> > Tail_Id_Ov_Amma;
		map<int, pair<int, int> > Head_Id_Len_Amma;
		map<int, pair<int, int> > Tail_Id_Len_Amma;
};

class C_Link
{
public:
	int length;
	int degree;
	set<int> links;   // еid link
	set<pair<int, int> > head_links;
	set<pair<int, int> > tail_links;
	set<pair<int, int> > i_head_links;
	set<pair<int, int> > i_tail_links;
	multimap<int, pair<int, int> > Head_Len_Id_Ma;    // key <-- length, value <-- id.   length means that exceeds the self seq
	multimap<int, pair<int, int> > Tail_Len_Id_Ma;
	map<pair<int, int>, int > Head_Id_Len_Ma;         // key <-- id, value <-- length.   length means the overlap's length between two seqs
	map<pair<int, int>, int > Tail_Id_Len_Ma;
	map<pair<int, int>, int > Head_Id_Ov_Ma;
	map<pair<int, int>, int> Tail_Id_Ov_Ma;
	map<pair<int, int>, pair<int, int> > inner_links;       // first->id, second->de, de == 0 same, 1 trans
	map<pair<int, int>, pair<int, int> > outer_links;
};

class E_Link
{
public:
	int fate;
	int id1;
	int id2;
	int de1;   // link number
	int de2;
	int ht1;
	int ht2;
	int length1;
	int length2;
	int overlap_length;
	Mates mate_ob;
	vector<int> missVe;
	int configs;

};

class Matrix
{
public:
	vector<vector<int> > matrix;
	map<pair<int, int>, int> rowmap;
	map<pair<int, int>, int> arrmap;
	map<int, pair<int, int> > rrowmap;
	map<int, pair<int, int> > rarrmap;
};

class P_Link
{
public:
	set<pair<int, int> > head_links;
	set<pair<int, int> > tail_links;
};

#endif
