#include "localalign.h"
#include <fstream>

using namespace std;



void Localalign::headalign(Str &seq1, Str &seq2, vector<int> &scve1, vector<int> &scve2)
{
	if((int)seq1.size() != (int)scve1.size() || (int)seq2.size() != scve2.size()){
		cout<<"error in localalign::headalign &&"<<endl;   exit(1);
	}
	
	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();


	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;

	int i;
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;

		num.push_back(0);
		tag.push_back(0);
	
		

		if(i==0){
			for(j=1; j<=seq2Len; ++j){
				num.push_back(0);
				tag.push_back(0);
			
			}
		

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			for(j=1; j<=seq2Len; ++j){
				
				int sc1 = scve1[i-1];
				int sc2 = scve2[j-1];
				int minsc = min(sc1, sc2);
				if( seq1[i-1]==seq2[j-1] ){
				
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
				
					maxloc.insert( make_pair( num_v[i-1][j-1] - ( minsc/10+1 ), 2 ) );
				
				}
				
				int tsc = sc1;
				if ( (int)scve1.size() > i )
					tsc = min( sc1, scve1[i] );
				minsc = min( tsc, sc2 );
				if( (tag[j-1]==0)  )
					maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ), -1 ) );
				else
					maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ) , -1 ) );

				tsc = sc2;
				if ( (int)scve2.size() > j )
					tsc = min( sc2, scve2[j] );
				minsc = min( tsc, sc1 );
				if( (tag_v[i-1][j]==0)  )
					maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10+1 ), 1 ) );
				else
					maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10 +1) , 1 ) );
			

			
				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);

				maxloc.erase( maxloc.begin(), maxloc.end() );

			}
		
		}
		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}

	score = num_v[seq1Len][seq2Len];

	if(score>-50){
		int dex_i = seq1Len;
		int dex_j = seq2Len;

		string overlap;

		while(dex_j!=0 && dex_i!=0){

			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
					 misqs.push_front( make_pair(scve1[dex_i-1], scve2[dex_j-1] ) );
					 overlap+='-';
				}else{
					
					overlap+=seq1[dex_i-1];
				}
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(scve2[dex_j-1]);
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';
				
				int tsc = scve1[dex_i-1];
				if ( dex_i < (int)scve1.size() )
					tsc = min( scve1[dex_i-1], scve1[dex_i] );
				aliqul1.push_back(tsc);
				aliqul2.push_back(scve2[dex_j-1]);

				misqs.push_front( make_pair(tsc, scve2[dex_j-1]) );
				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';

				int tsc = scve2[dex_j-1];
				if ( dex_j < (int)scve2.size() )
					tsc = min( scve2[dex_j-1], scve2[dex_j] );
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(tsc);

				misqs.push_front( make_pair( scve1[dex_i-1], tsc ) );
				dex_i--;

			}
		}
		reverse( aliqul1.begin(), aliqul1.end() );
		reverse( aliqul2.begin(), aliqul2.end() );
		reverse( overlap.begin(), overlap.end() );

	

		if(dex_i == 0 && dex_j != 0){

			alignseq += seq2.substr(0, dex_j);
			alignseq += overlap;
			r = 2;              //seq2 head;
			leftlen = dex_j;
			
			rightlen = 0;

		}

		if(dex_i != 0 &&dex_j == 0){
			alignseq += seq1.substr(0, dex_i);
			alignseq += overlap;
			r = 1;              //seq1 head;
			leftlen = dex_i;
			
			rightlen = 0;

		}
		if(dex_i == 0 && dex_j == 0){
			alignseq += overlap;
			r = 0;
			leftlen = 0;
			rightlen = 0;
		}


	}
}

void Localalign::midalign(Str &seq1, Str &seq2, vector<int> &scve1, vector<int> &scve2)
{

	if((int)seq1.size() != (int)scve1.size() || (int)seq2.size() != scve2.size()){
		cout<<"error in localalign::midalign &&"<<endl;   exit(1);
	}

	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();


	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;


	int i;
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;

		if(i==0){
			num.push_back(0);  
			tag.push_back(0);
		

			num.push_back(-1000);  
			tag.push_back(-1);
		
			for(j=2; j<=seq2Len; ++j){
				num.push_back(-1000);
				tag.push_back(-1);
			
			}
	
			

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			if(i == 1){
				num.push_back(-1000);  
				tag.push_back(1);
			
			}else{
				num.push_back(-1000);
				tag.push_back(1);
			
			}

			for(j=1; j<=seq2Len; ++j){

				int sc1 = scve1[i-1];
				int sc2 = scve2[j-1];

				int minsc = min(sc1, sc2);
				if( seq1[i-1]==seq2[j-1] ){
				
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
					maxloc.insert( make_pair( num_v[i-1][j-1] - ( minsc/10+1 ), 2 ) );
				
				}

				int tsc = sc1;
				if ( (int)scve1.size() > i )
					tsc = min( sc1, scve1[i] );
				minsc = min(tsc, sc2);
				if( (tag[j-1]==0)  )
					maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ), -1 ) );
				else
					maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ) , -1 ) );
				
			
				tsc = sc2;
				if ( (int)scve2.size() > j )
					tsc = min( sc2, scve2[j] );
				minsc = min( tsc, sc1 );
				if( (tag_v[i-1][j]==0)  )
					maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10+1 ), 1 ) );
				else
					maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10+1 ) , 1 ) );
			

				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);
			

				maxloc.erase( maxloc.begin(), maxloc.end() );	

			}
	
			

		}

		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}
	
	score = num_v[seq1Len][seq2Len];

	if(score>-50){
		int dex_i = seq1Len;
		int dex_j = seq2Len;

		while(dex_j!=0 || dex_i!=0){

			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
					 misqs.push_front( make_pair(scve1[dex_i-1], scve2[dex_j-1] ) );
				
					 alignseq+='-';
				}else{
					
					alignseq+=seq1[dex_i-1];
				}
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(scve2[dex_j-1]);
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				alignseq+='-';
				int tsc = scve1[dex_i-1];
				if ( dex_i < (int)scve1.size() )
					tsc = min( scve1[dex_i-1], scve1[dex_i] );

				aliqul1.push_back(tsc);
				aliqul2.push_back(scve2[dex_j-1]);

				misqs.push_front( make_pair(tsc, scve2[dex_j-1]) );

				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				alignseq+='-';
				int tsc = scve2[dex_j-1];
				if ( dex_j < (int)scve2.size() )
					tsc = min( scve2[dex_j-1], scve2[dex_j] );
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(tsc);

				misqs.push_front( make_pair( scve1[dex_i-1], tsc ) );

				dex_i--;

			}
		}
		
		reverse( aliqul1.begin(), aliqul1.end() );
		reverse( aliqul2.begin(), aliqul2.end() );
		reverse( alignseq.begin(), alignseq.end() );
	}

	r = 0;
	leftlen = 0;
	rightlen = 0;
	
}

void Localalign::tailalign(Str &seq1, Str &seq2, vector<int> &scve1, vector<int> &scve2)
{

	if((int)seq1.size() != (int)scve1.size() || (int)seq2.size() != scve2.size()){
		cout<<"error in localalign::tailalign &&"<<endl;   exit(1);
	}

	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();


	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;
	multimap< int, pair<int,int>, greater<int> > endvalue_i_j;

	int i;
	
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;
		
		if(i==0){
			num.push_back(0);  
			tag.push_back(0);
		

			num.push_back(-1000);  
			tag.push_back(-1);
			for(j=2; j<=seq2Len; ++j){
				num.push_back(-1000);
				tag.push_back(-1);
			
			}
		

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			if(i == 1){
				num.push_back(-1000);  
				tag.push_back(1);
		
			}else{
				num.push_back(-1000);
				tag.push_back(1);
		
			}

			for(j=1; j<=seq2Len; ++j){
				
				int sc1 = scve1[i-1];
				int sc2 = scve2[j-1];
				int minsc = min(sc1, sc2);
				if( seq1[i-1]==seq2[j-1] ){
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
					maxloc.insert( make_pair( num_v[i-1][j-1] - ( minsc/10+1 ), 2 ) );
				
				}

				int tsc = sc1;
				if ( (int)scve1.size() > i )
					tsc = min( sc1, scve1[i] );
				minsc = min(tsc, sc2);
				if( (tag[j-1]==0)  ) {
					if ( j != seq2Len )
						maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ), -1 ) );
					else
						maxloc.insert( make_pair( -1000, -1 ) );
				} else {
					if ( j != seq2Len )
						maxloc.insert( make_pair( num[j-1] - ( minsc/10+1 ) , -1 ) );
					else
						maxloc.insert( make_pair( -1000, -1 ) );
				}
			
				tsc = sc2;
				if ( (int)scve2.size() > j ) 
					tsc = min( sc2, scve2[j] );
				minsc = min(tsc, sc1);
				if( (tag_v[i-1][j]==0)  ) {
					if ( i != seq1Len )
						maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10+1 ), 1 ) );
					else
						maxloc.insert( make_pair( -1000, 1 ) );
				} else {
					if ( i != seq1Len ) 
						maxloc.insert( make_pair( num_v[i-1][j] - ( minsc/10+1 ) , 1 ) );
					else
						maxloc.insert( make_pair( -1000, 1 ) );
				}
			
				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);
			

				if( (i == seq1Len || j == seq2Len) ){
					if( j == seq2Len ){
						
							endvalue_i_j.insert( make_pair( maxloc.begin()->first, make_pair(i,j) ) );
					
					}
					if( i == seq1Len ){
						
							endvalue_i_j.insert( make_pair( maxloc.begin()->first, make_pair(i,j) ) );
					
					}

				}

				maxloc.erase( maxloc.begin(), maxloc.end() );	

			}
		

		}

		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}

	score = endvalue_i_j.begin()->first;

	if(score>-50){
		int dex_i = endvalue_i_j.begin()->second.first;
		int dex_j = endvalue_i_j.begin()->second.second;
		

		

		string overlap;

		while(dex_j!=0 || dex_i!=0){

			
			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
					 misqs.push_front( make_pair(scve1[dex_i-1], scve2[dex_j-1] ) );
					 
					 overlap+='-';
				}else{
					
					overlap+=seq1[dex_i-1];
				}
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(scve2[dex_j-1]);
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';

				int tsc = scve1[dex_i-1];
				if ( dex_i < (int)scve1.size() )
					tsc = min( scve1[dex_i-1], scve1[dex_i] );

				aliqul1.push_back(tsc);
				aliqul2.push_back(scve2[dex_j-1]);

				misqs.push_front( make_pair(tsc, scve2[dex_j-1]) );

			
				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';
				int tsc = scve2[dex_j-1];
				if ( dex_j < (int)scve2.size() )
					tsc = min( scve2[dex_j-1], scve2[dex_j] );
				aliqul1.push_back(scve1[dex_i-1]);
				aliqul2.push_back(tsc);

				misqs.push_front( make_pair( scve1[dex_i-1], tsc ) );

				dex_i--;

			}
		}

		reverse( aliqul1.begin(), aliqul1.end() );
		reverse( aliqul2.begin(), aliqul2.end() );
		reverse( overlap.begin(), overlap.end() );

		alignseq += overlap;

		if( (seq1Len-(endvalue_i_j.begin()->second.first) ) != 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) == 0 ){  
			alignseq+=seq1.substr(endvalue_i_j.begin()->second.first);
			r = 3;   //seq1 tail;
			leftlen=0;
			rightlen=(int)seq1.substr(endvalue_i_j.begin()->second.first).size();
		}

		if( (seq1Len-(endvalue_i_j.begin()->second.first) ) == 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) != 0 ){  
			alignseq += seq2.substr(endvalue_i_j.begin()->second.second);
			r = 4;   //seq2 tail;
			leftlen = 0;
			rightlen = (int)seq2.substr(endvalue_i_j.begin()->second.second).size();
		}
		if((seq1Len-(endvalue_i_j.begin()->second.first) ) == 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) == 0){
			r = 0;
			leftlen = 0;
			rightlen = 0;
		}
	}

}


void Localalign::headalign(Str &seq1, Str &seq2)
{
	
	
	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();


	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;

	int i;
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;

		num.push_back(0);
		tag.push_back(0);
	
		

		if(i==0){
			for(j=1; j<=seq2Len; ++j){
				num.push_back(0);
				tag.push_back(0);
			
			}
		

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			for(j=1; j<=seq2Len; ++j){
				
		
				if( seq1[i-1]==seq2[j-1] ){
				
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
				
					maxloc.insert( make_pair( num_v[i-1][j-1] - 2, 2 ) );
				
				}
				
		
				if( (tag[j-1]==-1 )  )
					maxloc.insert( make_pair( num[j-1] - 3, -1 ) );
				else
					maxloc.insert( make_pair( num[j-1] - 4 , -1 ) );

			
				if( (tag_v[i-1][j]==1)  )
					maxloc.insert( make_pair( num_v[i-1][j] - 3, 1 ) );
				else
					maxloc.insert( make_pair( num_v[i-1][j] - 4 , 1 ) );
			

			
				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);

				maxloc.erase( maxloc.begin(), maxloc.end() );

			}
		
		}
		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}

	score = num_v[seq1Len][seq2Len];

	if(score>-50){
		int dex_i = seq1Len;
		int dex_j = seq2Len;

		string overlap;

		while(dex_j!=0 && dex_i!=0){

			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
					 overlap+='-';
					
				
				}else{
					
					overlap+=seq1[dex_i-1];
				}
		
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';
				
		
				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';

			
				dex_i--;

			}
		}
	
		reverse( overlap.begin(), overlap.end() );

	

		if(dex_i == 0 && dex_j != 0){

			alignseq += seq2.substr(0, dex_j);
			alignseq += overlap;
			r = 2;              //seq2 head;
			leftlen = dex_j;
			
			rightlen = 0;

		}

		if(dex_i != 0 &&dex_j == 0){
			alignseq += seq1.substr(0, dex_i);
			alignseq += overlap;
			r = 1;              //seq1 head;
			leftlen = dex_i;
			
			rightlen = 0;

		}
		if(dex_i == 0 && dex_j == 0){
			alignseq += overlap;
			r = 0;
			leftlen = 0;
			rightlen = 0;
		}


	}
}

void Localalign::midalign(Str &seq1, Str &seq2)
{

	

	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();




	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;


	int i;
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;

		if(i==0){
			num.push_back(0);  
			tag.push_back(0);
		

			num.push_back(-1000);  
			tag.push_back(-1);
		
			for(j=2; j<=seq2Len; ++j){
				num.push_back(-1000);
				tag.push_back(-1);
			
			}
	
			

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			if(i == 1){
				num.push_back(-1000);  
				tag.push_back(1);
			
			}else{
				num.push_back(-1000);
				tag.push_back(1);
			
			}

			for(j=1; j<=seq2Len; ++j){

		
				if( seq1[i-1]==seq2[j-1] ){
				
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
					maxloc.insert( make_pair( num_v[i-1][j-1] - 2, 2 ) );
				
				}

			
				if( (tag[j-1]==-1)  )
					maxloc.insert( make_pair( num[j-1] - 3, -1 ) );
				else
					maxloc.insert( make_pair( num[j-1] - 4 , -1 ) );
				
			
		
				if( (tag_v[i-1][j]==1)  )
					maxloc.insert( make_pair( num_v[i-1][j] - 3, 1 ) );
				else
					maxloc.insert( make_pair( num_v[i-1][j] - 4 , 1 ) );
			

				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);
			

				maxloc.erase( maxloc.begin(), maxloc.end() );	

			}
	
			

		}

		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}
	
	score = num_v[seq1Len][seq2Len];

	if(score>-50){
		int dex_i = seq1Len;
		int dex_j = seq2Len;

		while(dex_j!=0 || dex_i!=0){

			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
					 alignseq+='-';
				}else{
					
					alignseq+=seq1[dex_i-1];
				}
			
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				alignseq+='-';
			
				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				alignseq+='-';
			
				dex_i--;

			}
		}
		
	
		reverse( alignseq.begin(), alignseq.end() );
	}

	r = 0;
	leftlen = 0;
	rightlen = 0;
	
}

void Localalign::tailalign(Str &seq1, Str &seq2)
{

	

	int seq1Len = (int)seq1.size();
	int seq2Len = (int)seq2.size();



	vector<vector<int> > num_v;
	vector<vector<int> > tag_v;  
	vector<int> num;
	vector<int> tag;
	multimap< int, pair<int,int>, greater<int> > endvalue_i_j;

	int i;
	
	
	for(i=0; i<=seq1Len; ++i)
	{
		int j;
		
		if(i==0){
			num.push_back(0);  
			tag.push_back(0);
		

			num.push_back(-1000);  
			tag.push_back(-1);
			for(j=2; j<=seq2Len; ++j){
				num.push_back(-1000);
				tag.push_back(-1);
			
			}
		

		}else{
			multimap< int, int, greater<int> > maxloc;
			multimap< int, int, greater<int> > ::iterator iter;

			if(i == 1){
				num.push_back(-1000);  
				tag.push_back(1);
		
			}else{
				num.push_back(-1000);
				tag.push_back(1);
		
			}

			for(j=1; j<=seq2Len; ++j){
			
				if( seq1[i-1]==seq2[j-1] ){
					maxloc.insert( make_pair( num_v[i-1][j-1]+1, 0 ) );
				}else{
					maxloc.insert( make_pair( num_v[i-1][j-1] - 2, 2 ) );
				
				}

				if( (tag[j-1]==-1)  ) 
					
					maxloc.insert( make_pair( num[j-1] - 3, -1 ) );
				else
					maxloc.insert( make_pair( num[j-1] - 4, -1 ) );
				
			
			
				if( (tag_v[i-1][j]==1)  ) 
					
						maxloc.insert( make_pair( num_v[i-1][j] - 3, 1 ) );
					else
						maxloc.insert( make_pair( num_v[i-1][j] - 4, 1 ) );
				
			
				num.push_back(maxloc.begin()->first);
				tag.push_back(maxloc.begin()->second);
			

				if( (i == seq1Len || j == seq2Len) ){
					if( j == seq2Len ){
						
							endvalue_i_j.insert( make_pair( maxloc.begin()->first, make_pair(i,j) ) );
					
					}
					if( i == seq1Len ){
						
							endvalue_i_j.insert( make_pair( maxloc.begin()->first, make_pair(i,j) ) );
					
					}

				}

				maxloc.erase( maxloc.begin(), maxloc.end() );	

			}
		

		}

		num_v.push_back(num);
		tag_v.push_back(tag);
		num.erase( num.begin(), num.end() );
		tag.erase( tag.begin(), tag.end() );
	}

	score = endvalue_i_j.begin()->first;

	if(score>-50){
		int dex_i = endvalue_i_j.begin()->second.first;
		int dex_j = endvalue_i_j.begin()->second.second;
		

		

		string overlap;

		while(dex_j!=0 || dex_i!=0){

			
			if( (tag_v[dex_i][dex_j]==0) || (tag_v[dex_i][dex_j]==2) ){
				if(seq1[dex_i-1]!=seq2[dex_j-1]){
					    
					 misp.push_front( make_pair( make_pair(seq1[dex_i-1],seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
					 
					 overlap+='-';
				}else{
					
					overlap+=seq1[dex_i-1];
				}
			
				dex_i--;
				dex_j--;

			}

			if(tag_v[dex_i][dex_j]==-1){
					
				misp.push_front( make_pair( make_pair('-',seq2[dex_j-1]), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';

			
				dex_j--;
				continue;
			}
			if(tag_v[dex_i][dex_j]==1){
					
				misp.push_front( make_pair( make_pair(seq1[dex_i-1],'-'), make_pair(dex_i, dex_j) ) );
				
				overlap+='-';
			
				dex_i--;

			}
		}

	
		reverse( overlap.begin(), overlap.end() );

		alignseq += overlap;

		if( (seq1Len-(endvalue_i_j.begin()->second.first) ) != 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) == 0 ){  
			alignseq+=seq1.substr(endvalue_i_j.begin()->second.first);
			r = 3;   //seq1 tail;
			leftlen=0;
			rightlen=(int)seq1.substr(endvalue_i_j.begin()->second.first).size();
		}

		if( (seq1Len-(endvalue_i_j.begin()->second.first) ) == 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) != 0 ){  
			alignseq += seq2.substr(endvalue_i_j.begin()->second.second);
			r = 4;   //seq2 tail;
			leftlen = 0;
			rightlen = (int)seq2.substr(endvalue_i_j.begin()->second.second).size();
		}
		if((seq1Len-(endvalue_i_j.begin()->second.first) ) == 0 && (seq2Len-(endvalue_i_j.begin()->second.second) ) == 0){
			r = 0;
			leftlen = 0;
			rightlen = 0;
		}
	}

}

