#include "mates.h"

void Mates::matescalculate(Contig &con1, Contig &con2, int overlap, map<int, pair<int, pair<int, int> > > & Pairs)
{

	
	int size1 = con1.RelposList.back().second;
	int size2 = con2.RelposList.back().second;

	exp1 = 0;
	ser_num1 = 0;
	ser_num2 = 0;
	miss_num1 = 0;
	miss_num2 = 0;
	config1 = 0;
	config2 = 0;
	if(con1.ReadidList.empty()){
		cout<< "re1" << endl;  exit(1);
	}

	set<int>::iterator ite;
	int maxlen = 0;

	int thr = 10000;
	for(ite = con1.ReadidSet.begin(); ite != con1.ReadidSet.end(); ++ite){
		if(Pairs.find(*ite) == Pairs.end())
			continue;
		int l = Pairs[*ite].second.first + 3 * Pairs[*ite].second.second;
		if(l > maxlen && l <= thr){
			maxlen = l;

		}
	}
	
	list<int>::reverse_iterator Riteli;
	list<pair<int, int> >::reverse_iterator Riterp = con1.RelposList.rbegin();
	list<int>::reverse_iterator Ritef = con1.ForbList.rbegin();
	for(Riteli = con1.ReadidList.rbegin(); Riteli != con1.ReadidList.rend(); ++Riteli){
		int id1 = *Riteli;
	
		if(*Ritef != 0){
			++Riterp;
			++Ritef;
			continue;
		}
	
		int t_len = size1 - Riterp->first + 1;
	

		if(t_len - overlap > maxlen)
			break;
	

	
		if(Pairs.find(id1) == Pairs.end()){
			++Riterp;
			++Ritef;
			continue;
		}
	
		int id1_p = Pairs[id1].first;
		if(con1.ReadidSet.find(id1_p)!=con1.ReadidSet.end()){
			++Riterp;
			++Ritef;
			continue;
		}

		int e = Pairs[id1].second.first;
		int v = Pairs[id1].second.second;
		int l1 = e - 3 * v;
		int l2 = e + 3 * v;
		double ex1 = probf(e, v, (t_len + size2 - overlap));
		double ex2 = probf(e, v, (-overlap));
		exp1 += (ex1 - ex2);

		int tag = 0;
		if(con2.ReadidSet.find(id1_p) != con2.ReadidSet.end()){
			if(con2.read_forbMap.find(id1_p)==con2.read_forbMap.end()){
				cout<< "a3, "<<id1_p<<endl;  exit(1);
			}
			if(con2.read_forbMap[id1_p] == 1){
				if(con2.read_relposMap.find(id1_p)==con2.read_relposMap.end()){
					cout<<"a4,"<< id1_p<<endl;  exit(1);
				}
				int in_length = t_len + con2.read_relposMap[id1_p].second - overlap;
				if(l1 < in_length && in_length < l2){
					tag = 1;
					config1 +=1;
				}
			}
		}

	

		++Riterp;
		++Ritef;
		
	}


}


pair<Seed, Seed> Mates::selectseed(Contig &con1, std::map<int, pair<int, pair<int, int> > > & Pairs)
{
	
	Seed ob1;
	Seed ob2;

	set<int>::iterator ite;
	int maxlen = 0;

	int thr = 10000;
	for(ite = con1.ReadidSet.begin(); ite != con1.ReadidSet.end(); ++ite){
		if(Pairs.find(*ite) == Pairs.end())
			continue;
		int l = Pairs[*ite].second.first + 3 * Pairs[*ite].second.second;
		if(l > maxlen && l <= thr){
			maxlen = l;

		}
	}
 
	int size1 = con1.RelposList.back().second;

	list<int>::reverse_iterator Riteli;
	list<pair<int, int> >::reverse_iterator Riterp = con1.RelposList.rbegin();
	list<int>::reverse_iterator Ritef = con1.ForbList.rbegin();
	for(Riteli = con1.ReadidList.rbegin(); Riteli != con1.ReadidList.rend(); ++Riteli){
		int id1 = *Riteli;
		
		if(*Ritef != 0){
			++Riterp;
			++Ritef;
			continue;
		}

		int t_len = size1 - Riterp->first + 1;

		
		if(t_len > maxlen)
			break;


	
		if(Pairs.find(id1) == Pairs.end()){
			++Riterp;
			++Ritef;
			continue;
		}

		int id1_p = Pairs[id1].first;

		if(con1.ReadidSet.find(id1_p)!=con1.ReadidSet.end()){
			++Riterp;
			++Ritef;
			continue;
		}

		int e = Pairs[id1].second.first;
		int v = Pairs[id1].second.second;
		if(probf(e, v, t_len) == 1){
			++Riterp;
			++Ritef;
			continue;
		}

		int l1 = e - 3 * v;
		int l2 = e + 3 * v;
		
		ob1.lenve.push_back(make_pair(t_len, make_pair(e, v)));
		ob1.readmap.insert(make_pair(id1_p, make_pair(t_len, make_pair(l1, l2))));
		ob1.configs = 0;
		++Riterp;
		++Ritef;
	}

	list<int>::iterator Iteli;
	list<pair<int, int> >::iterator Iterp = con1.RelposList.begin();
	list<int>::iterator Itef = con1.ForbList.begin();
	for(Iteli = con1.ReadidList.begin(); Iteli != con1.ReadidList.end(); ++Iteli){
		int id1 = *Iteli;
		

		if(*Itef != 1){
			++Iterp;
			++Itef;
			continue;
		}
		

	
		int t_len = Iterp->second;

		if(t_len > maxlen)
			break;


		if(Pairs.find(id1) == Pairs.end()){
			++Iterp;
			++Itef;
			continue;
		}

		int id1_p = Pairs[id1].first;
	
		if(con1.ReadidSet.find(id1_p)!=con1.ReadidSet.end()){
			++Iterp;
			++Itef;
			continue;
		}

		int e = Pairs[id1].second.first;
		int v = Pairs[id1].second.second;
		if(probf(e, v, t_len) == 1){
			++Iterp;
			++Itef;
			continue;
		}

		int l1 = e - 3 * v;
		int l2 = e + 3 * v;

		ob2.lenve.push_back(make_pair(t_len, make_pair(e, v)));
		ob2.readmap.insert(make_pair(id1_p, make_pair(t_len, make_pair(l1, l2))));
		ob2.configs = 0;
		++Iterp;
		++Itef;
	}

	pair<Seed, Seed> value = make_pair(ob1, ob2);

	return value;
}

Seed Mates::elong(Seed & sob, Contig & con, int ovlen, int hint)
{
	

	Seed ob;
	ob.configs = sob.configs;
	map<int, pair<int, pair<int, int> > >::iterator Item;
	for(Item = sob.readmap.begin(); Item != sob.readmap.end(); ++Item){
		
		
		int tg = 0;
		if(hint == 0){
			if(con.read_relposMap.find(Item->first) != con.read_relposMap.end()){

				if(con.read_forbMap[Item->first] == 1){
					int len = Item->second.first + con.read_relposMap[Item->first].second - ovlen;
					
					if(len > Item->second.second.first && len < Item->second.second.second){
						ob.configs += 1;
						tg = 1;
						
					}
					
				}
			}
		}
		int len = Item->second.first + con.RelposList.back().second - ovlen;
	
		if(tg == 0){
			ob.readmap.insert(make_pair(Item->first, make_pair(len, make_pair(Item->second.second.first, Item->second.second.second))));
		}
	}

	ob.exp = 0;
	for(int i = 0; i < (int)sob.lenve.size(); ++i){
		int len = sob.lenve[i].first + con.RelposList.back().second - ovlen;
	
		ob.exp += probf(sob.lenve[i].second.first, sob.lenve[i].second.second, len);
		ob.lenve.push_back(make_pair(len, make_pair(sob.lenve[i].second.first, sob.lenve[i].second.second)));
	}
	if(ob.exp > (int)sob.lenve.size()){
		cout<<"error exp > lenve.size: "<<ob.exp<<"\t"<<sob.lenve.size()<<endl;  exit(1);
	}
	if(ob.exp != 0)
		ob.score = double(ob.configs) / ob.exp;


	return ob;
}

set<pair<int, int> > Mates::checkrepeatread(Contig &con, std::set<int> &rs1, std::set<int> &rs2, std::map<int, pair<int, pair<int, int> > > &Pairs)  //rs1 repeatread, rs2 stressread.
{


	int consize = con.RelposList.back().second;

	list<int>::iterator Iterl = con.ReadidList.begin();
	list<pair<int, int> >::iterator Iterp = con.RelposList.begin();
	list<int>::iterator Iterf = con.ForbList.begin();

	vector<int> str;
	vector<pair<int, int> > strp;
	set<pair<int, int> > strpset;

	for(; Iterl != con.ReadidList.end(); ++Iterl){
		if(rs1.find(*Iterl) != rs1.end()){
			if(Pairs.find(*Iterl) != Pairs.end()){
				int id_p = Pairs[*Iterl].first;
				int e = Pairs[*Iterl].second.first;
				int v = Pairs[*Iterl].second.second;
				int tag = 0;
				if(con.ReadidSet.find(id_p) != con.ReadidSet.end()){
					
						if(con.MultiReadMap.find(id_p) != con.MultiReadMap.end()){
							set<pair<pair<int, int>, int > >::iterator Iters;
							for(Iters = con.MultiReadMap[id_p].begin(); Iters != con.MultiReadMap[id_p].end(); ++Iters){
								
								int forb2 = Iters->second;
								if(*Iterf == 0){
									if(forb2 == 1){
										int len = Iters->first.second - Iterp->first + 1;
										if( (e - 4 * v) < len && len < (e + 4 * v)){
											tag = 1;
											break;
										}
									}
								}else{
									if(forb2 == 0){
										int len = Iterp->second - Iters->first.first + 1;
										if( (e - 4 * v) < len && len < (e + 4 * v)){
											tag = 1;
											break;
										}
									}
								}
							}
						}else{
							
							int forb2 = con.read_forbMap[id_p];
							if(*Iterf == 0){
								if(forb2 == 1){
									int len = con.read_relposMap[id_p].second - Iterp->first + 1;
									if( (e - 4 * v) < len && len < (e + 4 * v)){
										tag = 1;
										
									}
								}
							}else{
								if(forb2 == 0){
									int len = Iterp->second - con.read_relposMap[id_p].first + 1;
									if( (e - 4 * v) < len && len < (e + 4 * v)){
										tag = 1;
										
									}
								}
							}
						}
					
				}

				if(tag == 0){
					if(rs2.find(*Iterl) != rs2.end()){
						str.push_back(*Iterl);
						strp.push_back(*Iterp);
						strpset.insert(*Iterp);
					}
				
					
				}
				
			}
		}
		++Iterp;
		++Iterf;
	}


	

	set<pair<int, int> > instrp;
	set<pair<int, int> > cutp;
	for(int i = 0; i < (int)str.size(); ++i){
		if(strp[i].first == 1 || strp[i].second == consize){
	
			cutp.insert(strp[i]);
			continue;
		}
		if(con.inreadmap.find(str[i]) != con.inreadmap.end()){
	
			instrp.insert(strp[i]);
		}else{
			list<pair<int, int> >::iterator Iterp_t;
			Iterp_t = find(con.RelposList.begin(), con.RelposList.end(), strp[i]);
			if(Iterp_t == con.RelposList.end()){
				cout<<"error1 in Mates::checkrepeatread "<<strp[i].first<<","<<strp[i].second<<endl;   exit(1);
			}
			if(Iterp_t == con.RelposList.begin()){
				cout<<"error2 in Mates::checkrepeatread "<<strp[i].first<<","<<strp[i].second<<endl;   exit(1);
			}
			Iterl = con.ReadidList.begin();
			Iterp = con.RelposList.begin(); 
			for(; Iterp != con.RelposList.end(); ++Iterp){
				if(*Iterp == strp[i]){
					if(Iterp == con.RelposList.begin()){
						cout<<"error1 in Mates::checkrepeatread "<<strp[i].first<<","<<strp[i].second<<endl;   exit(1);
					}
					list<int>::iterator Iterl_1 = Iterl;
					--Iterl_1;
					list<pair<int, int> >::iterator Iterp_1 = Iterp;
					--Iterp_1;
					int tt = 0;
					while(con.inreadmap.find(*Iterl_1) != con.inreadmap.end() || strpset.find(*Iterp_1) != strpset.end()){
						if(Iterp_1 == con.RelposList.begin()){
							tt = 1;
						
							break;
						}
						--Iterl_1;
						--Iterp_1;
					}
					if(tt == 1){
						cutp.insert(strp[i]);
						break;
					}else{
						
						int pos1 = Iterp_1->second;
					
						list<int>::iterator Iterl_2 = Iterl;
						++Iterl_2;
						list<pair<int, int> >::iterator Iterp_2 = Iterp;
						++Iterp_2;
						if(Iterp_2 == con.RelposList.end()){
					
							cutp.insert(strp[i]);
							break;
						}
						tt = 0;
						while(con.inreadmap.find(*Iterl_2) != con.inreadmap.end() || strpset.find(*Iterp_2) != strpset.end()){
							++Iterl_2;
							++Iterp_2;
							if(Iterp_2 == con.RelposList.end()){
							
								tt = 1;
								break;
							}
							
						}
						if(tt == 1){
							cutp.insert(strp[i]);
							break;
						}else{
							int pos2 = Iterp_2->first;
						
							if(pos2 < pos1){
						
								instrp.insert(strp[i]);
								break;
							}else{
						
								cutp.insert(strp[i]);
								break;
							}

						}
					}

					break;
				}
				++Iterl;
			}
		}
	}


	

	Iterl = con.ReadidList.begin();
	Iterp = con.RelposList.begin();
	Iterf = con.ForbList.begin();

	list<int> nrl;
	list<pair<int, int> > nrp;
	list<int> nrf;

	set<int> podel;
	for(; Iterp != con.RelposList.end(); ++Iterp){
		if(instrp.find(*Iterp) == instrp.end()){
			nrl.push_back(*Iterl);
			nrp.push_back(*Iterp);
			nrf.push_back(*Iterf);
		}else{
			
			if(con.MultiReadMap.find(*Iterl) != con.MultiReadMap.end()){
		
				set<pair<pair<int, int>, int > >::iterator Ites;
				for(Ites = con.MultiReadMap[*Iterl].begin(); Ites != con.MultiReadMap[*Iterl].end(); ++Ites){
					if(Ites->first == *Iterp){
						con.MultiReadMap[*Iterl].erase(Ites);
				
						break;
					}
				}
				if((int)con.MultiReadMap[*Iterl].size() == 1){
				
					con.read_relposMap[*Iterl] = con.MultiReadMap[*Iterl].begin()->first;
				
					con.read_forbMap[*Iterl] = con.MultiReadMap[*Iterl].begin()->second;
				
					con.MultiReadMap.erase(*Iterl);
			
				}
			}else{
				if(con.read_forbMap.find(*Iterl) != con.read_forbMap.end()){
			
					con.read_forbMap.erase(*Iterl);
				}//else
			
				if(con.read_relposMap.find(*Iterl) != con.read_relposMap.end()){
				
					con.read_relposMap.erase(*Iterl);
				}//else
			
			}
			podel.insert(*Iterl);
			
		}
		++Iterf;
		++Iterl;
	}



	con.ReadidList = nrl;
	con.RelposList = nrp;
	con.ForbList = nrf;

	set<int>::iterator itepo;
	for(itepo = podel.begin(); itepo != podel.end(); ++itepo){
		list<int>::iterator Itei;
		Itei = find(con.ReadidList.begin(), con.ReadidList.end(), *itepo);
		if(Itei == con.ReadidList.end()){
			con.ReadidSet.erase(*itepo);
	
			if(con.inreadmap.find(*itepo) != con.inreadmap.end()){
				con.inreadmap.erase(*itepo);
			
			}
		}
	}

	


	return cutp;

}

