#include "ovl.h"

void getseq_pfa( multimap< int, int, greater<int> > &LenNidMap,
				map<int, map<int, Matchseed> > &seedmap,
				vector<pair<Str, Str > >& IdSeqVe,
				map<int, map<int, Matchseed> > &incluster )
{

	int n = (int)IdSeqVe.size();

	set<int> Nids;
	map<int, map<int, Matchseed> >::iterator ite;
	for(ite=incluster.begin(); ite!=incluster.end(); ++ite){
		int i = ite->first;
		
	

		if(Nids.find(i) == Nids.end()){
		

			LenNidMap.insert( make_pair( (int)IdSeqVe[i-1].second.size(), i ) );



			Nids.insert(i);
		}
		map<int, Matchseed>::iterator Ites;
		for(Ites = ite->second.begin(); Ites != ite->second.end(); ++Ites){
			int j = Ites->first;
			
		
			if(Nids.find(j) == Nids.end()){
			
				LenNidMap.insert( make_pair( (int)IdSeqVe[j-1].second.size(), j ) );


				Nids.insert(j);
			}
			Matchseed ob;
			ob = Ites->second;
			Matchseed nul;

			seedmap[i][j] = ob;
			ob.reversep();
			seedmap[j][i] = ob;





		}

	}
}


void getalignment( short_assembly_bank &assbank,
				  multimap< int, int, greater<int> > &LenNidMap,
				  vector< pair<string, string > >& IdSeqVe,
				  vector< vector<int> > &Qualve,
				  map<int, map<int, Matchseed> > &seedmap,
				  int ov_len_th,
				  double er_thr,
				  double er_thr_100,
				  double er_thr_50,
				  double snprate,
				  int wl,
				  int max_thread_num )
{

	int kk = 2;
	set< int > usedid;

	multimap< int, int, greater<int> >::iterator pos;


	
	vector<int> idve;
	for ( pos = LenNidMap.begin(); pos != LenNidMap.end(); ++pos){
		idve.push_back(pos->second);
		
	}
	int vesize = (int)idve.size();

	int g_ncore = omp_get_num_procs();
	int nt = g_ncore > max_thread_num? max_thread_num : g_ncore;
	omp_lock_t lk_usedid;
	omp_init_lock(&lk_usedid);
	omp_lock_t lk_seedmap;
	omp_init_lock(&lk_seedmap);
	omp_lock_t lk_alnmap;
	omp_init_lock(&lk_alnmap);
	omp_lock_t lk_IA;
	omp_init_lock(&lk_IA);
	omp_lock_t lk_mismatch;
	omp_init_lock(&lk_mismatch);

//	cout<<"nt "<<nt<<endl;
	cout<<"total "<<vesize<<" reads"<<endl;

#pragma omp parallel for ordered schedule(static, 1) num_threads(nt)
	for ( int i = 0; i < vesize; ++i ) {

		if ( (i+1 ) % 10000 == 0 ) {
			cout<<(i+1)<<" reads aligned!"<<endl;
		}

		int id1 = idve[i];
	
		omp_set_lock(&lk_seedmap);
		if(seedmap.find(id1) == seedmap.end()){
			cout<<"error: not found in seedmap "<<id1<<endl;  exit(1);
		}
	
		map<int, Matchseed> seeds = seedmap[id1];
		
		seedmap.erase(id1);
		omp_unset_lock(&lk_seedmap);

		map<int, Aln_id > AliMap;
		map<int, multimap<int, Aln_id, greater<int> > > MulAliMap;

		map<int, Matchseed>::iterator Itese;
		for(Itese = seeds.begin(); Itese != seeds.end(); ++Itese){

			if ( (int)Itese->second.fwmatch.size() < kk && (int)Itese->second.revmatch.size() < kk )
				continue;

			int id2 = Itese->first;
			bool used = false;
			omp_set_lock(&lk_usedid);
			
			if(usedid.find(id2)!=usedid.end()){
				used = true;
			}
			omp_unset_lock(&lk_usedid);


			if ( used ) {
				omp_set_lock(&lk_IA);
				
				if(assbank.IdAliMap.find(id2)!=assbank.IdAliMap.end()){
					if(assbank.IdAliMap[id2].find(id1) != assbank.IdAliMap[id2].end()){
						AliMap.insert(make_pair(id2, assbank.IdAliMap[id2][id1]));
					
					}
				}



				if(assbank.MulIdAliMap.find(id2) != assbank.MulIdAliMap.end()){
					if(assbank.MulIdAliMap[id2].find(id1) != assbank.MulIdAliMap[id2].end()){
						MulAliMap.insert(make_pair(id2, assbank.MulIdAliMap[id2][id1]));
						
					}
				}


				omp_unset_lock(&lk_IA);
				

				continue;
			}
			


			
			multimap<int, Calignment, greater<int> > mva;

			Matchseed ms = Itese->second;
			int tag = 0;
			if((int)ms.fwmatch.size() >= kk){
				
				

				Align A_ob(id1, id2, IdSeqVe[id1-1].second, IdSeqVe[id2-1].second, Qualve[id1-1], Qualve[id2-1], 0, 0, wl,ov_len_th, er_thr, er_thr_100, er_thr_50, snprate);
				A_ob.process2(ms.fwmatch);
				multimap<int, Calignment, greater<int> > va = A_ob.alive;

				mva.insert(va.begin(), va.end());
				tag = 1;

			}
			if((int)ms.revmatch.size() >= kk){

				string seq2;
				vector<int> qual2;
				
				
				seq2 = IdSeqVe[id2-1].second;
				
				qual2 = Qualve[id2-1];
				

				std::reverse( seq2.begin(), seq2.end() );
				std::for_each( seq2.begin(), seq2.end(),
					SequenceTransform_T::ToOppRule_T() );
				
				std::reverse( qual2.begin(), qual2.end() );
				Align A_ob(id1, id2, IdSeqVe[id1-1].second, seq2, Qualve[id1-1], qual2, 0, 1, wl, ov_len_th, er_thr, er_thr_100, er_thr_50, snprate);
				int size = (int)seq2.size();
				set<pair<int, int> > match = antimatch(ms.revmatch, size, wl);
				A_ob.process2(match);
				multimap<int, Calignment, greater<int> > va = A_ob.alive;

				mva.insert(va.begin(), va.end());
				tag = 1;

			}

			





			
			if(!mva.empty()){

				Calignment cob = mva.begin()->second;


				Aln_id nid = 0;

				omp_set_lock(&lk_alnmap);
				if ( assbank.Aln_Map.empty() ) {
					nid = 1;
				} else {
					nid = assbank.Aln_Map.rbegin()->first + 1;
				}

				assbank.Aln_Map.insert( make_pair( nid, cob ) );
				omp_unset_lock(&lk_alnmap);

					AliMap.insert(make_pair(id2, nid));

				

				if((int)mva.size()>1){
					multimap<int, Aln_id, greater<int> > id_mva;
					multimap<int, Calignment, greater<int> >::iterator itemva;
					for ( itemva = mva.begin(); itemva != mva.end(); ++itemva ) {
						if ( itemva == mva.begin() ) {
							id_mva.insert( make_pair( itemva->first, nid ) );
							continue;
						}
						omp_set_lock(&lk_alnmap);
						Aln_id n_id = assbank.Aln_Map.rbegin()->first + 1;
						assbank.Aln_Map.insert( make_pair( n_id, itemva->second ) );
						id_mva.insert( make_pair( itemva->first, n_id ) );
						omp_unset_lock(&lk_alnmap);
					}
					MulAliMap.insert( make_pair( id2, id_mva ) );
				}
			}else{
				omp_set_lock(&lk_mismatch);
				if(id1 < id2)
					assbank.mismatch.insert(make_pair(id1, id2));
				else
					assbank.mismatch.insert(make_pair(id2, id1));
				omp_unset_lock(&lk_mismatch);
			}
		


		}

		omp_set_lock(&lk_IA);
		
		if(!AliMap.empty()){

			assbank.IdAliMap.insert(make_pair(id1, AliMap));
			AliMap.clear();

		}
		if(!MulAliMap.empty()){
			assbank.MulIdAliMap.insert(make_pair(id1, MulAliMap));
			MulAliMap.clear();
		}
		omp_unset_lock(&lk_IA);


		omp_set_lock(&lk_usedid);
		usedid.insert(id1);

		omp_unset_lock(&lk_usedid);


	}

	omp_destroy_lock(&lk_usedid);
	omp_destroy_lock(&lk_seedmap);
	omp_destroy_lock(&lk_alnmap);
	omp_destroy_lock(&lk_IA);
	omp_destroy_lock(&lk_mismatch);


}

set<int> symalign( short_assembly_bank &assbank,
				  map<int, C_Link> &L_Map,
				  set<pair<int, int> > &tadd,
				  set<int> &idset,
				  int hint,
				  vector< pair<string, string > >& IdSeqVe,
				  vector< vector<int> > &Qualve,
				  int ov_len_th,
				  double er_thr,
				  double er_thr_100,
				  double er_thr_50,
				  double snprate,
				  int wl )    
{
	set<int> reva;
	set<pair<int, int> > add;

	map<int, C_Link>::iterator IteL;
	for(IteL = L_Map.begin(); IteL != L_Map.end(); ++IteL){
		if(hint != 0 ){
			if(idset.find(IteL->first) == idset.end())
				continue;
		}
		int ss = (int)IteL->second.head_links.size() + (int)IteL->second.tail_links.size() + (int)IteL->second.inner_links.size() + (int)IteL->second.outer_links.size();

		if(ss <= 1)
			continue;

		int read_size = (int)IdSeqVe[IteL->first-1].second.size();
		map<pair<int, int>, pair<int, int> > idovmap;
		map<pair<int, int>, int >::iterator Iteh;
		for(Iteh = IteL->second.Head_Id_Ov_Ma.begin(); Iteh != IteL->second.Head_Id_Ov_Ma.end(); ++Iteh){
			int ov = Iteh->second;
			int rlen = (int)IdSeqVe[Iteh->first.first-1].second.size();
			idovmap.insert(make_pair(make_pair(read_size-ov+1, read_size+(rlen-ov)), reversepht(Iteh->first)));

		}
		map<pair<int, int>, int >::iterator Itet;
		for(Itet = IteL->second.Tail_Id_Ov_Ma.begin(); Itet != IteL->second.Tail_Id_Ov_Ma.end(); ++Itet){
			int ov = Itet->second;
			int rlen = (int)IdSeqVe[Itet->first.first-1].second.size();
			idovmap.insert(make_pair( make_pair(1-(rlen-ov), ov), Itet->first ) );

		}
		map<pair<int, int>, pair<int, int> >::iterator Itei;
		for(Itei = IteL->second.inner_links.begin(); Itei != IteL->second.inner_links.end(); ++Itei){
			idovmap.insert(make_pair( make_pair(Itei->second.first + 1, read_size - Itei->second.second ), Itei->first) );
		}
		map<pair<int, int>, pair<int, int> >::iterator Iteo;
		for(Iteo = IteL->second.outer_links.begin(); Iteo != IteL->second.outer_links.end(); ++Iteo){
			idovmap.insert(make_pair(make_pair(1-Iteo->second.first, read_size+Iteo->second.second), Iteo->first) );
		}



		map<pair<int, int>, pair<int, int> >::iterator Item;
		for(Item = idovmap.begin(); Item != idovmap.end(); ++Item){
			map<pair<int, int>, pair<int, int> >::iterator Item_2 = Item;
			++Item_2;
			if(Item_2 == idovmap.end())
				break;

			for(; Item_2 != idovmap.end(); ++Item_2){

				if(Item->first.second - Item_2->first.first + 1 >= ov_len_th && Item->first.second - Item_2->first.first + 1 <= 130){      // why?
			
					int id1 = Item->second.first;
					int id2 = Item_2->second.first;
					int forb1 = Item->second.second;
					int forb2 = Item_2->second.second;
					if(assbank.IdAliMap[id1].find(id2) != assbank.IdAliMap[id1].end())
						continue;

					if(id1 < id2){
						if(assbank.mismatch.find(make_pair(id1, id2)) != assbank.mismatch.end())
							continue;
						if(add.find(make_pair(id1, id2)) != add.end())
							continue;
					}else{
						if(assbank.mismatch.find(make_pair(id2, id1)) != assbank.mismatch.end())
							continue;
						if(add.find(make_pair(id2, id1)) != add.end())
							continue;
					}


					Str seq1 = IdSeqVe[id1-1].second;
					Str seq2 = IdSeqVe[id2-1].second;
					vector<int> qulve1 = Qualve[id1-1];
					vector<int> qulve2 = Qualve[id2-1];

					multimap<int, Calignment, greater<int> > va;
					if((int)seq1.size() >= (int)seq2.size()){
						if(forb1 != forb2){
							std::reverse( seq2.begin(), seq2.end() );
							std::for_each( seq2.begin(), seq2.end(),
								SequenceTransform_T::ToOppRule_T() );
							std::reverse( qulve2.begin(), qulve2.end() );

							Align A_ob(id1, id2, seq1, seq2, qulve1, qulve2, 0, 1, 11, ov_len_th, er_thr, er_thr_100, er_thr_50, snprate );
							A_ob.process( 1 );
							va = A_ob.alive;


						}else{
							Align A_ob(id1, id2, seq1, seq2, qulve1, qulve2, 0, 0, 11, ov_len_th, er_thr, er_thr_100, er_thr_50, snprate );
							A_ob.process( 1 );
							va = A_ob.alive;


						}
					}else{
						if(forb1 != forb2){
							std::reverse( seq1.begin(), seq1.end() );
							std::for_each( seq1.begin(), seq1.end(),
								SequenceTransform_T::ToOppRule_T() );
							std::reverse( qulve1.begin(), qulve1.end() );

							Align A_ob(id2, id1, seq2, seq1, qulve2, qulve1, 0, 1, 11, ov_len_th, er_thr, er_thr_100, er_thr_50, snprate );
							A_ob.process( 1 );
							va = A_ob.alive;


						}else{
							Align A_ob(id2, id1, seq2, seq1, qulve2, qulve1, 0, 0, 11, ov_len_th, er_thr, er_thr_100, er_thr_50, snprate );
							A_ob.process( 1 );
							va = A_ob.alive;


						}
					}


					if(!va.empty()){
						Calignment c_ob = va.begin()->second;
						Aln_id nid = assbank.Aln_Map.rbegin()->first + 1;
						assbank.Aln_Map.insert( make_pair( nid, c_ob ) );
						assbank.IdAliMap[id1][id2] = nid;
						assbank.IdAliMap[id2][id1] = nid;
						
						if(id1 < id2)
							add.insert(make_pair(id1, id2));
						else
							add.insert(make_pair(id2, id1));
						if((int)va.size() > 1){
							multimap<int, Aln_id, greater<int> > id_va;
							multimap<int, Calignment, greater<int> >::iterator iteva;
							for ( iteva = va.begin(); iteva != va.end(); ++iteva ) {
								if ( iteva == va.begin() ) {
									id_va.insert( make_pair( iteva->first, nid ) );
									continue;
								}
								Aln_id n_id = assbank.Aln_Map.rbegin()->first + 1;
								assbank.Aln_Map.insert( make_pair( n_id, iteva->second ) );
								id_va.insert( make_pair( iteva->first, n_id ) );
							}
							assbank.MulIdAliMap[id1][id2] = id_va;
							assbank.MulIdAliMap[id2][id1] = id_va;
						}
					}else{
						if(id1 < id2)
							assbank.mismatch.insert(make_pair(id1, id2));
						else
							assbank.mismatch.insert(make_pair(id2, id1));
						
					}


				}
			}
		}
	}

	if(!add.empty()){

		set<pair<int, int> >::iterator Ites;
		for(Ites = add.begin(); Ites != add.end(); ++Ites){

			int id1 = Ites->first;
			int id2 = Ites->second;
			reva.insert(id1);
			reva.insert(id2);
			Aln_id alnid = assbank.IdAliMap[id1][id2];
			Calignment cob = assbank.Aln_Map[alnid];
			addnet(id1, id2, cob, L_Map, ov_len_th);
			tadd.insert(make_pair(id1, id2));


		}
	}


	return reva;

}

set<int> add_lower_lev_aln(  short_assembly_bank &assbank,
						vector< pair<string, string > >& IdSeqVe,
						int ov_len_th,
						map<int, C_Link> &L_Map,
						set<int> &idset,
						int hint,
						double in_er_th,
						double in_er_thr_100,
						double in_er_thr_50,
						double snprate )
{

	set<int> reva;
	map<pair<int, int>, Calignment > add;

	map<int, C_Link>::iterator IteL;
	for(IteL = L_Map.begin(); IteL != L_Map.end(); ++IteL){
		if(hint != 0 ){
			if(idset.find(IteL->first) == idset.end())
				continue;
		}
		int ss = (int)IteL->second.head_links.size() + (int)IteL->second.tail_links.size() + (int)IteL->second.inner_links.size() + (int)IteL->second.outer_links.size();

		if(ss <= 1)
			continue;

		int read_size = (int)IdSeqVe[IteL->first-1].second.size();
		map<pair<int, int>, pair<int, int> > idovmap;        //   < <relative_position_of_id_to_IteL->first(in pair)>, id >
		map< pair<int, int>, int > e_ovmap;                  //   < id, ovlen_with_IteL->first >
		map<pair<int, int>, int >::iterator Iteh;
		for(Iteh = IteL->second.Head_Id_Ov_Ma.begin(); Iteh != IteL->second.Head_Id_Ov_Ma.end(); ++Iteh){
			int ov = Iteh->second;
			int rlen = (int)IdSeqVe[Iteh->first.first-1].second.size();
			idovmap.insert(make_pair(make_pair(read_size-ov+1, read_size+(rlen-ov)), reversepht(Iteh->first)));
			e_ovmap.insert( make_pair( reversepht(Iteh->first), ov ) );
		}
		map<pair<int, int>, int >::iterator Itet;
		for(Itet = IteL->second.Tail_Id_Ov_Ma.begin(); Itet != IteL->second.Tail_Id_Ov_Ma.end(); ++Itet){
			int ov = Itet->second;
			int rlen = (int)IdSeqVe[Itet->first.first-1].second.size();
			idovmap.insert(make_pair( make_pair(1-(rlen-ov), ov), Itet->first ));
			e_ovmap.insert( make_pair( Itet->first, ov ) );
		}
		map<pair<int, int>, pair<int, int> >::iterator Itei;
		for(Itei = IteL->second.inner_links.begin(); Itei != IteL->second.inner_links.end(); ++Itei){
			idovmap.insert(make_pair(make_pair(Itei->second.first + 1, read_size - Itei->second.second), Itei->first));
			int ov = read_size - Itei->second.first - Itei->second.second;
			e_ovmap.insert( make_pair( Itei->first, ov ) );
		}
		map<pair<int, int>, pair<int, int> >::iterator Iteo;
		for(Iteo = IteL->second.outer_links.begin(); Iteo != IteL->second.outer_links.end(); ++Iteo){
			idovmap.insert(make_pair(make_pair(1-Iteo->second.first, read_size+Iteo->second.second), Iteo->first));
			int ov = read_size;
			e_ovmap.insert( make_pair( Iteo->first, ov ) );
		}

		map<pair<int, int>, pair<int, int> >::iterator Item;
		for(Item = idovmap.begin(); Item != idovmap.end(); ++Item){
		
			map<pair<int, int>, pair<int, int> >::iterator Item_2 = Item;
			++Item_2;
			if(Item_2 == idovmap.end())
				break;

			for(; Item_2 != idovmap.end(); ++Item_2){
			
				int ovlen = min( Item_2->first.second, Item->first.second ) - max( Item->first.first, Item_2->first.first ) + 1;
				int ov_1 = e_ovmap[Item->second];
				int ov_2 = e_ovmap[Item_2->second];

				if( ovlen >= ov_len_th && ( ovlen <= ov_1 && ovlen <= ov_2 ) ){

					int id1 = Item->second.first;
					int id2 = Item_2->second.first;
					int forb1 = Item->second.second;
					int forb2 = Item_2->second.second;

				

					if ( tri_completeness_check( id1, id2, ovlen, forb1, forb2, L_Map ) )
						continue;

					

					if(id1 < id2){
						if(add.find(make_pair(id1, id2)) != add.end())
							continue;
					}else{
						if(add.find(make_pair(id2, id1)) != add.end())
							continue;
					}

					Calignment cob;
					if ( selectalign_o( id1, id2, forb1, forb2, ovlen, cob, assbank.IdAliMap, assbank.MulIdAliMap, assbank.Aln_Map ) ) {
						ovlen = cob.score;
					
							if ( id1 < id2 )
								add.insert( make_pair( make_pair( id1, id2 ), cob ) );
							else
								add.insert( make_pair( make_pair( id2, id1 ), cob ) );
					
					} 
				}
			}

		}

	}

	map< pair< int, int >, Calignment >::iterator Itea;
	for ( Itea = add.begin(); Itea != add.end(); ++Itea ) {
		addnet( Itea->first.first, Itea->first.second, Itea->second, L_Map, 0 );
		reva.insert( Itea->first.first );
		reva.insert( Itea->first.second );
	}
	return reva;

}


bool tri_completeness_check( int id1, int id2, int ovlen, int forb1, int forb2, map< int, C_Link > &lmap )   // id1 left, id2 right
{
	if ( forb1 == 0 ) {
		if ( lmap.find( id1 ) != lmap.end() ) {
			if ( lmap[id1].head_links.find( make_pair( id2, reverseforb( forb2 ) ) ) != lmap[id1].head_links.end() )
				return true;
			if ( lmap[id1].inner_links.find( make_pair( id2, forb2 ) ) != lmap[id1].inner_links.end() ) {
				return true;
			}
			if ( lmap[id1].tail_links.find( make_pair( id2, forb2 ) ) != lmap[id1].tail_links.end() )
				return true;
			if ( lmap[id1].outer_links.find( make_pair( id2, forb2 ) ) != lmap[id1].outer_links.end() )
				return true;
		} 
		
	} else {
		if ( lmap.find( id1 ) != lmap.end() ) {
			if ( lmap[id1].tail_links.find( make_pair( id2, reverseforb( forb2 ) ) ) != lmap[id1].tail_links.end()  ) 
				return true;
			if ( lmap[id1].inner_links.find( make_pair( id2, reverseforb( forb2 ) ) ) != lmap[id1].inner_links.end() ) 
				return true;
			if ( lmap[id1].head_links.find( make_pair( id2, forb2 ) ) != lmap[id1].head_links.end() )
				return true;
			if ( lmap[id1].outer_links.find( make_pair( id2, reverseforb( forb2 ) ) ) != lmap[id1].outer_links.end() )
				return true;
		}
	}
	return false;

}

int addnet(int id1, int id2, Calignment &ali, map<int, C_Link> &lmap, int t)
{

	if(ali.score < t)
		return 0;

	if(ali.r == 2 || ali.r == 3){
		if(id1 == ali.id1){
			if(ali.r == 2){
				if(ali.forb1 == ali.forb2){
					lmap[id1].inner_links.insert(make_pair(make_pair(id2, 0), make_pair(ali.left, ali.right)));
					lmap[id2].outer_links.insert(make_pair(make_pair(id1, 0), make_pair(ali.left, ali.right)));
				}else{
					lmap[id1].inner_links.insert(make_pair(make_pair(id2, 1), make_pair(ali.left, ali.right)));
					lmap[id2].outer_links.insert(make_pair(make_pair(id1, 1), make_pair(ali.right, ali.left)));
				}
			}else{
				if(ali.forb1 == ali.forb2){
					lmap[id2].inner_links.insert(make_pair(make_pair(id1, 0), make_pair(ali.left, ali.right)));
					lmap[id1].outer_links.insert(make_pair(make_pair(id2, 0), make_pair(ali.left, ali.right)));

				}else{
					lmap[id2].inner_links.insert(make_pair(make_pair(id1, 1), make_pair(ali.right, ali.left)));
					lmap[id1].outer_links.insert(make_pair(make_pair(id2, 1), make_pair(ali.left, ali.right)));
				}
			}
		}else{
			if(ali.r == 2){
				if(ali.forb1 == ali.forb2){
					lmap[id2].inner_links.insert(make_pair(make_pair(id1, 0), make_pair(ali.left, ali.right)));
					lmap[id1].outer_links.insert(make_pair(make_pair(id2, 0), make_pair(ali.left, ali.right)));
				}else{
					lmap[id2].inner_links.insert(make_pair(make_pair(id1, 1), make_pair(ali.left, ali.right)));
					lmap[id1].outer_links.insert(make_pair(make_pair(id2, 1), make_pair(ali.right, ali.left)));
				}
			}else{
				if(ali.forb1 == ali.forb2){
					lmap[id1].inner_links.insert(make_pair(make_pair(id2, 0), make_pair(ali.left, ali.right)));
					lmap[id2].outer_links.insert(make_pair(make_pair(id1, 0), make_pair(ali.left, ali.right)));

				}else{
					lmap[id1].inner_links.insert(make_pair(make_pair(id2, 1), make_pair(ali.right, ali.left)));
					lmap[id2].outer_links.insert(make_pair(make_pair(id1, 1), make_pair(ali.left, ali.right)));
				}
			}
		}
		return 1;
	}

	int length1, length2;
	if(id1 == ali.id1){
		if(ali.r == 0){
			length1 = ali.right;
			length2 = ali.left;
		}else if(ali.r == 1){
			length1 = ali.left;
			length2 = ali.right;
		}else{
			cout<<"error : Calignment.r != 1 && != 0 in addnet " <<endl;   exit(1);
		}
		pair<int, int> tp1 = make_pair(id2, ali.hort2);
		pair<int, int> tp2 = make_pair(id1, ali.hort1);
		if(ali.hort1 == 0){   
			lmap[id1].head_links.insert(tp1);
			lmap[id1].Head_Len_Id_Ma.insert(make_pair(length1, tp1));
			lmap[id1].Head_Id_Len_Ma.insert(make_pair(tp1, length1));
			lmap[id1].Head_Id_Ov_Ma.insert(make_pair(tp1, ali.score));
		}else{
			if(ali.hort1 != 1){
				cout<<"error! hort1!=0 && hort1!=1 in addnet " <<endl;   exit(1);
			}
			lmap[id1].tail_links.insert(tp1);
			lmap[id1].Tail_Len_Id_Ma.insert(make_pair(length1, tp1));
			lmap[id1].Tail_Id_Len_Ma.insert(make_pair(tp1, length1));
			lmap[id1].Tail_Id_Ov_Ma.insert(make_pair(tp1, ali.score));
		}
		if(ali.hort2 == 0){
			lmap[id2].head_links.insert(tp2);
			lmap[id2].Head_Len_Id_Ma.insert(make_pair(length2, tp2));
			lmap[id2].Head_Id_Len_Ma.insert(make_pair(tp2, length2));
			lmap[id2].Head_Id_Ov_Ma.insert(make_pair(tp2, ali.score));
		}else{
			if(ali.hort2 != 1){
				cout<<"error! hort2!=0 && hort2!=1 in addnet " <<endl;   exit(1);
			}
			lmap[id2].tail_links.insert(tp2);
			lmap[id2].Tail_Len_Id_Ma.insert(make_pair(length2, tp2));
			lmap[id2].Tail_Id_Len_Ma.insert(make_pair(tp2, length2));
			lmap[id2].Tail_Id_Ov_Ma.insert(make_pair(tp2, ali.score));
		}
	}else if(id1 == ali.id2){
		if(ali.r == 0){
			length1 = ali.left;
			length2 = ali.right;
		}else if(ali.r == 1){
			length1 = ali.right;
			length2 = ali.left;
		}else{
			cout<<"error : Calignment.r != 1 && != 0 in addnet " <<endl;   exit(1);
		}
		pair<int, int> tp1 = make_pair(id2, ali.hort1);
		pair<int, int> tp2 = make_pair(id1, ali.hort2);
		if(ali.hort2 == 0){
			lmap[id1].head_links.insert(tp1);
			lmap[id1].Head_Len_Id_Ma.insert(make_pair(length1, tp1));
			lmap[id1].Head_Id_Len_Ma.insert(make_pair(tp1, length1));
			lmap[id1].Head_Id_Ov_Ma.insert(make_pair(tp1, ali.score));
		}else{
			if(ali.hort2 != 1){
				cout<<"error! hort2!=0 && hort2!=1 in addnet " <<endl;   exit(1);
			}
			lmap[id1].tail_links.insert(tp1);
			lmap[id1].Tail_Len_Id_Ma.insert(make_pair(length1, tp1));
			lmap[id1].Tail_Id_Len_Ma.insert(make_pair(tp1, length1));
			lmap[id1].Tail_Id_Ov_Ma.insert(make_pair(tp1, ali.score));
		}

		if(ali.hort1 == 0){
			lmap[id2].head_links.insert(tp2);
			lmap[id2].Head_Len_Id_Ma.insert(make_pair(length2, tp2));
			lmap[id2].Head_Id_Len_Ma.insert(make_pair(tp2, length2));
			lmap[id2].Head_Id_Ov_Ma.insert(make_pair(tp2, ali.score));
		}else{
			if(ali.hort1 != 1){
				cout<<"error! hort1!=0 && hort1!=1 in addnet " <<endl;   exit(1);
			}
			lmap[id2].tail_links.insert(tp2);
			lmap[id2].Tail_Len_Id_Ma.insert(make_pair(length2, tp2));
			lmap[id2].Tail_Id_Len_Ma.insert(make_pair(tp2, length2));
			lmap[id2].Tail_Id_Ov_Ma.insert(make_pair(tp2, ali.score));
		}

	}

	return 1;
}


bool selectalign_o(int id1, int id2, int forb1, int forb2, int ovlen, Calignment &ali,
				 map< int, map<int, Aln_id> > & IdAliMap,
				 map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
				 map< Aln_id, Calignment > &AlnMap )
{

	if(IdAliMap[id1].find(id2) == IdAliMap[id1].end())
		return false;
	Calignment cob = AlnMap[IdAliMap[id1][id2]];

	int tag = 0;
	if((forb1 == forb2 && cob.forb1 == cob.forb2) || (forb1 != forb2 && cob.forb1 != cob.forb2)){
		
		ali = cob;

		int var = abs(ovlen-cob.score);
		if(var < 10 )
			return true;

		
			
	}

	if(MulIdAliMap.find(id1) != MulIdAliMap.end()){
		if(MulIdAliMap[id1].find(id2) != MulIdAliMap[id1].end()){
			multimap<int, Aln_id, greater<int> >::iterator ite;
			multimap<int, Aln_id > alim;
			for(ite = MulIdAliMap[id1][id2].begin(); ite != MulIdAliMap[id1][id2].end(); ++ite){
				cob = AlnMap[ite->second];
				if((forb1 == forb2 && cob.forb1 == cob.forb2) || (forb1 != forb2 && cob.forb1 != cob.forb2)){
					
					
					int var = abs(ovlen-cob.score);
					if(var < 10 ){
						alim.insert( make_pair( var, ite->second  ) );
					
						
					}
				
					
				}
			}

			if ( !alim.empty() ) {
				Aln_id aid = alim.begin()->second;
				IdAliMap[id1][id2] = aid;
				IdAliMap[id2][id1] = aid;
				ali = AlnMap[aid];

				return true;
			}
		
		}
	}


	return false;
	
	
}

