#ifndef OVL_H
#define OVL_H

#include "calignment.h"
#include "kmer.h"
#include "sequencetransform.h"
#include "assemblybank.h"
#include "link.h"
#include "omp.h"

using namespace std;


void getseq_pfa( multimap< int, int, greater<int> > &LenNidMap,
				map<int, map<int, Matchseed> > &seedmap,
				vector<pair<Str, Str > >& IdSeqVe,
				map<int, map<int, Matchseed> > &incluster );

void getalignment( short_assembly_bank &assbank,
				  multimap< int, int, greater<int> > &LenNidMap,
				  vector< pair<string, string > >& IdSeqVe,
				  vector< vector<int> > &Qualve,
				  map<int, map<int, Matchseed> > &seedmap,
				  int ov_len_th,
				  double er_thr,
				  double er_thr_100,
				  double er_thr_50,
				  double snprate,
				  int wl,
				  int max_thread_num );

set<int> symalign( short_assembly_bank &assbank,
				  map<int, C_Link> &L_Map,
				  set<pair<int, int> > &tadd,
				  set<int> &idset,
				  int hint,
				  vector< pair<string, string > >& IdSeqVe,
				  vector< vector<int> > &Qualve,
				  int ov_len_th,
				  double er_thr,
				  double er_thr_100,
				  double er_thr_50,
				  double snprate,
				  int wl );


set<int> add_lower_lev_aln(  short_assembly_bank &assbank,
						vector< pair<string, string > >& IdSeqVe,
						int ov_len_th,
						map<int, C_Link> &L_Map,
						set<int> &idset,
						int hint,
						double in_er_th,
						double er_thr_100,
						double er_thr_50,
						double snprate );

int addnet(int id1, int id2, Calignment &ali, map<int, C_Link> &lmap, int t);


bool selectalign_o(int id1, int id2, int forb1, int forb2, int ovlen, Calignment &ali,
				 map< int, map<int, Aln_id> > & IdAliMap,
				 map< int, map<int, multimap<int, Aln_id, greater<int> > > > & MulIdAliMap,
				 map< Aln_id, Calignment > &AlnMap );

bool tri_completeness_check( int id1, int id2, int ovlen, int forb1, int forb2, map< int, C_Link > &lmap );

#endif

