#include <cstdlib>
#include "probfunc.h"

double phi(double u)
{
	if(u < 0){
		cout<<"error: u < 0!"<<endl;  exit(1);
	}
	double v;
	int c = (int)floor(u * 10);
	switch(c){
		case 0:      v = 0.5;    break;
		case 1:      v = 0.54;   break;
		case 2:      v = 0.58;   break;
		case 3:      v = 0.618;  break;
		case 4:      v = 0.655;  break;
		case 5:      v = 0.692;  break;
		case 6:      v = 0.726;  break;
		case 7:      v = 0.758;  break;
		case 8:      v = 0.788;  break;
		case 9:      v = 0.816;  break;
		case 10:     v = 0.841;  break;
		case 11:     v = 0.864;  break;
		case 12:     v = 0.885;  break;
		case 13:     v = 0.903;  break;
		case 14:     v = 0.919;  break;
		case 15:     v = 0.933;  break;
		case 16:     v = 0.945;  break;
		case 17:     v = 0.955;  break;
		case 18:     v = 0.964;  break;
		case 19:     v = 0.971;  break;
		case 20:     v = 0.977;  break;
		case 21:     v = 0.982;  break;
		case 22:     v = 0.986;  break;
		case 23:     v = 0.989;  break;
		case 24:     v = 0.991;  break;
		case 25:     v = 0.994;  break;
		case 26:     v = 0.995;  break;
		case 27:     v = 0.996;  break;
		case 28:     v = 0.997;  break;
		case 29:     v = 0.998;  break;
		case 30:     v = 0.999;  break;
		default:     v = 1;
	}

	return v;
}

double miuf(double u)
{
	if(u >= 0)
		return phi(u);
	else
		return 1 - phi(-1 * u);
}

double probf(int exp, int var, int x)
{
	if(var == 0)
	{
		cout<<"error: var == 0"<<endl;
	}
	double u = double(x-exp) / var;

	return miuf(u);
}

int poissionexf(double lam)
{
	
	int c;
	int r;
	if(lam <= 4 ){
		c = (int)floor(lam*10);
		switch(c){
			case 0:     r = 2;      break;
			case 1:     r = 2;      break;
			case 2:     r = 3;      break;
			case 3:		r = 3;      break;
			case 4:		r = 4;		break;
			case 5:		r = 4;		break;
			case 6:		r = 4;		break;
			case 7:		r = 5;		break;
			case 8:		r = 5;		break;
			case 9:		r = 5;		break;
			case 10:	r = 6;		break;
			case 11:	r = 6;		break;
			case 12:	r = 6;		break;
			case 13:	r = 6;		break;
			case 14:	r = 7;		break;
			case 15:	r = 7;		break;
			case 16:	r = 7;		break;
			case 17:	r = 7;		break;
			case 18:	r = 8;		break;
			case 19:	r = 8;		break;
			case 20:	r = 8;		break;
			case 21:	r = 8;		break;
			case 22:	r = 8;		break;
			case 23:	r = 9;		break;
			case 24:	r = 9;		break;
			case 25:	r = 9;		break;
			case 26:	r = 9;		break;
			case 27:	r = 10;		break;
			case 28:	r = 10;		break;
			case 29:	r = 10;		break;
			case 30:	r = 10;		break;
			case 31:	r = 10;		break;
			case 32:	r = 10;		break;
			case 33:	r = 11;		break;
			case 34:	r = 11;		break;
			case 35:	r = 11;		break;
			case 36:	r = 11;		break;
			case 37:	r = 11;		break;
			case 38:	r = 12;		break;
			case 39:	r = 12;		break;
			case 40:	r = 12;		break;
			default: break;
		}
	}
	if(lam > 4){
		c = (int)floor(lam);
		switch(c){
			case 4:		r = 12;		break;
			case 5:		r = 14;		break;
			case 6:		r = 15;		break;
			case 7:		r = 17;		break;
			case 8:		r = 19;		break;
			case 9:		r = 20;		break;
			case 10:	r = 22;		break;
			case 11:	r = 23;		break;
			case 12:	r = 25;		break;
			case 13:	r = 26;		break;
			case 14:	r = 27;		break;
			case 15:	r = 29;		break;
			default:	r = 30;
		}
	}
	return r;

}

int poissionexf_995(double lam)
{
	
	int c;
	int r;
	if(lam <= 4 ){
		c = (int)floor(lam*10);
		switch(c){
			case 0:     r = 0;      break;
			case 1:     r = 1;      break;
			case 2:     r = 2;      break;
			case 3:		r = 2;      break;
			case 4:		r = 3;		break;
			case 5:		r = 3;		break;
			case 6:		r = 3;		break;
			case 7:		r = 3;		break;
			case 8:		r = 4;		break;
			case 9:		r = 4;		break;
			case 10:	r = 4;		break;
			case 11:	r = 4;		break;
			case 12:	r = 5;		break;
			case 13:	r = 5;		break;
			case 14:	r = 5;		break;
			case 15:	r = 5;		break;
			case 16:	r = 6;		break;
			case 17:	r = 6;		break;
			case 18:	r = 6;		break;
			case 19:	r = 6;		break;
			case 20:	r = 6;		break;
			case 21:	r = 7;		break;
			case 22:	r = 7;		break;
			case 23:	r = 7;		break;
			case 24:	r = 7;		break;
			case 25:	r = 7;		break;
			case 26:	r = 7;		break;
			case 27:	r = 8;		break;
			case 28:	r = 8;		break;
			case 29:	r = 8;		break;
			case 30:	r = 8;		break;
			case 31:	r = 8;		break;
			case 32:	r = 9;		break;
			case 33:	r = 9;		break;
			case 34:	r = 9;		break;
			case 35:	r = 9;		break;
			case 36:	r = 9;		break;
			case 37:	r = 9;		break;
			case 38:	r = 10;		break;
			case 39:	r = 10;		break;
			case 40:	r = 10;		break;
			default: break;
		}
	}
	if(lam > 4){
		c = (int)floor(lam);
		switch(c){
			case 4:		r = 10;		break;
			case 5:		r = 11;		break;
			case 6:		r = 13;		break;
			case 7:		r = 15;		break;
			case 8:		r = 16;		break;
			case 9:		r = 17;		break;
			case 10:	r = 19;		break;
			case 11:	r = 20;		break;
			case 12:	r = 22;		break;
			case 13:	r = 23;		break;
			case 14:	r = 24;		break;
			case 15:	r = 25;		break;
			default:	r = 26;
		}
	}
	return r;

}

double poissonf1(double lam, int k)
{
	if(lam == 0.1){    vector<double> v(3);    v[0]=0.905; v[1]=0.995; v[2]=1;  if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.2){		vector<double> v(4);	v[0]=0.819; v[1]=0.982; v[2]=0.999; v[3]=1;  if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.3){		vector<double> v(4);	v[0]=0.741; v[1]=0.963; v[2]=0.996; v[3]=1;  if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.4){		vector<double> v(5);	v[0]=0.670; v[1]=0.938; v[2]=0.992; v[3]=0.999; v[4]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.5){		vector<double> v(5);	v[0]=0.607; v[1]=0.910; v[2]=0.986; v[3]=0.998; v[4]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.6){		vector<double> v(5);	v[0]=0.549; v[1]=0.878; v[2]=0.977; v[3]=0.997; v[4]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.7){		vector<double> v(6);	v[0]=0.497; v[1]=0.844; v[2]=0.966; v[3]=0.994; v[4]=0.999; v[5]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.8){		vector<double> v(6);	v[0]=0.449; v[1]=0.809; v[2]=0.953; v[3]=0.991; v[4]=0.999; v[5]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 0.9){		vector<double> v(6);	v[0]=0.407; v[1]=0.772; v[2]=0.937; v[3]=0.987; v[4]=0.998; v[5]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1){		vector<double> v(7);	v[0]=0.368; v[1]=0.736; v[2]=0.920; v[3]=0.981; v[4]=0.996; v[5]=0.999; v[6]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.1){		vector<double> v(7);	v[0]=0.333; v[1]=0.699; v[2]=0.900; v[3]=0.974; v[4]=0.995; v[5]=0.999; v[6]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.2){		vector<double> v(7);	v[0]=0.301; v[1]=0.663; v[2]=0.879; v[3]=0.966; v[4]=0.992; v[5]=0.998; v[6]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.3){		vector<double> v(7);	v[0]=0.273; v[1]=0.627; v[2]=0.857; v[3]=0.957; v[4]=0.989; v[5]=0.998; v[6]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.4){		vector<double> v(8);	v[0]=0.247; v[1]=0.592; v[2]=0.833; v[3]=0.946; v[4]=0.986; v[5]=0.997; v[6]=0.999; v[7]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.5){		vector<double> v(8);	v[0]=0.223; v[1]=0.558; v[2]=0.809; v[3]=0.934; v[4]=0.981; v[5]=0.996; v[6]=0.999; v[7]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.6){		vector<double> v(8);	v[0]=0.202; v[1]=0.525; v[2]=0.783; v[3]=0.921; v[4]=0.976; v[5]=0.994; v[6]=0.999; v[7]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.7){		vector<double> v(8);	v[0]=0.183; v[1]=0.493; v[2]=0.757; v[3]=0.907; v[4]=0.970; v[5]=0.992; v[6]=0.998; v[7]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.8){		vector<double> v(9);	v[0]=0.165; v[1]=0.463; v[2]=0.731; v[3]=0.891; v[4]=0.964; v[5]=0.990; v[6]=0.997; v[7]=0.999; v[8]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 1.9){		vector<double> v(9);	v[0]=0.150; v[1]=0.434; v[2]=0.704; v[3]=0.875; v[4]=0.956; v[5]=0.987; v[6]=0.997; v[7]=0.999; v[8]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2){		vector<double> v(9);	v[0]=0.135; v[1]=0.406; v[2]=0.677; v[3]=0.857; v[4]=0.947; v[5]=0.983; v[6]=0.995; v[7]=0.999; v[8]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.1){		vector<double> v(9);	v[0]=0.122; v[1]=0.380; v[2]=0.650; v[3]=0.839; v[4]=0.938; v[5]=0.980; v[6]=0.994; v[7]=0.999; v[8]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.2){		vector<double> v(9);	v[0]=0.111; v[1]=0.355; v[2]=0.623; v[3]=0.819; v[4]=0.928; v[5]=0.975; v[6]=0.993; v[7]=0.998; v[8]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.3){		vector<double> v(10);	v[0]=0.100; v[1]=0.331; v[2]=0.596; v[3]=0.799; v[4]=0.916; v[5]=0.970; v[6]=0.991; v[7]=0.997; v[8]=0.999; v[9]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.4){		vector<double> v(10);	v[0]=0.091; v[1]=0.308; v[2]=0.570; v[3]=0.779; v[4]=0.904; v[5]=0.964; v[6]=0.988; v[7]=0.997; v[8]=0.999; v[9]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.5){		vector<double> v(10);	v[0]=0.082; v[1]=0.287; v[2]=0.544; v[3]=0.758; v[4]=0.891; v[5]=0.958; v[6]=0.986; v[7]=0.996; v[8]=0.999; v[9]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.6){		vector<double> v(10);	v[0]=0.074; v[1]=0.267; v[2]=0.518; v[3]=0.736; v[4]=0.877; v[5]=0.951; v[6]=0.983; v[7]=0.995; v[8]=0.999; v[9]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.7){		vector<double> v(11);	v[0]=0.067; v[1]=0.249; v[2]=0.494; v[3]=0.714; v[4]=0.863; v[5]=0.943; v[6]=0.979; v[7]=0.993; v[8]=0.998; v[9]=0.999; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.8){		vector<double> v(11);	v[0]=0.061; v[1]=0.231; v[2]=0.469; v[3]=0.692; v[4]=0.848; v[5]=0.935; v[6]=0.976; v[7]=0.992; v[8]=0.998; v[9]=0.999; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 2.9){		vector<double> v(11);	v[0]=0.055; v[1]=0.215; v[2]=0.446; v[3]=0.670; v[4]=0.832; v[5]=0.926; v[6]=0.971; v[7]=0.990; v[8]=0.997; v[9]=0.999; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3){		vector<double> v(11);	v[0]=0.050; v[1]=0.199; v[2]=0.423; v[3]=0.647; v[4]=0.815; v[5]=0.916; v[6]=0.966; v[7]=0.988; v[8]=0.996; v[9]=0.999; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.1){		vector<double> v(11);	v[0]=0.045; v[1]=0.185; v[2]=0.401; v[3]=0.625; v[4]=0.798; v[5]=0.906; v[6]=0.961; v[7]=0.986; v[8]=0.995; v[9]=0.999; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.2){		vector<double> v(11);	v[0]=0.041; v[1]=0.171; v[2]=0.380; v[3]=0.603; v[4]=0.781; v[5]=0.895; v[6]=0.955; v[7]=0.983; v[8]=0.994; v[9]=0.998; v[10]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.3){		vector<double> v(12);	v[0]=0.037; v[1]=0.159; v[2]=0.359; v[3]=0.580; v[4]=0.763; v[5]=0.883; v[6]=0.949; v[7]=0.980; v[8]=0.993; v[9]=0.998; v[10]=0.999; v[11]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.4){		vector<double> v(12);	v[0]=0.033; v[1]=0.147; v[2]=0.340; v[3]=0.558; v[4]=0.744; v[5]=0.871; v[6]=0.942; v[7]=0.977; v[8]=0.992; v[9]=0.997; v[10]=0.999; v[11]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.5){		vector<double> v(12);	v[0]=0.030; v[1]=0.136; v[2]=0.321; v[3]=0.537; v[4]=0.725; v[5]=0.858; v[6]=0.935; v[7]=0.973; v[8]=0.990; v[9]=0.997; v[10]=0.999; v[11]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.6){		vector<double> v(12);	v[0]=0.027; v[1]=0.126; v[2]=0.303; v[3]=0.515; v[4]=0.706; v[5]=0.844; v[6]=0.927; v[7]=0.969; v[8]=0.988; v[9]=0.996; v[10]=0.999; v[11]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.7){		vector<double> v(12);	v[0]=0.025; v[1]=0.116; v[2]=0.385; v[3]=0.494; v[4]=0.687; v[5]=0.830; v[6]=0.918; v[7]=0.965; v[8]=0.986; v[9]=0.995; v[10]=0.998; v[11]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.8){		vector<double> v(13);	v[0]=0.022; v[1]=0.107; v[2]=0.269; v[3]=0.473; v[4]=0.668; v[5]=0.816; v[6]=0.909; v[7]=0.960; v[8]=0.984; v[9]=0.994; v[10]=0.998; v[11]=0.999; v[12]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 3.9){		vector<double> v(13);	v[0]=0.020; v[1]=0.099; v[2]=0.253; v[3]=0.453; v[4]=0.648; v[5]=0.801; v[6]=0.899; v[7]=0.955; v[8]=0.981; v[9]=0.993; v[10]=0.998; v[11]=0.999; v[12]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 4){		vector<double> v(13);	v[0]=0.018; v[1]=0.092; v[2]=0.238; v[3]=0.433; v[4]=0.629; v[5]=0.785; v[6]=0.889; v[7]=0.949; v[8]=0.979; v[9]=0.992; v[10]=0.997; v[11]=0.999; v[12]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 5){		vector<double> v(15);	v[0]=0.007; v[1]=0.040; v[2]=0.125; v[3]=0.265; v[4]=0.440; v[5]=0.616; v[6]=0.762; v[7]=0.867; v[8]=0.932; v[9]=0.968; v[10]=0.986; v[11]=0.995; v[12]=0.998;
		v[13]=0.999; v[14]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 6){		vector<double> v(16);	v[0]=0.002; v[1]=0.017; v[2]=0.062; v[3]=0.151; v[4]=0.285; v[5]=0.446; v[6]=0.606; v[7]=0.744; v[8]=0.847; v[9]=0.916; v[10]=0.957; v[11]=0.980; v[12]=0.991;
		v[13]=0.996; v[14]=0.999; v[15]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 7){		vector<double> v(18);	v[0]=0.001; v[1]=0.007; v[2]=0.030; v[3]=0.082; v[4]=0.173; v[5]=0.301; v[6]=0.450; v[7]=0.599; v[8]=0.729; v[9]=0.830; v[10]=0.901; v[11]=0.947; v[12]=0.973;
		v[13]=0.987; v[14]=0.994; v[15]=0.998; v[16]=0.999; v[17]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 8){		vector<double> v(20);	v[0]=0; v[1]=0.003; v[2]=0.014; v[3]=0.042; v[4]=0.1; v[5]=0.191; v[6]=0.313; v[7]=0.453; v[8]=0.593; v[9]=0.717; v[10]=0.816; v[11]=0.888; v[12]=0.936;
		v[13]=0.966; v[14]=0.983; v[15]=0.992; v[16]=0.996; v[17]=0.998; v[18]=0.999; v[19]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 9){		vector<double> v(21);	v[0]=0; v[1]=0.001; v[2]=0.006; v[3]=0.021; v[4]=0.055; v[5]=0.116; v[6]=0.207; v[7]=0.324; v[8]=0.456; v[9]=0.587; v[10]=0.706; v[11]=0.803; v[12]=0.876;
		v[13]=0.926; v[14]=0.959; v[15]=0.978; v[16]=0.989; v[17]=0.995; v[18]=0.998; v[19]=0.999; v[20]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 10){		vector<double> v(23);	v[0]=0; v[1]=0; v[2]=0.003; v[3]=0.01; v[4]=0.029; v[5]=0.067; v[6]=0.130; v[7]=0.220; v[8]=0.333; v[9]=0.458; v[10]=0.583; v[11]=0.697; v[12]=0.792;
		v[13]=0.864; v[14]=0.917; v[15]=0.951; v[16]=0.973; v[17]=0.986; v[18]=0.993; v[19]=0.997; v[20]=0.998; v[21]=0.999; v[22]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 11){		vector<double> v(24);	v[0]=0; v[1]=0; v[2]=0.001; v[3]=0.005; v[4]=0.015; v[5]=0.038; v[6]=0.079; v[7]=0.143; v[8]=0.232; v[9]=0.341; v[10]=0.460; v[11]=0.579; v[12]=0.689;
		v[13]=0.781; v[14]=0.854; v[15]=0.907; v[16]=0.944; v[17]=0.968; v[18]=0.982; v[19]=0.991; v[20]=0.995; v[21]=0.998; v[22]=0.999; v[23]=1; if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 12){		vector<double> v(26);	v[0]=0; v[1]=0; v[2]=0.001; v[3]=0.002; v[4]=0.008; v[5]=0.02; v[6]=0.046; v[7]=0.09; v[8]=0.155; v[9]=0.242; v[10]=0.347; v[11]=0.462; v[12]=0.576;
		v[13]=0.682; v[14]=0.772; v[15]=0.844; v[16]=0.899; v[17]=0.937; v[18]=0.963; v[19]=0.979; v[20]=0.988; v[21]=0.994; v[22]=0.997; v[23]=0.999; v[24]=0.999; v[25]=1;
		if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 13){		vector<double> v(27);	v[0]=0; v[1]=0; v[2]=0; v[3]=0.001; v[4]=0.004; v[5]=0.011; v[6]=0.026; v[7]=0.054; v[8]=0.1; v[9]=0.166; v[10]=0.252; v[11]=0.353; v[12]=0.463;
		v[13]=0.573; v[14]=0.675; v[15]=0.764; v[16]=0.835; v[17]=0.890; v[18]=0.930; v[19]=0.957; v[20]=0.975; v[21]=0.986; v[22]=0.992; v[23]=0.996; v[24]=0.998; v[25]=0.999; v[26]=1;
		if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 14){		vector<double> v(29);	v[0]=0; v[1]=0; v[2]=0; v[3]=0; v[4]=0.002; v[5]=0.006; v[6]=0.014; v[7]=0.032; v[8]=0.062; v[9]=0.109; v[10]=0.176; v[11]=0.26; v[12]=0.358;
		v[13]=0.464; v[14]=0.57; v[15]=0.669; v[16]=0.756; v[17]=0.827; v[18]=0.883; v[19]=0.923; v[20]=0.952; v[21]=0.971; v[22]=0.983; v[23]=0.991; v[24]=0.995; v[25]=0.997; v[26]=0.999; v[27]=0.999; v[28]=1;
		if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}
	if(lam == 15){		vector<double> v(30);	v[0]=0; v[1]=0; v[2]=0; v[3]=0; v[4]=0.001; v[5]=0.003; v[6]=0.008; v[7]=0.018; v[8]=0.037; v[9]=0.070; v[10]=0.118; v[11]=0.185; v[12]=0.268;
		v[13]=0.363; v[14]=0.466; v[15]=0.568; v[16]=0.664; v[17]=0.749; v[18]=0.819; v[19]=0.875; v[20]=0.917; v[21]=0.947; v[22]=0.967; v[23]=0.981; v[24]=0.989; v[25]=0.994; v[26]=0.997; v[27]=0.998; v[28]=0.999; v[29]=1;
		if( k <= (int)v.size() ){	return 1-v[k-1];	}else{	return	0;	}	}

	return 1;
}

// input k >= 0, else return 1
double poissonf(double lam, int k)
{
	if ( k < 1 )
		return 1;

	if ( lam < 0.075 )
		return 0;
	
	if(lam < 0.1) {
		if ( k == 1 )
			return 0.005;
		else 
			return 0;
	}
	double r;
	if(lam < 4){
		double lam2 = floor(lam * 10) / 10;
	
		r = poissonf1(lam2, k);
	
	}else{
		double lam2 = floor(lam);
		if(lam2 <= 15)
			r = poissonf1(lam2, k);
		else
			r = 1;
	}

	return r;
}

