
#include"sequencetransform.h"

Str SequenceTransform_T::char2DigitalSeq( Str& seq )
{
	int seqLen = (int)seq.size();
	Str tmp;
	tmp.reserve( seqLen );
	for( int i = 0; i < seqLen; ++i)
		tmp += char2digital( seq[i] );
	return tmp;
}
char SequenceTransform_T::char2digital( char res )
{
	switch( res)
	{
	case 'A' : return '0';
	case 'C' : return '1';
	case 'G' : return '2';
	case 'T' : return '3';
	case 'N' : return 'N';
	case 'X' : return '0';
	case 'H' : return '3';
	case 'M' : return '1';
	case 'K' : return '2';
	case 'D' : return '0';
	case 'R' : return '2';
	case 'Y' : return '3';
	case 'S' : return '1';
	case 'W' : return '0';
	case 'B' : return '1';
	case 'V' : return '2';
	default  :
		std::cout<<"Unexpected "<<res<<std::endl;
		return 'N';
	}
}

char SequenceTransform_T::digital2char( char res )
{
	switch( res)
	{
		case '0' : return 'A';
		case '1' : return 'C'; 
		case '2' : return 'G'; 
		case '3' : return 'T'; 
		case '-' : return '-'; 
		case 'N' : return 'N'; 
		default : return '$';
		
	}
}

Str SequenceTransform_T::digital2CharSeq( Str& seq )
{
	Str tmp( seq.size(), '0' );
	for( int i = 0; i < (int)seq.size(); ++i )
	{
		switch( seq[i] )
		{
		case '0' : tmp[i] = 'A'; break;
		case '1' : tmp[i] = 'C'; break;
		case '2' : tmp[i] = 'G'; break;
		case '3' : tmp[i] = 'T'; break;
		case '-' : tmp[i] = '-'; break;
		case 'N' : tmp[i] = 'N'; break;
		default :;
		}
	}
	return tmp;
}

char SequenceTransform_T::complement( char c )
{
	char a;
	switch( c )
				{
					case '0' : a = '3'; break;
					case '1' : a = '2'; break;
					case '2' : a = '1'; break;
					case '3' : a = '0'; break;
					case '-' : a = '-'; break;
					case 'N' : a = 'N'; break;
					default  : std::cout << "!unexpected symbol" << c<<std::endl; exit(1);
				}

	return a;
}
