#include "short_assembly.h"

void short_last_assembly( short_assembly_bank &assbank,
						 vector< pair<string, string > >& IdSeqVe, 
						 vector< vector<int> > &Qualve,
						 int inovlenth,
						 double in_er_thr,
						 double in_er_thr_100,
						 double in_er_thr_50,
						 double in_snprate,
						 M_sol & inob,
						 bool syma,
						 int inwl,
						 int kmer_len,
						 int kmer_num,
						 int numb,
						 int max_thread_num,
						 map<int, pair<int, pair<int, int> > > &Pairs,
						 int tig_len, int mate_len, int mate_len_var, int mate_type, Graph_parameter &para )
{


	
	{

		multimap< int, int, greater<int> > LenNidMap;
		map<int, map<int, Matchseed> > seedmap;

		{
			cout<<"reading kmers and grouping reads that share kmers..."<<endl;
			
			Kmer kmer( kmer_len, kmer_num );
			kmer.getkeykmer2( IdSeqVe, numb );
			kmer.ma();
			

		
			getseq_pfa( LenNidMap, seedmap, IdSeqVe, kmer.final[0] );

	

		}

		cout<<"calculate overlaps..."<<endl;
	
		getalignment( assbank, LenNidMap, IdSeqVe, Qualve, seedmap, inovlenth, in_er_thr, in_er_thr_100, in_er_thr_50, in_snprate, inwl, max_thread_num );

	}

	Filtaln( assbank );
	
	
	map< int, C_Link > L_Map;
	map< int, Contig > IdConMap;
	buildnet( inovlenth, L_Map, assbank );
	
	set<pair<int, int> > tadd;
	set<int> nul;
	set<int> addali = symalign( assbank, L_Map, tadd, nul, 0, IdSeqVe, Qualve,  inovlenth, in_er_thr, in_er_thr_100, in_er_thr_50, in_snprate, inwl);

	while(!addali.empty()){
		set<int> al_set = symalign( assbank, L_Map, tadd, addali, 1, IdSeqVe, Qualve,  inovlenth, in_er_thr, in_er_thr_100, in_er_thr_50, in_snprate, inwl );
		addali = al_set;
		al_set.clear();
	}

	/////////////////build net using strict overlap threshold///////////////////////
	L_Map.clear();
	buildnet( inovlenth, in_er_thr, in_er_thr_100, in_er_thr_50, in_snprate, L_Map, assbank );
	
	
	
	hideinalign(L_Map, IdConMap, IdSeqVe, assbank.IdAliMap, assbank.InalignMap );


	simplifynet(L_Map);

	merge_to_unitig( IdConMap, L_Map );

	red_sel_rev_link(L_Map);

	merge_to_unitig(IdConMap, L_Map);

	if ( !assbank.InalignMap.empty() ) {
		map< int, Contig >::iterator Itecm;
		for ( Itecm = IdConMap.begin(); Itecm != IdConMap.end(); ++Itecm ) {
			Addinalign( Itecm->second, assbank.InalignMap, assbank.Aln_Map );
		}
	}

	domain_pro( L_Map, IdConMap, inob );

	cout<<"graph process.."<<endl;

	graph_process( assbank, L_Map, IdConMap, Pairs, tig_len, mate_len, mate_len_var, mate_type, para );

	map< Contig_id, Contig_bank >::iterator Itecm;
	for ( Itecm = assbank.assbank.Contig_map.begin(); Itecm != assbank.assbank.Contig_map.end(); ++Itecm ) {
		if ( (int)Itecm->second.contig.ReadidList.size() > 1 ) {
			Itecm->second.contig.erase_redun_read();
		}
	}

	trans_mate_pair( Pairs, assbank.mp_bank );
	ctg_qual( assbank.assbank, assbank.mp_bank );

	vector<int> conve;
	for(Itecm = assbank.assbank.Contig_map.begin(); Itecm != assbank.assbank.Contig_map.end(); ++Itecm){
		conve.push_back(Itecm->first);
	}
	int convesize = (int)conve.size();
	int g_ncore = omp_get_num_procs();
	int nt = g_ncore > max_thread_num? max_thread_num : g_ncore;
	nt = nt > convesize? convesize : nt;

	cout<<"calculate consensus.."<<endl;

#pragma omp parallel for schedule(dynamic) num_threads(nt) if ( nt > 1 )
	for ( int i = 0; i < convesize; ++i ) {
		int k = conve[i];
		if( assbank.assbank.Contig_map[k].contig.ReadidList.size() == 1 ) {
		
			assbank.assbank.Contig_map[k].contig.qualsc = Qualve[assbank.assbank.Contig_map[k].contig.ReadidList.front()-1];
			continue;
		}
	
		Lay_Cons( assbank.assbank.Contig_map[k].contig, assbank.IdAliMap, assbank.MulIdAliMap, assbank.Aln_Map, IdSeqVe, Qualve );
	
	}
	
	
	set< Aln_id > revsed;
	set< int > revsed_read;
	map< int, read_crt_info > read_crt_info_map;
	for ( Itecm = assbank.assbank.Contig_map.begin(); Itecm != assbank.assbank.Contig_map.end(); ++Itecm ) {
		if ( Itecm->second.contig.ReadidList.size() == 1 )
			continue;
		correct_err_ctg( Itecm->second.contig, assbank.Aln_Map, assbank.IdAliMap, assbank.MulIdAliMap, revsed_read, read_crt_info_map, revsed, inovlenth, IdSeqVe, Qualve, 1, false );
		erase_indels_off_ctg( Itecm->second.contig );
	}


	set<int> assembled;
	map< int, Contig >::iterator IteCon;
	for ( Itecm = assbank.assbank.Contig_map.begin(); Itecm != assbank.assbank.Contig_map.end(); ++Itecm ) {
		assbank.ConVe.push_back(Itecm->second.contig);
		assembled.insert( Itecm->second.contig.ReadidSet.begin(), Itecm->second.contig.ReadidSet.end() );
	}
	
	int si = 0;
	for(int j = 0; j < (int)IdSeqVe.size(); ++j){
		if(assembled.find(j+1)==assembled.end()){
			Contig single;
			single.singletocontig(j+1, IdSeqVe[j].second);

			assbank.ConVe.push_back(single);
			si += 1;
		}
	}
	
}

void buildnet(int t, map< int, C_Link > &L_Map, short_assembly_bank &assbank )
{

	map< int, map<int, Aln_id> >::iterator IteIdAli;
	for(IteIdAli = assbank.IdAliMap.begin(); IteIdAli != assbank.IdAliMap.end(); ++IteIdAli){

		C_Link L_ob;
		int id1 = IteIdAli->first;
		map<int, Aln_id>::iterator IteC;
		for(IteC = IteIdAli->second.begin(); IteC != IteIdAli->second.end(); ++IteC){

			if(assbank.Aln_Map[IteC->second].score < t)
				continue;
			if(assbank.Aln_Map[IteC->second].r == 2 || assbank.Aln_Map[IteC->second].r == 3){
				if(id1 == assbank.Aln_Map[IteC->second].id1 ){
					if(assbank.Aln_Map[IteC->second].r == 2){
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
					}else{
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
					}
				}else{
					if(assbank.Aln_Map[IteC->second].r == 2){
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].right, assbank.Aln_Map[IteC->second].left)));

					}else{
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].right, assbank.Aln_Map[IteC->second].left)));
					}
				}
				continue;
			}
			int length;
			if(id1 == assbank.Aln_Map[IteC->second].id1){
				if(assbank.Aln_Map[IteC->second].r == 0){
					length = assbank.Aln_Map[IteC->second].right;
				}else if(assbank.Aln_Map[IteC->second].r == 1){
					length = assbank.Aln_Map[IteC->second].left;
				}else{
					cout<<"error : Calignment.r != 1 && != 0" <<endl;   exit(1);
				}
				pair<int, int> tp = make_pair(IteC->first, assbank.Aln_Map[IteC->second].hort2);
				if(assbank.Aln_Map[IteC->second].hort1 == 0){   //id1 tail hangs, head overlaps
					L_ob.head_links.insert(tp);
					L_ob.Head_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Head_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Head_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}else{
					if(assbank.Aln_Map[IteC->second].hort1 != 1){
						cout<<"error! hort1!=0 && hort1!=1" <<endl;   exit(1);
					}
					L_ob.tail_links.insert(tp);
					L_ob.Tail_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Tail_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Tail_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}
			}else if(id1 == assbank.Aln_Map[IteC->second].id2){
				if(assbank.Aln_Map[IteC->second].r == 0){
					length = assbank.Aln_Map[IteC->second].left;
				}else if(assbank.Aln_Map[IteC->second].r == 1){
					length = assbank.Aln_Map[IteC->second].right;
				}else{
					cout<<"error : Calignment.r != 1 && != 0" <<endl;   exit(1);
				}
				pair<int, int> tp = make_pair(IteC->first, assbank.Aln_Map[IteC->second].hort1);
				if(assbank.Aln_Map[IteC->second].hort2 == 0){
					L_ob.head_links.insert(tp);
					L_ob.Head_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Head_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Head_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}else{
					if(assbank.Aln_Map[IteC->second].hort2 != 1){
						cout<<"error! hort1!=0 && hort1!=1" <<endl;   exit(1);
					}
					L_ob.tail_links.insert(tp);
					L_ob.Tail_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Tail_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Tail_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}

			}else{
				cout<< "error: id1 not in the alignment!" <<endl;  exit(1);
			}
		}
		if(!L_ob.head_links.empty() || !L_ob.tail_links.empty() || !L_ob.outer_links.empty() || !L_ob.inner_links.empty())
			L_Map.insert(make_pair(IteIdAli->first, L_ob));
	}



}

void buildnet(int ovlenthr, double errorthr, double er_thr_100, double er_thr_50, double snprate, map< int, C_Link > &L_Map, short_assembly_bank &assbank )
{

	L_Map.clear(); 

	map< int, map<int, Aln_id> >::iterator IteIdAli;
	for(IteIdAli = assbank.IdAliMap.begin(); IteIdAli != assbank.IdAliMap.end(); ++IteIdAli){

		C_Link L_ob;
		int id1 = IteIdAli->first;
		map<int, Aln_id>::iterator IteC;
		for(IteC = IteIdAli->second.begin(); IteC != IteIdAli->second.end(); ++IteC){

		
		//	if ( !filteralign( assbank.Aln_Map[IteC->second], 0.004, 0.004 ) )
		//		continue;
			if(assbank.Aln_Map[IteC->second].r == 2 || assbank.Aln_Map[IteC->second].r == 3){
				if(id1 == assbank.Aln_Map[IteC->second].id1 ){
					if(assbank.Aln_Map[IteC->second].r == 2){
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
					}else{
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
					}
				}else{
					if(assbank.Aln_Map[IteC->second].r == 2){
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.outer_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].right, assbank.Aln_Map[IteC->second].left)));

					}else{
						if(assbank.Aln_Map[IteC->second].forb1 == assbank.Aln_Map[IteC->second].forb2){
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 0), make_pair(assbank.Aln_Map[IteC->second].left, assbank.Aln_Map[IteC->second].right)));
						}else
							L_ob.inner_links.insert(make_pair(make_pair(IteC->first, 1), make_pair(assbank.Aln_Map[IteC->second].right, assbank.Aln_Map[IteC->second].left)));
					}
				}
				continue;
			}
			int length=0;
			if(id1 == assbank.Aln_Map[IteC->second].id1){
				if(assbank.Aln_Map[IteC->second].r == 0){
					length = assbank.Aln_Map[IteC->second].right;
				}else if(assbank.Aln_Map[IteC->second].r == 1){
					length = assbank.Aln_Map[IteC->second].left;
				}else{
					cout<<"error : Calignment.r != 1 && != 0" <<endl;   exit(1);
				}
				pair<int, int> tp = make_pair(IteC->first, assbank.Aln_Map[IteC->second].hort2);
				if(assbank.Aln_Map[IteC->second].hort1 == 0){   //id1 tail hangs, head overlaps
					L_ob.head_links.insert(tp);
					L_ob.Head_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Head_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Head_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}else{
					if(assbank.Aln_Map[IteC->second].hort1 != 1){
						cout<<"error! hort1!=0 && hort1!=1" <<endl;   exit(1);
					}
					L_ob.tail_links.insert(tp);
					L_ob.Tail_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Tail_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Tail_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}
			}else if(id1 == assbank.Aln_Map[IteC->second].id2){
				if(assbank.Aln_Map[IteC->second].r == 0){
					length = assbank.Aln_Map[IteC->second].left;
				}else if(assbank.Aln_Map[IteC->second].r == 1){
					length = assbank.Aln_Map[IteC->second].right;
				}else{
					cout<<"error : Calignment.r != 1 && != 0" <<endl;   exit(1);
				}
				pair<int, int> tp = make_pair(IteC->first, assbank.Aln_Map[IteC->second].hort1);
				if(assbank.Aln_Map[IteC->second].hort2 == 0){
					L_ob.head_links.insert(tp);
					L_ob.Head_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Head_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Head_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}else{
					if(assbank.Aln_Map[IteC->second].hort2 != 1){
						cout<<"error! hort1!=0 && hort1!=1" <<endl;   exit(1);
					}
					L_ob.tail_links.insert(tp);
					L_ob.Tail_Len_Id_Ma.insert(make_pair(length, tp));
					L_ob.Tail_Id_Len_Ma.insert(make_pair(tp, length));
					L_ob.Tail_Id_Ov_Ma.insert(make_pair(tp, assbank.Aln_Map[IteC->second].score));
				}

			}else{
				cout<< "error: id1 not in the alignment!" <<endl;  exit(1);
			}
		}
		if(!L_ob.head_links.empty() || !L_ob.tail_links.empty() || !L_ob.outer_links.empty() || !L_ob.inner_links.empty())
			L_Map.insert(make_pair(IteIdAli->first, L_ob));
	}


}


void hideinalign(map<int, C_Link> &lmap,
				 map<int, Contig> &idconmap,
				 map< int, Str > &NidSeqMap,
				 map< int, map<int, Aln_id> > &IdAliMap,
				 multimap<int, Aln_id> &InalignMap )
{
	set<int> inners;
	multimap<int, int> inmap;
	map<int, C_Link>::iterator IteL;
	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL){
		if(IteL->second.outer_links.empty())
			continue;
		int id1 = IteL->first;
		inners.insert(id1);
		map<pair<int, int>, pair<int, int> >::iterator iteo;
		for(iteo = IteL->second.outer_links.begin(); iteo != IteL->second.outer_links.end(); ++iteo){
			int id2 = iteo->first.first;
			if(IdAliMap.find(id1) == IdAliMap.end()){
				cout<<"error1 in hidealign "<<id1<<endl;
				exit(1);
			}
			if(IdAliMap[id1].find(id2) == IdAliMap[id1].end()){
				cout<<"error2 in hidealign "<<id1 <<","<<id2<<endl;  exit(1);
			}
			Aln_id alnid = IdAliMap[id1][id2];
		//	Calignment ob = AlnMap[alnid];
			InalignMap.insert(make_pair(id2, alnid));
			inmap.insert(make_pair(id2, id1));
		}
	}
	set<int>::iterator iteim;
	for(iteim = inners.begin(); iteim != inners.end(); ++iteim){
		int id = *iteim;
		if(lmap.find(id) != lmap.end()){
			lmap.erase(id);
		}
		if(inmap.find(id) != inmap.end()){
			inmap.erase(id);
			InalignMap.erase(id);
		}
	}

	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL){
		if(!IteL->second.inner_links.empty())
			IteL->second.inner_links.clear();
		set<pair<int, int> >::iterator Iteh;
		vector<pair<int, int> > erp;
		for(Iteh = IteL->second.head_links.begin(); Iteh != IteL->second.head_links.end(); ++Iteh){
			int id2 = Iteh->first;
			if(inners.find(id2) != inners.end())
				erp.push_back(*Iteh);
		}
		for(int i = 0; i < (int)erp.size(); ++i){
			IteL->second.head_links.erase(erp[i]);
			IteL->second.Head_Id_Len_Ma.erase(erp[i]);
			IteL->second.Head_Id_Ov_Ma.erase(erp[i]);
			multimap<int, pair<int, int> >::iterator ite = IteL->second.Head_Len_Id_Ma.begin();
			for(; ite != IteL->second.Head_Len_Id_Ma.end(); ++ite){
				if(erp[i] == ite->second){
					IteL->second.Head_Len_Id_Ma.erase(ite);
					break;
				}
			}
		}
		erp.clear();
		set<pair<int, int> >::iterator Itet;
		vector<pair<int, int> > erpt;
		for(Itet = IteL->second.tail_links.begin(); Itet != IteL->second.tail_links.end(); ++Itet){
			int id2 = Itet->first;
			if(inners.find(id2) != inners.end())
				erpt.push_back(*Itet);
		}
		for(int i = 0; i < (int)erpt.size(); ++i){
			IteL->second.tail_links.erase(erpt[i]);
			IteL->second.Tail_Id_Len_Ma.erase(erpt[i]);
			IteL->second.Tail_Id_Ov_Ma.erase(erpt[i]);
			multimap<int, pair<int, int> >::iterator ite = IteL->second.Tail_Len_Id_Ma.begin();
			for(; ite != IteL->second.Tail_Len_Id_Ma.end(); ++ite){
				if(erpt[i] == ite->second){
					IteL->second.Tail_Len_Id_Ma.erase(ite);
					break;
				}
			}
		}
	}

	idconmap.clear();
	map<int, C_Link>::iterator Ite;
	for(Ite = lmap.begin(); Ite != lmap.end(); ++Ite){
		Contig con;
		con.singletocontig(Ite->first, NidSeqMap[Ite->first]);
		idconmap.insert(make_pair(Ite->first, con));
	//	cout<<"add in idconmap "<<Ite->first<<endl;

	}

}

void hideinalign(map<int, C_Link> &lmap,
				 map<int, Contig> &idconmap,
				 vector< pair<string, string > >& IdSeqVe,
				 map< int, map<int, Aln_id> > &IdAliMap,
				 multimap<int, Aln_id> &InalignMap )
{
	set<int> inners;
	multimap<int, int> inmap;
	map<int, C_Link>::iterator IteL;

	for ( IteL = lmap.begin(); IteL != lmap.end(); ++IteL ) {
		if(!IteL->second.outer_links.empty()) {
			inners.insert( IteL->first );
		}
	}

	set< int >::iterator Itein;
	for ( Itein = inners.begin(); Itein != inners.end(); ++Itein ) {
		int id1 = *Itein;
		map<pair<int, int>, pair<int, int> >::iterator iteo;
		multimap< int, int, greater<int> > outer;
		for(iteo = lmap[id1].outer_links.begin(); iteo != lmap[id1].outer_links.end(); ++iteo){
			int id2 = iteo->first.first;
			if ( inners.find( id2 ) != inners.end() )
				continue;
			int len = (int)IdSeqVe[id2-1].second.size();
			outer.insert( make_pair( len, id2 ) );
		}
		if ( outer.empty() ) {
			continue;
			cout<<"outer empty!"<<id1<<endl;  exit(1);
		}
		int id2 = outer.begin()->second;
		if(IdAliMap.find(id1) == IdAliMap.end()){
			cout<<"error1 in hidealign "<<id1<<endl;
			exit(1);
		}
		if(IdAliMap[id1].find(id2) == IdAliMap[id1].end()){
			cout<<"error2 in hidealign "<<id1 <<","<<id2<<endl;  exit(1);
		}
		Aln_id alnid = IdAliMap[id1][id2];
	//	Calignment ob = AlnMap[alnid];
		InalignMap.insert(make_pair(id2, alnid));
		inmap.insert(make_pair(id2, id1));
	}

	set<int>::iterator iteim;
	for(iteim = inners.begin(); iteim != inners.end(); ++iteim){
		int id = *iteim;
		if(lmap.find(id) != lmap.end()){
			lmap.erase(id);
		}
		if(inmap.find(id) != inmap.end()){
			inmap.erase(id);
			InalignMap.erase(id);
		}
	}

	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL){
		if(!IteL->second.inner_links.empty())
			IteL->second.inner_links.clear();
		set<pair<int, int> >::iterator Iteh;
		vector<pair<int, int> > erp;
		for(Iteh = IteL->second.head_links.begin(); Iteh != IteL->second.head_links.end(); ++Iteh){
			int id2 = Iteh->first;
			if(inners.find(id2) != inners.end())
				erp.push_back(*Iteh);
		}
		for(int i = 0; i < (int)erp.size(); ++i){
			IteL->second.head_links.erase(erp[i]);
			IteL->second.Head_Id_Len_Ma.erase(erp[i]);
			IteL->second.Head_Id_Ov_Ma.erase(erp[i]);
			multimap<int, pair<int, int> >::iterator ite = IteL->second.Head_Len_Id_Ma.begin();
			for(; ite != IteL->second.Head_Len_Id_Ma.end(); ++ite){
				if(erp[i] == ite->second){
					IteL->second.Head_Len_Id_Ma.erase(ite);
					break;
				}
			}
		}
		erp.clear();
		set<pair<int, int> >::iterator Itet;
		vector<pair<int, int> > erpt;
		for(Itet = IteL->second.tail_links.begin(); Itet != IteL->second.tail_links.end(); ++Itet){
			int id2 = Itet->first;
			if(inners.find(id2) != inners.end())
				erpt.push_back(*Itet);
		}
		for(int i = 0; i < (int)erpt.size(); ++i){
			IteL->second.tail_links.erase(erpt[i]);
			IteL->second.Tail_Id_Len_Ma.erase(erpt[i]);
			IteL->second.Tail_Id_Ov_Ma.erase(erpt[i]);
			multimap<int, pair<int, int> >::iterator ite = IteL->second.Tail_Len_Id_Ma.begin();
			for(; ite != IteL->second.Tail_Len_Id_Ma.end(); ++ite){
				if(erpt[i] == ite->second){
					IteL->second.Tail_Len_Id_Ma.erase(ite);
					break;
				}
			}
		}
	}

	idconmap.clear();
	map<int, C_Link>::iterator Ite;
	for(Ite = lmap.begin(); Ite != lmap.end(); ++Ite){
		Contig con;
		con.singletocontig(Ite->first, IdSeqVe[Ite->first-1].second);
		idconmap.insert(make_pair(Ite->first, con));
	//	cout<<"add in idconmap "<<Ite->first<<endl;

	}
}

void delete_isolate(map<int, C_Link> &lmap, map<int, Contig> &idconmap, vector<Contig> &singlecon)
{
	vector<int> era;
	map<int, C_Link>::iterator Itel;
//	int alidx = 0;
	for(Itel = lmap.begin(); Itel != lmap.end(); ++Itel){
		if(Itel->second.head_links.empty() && Itel->second.tail_links.empty()){
			singlecon.push_back(idconmap[Itel->first]);
			era.push_back(Itel->first);
		}
	}

	for(int i = 0; i < (int)era.size(); ++i){
		lmap.erase(era[i]);
		idconmap.erase(era[i]);
	}

}

void simplifynet(map<int, C_Link> &lmap)
{

	set<int> remainid;

	map<int, C_Link>::iterator Ite_L;
	for(Ite_L = lmap.begin(); Ite_L != lmap.end(); ++Ite_L){
		if( (!Ite_L->second.head_links.empty()) || (!Ite_L->second.tail_links.empty())){
			remainid.insert(Ite_L->first);
		}
	}

	while(!remainid.empty()){

			set<int> walked;
			set<int> downvacant;
			set<pair<pair<int, int>, pair<int, int> > > redundant_links;
			int id = *remainid.begin();

			downvacant.insert(id);

			while(!downvacant.empty()){

				id = *downvacant.begin();

				pair<set<int>, set<pair<pair<int, int>, pair<int, int> > > > re_value = check_redundance(id, walked, lmap);
				set<int> newvacant = re_value.first;
				set<pair<pair<int, int>, pair<int, int> > > newredundant = re_value.second;
				downvacant.insert(newvacant.begin(), newvacant.end());
				redundant_links.insert(newredundant.begin(), newredundant.end());

				walked.insert(id);
				downvacant.erase(id);
				remainid.erase(id);
			}


			walked.erase(walked.begin(), walked.end());

			edge_reduce(redundant_links, lmap);

	}


}

pair<set<int>, set<pair<pair<int, int>, pair<int, int> > > > check_redundance(int id, set<int> &walked, map<int, C_Link>& lmap)
{
	pair<set<int>, set<pair<pair<int, int>, pair<int, int> > > > Re_value;

	set<int> downvacant;
	if(lmap.find(id)==lmap.end()){
		cout<<"error! L_Map[id] not found!"<<id <<endl; exit(1);
	}
	set<pair<pair<int, int>, pair<int, int> > > markedid;

		if(!lmap[id].head_links.empty()){

			if((int)lmap[id].head_links.size() > 1){

				int longest;
				multimap<int, pair<int,int> >::reverse_iterator Rite = lmap[id].Head_Len_Id_Ma.rbegin();
				longest = Rite->first + 50;


				multimap<int, pair<int,int> >::iterator IteH_L_I;
				pair<int, int> p1 = make_pair(id, 0);
				for(IteH_L_I = lmap[id].Head_Len_Id_Ma.begin(); IteH_L_I != lmap[id].Head_Len_Id_Ma.end(); ++IteH_L_I){
					pair<int,int> p2 = IteH_L_I->second;
					int id2 = IteH_L_I->second.first;
					int ht2 = IteH_L_I->second.second;

					int len_v_w = IteH_L_I->first;

					if(lmap[id].Head_Id_Ov_Ma.find(p2)==lmap[id].Head_Id_Ov_Ma.end()){
						cout<< "error__a_1 : in check_redundance() " <<endl; exit(1);
					}
					int ov_v_w = lmap[id].Head_Id_Ov_Ma[p2];



					if(ht2 == 1){
						if(lmap[id2].tail_links.find(p1)==lmap[id2].tail_links.end()){
							cout<< "error200_0: "<< id2<<"\t"<<ht2<<"\t"<<id<<endl;  exit(1);
						}

						if(lmap[id2].Tail_Id_Ov_Ma.find(p1)==lmap[id2].Tail_Id_Ov_Ma.end()){
							cout<< "error__a_2 : in check_redundance() "  <<id2<<"\t"<<ht2<<"\t"<<id<<endl; exit(1);
						}
						if(lmap[id2].Tail_Id_Ov_Ma[p1] != ov_v_w){
							cout<< "error_b_2 : in check_redundance() " <<id2<<"\t"<<ht2<<"\t"<<id<<endl; system("pause");
						}else{

							if(walked.find(id2) == walked.end())
								downvacant.insert(id2);

							multimap<int, pair<int,int> >::iterator Ite_id2_HLI;
							for(Ite_id2_HLI = lmap[id2].Head_Len_Id_Ma.begin(); Ite_id2_HLI != lmap[id2].Head_Len_Id_Ma.end(); ++Ite_id2_HLI){
								int len_w_u = Ite_id2_HLI->first;

								if( (len_w_u + len_v_w) > longest )
									break;
								else{
									pair<int, int> pu = Ite_id2_HLI->second;
									int u = pu.first;

									if(lmap[id].head_links.find(pu)!=lmap[id].head_links.end()){
										if(lmap.find(u)==lmap.end()){
											cout<< "error: L_Map.find(u)==L_Map.end(),1 " <<u<<endl; exit(1);
										}
										if(pu.second == 0 && lmap[u].head_links.find(p1)!=lmap[u].head_links.end()){

											int len_v_u = lmap[id].Head_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
										if(pu.second == 1 && lmap[u].tail_links.find(p1)!=lmap[u].tail_links.end()){

											int len_v_u = lmap[id].Head_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
									}
								}

							}
						}
					}
					if(ht2 == 0){
						if(lmap[id2].head_links.find(p1)==lmap[id2].head_links.end()){
							cout<< "error200_1: "<< id2<<"\t"<<ht2<<"\t"<<id<<endl;  exit(1);
						}

						if(lmap[id2].Head_Id_Ov_Ma.find(p1)==lmap[id2].Head_Id_Ov_Ma.end()){
							cout<< "error__a_3 : in check_redundance() " << id2<<"\t"<<ht2<<"\t"<<id<<endl; exit(1);
						}
						if(lmap[id2].Head_Id_Ov_Ma[p1] != ov_v_w){
							cout<<"error_b_2_1 : in check_redundance() " <<id2<<"\t"<<ht2<<"\t"<<id<<endl; system("pause");
						}else{
							if(walked.find(id2) == walked.end())
								downvacant.insert(id2);

							multimap<int, pair<int, int> >::iterator Ite_id2_TLI;
							for(Ite_id2_TLI = lmap[id2].Tail_Len_Id_Ma.begin(); Ite_id2_TLI != lmap[id2].Tail_Len_Id_Ma.end(); ++Ite_id2_TLI){
								int len_w_u = Ite_id2_TLI->first;

								if( (len_w_u + len_v_w) > longest )
									break;
								else{
									pair<int,int> pu = Ite_id2_TLI->second;
									int u = Ite_id2_TLI->second.first;

									if(lmap[id].head_links.find(pu)!=lmap[id].head_links.end()){
										if(lmap.find(u)==lmap.end()){
											cout<< "error: L_Map.find(u)==L_Map.end(),2 " <<u<< endl; exit(1);
										}
										if(pu.second == 0 && lmap[u].head_links.find(p1)!=lmap[u].head_links.end()){

											int len_v_u = lmap[id].Head_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){


												markedid.insert(make_pair(p1, pu));
											}
										}
										if(pu.second == 1 && lmap[u].tail_links.find(p1)!=lmap[u].tail_links.end()){

											int len_v_u = lmap[id].Head_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));

											}
										}
									}
								}
							}
						}
					}


				}
			}else{
				pair<int, int> p = *lmap[id].head_links.begin();
				if(walked.find( p.first ) == walked.end())
					downvacant.insert(p.first);
			}
		}



		if(!lmap[id].tail_links.empty()){

			if((int)lmap[id].tail_links.size() > 1){
				int longest;
				multimap<int, pair<int, int> >::reverse_iterator Rite = lmap[id].Tail_Len_Id_Ma.rbegin();
				longest = Rite->first + 50;


				multimap<int, pair<int,int> >::iterator IteT_L_I;
				pair<int, int> p1 = make_pair(id, 1);
				for(IteT_L_I = lmap[id].Tail_Len_Id_Ma.begin(); IteT_L_I != lmap[id].Tail_Len_Id_Ma.end(); ++IteT_L_I){
					pair<int,int> p2 = IteT_L_I->second;
					int id2 = p2.first;
					int ht2 = p2.second;
					int len_v_w = IteT_L_I->first;
					if(lmap[id].Tail_Id_Ov_Ma.find(p2)==lmap[id].Tail_Id_Ov_Ma.end()){
						cout<< "error__a_4 : in check_redundance() " << id<< "\t"<<id2<<"\t"<<ht2<<endl; exit(1);
					}
					int ov_v_w = lmap[id].Tail_Id_Ov_Ma[p2];

					if(ht2 == 1){
						if(lmap[id2].tail_links.find(p1)==lmap[id2].tail_links.end()){
							cout<< "error200_2: "<< id2<<"\t"<<ht2<<"\t"<<id<<endl;  exit(1);
						}

						if(lmap[id2].Tail_Id_Ov_Ma.find(p1)==lmap[id2].Tail_Id_Ov_Ma.end()){
							cout<< "error__a_5 : in check_redundance() " <<id<< "\t"<<id2<<"\t"<<ht2<<endl; exit(1);
						}
						if(lmap[id2].Tail_Id_Ov_Ma[p1] != ov_v_w){
							cout<<"error_b_2_2 : in check_redundance() " <<id2<<"\t"<<ht2<<"\t"<<id<<endl; system("pause");
						}else{
							if(walked.find(id2) == walked.end())
								downvacant.insert(id2);

							multimap<int, pair<int,int> >::iterator Ite_id2_HLI;
							for(Ite_id2_HLI = lmap[id2].Head_Len_Id_Ma.begin(); Ite_id2_HLI != lmap[id2].Head_Len_Id_Ma.end(); ++Ite_id2_HLI){
								int len_w_u = Ite_id2_HLI->first;
								if( (len_w_u + len_v_w) > longest )
									break;
								else{
									pair<int,int>  pu = Ite_id2_HLI->second;
									int u = Ite_id2_HLI->second.first;
									if(lmap[id].tail_links.find(pu)!=lmap[id].tail_links.end()){
										if(lmap.find(u)==lmap.end()){
											cout<< "error: L_Map.find(u)==L_Map.end(),1 " <<u<<endl; exit(1);
										}
										if(pu.second == 0 && lmap[u].head_links.find(p1)!=lmap[u].head_links.end()){

											int len_v_u = lmap[id].Tail_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
										if(pu.second == 1 && lmap[u].tail_links.find(p1)!=lmap[u].tail_links.end()){

											int len_v_u = lmap[id].Tail_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
									}
								}

							}
						}
					}

					if(ht2 == 0){
						if(lmap[id2].head_links.find(p1)==lmap[id2].head_links.end()){
							cout<< "error200_3: "<< id2<<"\t"<<ht2<<"\t"<<id<<endl;  exit(1);
						}

						if(lmap[id2].Head_Id_Ov_Ma.find(p1)==lmap[id2].Head_Id_Ov_Ma.end()){
							cout<< "error__a_3 : in check_redundance() " <<endl; exit(1);
						}
						if(lmap[id2].Head_Id_Ov_Ma[p1] != ov_v_w){
							cout<<"error_b_2_3 : in check_redundance() " <<id2<<"\t"<<ht2<<"\t"<<id<<endl; system("pause");
						}else{
							if(walked.find(id2) == walked.end())
								downvacant.insert(id2);

							multimap<int, pair<int,int> >::iterator Ite_id2_TLI;
							for(Ite_id2_TLI = lmap[id2].Tail_Len_Id_Ma.begin(); Ite_id2_TLI != lmap[id2].Tail_Len_Id_Ma.end(); ++Ite_id2_TLI){
								int len_w_u = Ite_id2_TLI->first;
								if( (len_w_u + len_v_w) > longest )
									break;
								else{
									pair<int, int> pu = Ite_id2_TLI->second;
									int u = Ite_id2_TLI->second.first;
									if(lmap[id].tail_links.find(pu)!=lmap[id].tail_links.end()){
										if(lmap.find(u)==lmap.end()){
											cout<< "error: L_Map.find(u)==L_Map.end(),2" <<endl; exit(1);
										}
										if(pu.second == 0 && lmap[u].head_links.find(p1)!=lmap[u].head_links.end()){

											int len_v_u = lmap[id].Tail_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
										if(pu.second == 1 && lmap[u].tail_links.find(p1)!=lmap[u].tail_links.end()){

											int len_v_u = lmap[id].Tail_Id_Len_Ma[pu];

											if( (len_w_u + len_v_w <= len_v_u + 50) && (len_w_u + len_v_w >= len_v_u - 50)){

												markedid.insert(make_pair(p1, pu));
											}
										}
									}
								}
							}
						}
					}

				}

			}else{
				pair<int, int> p = *lmap[id].tail_links.begin();
				if(walked.find( p.first ) == walked.end())
					downvacant.insert(p.first);
			}


		}

		Re_value = make_pair(downvacant, markedid);

	return Re_value;


}

void edge_reduce(set<pair<pair<int, int>, pair<int, int> > > &redundant, map<int, C_Link> &lmap)
{
	set<pair<pair<int, int>, pair<int, int> > >::iterator Ite_r;
	for(Ite_r = redundant.begin(); Ite_r != redundant.end(); ++Ite_r){
		pair<int, int> p1 = Ite_r->first;
		pair<int, int> p2 = Ite_r->second;

		int id = p1.first;
		int ht1 = p1.second;
		int u = p2.first;
		int ht2 = p2.second;

		if(lmap.find(id) != lmap.end()){
			if(ht1 == 0){
				if(lmap[id].head_links.find(p2)!=lmap[id].head_links.end()){


					lmap[id].head_links.erase(p2);
					lmap[id].Head_Id_Len_Ma.erase(p2);
					lmap[id].Head_Id_Ov_Ma.erase(p2);
					multimap<int, pair<int, int> >::iterator IteHM;
					for(IteHM = lmap[id].Head_Len_Id_Ma.begin(); IteHM != lmap[id].Head_Len_Id_Ma.end(); ++IteHM){
						if(IteHM->second == p2){
							lmap[id].Head_Len_Id_Ma.erase(IteHM);
							break;
						}
					}
				}
			}
			if(ht1 == 1){
				if(lmap[id].tail_links.find(p2)!=lmap[id].tail_links.end()){


					lmap[id].tail_links.erase(p2);
					lmap[id].Tail_Id_Len_Ma.erase(p2);
					lmap[id].Tail_Id_Ov_Ma.erase(p2);
					multimap<int, pair<int, int> >::iterator IteTM;
					for(IteTM = lmap[id].Tail_Len_Id_Ma.begin(); IteTM != lmap[id].Tail_Len_Id_Ma.end(); ++IteTM){
						if(IteTM->second == p2){
							lmap[id].Tail_Len_Id_Ma.erase(IteTM);
							break;
						}
					}
				}
			}
		}
		if(lmap.find(u) != lmap.end()){

			if(ht2 == 0){
				if(lmap[u].head_links.find(p1)!=lmap[u].head_links.end()){
					lmap[u].head_links.erase(p1);
					lmap[u].Head_Id_Len_Ma.erase(p1);
					lmap[u].Head_Id_Ov_Ma.erase(p1);
					multimap<int, pair<int, int> >::iterator IteHM;
					for(IteHM = lmap[u].Head_Len_Id_Ma.begin(); IteHM != lmap[u].Head_Len_Id_Ma.end(); ++IteHM){
						if(IteHM->second == p1){
							lmap[u].Head_Len_Id_Ma.erase(IteHM);
							break;
						}
					}
				}
			}
			if(ht2 == 1){
				if(lmap[u].tail_links.find(p1)!=lmap[u].tail_links.end()){

					lmap[u].tail_links.erase(p1);
					lmap[u].Tail_Id_Len_Ma.erase(p1);
					lmap[u].Tail_Id_Ov_Ma.erase(p1);
					multimap<int, pair<int, int> >::iterator IteTM;
					for(IteTM = lmap[u].Tail_Len_Id_Ma.begin(); IteTM != lmap[u].Tail_Len_Id_Ma.end(); ++IteTM){
						if(IteTM->second == p1){
							lmap[u].Tail_Len_Id_Ma.erase(IteTM);
							break;
						}
					}
				}
			}
		}
	}
}

void red_sel_rev_link(map<int, C_Link> &lmap)
{
	map<int, C_Link>::iterator IteL;
	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL){
		set<pair<int, int> >::iterator Iteh; 
		for(Iteh = IteL->second.head_links.begin(); Iteh != IteL->second.head_links.end(); ++Iteh){
			if(Iteh->first == IteL->first){
				pair<int, int> p = *Iteh;
				IteL->second.head_links.erase(p);
				IteL->second.Head_Id_Ov_Ma.erase(p);
				if(!IteL->second.Head_Id_Len_Ma.empty()){
					multimap<int, pair<int, int> >::iterator IteLH;
					for(IteLH = IteL->second.Head_Len_Id_Ma.begin(); IteLH != IteL->second.Head_Len_Id_Ma.end(); ++IteLH){
						if(IteLH->second == p){
							IteL->second.Head_Len_Id_Ma.erase(IteLH);
							break;
						}
					}
				}
				break;
			}
		}
		set<pair<int, int> >::iterator Itet;
		for(Itet = IteL->second.tail_links.begin(); Itet != IteL->second.tail_links.end(); ++Itet){
			if(Itet->first == IteL->first){
				pair<int, int> p = *Itet;
				IteL->second.tail_links.erase(p);
				IteL->second.Tail_Id_Ov_Ma.erase(p);
				if(!IteL->second.Tail_Len_Id_Ma.empty()){
					multimap<int, pair<int, int> >::iterator IteLT;
					for(IteLT = IteL->second.Tail_Len_Id_Ma.begin(); IteLT != IteL->second.Tail_Len_Id_Ma.end(); ++IteLT){
						if(IteLT->second == p){
							IteL->second.Tail_Len_Id_Ma.erase(IteLT);
							break;
						}
					}
				}
				break;
			}
		}
	}
}

int merge_to_unitig(map<int, Contig> & idconmap, map<int, C_Link> & lmap)
{
	int change = 0;

	vector<list<pair<int, int> > > unitigVe;
	set<int> remainid;
	map<int, C_Link>::iterator IteL;
	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL)
		remainid.insert(IteL->first);


	map<pair<int, int>, pair<int, int> > v_p;
	int idx = 0;

	int i = 0;
	while(!remainid.empty()){
		i+=1;

		set<int> walked;
		list<pair<int, int> > unitig;
		int id = *remainid.begin();

		unitig.push_back(make_pair(id, 0));
		walked.insert(id);
		remainid.erase(id);

		if( (int)lmap[id].head_links.size() == 1 ){

			int id1 = id;
			pair<int,int> p1 = make_pair(id, 0);
			int tag = 0;
			int g = 0;
			int primer = 0;    //
			while(tag == 0 ){
				g+=1;

				int id2;
				int ht2;



				if(primer == 0){
					pair<int,int> p2 = *lmap[id1].head_links.begin();
					id2 = p2.first;
					ht2 = p2.second;

				}else if(primer == 1){
					pair<int,int> p2 = *lmap[id1].tail_links.begin();
					id2 = p2.first;
					ht2 = p2.second;

				}

				if(walked.find(id2) != walked.end()){

					break;
				}

				if( ht2 == 0 && (int)lmap[id2].head_links.size() == 1 ){


					unitig.push_back(make_pair(id2, 1));


					walked.insert(id2);

					remainid.erase(id2);

					if((int)lmap[id2].tail_links.size() == 1){
						id1 = id2;
						p1 = make_pair(id1, 1);
						primer = 1;
					}else{
						tag = 1;
					}

				}else if( ht2 == 1 && (int)lmap[id2].tail_links.size() == 1 ){


					unitig.push_back(make_pair(id2, 0));


					walked.insert(id2);

					remainid.erase(id2);


					if((int)lmap[id2].head_links.size() == 1){
						id1 = id2;
						p1 = make_pair(id1, 0);
						primer = 0;
					}else{
						tag = 1;
					}


				}else{
					tag = 1;
				}
			}

		}
		if((int)lmap[id].tail_links.size() == 1){

			int id1 = id;
			pair<int, int> p1 = make_pair(id1, 1);
			int tag = 0;
			int g = 0;
			int primer = 1;

			while(tag == 0 ){
				g+=1;

				int id2;


				int ht2;

				if(primer == 0){
					pair<int, int> p2 = *lmap[id1].head_links.begin();
					id2 = p2.first;
					ht2 = p2.second;


				}else if(primer == 1){
					pair<int, int> p2 = *lmap[id1].tail_links.begin();
					id2 = p2.first;
					ht2 = p2.second;

				}

				if(walked.find(id2) != walked.end())
					break;

				if( ht2 == 0 && (int)lmap[id2].head_links.size() == 1 ){

					unitig.push_front(make_pair(id2, 0));

					walked.insert(id2);
					remainid.erase(id2);

					if((int)lmap[id2].tail_links.size() == 1){
						id1 = id2;
						p1 = make_pair(id1, 1);
						primer = 1;
					}else{
						tag = 1;
					}

				}else if( ht2 == 1 && (int)lmap[id2].tail_links.size() == 1 ){

					unitig.push_front(make_pair(id2, 1));

					walked.insert(id2);
					remainid.erase(id2);

					if((int)lmap[id2].head_links.size() == 1){
						id1 = id2;
						p1 = make_pair(id1, 0);
						primer = 0;
					}else{
						tag = 1;
					}

				}else{
						tag = 1;
				}
			}
		}


		unitigVe.push_back(unitig);
		idx +=1;
		if((int)unitig.size() > 1)
			change += 1;

		int id_f = unitig.front().first;
		if(unitig.front().second == 0)
			v_p.insert(make_pair(make_pair(id_f, 1), make_pair(idx, 1)));
		else if(unitig.front().second == 1)
			v_p.insert(make_pair(make_pair(id_f, 0), make_pair(idx, 1)));
		else{
			cout<<"error: unitig.front().second != 0 || 1 : " <<unitig.front().first<<endl;
			exit(1);
		}
		int id_b = unitig.back().first;
		if(unitig.back().second == 0)
			v_p.insert(make_pair(make_pair(id_b, 0), make_pair(idx, 0)));
		else if(unitig.back().second == 1)
			v_p.insert(make_pair(make_pair(id_b, 1), make_pair(idx, 0)));
		else{
			cout<<"error: unitig.back().second != 0 || 1 : " <<unitig.back().first<<endl;
			exit(1);
		}


		unitig.erase(unitig.begin(), unitig.end());
		walked.erase(walked.begin(), walked.end());

	}


	idconmap = mergecontig(unitigVe, idconmap, lmap);
	if((int)unitigVe.size() > 0)
		lmap = replace_L_Map2(v_p, unitigVe, lmap);

	return change;

}

map<int, C_Link> replace_L_Map2(map<pair<int, int>, pair<int,int> > &v_p, vector<list<pair<int, int> > > & unitigVe, map<int, C_Link> &lmap)
{
	map<int, C_Link> new_L_map;
	for(int i = 0; i < (int)unitigVe.size(); ++i){
		C_Link ob;
		pair<int,int> p_f = unitigVe[i].front();
		
		int id_f = p_f.first;
		int forb = p_f.second;
		if(forb == 0){
			
			if(v_p.find(make_pair(id_f, 1)) != v_p.end()){
				set<pair<int, int> >::iterator Ite_t;
				if(lmap.find(id_f)==lmap.end()){
					cout<<"error1 in Assembly_Later::replace_L_Map2(): "<<id_f<<endl;   exit(1);
				}
				for(Ite_t = lmap[id_f].tail_links.begin(); Ite_t != lmap[id_f].tail_links.end(); ++Ite_t){
					pair<int, int> p =*Ite_t;
					if(v_p.find(p)!=v_p.end()){
						ob.tail_links.insert(v_p[p]);
						ob.Tail_Id_Ov_Ma.insert(make_pair(v_p[p], lmap[id_f].Tail_Id_Ov_Ma[p]));
					}

				}
			}
		}else if(forb == 1){
			if(v_p.find(make_pair(id_f, 0)) != v_p.end()){
				set<pair<int,int> >::iterator Ite_h;
				if(lmap.find(id_f)==lmap.end()){
					cout<<"error1_1 in Assembly_Later::replace_L_Map2(): "<<id_f<<endl;   exit(1);
				}
				for(Ite_h = lmap[id_f].head_links.begin(); Ite_h != lmap[id_f].head_links.end(); ++Ite_h){
					pair<int, int> p =*Ite_h;
					if(v_p.find(p)!=v_p.end()){
						ob.tail_links.insert(v_p[p]);
						ob.Tail_Id_Ov_Ma.insert(make_pair(v_p[p], lmap[id_f].Head_Id_Ov_Ma[p]));
					}

				}
			}
		}

		pair<int, int> p_b = unitigVe[i].back();
		int id_b = p_b.first;
		forb = p_b.second;
		if(forb == 0){
			if(v_p.find(make_pair(id_b, 0)) != v_p.end()){
				set<pair<int,int> >::iterator Ite_h;
				if(lmap.find(id_b)==lmap.end()){
					cout<<"error1_2 in Assembly_Later::replace_L_Map2(): "<<id_b<<endl;   exit(1);
				}
				for(Ite_h = lmap[id_b].head_links.begin(); Ite_h != lmap[id_b].head_links.end(); ++Ite_h){
					pair<int, int> p = *Ite_h;
					if(v_p.find(p)!=v_p.end()){
						ob.head_links.insert(v_p[p]);
						ob.Head_Id_Ov_Ma.insert(make_pair(v_p[p], lmap[id_b].Head_Id_Ov_Ma[p]));
					}
				}
			}
		}else if(forb == 1){
			if(v_p.find(make_pair(id_b, 1)) != v_p.end()){
				set<pair<int,int> >::iterator Ite_t;
				if(lmap.find(id_b)==lmap.end()){
					cout<<"error1_3 in Assembly_Later::replace_L_Map2(): "<<id_b<<endl;   exit(1);
				}
				for(Ite_t = lmap[id_b].tail_links.begin(); Ite_t != lmap[id_b].tail_links.end(); ++Ite_t){
					pair<int, int> p = *Ite_t;
					if(v_p.find(p)!=v_p.end()){
						ob.head_links.insert(v_p[p]);
						ob.Head_Id_Ov_Ma.insert(make_pair(v_p[p], lmap[id_b].Tail_Id_Ov_Ma[p]));
					}
				}
			}
		}

		new_L_map.insert(make_pair(i + 1, ob));
	}
	return new_L_map;
}

map< int, Contig > mergecontig(vector<list<pair<int, int> > > & unitigVe, map<int, Contig> & this_idconmap, map<int, C_Link> &this_lmap)
{



	map<int, Contig> NewConMap;
	for(int i = 0; i < (int)unitigVe.size(); ++i){
		if(unitigVe.empty()){
			cout<< "error: unitgVe.empty in A_L::mergcontig()" <<endl;
			system("pause");
		}
		if((int)unitigVe[i].size() == 1){
			NewConMap.insert(make_pair(i+1, this_idconmap[unitigVe[i].front().first]));
			continue;
		}

		vector<Contig> Con_Ve;
		vector<int> OverVe;
		Contig con1 = this_idconmap[unitigVe[i].front().first];
		if(unitigVe[i].front().second == 1){
			con1.reverse();
		}
		Con_Ve.push_back(con1);


		list<pair<int,int> >::iterator Ite = unitigVe[i].begin();
		int id1 = Ite->first;
		int ht1 = Ite->second;
		++Ite;
		for(; Ite != unitigVe[i].end(); ++Ite){
			pair<int,int> p2;
			int id2 = Ite->first;
			int ht2 = Ite->second;
			Contig con2;
			con2 = this_idconmap[id2];
			if(ht2 == 1){
				con2.reverse();
				p2 = make_pair(id2, 0);
			}else
				p2 = make_pair(id2, 1);




			Con_Ve.push_back(con2);
			int overlap;
			if(ht1 == 0){

				overlap = this_lmap[id1].Head_Id_Ov_Ma[p2];
			}else if(ht1 == 1){

				overlap = this_lmap[id1].Tail_Id_Ov_Ma[p2];
			}
			OverVe.push_back(overlap);
			id1 = id2;
			ht1 = ht2;
		}

		Contig n_contig = mergetocontig(Con_Ve, OverVe);


		list<int>::iterator Itel;


		NewConMap.insert(make_pair(i+1, n_contig));
	}


	return NewConMap;
}

Contig mergetocontig(vector<Contig> & ConVe, vector<int> &overVe)
{


	Contig n_contig;
	Contig con1 = ConVe[0];


	for(int i = 1; i < (int)ConVe.size(); ++i){

		Contig con2 = ConVe[i];

		int len = overVe[i-1];
		n_contig = merge2contigs(con1, con2, len);

		con1 = n_contig;
	}
	return n_contig;
}


void Addinalign( Contig &con, multimap<int, Aln_id> &InalignMap, map<Aln_id, Calignment> &AlnMap )
{


	list<int>::iterator Iterl;
	for( Iterl=con.ReadidList.begin(); Iterl!=con.ReadidList.end(); ++Iterl ) {
		if(InalignMap.find(*Iterl)!=InalignMap.end()){
			deque<Aln_id> Inalign;
			multimap<int, Aln_id>::iterator IteInMa;
			for(IteInMa=InalignMap.lower_bound(*Iterl); IteInMa!=InalignMap.upper_bound(*Iterl); ++IteInMa){
				Inalign.push_front(IteInMa->second);
			}
			deque<Aln_id>::iterator Iteinde;
			for(Iteinde=Inalign.begin(); Iteinde!=Inalign.end(); ++Iteinde){
				con.AddIn(AlnMap[*Iteinde]);
			
			}
			continue;

		}
	}

}


void graph_process( short_assembly_bank &s_assbank, map<int, C_Link> & L_Map, map<int, Contig> & IdConMap,
				   map<int, pair<int, pair<int, int> > > &Pairs,
				   int tig_len, int mate_len, int mate_len_var, int mate_type, Graph_parameter &para )
{
	
	vector<map<int, C_Link> > lmapve = lmapcluster(L_Map);
	size_t vesize = lmapve.size(); 

	int g = 0;
	for ( size_t i = 0; i < vesize; ++i ) {
		if ( (int)lmapve[i].size() == 1 ) {
		
			add_single_to_bank( lmapve[i].begin()->first, s_assbank.assbank );
			continue;
		}
		g += 1;
		map<int, Contig> idconmap;
		map<int, Contig>::iterator IteIc;
		for(IteIc = IdConMap.begin(); IteIc != IdConMap.end(); ++IteIc){
			int id = IteIc->first;
			if(lmapve[i].find(id) != lmapve[i].end())
				idconmap.insert(*IteIc);
			
		}
		int lmapsize = (int)lmapve[i].size();
		
		vector< list< pair< int, int > > > path;
		map< Supertig_id, int > rev_trans_map;
		Supertig_bank bank;
		trans_to_graph( lmapve[i], idconmap, Pairs, tig_len, mate_len, mate_len_var, mate_type, bank, rev_trans_map, para );

		vector< list< pair< int, int > > > final_path;
		supplement_gap( bank, final_path, rev_trans_map, L_Map, idconmap, Pairs, s_assbank.IdAliMap, s_assbank.MulIdAliMap, s_assbank.Aln_Map );
		
		

		Trans_path_to_assbank( final_path, s_assbank.assbank );
	
	}
	ass_from_path_to_contig( s_assbank.assbank, IdConMap, L_Map );
}

void add_single_to_bank( int id, Assembly_bank &bank )
{
	Contig_bank cbank;
	cbank.path_from_graph.push_back( make_pair( id, 0 ) );
	Contig_id n_id;
	if ( bank.Contig_map.empty() )
		n_id = 1;
	else {
		n_id = bank.Contig_map.rbegin()->first + 1;

	}
	bank.Contig_map.insert( make_pair( n_id, cbank ) );
}

vector<map<int, C_Link> > lmapcluster(std::map<int,C_Link> &lmap)
{
	vector<map<int, C_Link> > value;




	set<int> remained;

	set<int> seed;
	set<int> al_seed;
	map<int, C_Link> gena;
	map<int, C_Link> al_gena;


	map<int, C_Link>::iterator IteL;
	for(IteL = lmap.begin(); IteL != lmap.end(); ++IteL){
	
		remained.insert(IteL->first);
	}

	while(!remained.empty()){
		int id = *remained.begin();
		seed.insert(id);
		remained.erase(id);
		
		gena.insert(make_pair(id, lmap[id]));

		
		while(!seed.empty()){
		
			set<int>::iterator Ites;
			for(Ites = seed.begin(); Ites != seed.end(); ++Ites){
				id = *Ites;
				
				if(!lmap[id].head_links.empty()){
				
						set<pair<int, int> >::iterator Iteh;
						for(Iteh = lmap[id].head_links.begin(); Iteh != lmap[id].head_links.end(); ++Iteh){
							pair<int, int> p = *Iteh;
							if(remained.find(p.first) == remained.end())
								continue;
							if(gena.find(p.first) != gena.end())
								continue;
						
								al_seed.insert(p.first);
								
								gena.insert(make_pair(p.first, lmap[p.first]));
							
								remained.erase(p.first);
								
						
						}

				
				}

				if(!lmap[id].tail_links.empty()){
				
						set<pair<int, int> >::iterator Itet;
						for(Itet = lmap[id].tail_links.begin(); Itet != lmap[id].tail_links.end(); ++Itet){
							pair<int, int> p = *Itet;
							if(remained.find(p.first) == remained.end())
								continue;
							if(gena.find(p.first) != gena.end())
								continue;
						
								al_seed.insert(p.first);
								
								gena.insert(make_pair(p.first, lmap[p.first]));
							
								remained.erase(p.first);
								
						
						}
				
				}

			}

			seed = al_seed;
			al_seed.clear();
		

		}


	
				value.push_back(gena);
		
			gena.clear();
			seed.clear();
			al_seed.clear();

	}

	return value;

}

void ass_from_path_to_contig( Assembly_bank &bank, map< int, Contig > &idconmap, map< int, C_Link > &lmap )
{
	map< Contig_id, Contig_bank >::iterator Ite;
	for ( Ite = bank.Contig_map.begin(); Ite != bank.Contig_map.end(); ++Ite ) {
	
		ass_from_path_to_contig_t( Ite->second.path_from_graph, Ite->second.contig, idconmap, lmap );
		Ite->second.path_from_graph.clear();
	}
}

void ass_from_path_to_contig_t( list< pair< int, int > > &path, Contig &n_contig, map< int, Contig > &this_idconmap, map< int, C_Link > &this_lmap )
{
	if ( path.empty() ) {
		cerr <<"Warning in Assembly_Later::ass_from_path_to_contig: path empty!"<<endl; return;
	}
	if ( (int)path.size() == 1 ) {
		if ( this_idconmap.find( path.front().first ) == this_idconmap.end() ) {
			cerr << "Error in Assembly_Later::ass_from_path_to_contig: id not found in idconmap! "<<endl;  exit(1);
		}
		n_contig = this_idconmap[path.front().first];
		if ( path.front().second == 1 ) {
			n_contig.reverse();
		} 
	} else {
		vector<Contig> Con_Ve;
		vector<int> OverVe;
		Contig con1 = this_idconmap[path.front().first];
		if(path.front().second == 1){
			con1.reverse();
		}
		Con_Ve.push_back(con1);

		list<pair<int,int> >::iterator Ite = path.begin();
		int id1 = Ite->first;
		int ht1 = Ite->second;
		++Ite;
		for( ; Ite != path.end(); ++Ite ) {
			pair<int,int> p2;
			int id2 = Ite->first;
			int ht2 = Ite->second;
			Contig con2;
			con2 = this_idconmap[id2];
			if(ht2 == 1){
				con2.reverse();
				p2 = make_pair(id2, 0);
			}else
				p2 = make_pair(id2, 1);

			
	
			Con_Ve.push_back(con2);
			int overlap;
			if(ht1 == 0){
				
				overlap = this_lmap[id1].Head_Id_Ov_Ma[p2];
			}else if(ht1 == 1){
				
				overlap = this_lmap[id1].Tail_Id_Ov_Ma[p2];
			}
			OverVe.push_back(overlap);
			id1 = id2;
			ht1 = ht2;
		}
		n_contig = mergetocontig( Con_Ve, OverVe );
	



	}
}

void Filtaln( short_assembly_bank &assbank )
{
	map< int, map< int, Aln_id > >::iterator IteA;
	for ( IteA = assbank.IdAliMap.begin(); IteA != assbank.IdAliMap.end(); ++IteA ) {
		map< int, Aln_id >::iterator subite;
		for ( subite = IteA->second.begin(); subite != IteA->second.end(); ++subite ) {
			
			if ( assbank.IdAliMap[subite->first].empty() ) {
				assbank.IdAliMap[subite->first].insert( make_pair( IteA->first, subite->second ) );
			} else {
				if ( assbank.IdAliMap[subite->first].find( IteA->first ) == assbank.IdAliMap[subite->first].end() ) {
					assbank.IdAliMap[subite->first].insert( make_pair( IteA->first, subite->second ) );
				} else {
					if ( assbank.IdAliMap[subite->first][IteA->first] != subite->second ) {
						assbank.IdAliMap[subite->first][IteA->first] = subite->second;
					}
				}
			} 
		}
	}
}


vector<E_Link> elinkform(map<int, C_Link> &lmap, map<int, Contig> &idconmap)
{
	vector<E_Link> elinkve;

	set<pair<int, int> > used;
	map<int, C_Link>::iterator IteLM;
	for(IteLM = lmap.begin(); IteLM != lmap.end(); ++IteLM){

		int id1 = IteLM->first;
		set<pair<int, int> >::iterator Iteh;
		pair<int, int> p1 = make_pair(id1, 0);
		for(Iteh = IteLM->second.head_links.begin(); Iteh != IteLM->second.head_links.end(); ++Iteh){
			if(used.find(*Iteh) != used.end())
				continue;
			E_Link Ob;
			Ob.configs = 0;
			pair<int, int> p2 = *Iteh;
			int id2 = p2.first;
			Ob.id1 = id1;
			Ob.id2 = id2;
			Ob.ht1 = 0;
			Ob.ht2 = p2.second;
			Ob.de1 = (int)IteLM->second.head_links.size();    
		
			Ob.overlap_length = IteLM->second.Head_Id_Ov_Ma[p2];
			int tg = 0;
			if(Ob.ht2 == 0){
				
					Ob.de2 = (int)lmap[id2].head_links.size();    
					Contig con1 = idconmap[id1];
					Contig con2 = idconmap[id2];
					con2.reverse();
				
					tg = 1;
				
			}
			if(Ob.ht2 == 1){
				
						Ob.de2 = (int)lmap[id2].tail_links.size();   
						Contig con1 = idconmap[id1];
						Contig con2 = idconmap[id2];
					
						tg = 1;

				
			}
			
			Ob.length1 = idconmap[id1].RelposList.back().second;
			Ob.length2 = idconmap[id2].RelposList.back().second;
		
			elinkve.push_back(Ob);
		}
		used.insert(p1);

		set<pair<int, int> >::iterator Itet;
		p1 = make_pair(id1, 1);
		for(Itet = IteLM->second.tail_links.begin(); Itet != IteLM->second.tail_links.end(); ++Itet){
			if(used.find(*Itet) != used.end())
				continue;
			E_Link Ob;
			Ob.configs = 0;
			pair<int, int> p2 = *Itet;
			int id2 = p2.first;
			Ob.id1 = id1;
			Ob.id2 = id2;
			Ob.ht1 = 1;
			Ob.ht2 = p2.second;
			Ob.de1 = (int)IteLM->second.tail_links.size();   
			Ob.de2 = lmap[id2].degree;
			Ob.overlap_length = IteLM->second.Tail_Id_Ov_Ma[p2];
			int tg = 0;
			if(Ob.ht2 == 0){
				
					Ob.de2 = (int)lmap[id2].head_links.size();    
					Contig con1 = idconmap[id1];
					con1.reverse();
					Contig con2 = idconmap[id2];
					con2.reverse();
				
					tg = 1;
				
			}
			if(Ob.ht2 == 1){
				
						Ob.de2 = (int)lmap[id2].tail_links.size();    
						Contig con1 = idconmap[id1];
						con1.reverse();
						Contig con2 = idconmap[id2];
					
						tg = 1;

				
			}
			
			Ob.length1 = idconmap[id1].RelposList.back().second;
			Ob.length2 = idconmap[id2].RelposList.back().second;
	
			elinkve.push_back(Ob);
		}
		used.insert(p1);
	}
	used.erase(used.begin(), used.end());


	return elinkve;
}

void domain_pro( map<int, C_Link> &lmap, map<int, Contig> &idconmap, M_sol & sol_ob )
{

	vector<E_Link> elinkve;
	elinkve = elinkform(lmap, idconmap);

	Domain D_ob(elinkve, sol_ob, 0);      

	D_ob.process();

	vector<E_Link> deletelinks = D_ob.deletelink;
	

	elinkdelete(deletelinks, lmap);

	merge_to_unitig(idconmap, lmap);
}

void elinkdelete(vector<E_Link> & deletelinks, map<int, C_Link> &lmap)
{
	for(int i = 0; i < (int)deletelinks.size(); ++i){
		int id1 = deletelinks[i].id1;
		int id2 = deletelinks[i].id2;
		int ht1 = deletelinks[i].ht1;
		int ht2 = deletelinks[i].ht2;
		pair<int, int> p1 = make_pair(id1, ht1);
		pair<int, int> p2 = make_pair(id2, ht2);
	
		
		if(ht1 == 0){
			
			lmap[id1].head_links.erase(p2);
			lmap[id1].Head_Id_Len_Ma.erase(p2);
			lmap[id1].Head_Id_Ov_Ma.erase(p2);
			multimap<int, pair<int, int> >::iterator IteHM;
			for(IteHM = lmap[id1].Head_Len_Id_Ma.begin(); IteHM != lmap[id1].Head_Len_Id_Ma.end(); ++IteHM){
				if(IteHM->second == p2){
					lmap[id1].Head_Len_Id_Ma.erase(IteHM);
					break;
				}
			}
		}else if(ht1 == 1){
			
			lmap[id1].tail_links.erase(p2);
			lmap[id1].Tail_Id_Len_Ma.erase(p2);
			lmap[id1].Tail_Id_Ov_Ma.erase(p2);
			multimap<int, pair<int,int> >::iterator IteTM;
			for(IteTM = lmap[id1].Tail_Len_Id_Ma.begin(); IteTM != lmap[id1].Tail_Len_Id_Ma.end(); ++IteTM){
				if(IteTM->second == p2){
					lmap[id1].Tail_Len_Id_Ma.erase(IteTM);
					break;
				}
			}
		}

		
		if(ht2 == 0){
			
			lmap[id2].head_links.erase(p1);
			lmap[id2].Head_Id_Len_Ma.erase(p1);
			lmap[id2].Head_Id_Ov_Ma.erase(p1);
			multimap<int, pair<int, int> >::iterator IteHM;
			for(IteHM = lmap[id2].Head_Len_Id_Ma.begin(); IteHM != lmap[id2].Head_Len_Id_Ma.end(); ++IteHM){
				if(IteHM->second == p1){
					lmap[id2].Head_Len_Id_Ma.erase(IteHM);
					break;
				}
			}
		}else if(ht2 == 1){
			
			lmap[id2].tail_links.erase(p1);
			lmap[id2].Tail_Id_Len_Ma.erase(p1);
			lmap[id2].Tail_Id_Ov_Ma.erase(p1);
			multimap<int, pair<int, int> >::iterator IteTM;
			for(IteTM = lmap[id2].Tail_Len_Id_Ma.begin(); IteTM != lmap[id2].Tail_Len_Id_Ma.end(); ++IteTM){
				if(IteTM->second == p1){
					lmap[id2].Tail_Len_Id_Ma.erase(IteTM);
					break;
				}
			}
		}
	}
}

