#ifndef SHORT_ASSEMBLY_H
#define SHORT_ASSEMBLY_H

#include "kmer.h"
#include "calignment.h"
#include "contig.h"
#include "ovl.h"
#include "assemblybank.h"
#include "link.h"
#include "layout_cons_exchange.h"
#include "output.h"
#include "correct_err.h"
#include "Trans_to_graph.h"
#include "Con_Qual.h"
#include "supplement_Gap.h"
#include "omp.h"
#include "matrixsol.h"
#include "domain.h"

using namespace std;

void short_last_assembly( short_assembly_bank &assbank,
						 vector< pair<string, string > >& IdSeqVe, 
						 vector< vector<int> > &Qualve,
						 int inovlenth,
						 double in_er_thr,
						 double in_er_thr_100,
						 double in_er_thr_50,
						 double in_snprate,
						 M_sol & inob,
						 bool syma,
						 int inwl,
						 int kmer_len,
						 int kmer_num,
						 int numb,
						 int max_thread_num,
						 map<int, pair<int, pair<int, int> > > &Pairs,
						 int tig_len, int mate_len, int mate_len_var, int mate_type, Graph_parameter &para );

void buildnet( int ovlen_thr, map< int, C_Link > &L_Map, short_assembly_bank &assbank );

void buildnet(int ovlenthr, double errorthr, double er_thr_100, double er_thr_50, double snprate, map< int, C_Link > &L_Map, short_assembly_bank &assbank );

void hideinalign(map<int, C_Link> &lmap,
				 map<int, Contig> &idconmap,
				 vector< pair<string, string > >& IdSeqVe,
				 map< int, map<int, Aln_id> > &IdAliMap,
				 multimap<int, Aln_id> &InalignMap );

void simplifynet(map<int, C_Link> &lmap);

pair<set<int>, set<pair<pair<int, int>, pair<int, int> > > > check_redundance(int id, set<int> &walked, map<int, C_Link>& lmap);

void edge_reduce(set<pair<pair<int, int>, pair<int, int> > > &redundant, map<int, C_Link> &lmap);

void red_sel_rev_link(map<int, C_Link> &lmap);

int merge_to_unitig(map<int, Contig> & idconmap, map<int, C_Link> & lmap);

map<int, C_Link> replace_L_Map2(map<pair<int, int>, pair<int,int> > &v_p, vector<list<pair<int, int> > > & unitigVe, map<int, C_Link> &lmap);

map< int, Contig > mergecontig(vector<list<pair<int, int> > > & unitigVe, map<int, Contig> & this_idconmap, map<int, C_Link> &this_lmap);

Contig mergetocontig(vector<Contig> & ConVe, vector<int> &overVe);

void Addinalign( Contig &con, multimap<int, Aln_id> &InalignMap, map<Aln_id, Calignment> &AlnMap );

void graph_process( short_assembly_bank &assbank, map<int, C_Link> & L_map, map<int, Contig> & Idconmap,
				   map<int, pair<int, pair<int, int> > > &Pairs,
				   int tig_len, int mate_len, int mate_len_var, int mate_type, Graph_parameter &para );

void add_single_to_bank( int id, Assembly_bank &bank );

vector<map<int, C_Link> > lmapcluster(std::map<int,C_Link> &lmap);

void ass_from_path_to_contig( Assembly_bank &bank, map< int, Contig > &idconmap, map< int, C_Link > &lmap );

void ass_from_path_to_contig_t( list< pair< int, int > > &path, Contig &n_contig, map< int, Contig > &this_idconmap, map< int, C_Link > &this_lmap );

void Filtaln( short_assembly_bank &assbank );            // for parallel calculating the overlap

void elinkdelete(vector<E_Link> & deletelinks, map<int, C_Link> &lmap);
vector<E_Link> elinkform(map<int, C_Link> &lmap, map<int, Contig> &idconmap);
void domain_pro( map<int, C_Link> &lmap, map<int, Contig> &idconmap, M_sol & inob );

#endif

