#include "supplement_Gap.h"

void supplement_gap( Supertig_bank &tig_bank, 
					vector< list< pair< int, int > > > &final_path,
					map< Supertig_id, int > &rev_trans_map,
					map<int, C_Link> &lmap, 
					map< int, Contig > &idconmap, 
					map<int, pair<int, pair<int, int> > > &Pairs,
					map< int, map< int, Aln_id > > &IdAliMap,
					map< int, map<int, multimap<int, Aln_id, greater<int> > > > &MulIdAliMap,
					map< Aln_id, Calignment > &Aln_Map )
{

	vector< list< pair< int, int > > > con_pathve;
	vector< vector< list< pair< int, int > > > > broken_pathve;
	vector< vector< pair< pair< int, int >, pair< int, int > > > > broken_p_ve;
	vector< vector< int > > broken_gap_ve;
	set< int > single;

	for ( size_t i = 0; i < tig_bank.con_pathve.size(); ++i ) {
		list< pair< int, int > > nconpathve;
		if ( rev_trans_pl( tig_bank.con_pathve[i], rev_trans_map, nconpathve ) ) {
			con_pathve.push_back( nconpathve );
		} else {
			cout<<"error transfer wrong! in supplement gap"<<endl; exit(1);
		}

	}

	final_path = con_pathve;

	for ( size_t i = 0; i < tig_bank.broken_pathve.size(); ++i ) {
		 vector< list< pair< int, int > > > broken_p;
		 for ( size_t j = 0; j < tig_bank.broken_pathve[i].size(); ++j ) {
			 list< pair< int, int > > b_p;
			 if ( rev_trans_pl( tig_bank.broken_pathve[i][j], rev_trans_map, b_p ) ) {
				 broken_p.push_back( b_p );
			 } else {
				 cout<<"error transfer wrong! in supplement gap"<<endl; exit(1);
			 }
		 }
		 broken_pathve.push_back( broken_p );
	}
	for ( size_t i = 0; i < tig_bank.broken_p_ve.size(); ++i ) {
		vector< pair< pair< int, int >, pair< int, int > > > br_p;
		for ( size_t j = 0; j < tig_bank.broken_p_ve[i].size(); ++j ) {
			if ( rev_trans_map.find( tig_bank.broken_p_ve[i][j].first.first ) == rev_trans_map.end() || 
				 rev_trans_map.find( tig_bank.broken_p_ve[i][j].second.first ) == rev_trans_map.end() ) {
				cout<<"error no map to revtransmap "<<endl;   exit(1);
			}
			br_p.push_back( make_pair( make_pair( rev_trans_map[tig_bank.broken_p_ve[i][j].first.first], tig_bank.broken_p_ve[i][j].first.second ),
				make_pair( rev_trans_map[tig_bank.broken_p_ve[i][j].second.first], tig_bank.broken_p_ve[i][j].second.second ) ) );
		}
		broken_p_ve.push_back( br_p );
	}
	set< Supertig_id >::iterator Ites;
	for ( Ites = tig_bank.Single_tig_Set.begin(); Ites != tig_bank.Single_tig_Set.end(); ++Ites ) {
		if ( rev_trans_map.find( *Ites ) == rev_trans_map.end() ) {
			cout<<"error no map to revtransmap "<<endl;   exit(1);
		}
		single.insert( rev_trans_map[*Ites] );
	}

	broken_gap_ve = tig_bank.broken_gap_ve;

	

	vector< list< pair< int, int > > > npve;

	for ( size_t i = 0; i < broken_pathve.size(); ++i ) {
	
		set< size_t > cn;
		for ( size_t j = 0; j < broken_p_ve[i].size(); ++j ) {
			pair< int, int > frontp = broken_p_ve[i][j].first;
			pair< int, int > backp = broken_p_ve[i][j].second;
		
			if ( lmaplink( frontp, backp, lmap ) ) {
				cn.insert( j );
			
				continue;
			}
			pair< int, int > leftp = getheadread( idconmap, frontp );
			pair< int, int > rightp = gettailread( idconmap, backp );
			int gap = broken_gap_ve[i][j];
		
			if ( gap > 1000 )
				continue;
			gap = gap * (-1);
			if ( gap < 0 ) {
				gap = 0;
			}
			int overlap = checkalign( leftp, rightp, gap, IdAliMap, MulIdAliMap, Aln_Map );
			if ( overlap > 0 ) {
				addlmaplink( frontp, backp, overlap, lmap );
			
				cn.insert( j );
				continue;
			}
		}
		list< pair< int, int > > np;
		np = broken_pathve[i][0];
		for ( size_t j = 1; j < broken_pathve[i].size(); ++j ) {
			if ( cn.find( j - 1 ) != cn.end() ) {
				np.insert( np.end(), broken_pathve[i][j].begin(), broken_pathve[i][j].end() );
			
			} else {
			
				npve.push_back( np );
				np = broken_pathve[i][j];
			}
		}
		npve.push_back( np );
	}

	final_path.insert( final_path.end(), npve.begin(), npve.end() );

	set< int >::iterator si;
	for ( si = single.begin(); si != single.end(); ++si  ) {
		list< pair< int, int > > sp;
		sp.push_back( make_pair( *si, 0 ) );
		final_path.push_back( sp );
	}

	reduceredunpl_t( final_path );

}

bool lmaplink( pair< int, int > frontp, pair< int, int > backp, map<int, C_Link> &lmap )
{
	if ( lmap.find( frontp.first ) != lmap.end() ) {
		if ( frontp.second == 0 ) {
			if ( lmap[frontp.first].head_links.find( reversepht(backp) ) != lmap[frontp.first].head_links.end() )
				return true;

		} else {
			if ( lmap[frontp.first].tail_links.find( reversepht(backp) ) != lmap[frontp.first].tail_links.end() )
				return true;
		}
	} else {
		cout<<"error lmap no find "<<frontp.first<<endl;  exit(1);
	}

	return false;
}

pair<int,int> getheadread( map< int, Contig > &idconmap, pair<int,int> Conid )
{
	if ( idconmap.find( Conid.first ) == idconmap.end() ) {
		cout<<"error in getbackread "<<endl;  exit(1);
	}

	int rid = 0;
	int forb = 0;
	if ( Conid.second == 0 ) {
		rid = idconmap[Conid.first].getheadid();
		forb = idconmap[Conid.first].getheadhort();
	} else {
		rid = idconmap[Conid.first].gettailid();
		forb = reverseforb( idconmap[Conid.first].gettailhort() );
	}

	return make_pair( rid, forb );


}

pair<int,int> gettailread( map< int, Contig > &idconmap, pair<int,int> Conid )
{
	if ( idconmap.find( Conid.first ) == idconmap.end() ) {
		cout<<"error in getbackread "<<endl;  exit(1);
	}

	int rid = 0;
	int forb = 0;
	if ( Conid.second == 0 ) {
		rid = idconmap[Conid.first].gettailid();
		forb = idconmap[Conid.first].gettailhort();
	} else {
		rid = idconmap[Conid.first].getheadid();
		forb = reverseforb( idconmap[Conid.first].getheadhort() );
	}

	return make_pair( rid, forb );


}


int checkalign( pair< int, int> leftp, pair< int, int> rightp,
				int len,
				map< int, map< int, Aln_id > > &IdAliMap,
				map< int, map<int, multimap<int, Aln_id, greater<int> > > > &MulIdAliMap,
				map< Aln_id, Calignment > &Aln_Map )
{
	if ( IdAliMap.find( leftp.first ) != IdAliMap.end() ) {
		if ( IdAliMap[leftp.first].find( rightp.first ) != IdAliMap[leftp.first].end() ) {
			Calignment cob = Aln_Map[IdAliMap[leftp.first][rightp.first]];
			int overlap = checkalign_t( leftp, rightp, cob );
			if ( overlap > 0 ) {
				if ( len > 0 ) {
					if ( overlap - len <= 20 || overlap - len >= -20 ) {
						return overlap;
					} 
				}else {
					return overlap;
				}
			}
			
		}
	}

	if ( MulIdAliMap.find( leftp.first ) != MulIdAliMap.end() ) {
		if ( MulIdAliMap[leftp.first].find( rightp.first) != MulIdAliMap[leftp.first].end() ) {
			multimap<int, Aln_id, greater<int> >::iterator Item;
			int mins = 10000;
			Aln_id cob_id;
			bool find = false;
			for ( Item = MulIdAliMap[leftp.first][rightp.first].begin(); Item != MulIdAliMap[leftp.first][rightp.first].end(); ++Item ) {

				int overlap = checkalign_t( leftp, rightp, Aln_Map[Item->second] );
				if ( overlap > 0 ) {
					if ( len > 0 ) {
						int s = abs( overlap - len );
						if ( s < mins ) {
							cob_id = Item->second;
							find = true;
							mins = s;
						}
					} else {
						IdAliMap[leftp.first][rightp.first] = Item->second;
						IdAliMap[rightp.first][leftp.first] = Item->second;
						return overlap;
					}
				}
			}
			if ( find ) {
				IdAliMap[leftp.first][rightp.first] = cob_id;
				IdAliMap[rightp.first][leftp.first] = cob_id;
				return Aln_Map[cob_id].score;
			}
		}
	}
	return 0;
}

int checkalign_t( pair< int, int> leftp, pair< int, int> rightp, Calignment &cob )
{

	if ( cob.id1 == leftp.first ) {
		if ( cob.forb1 == leftp.second ) {
			if ( cob.forb2 == rightp.second ) {
				if ( cob.r == 0 ) {
					return cob.score;
				}
			}
		} else {
			if ( cob.forb2 != rightp.second ) {
				if ( cob.r == 1 ) {
					return cob.score;
				}
			}
		}
	} else {
		if ( cob.forb2 == leftp.second ) {
			if ( cob.forb1 == rightp.second ) {
				if ( cob.r == 1 ) {
					return cob.score;
				}
			}
		} else {
			if ( cob.forb1 != rightp.second ) {
				if ( cob.r == 0 ) {
					return cob.score;
				}
			}
		}
	}

	return 0;
}

void addlmaplink( pair< int, int > &leftp, pair< int, int > &rightp, int ovlen, map<int, C_Link> &lmap )
{
	if ( leftp.second == 0 ) {
		lmap[leftp.first].head_links.insert( reversepht( rightp ) );
		lmap[leftp.first].Head_Id_Ov_Ma.insert( make_pair( reversepht( rightp ), ovlen ) );
	} else {
		lmap[leftp.first].tail_links.insert( reversepht( rightp ) );
		lmap[leftp.first].Tail_Id_Ov_Ma.insert( make_pair( reversepht( rightp ), ovlen ) );
	}

	if ( rightp.second == 0 ) {
		lmap[rightp.first].tail_links.insert( leftp );
		lmap[rightp.first].Tail_Id_Ov_Ma.insert( make_pair( leftp, ovlen ) );
	} else {
		lmap[rightp.first].head_links.insert( leftp );
		lmap[rightp.first].Head_Id_Ov_Ma.insert( make_pair( leftp, ovlen ) );
	
	}

	
}

void Trans_path_to_assbank( vector< list< pair< int, int > > > &pathve,  Assembly_bank &assbank )
{
	for ( size_t i = 0; i < pathve.size(); ++i ) {
		Contig_bank cbank;
		cbank.path_from_graph = pathve[i];

		Contig_id n_id;
		if ( assbank.Contig_map.empty() )
			n_id = 1;
		else
			n_id = assbank.Contig_map.rbegin()->first + 1;
		
		if( assbank.Contig_map.find( n_id ) != assbank.Contig_map.end() ) {
			cerr << "Warning in  func trans_graph_to_assbank: n_id n_id already exist tig_bank.Supertig_Map " <<endl;
		
		}
		assbank.Contig_map.insert( make_pair( n_id, cbank ) );
	}
}
