#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <algorithm>

using namespace std;

#define IN
#define OUT
#define INOUT

void change(INOUT string& str);
void split(IN string const& strSrc, IN string const& strDelimiters, OUT vector<string >& vctDst);

int main()
{
    string temp;
    vector<string > vtemp;
    ifstream in("tempread.reverse");
    ofstream out("tempread.s.reverse");

    while(getline(in,temp))
    {
	    vtemp.clear();
        split(temp," \t",vtemp);
	    change(vtemp[5]);
	    out << vtemp[0] << "\t" << vtemp[1] << "\t" << vtemp[2] <<"\t" << vtemp[3] << "\t" << vtemp[4] << "\t" << vtemp[5] << endl;
    }
}

void change(INOUT string& str)
{
        unsigned int i;

        for (i = 0; i < str.size(); ++i)
        {
                switch(str[i])
                {
                case 'a': str[i] = 'T'; break;
        		case 'A': str[i] = 'T'; break;
                case 'c': str[i] = 'G'; break;
		        case 'C': str[i] = 'G'; break;
                case 't': str[i] = 'A'; break;
		        case 'T': str[i] = 'A'; break;
                case 'g': str[i] = 'C'; break;
		        case 'G': str[i] = 'C'; break;
                }
        }

        reverse(str.begin(), str.end());
}

void split(IN string const& strSrc, IN string const& strDelimiters, OUT vector<string >& vctDst)
{
        string::size_type pos1, pos2;
        pos2 = 0;
        while(true)
        {
                pos1 = strSrc.find_first_not_of(strDelimiters, pos2);
                if (pos1 == string::npos) break;
                pos2 = strSrc.find_first_of(strDelimiters, pos1 + 1);
                if (pos2 == string::npos)
                {
                        vctDst.push_back(strSrc.substr(pos1));
                        break;
                }
                vctDst.push_back(strSrc.substr(pos1, pos2 - pos1));
                ++pos2;
        }
}

