#ifndef DETECT_H
#define DETECT_H

#include <string>
#include <vector>
#include <map>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <cmath>
#include <iomanip>
using namespace std;

#define IN
#define OUT
#define INOUT

///////////////

#define INPUT_FILE			        "tempco"
#define INV_FILE					"output_inv"	
#define OUTPUT_FILE_I				"output_i"
#define FIND_NPOS					0xffffffff
#define FLAG_FORWARD				"+"
#define FLAG_BACKWARD				"-"
#define SHOW_ERROR								cout << "error: \"" << __FILE__ << "\"(" << __LINE__ << ")" << endl
#define C_RET_FALSE								{SHOW_ERROR; return false;}
#define C_GOTO_END								{SHOW_ERROR; goto L_End;}
/* --------------------------------------------------------------------------------------------------------- */

typedef struct _record_info
{
	string head;
	string chr;
	string read;
	string ref;
	string start;
	string end;
	string flag;
}_record_info;

typedef struct _ana_info_node
{
	string flag;
	int subStart, subEnd;
	int mainStart, mainEnd;
	int errorNum;
	int matchNum;
}_ana_info_node;

typedef struct _ana_info
{
	string head;
	string chr;
	unsigned int chrSize;
	string read;
	string ref;
	string start;
	string end;
	string flag;

	vector<_ana_info_node > vctNode_0;
	vector<_ana_info_node > vctNode_1;

	vector<_ana_info_node > vctResult;

}_ana_info;

typedef struct _match_all_info
{
	unsigned char pos;
	unsigned int mainStart, mainEnd;
	unsigned int subStart;

}_match_all_info;

typedef struct _match_one_info
{
	vector<unsigned int > vctPos;

}_match_one_info;

typedef struct _start_end
{
	unsigned int start;
	unsigned int end;

}_start_end;

typedef struct _stack_info
{
	unsigned int pos;
	unsigned int curPos;
	vector<bool > vctAttr;

}_stack_info;


/* --------------------------------------------------------------------------------------------------------- */

bool Start(IN string const& strWorkDir);
int GetRecord(ifstream& ifs, OUT _record_info& ri);
bool Step1(IN _record_info const& ri, OUT _ana_info& ai);
void MatchAll(string const& mainStr, string const& subStr, unsigned int errorNum, OUT vector<_match_all_info >& vctMai);
void MatchAll_1(string const& mainStr, string const& subStr, unsigned int errorNum, OUT vector<_match_all_info >& vctMai);
void Add_0(IN vector<_match_all_info > const& vctMai, IN unsigned int subLen, IN unsigned int mainLen, IN  _ana_info& ai, IN unsigned int errorNum, OUT vector<_ana_info_node >& vctNode);
void Add_1(IN vector<_match_all_info > const& vctMai, IN unsigned int subLen, IN unsigned int mainLen, IN  _ana_info& ai, IN unsigned int errorNum, OUT vector<_ana_info_node >& vctNode);
void Change(INOUT string& str);
void Match(IN string const& mainStr, IN string const& subStr, IN unsigned int errorNum, OUT _match_one_info& moi);
void Match_1(IN string const& mainStr, IN string const& subStr, IN unsigned int errorNum, OUT _match_one_info& moi);
unsigned int WordFind(string const& subStr, string word);

unsigned int StrFind(string const& mainStr, string const& subStr, IN unsigned int errorNum, unsigned int posf);

///////////////

bool Step2(INOUT _ana_info& ai);
void GetErrorNum_0(string const& strRead, string const& strRef, INOUT vector<_ana_info_node >& vctNode);
void GetErrorNum_1(string const& strRead, string const& strRef, INOUT vector<_ana_info_node >& vctNode);
unsigned int MisFind(string const& subStr, string const& mainStr, unsigned int subStart, unsigned int mainStart, unsigned int len);
void Merge(INOUT vector<_ana_info_node >& vctNode);
bool SortSub(_ana_info_node const& elem1, _ana_info_node const& elem2);

///////////////

bool Step3(_ana_info& ai, OUT vector<_ana_info_node >& vctNode);
bool IsOverlap(_ana_info_node const& node1, _ana_info_node const& node2);
int  getScore(_ana_info_node const& node);
int computePay(_ana_info_node const& node1, _ana_info_node const& node2);
int computePay(_ana_info_node const& node1, unsigned int mainLen);
int computePay(_ana_info_node const& node1);
void GetBestCombination(vector<_ana_info_node >& vctNode, unsigned int mainLen);

///////////////

void Output(ofstream& ofii, ofstream& ofsi, _ana_info& ai);
void OutputInvInfo(ofstream &ofs, _ana_info& ai, vector<_ana_info_node >& vctNode);
void OutputAnaInfo(ofstream& ofs, _ana_info& ai);
void OutputVctNode(ofstream& ofs, _ana_info const& ai, vector<_ana_info_node > const& vctNode);
bool IsOutput_i(_ana_info& ai);

///////////////

void Split(IN string const& strSrc, IN string const& strDelimiters, OUT vector<string >& vctDst);
string Trim(string const& str, string const& strCharacters);

#endif	
