#include <string>
#include <vector>
#include <map>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <cmath>
using namespace std;

#define IN
#define OUT
typedef struct _inv_info
{
        string name;
        string chr;
        unsigned int start;
        unsigned int end;
        unsigned int len;
        string seq;
}_inv_info;

void Split(IN string const& strSrc, IN string const& strDelimiters, OUT vector<string >& vctDst);

int main()
{
    ifstream in("output_inv");
	ofstream out("o_inv");
	string temp;
	vector<_inv_info> vctInv;
	vector<string> vctTemp;

	while(getline(in, temp))
	{
		vctTemp.clear();
		Split(temp, " \t", vctTemp);
		vctInv.push_back(_inv_info());
		vctInv.back().name = vctTemp[0];
		vctInv.back().chr = vctTemp[1];
		vctInv.back().start = atoi(vctTemp[2].c_str());
		vctInv.back().end = atoi(vctTemp[3].c_str());
		vctInv.back().len = atoi(vctTemp[4].c_str());
		vctInv.back().seq = vctTemp[5];
		
	}
	unsigned int j = 0;
	for(unsigned int i = 1; i < vctInv.size(); ++i)
	{
		if((vctInv[j].chr == vctInv[i].chr) && (vctInv[j].end >= vctInv[i].start))
		{
			if(vctInv[j].len < vctInv[i].len)
			{
				vctInv[j] = vctInv[i];
			}
		}
		else 
		{
			j++;
			vctInv[j] = vctInv[i];
		}
	}
	vctInv.erase(vctInv.begin() + j + 1, vctInv.end());
	
	for(unsigned int i = 0; i < vctInv.size(); ++i)
	{
		out << vctInv[i].name << "	" << vctInv[i].chr << "	" <<vctInv[i].start << "	" << vctInv[i].end << "	" << vctInv[i].len << "	" << vctInv[i].seq << endl;
	}
        cout << "OK!" << endl;
        return 0;

}

void Split(IN string const& strSrc, IN string const& strDelimiters, OUT vector<string >& vctDst)
{
        string::size_type pos1, pos2;
        pos2 = 0;
        while(true)
        {
                pos1 = strSrc.find_first_not_of(strDelimiters, pos2);
                if (pos1 == string::npos) break;
                pos2 = strSrc.find_first_of(strDelimiters, pos1 + 1);
                if (pos2 == string::npos)
                {
                        vctDst.push_back(strSrc.substr(pos1));
                        break;
                }
                vctDst.push_back(strSrc.substr(pos1, pos2 - pos1));
                ++pos2;
        }
}


