//	created:	2008-11-17
//  author:		Jiangtao Guo
//	Metagenome TIS prediction

#include <ctime>
#include "TypeDef.h"
#include "SequenceTransform.h"
#include "OftenUsedOperatLib.h"
#include "Metagenome.h"

using   namespace   std;

string shotgunSeqFile, shotgunLocationsFile, binnedFile, bin_model_file, taxon_map_file, prioriparameters;
string binnedResult = "binned.txt";
string resultFile = "metagenome.med";
std::string resultFormat = "GFF"; 

void exit_with_help()
{
	cout<< "Usage: MetaTISA [-s shotgunSeqFile] [-l shotgunLocationsFile] [-b binnedFile]\n"
		<< "                [-m bin_model_file] [-t taxon_map_file ] \n"
		<< "                [-p priori parameters] [-o resultFile] \n"
		<< "                [-f resultFormat]\n\n"
		<< "Options:\n"
		<< "  -s shotgunSeqFile       metagenome sequence file in FASTA format\n"
		<< "  -l shotgunLocationsFile CDS Location file predicted by certain gene predictor\n"
		<< "  -m bin_model_file       file stored the binning model\n"
		<< "  -t taxon_map_file       file stored the taxonomic map\n"
		<< "  -p priori parameters	  priori parameters for PWM\n"
		<< "  -o resultFile           result Filename, 'metagenome.gff' by default\n"
		<< "  -f resultFormat         Format of result file, currently MED and GFF available, 'GFF' by default\n";
	exit(1);
}

int main(
		  int argc, char* argv[]
		  )
{
	//parse options
	int i = 1;
	for(; i<argc; ++i)
	{
		if(argv[i][0] != '-') continue;
		if(++i >= argc) 
		{
			cout << "Not specified option " << argv[i-1] << endl;
			exit_with_help();
		}
		switch(argv[i-1][1])
		{
		case 's' : 
			shotgunSeqFile = string(argv[i]);
			break;
		case 'l' :
			shotgunLocationsFile = string(argv[i]);
			break;
		case 'm' :
			bin_model_file = string(argv[i]);
			break;
		case 't' :
			taxon_map_file = string(argv[i]);
			break;
		case 'p' :
			prioriparameters = string(argv[i]);
			break;
		case 'f' :
			resultFormat = string(argv[i]);
			if (resultFile == "metagenome.med")
			{
				if (resultFormat == "MED" || resultFormat =="med")
					resultFile = "metagenome.med";
				else 
					resultFile = "metagenome.gff";
			}
			break;
		case 'o' :
			resultFile = string(argv[i]);
			break;
		default :
			cout << "Unknown Option!" << endl;
			exit_with_help();
		}
	}
	if(i>argc) exit_with_help();

	if(shotgunSeqFile.empty())
	{
		cout<< "Not enough arguments:\n"
			<< "     shotgunSeqFile is not defined\n";
		exit_with_help();
	}
	if(shotgunLocationsFile.empty())
	{
		cout<< "Not enough arguments:\n"
			<< "     shotgunLocationsFile is not defined\n";
		exit_with_help();
	}
	if(bin_model_file.empty())
	{
		cout<< "Not enough arguments:\n"
			<< "     bin model file is not defined\n";
		exit_with_help();
	}
	if(taxon_map_file.empty())
	{
		cout<< "Not enough arguments:\n"
			<< "     taxon map file is not defined\n";
		exit_with_help();
	}
	if(prioriparameters.empty())
	{
		cout<< "Not enough arguments:\n"
			<< "     priori parameters is not defined\n";
		exit_with_help();
	}

	TIS_T MetagenomeTIS;
	MetagenomeTIS.prioriparameters = prioriparameters;

	cout << "Getting Seqs..." << endl;	
	MetagenomeTIS.getSeqs( shotgunSeqFile );

	cout << "Binning Seqs..." << endl;
	MetagenomeTIS.getGenusId_from_beginning(shotgunSeqFile, bin_model_file, taxon_map_file);
	
	cout << "Output Binned result..." << endl;
	MetagenomeTIS.outGenusId( binnedResult );

	cout << "Getting CDS Locations..." << endl;
	MetagenomeTIS.getLocations( shotgunLocationsFile );
	
	cout << "Getting ORFSet..." << endl;
	MetagenomeTIS.getGenusORFSetMap();

	cout << "Getting Settings file..." << endl;
	MetagenomeTIS.initiateSettings();

	cout << "Revising TIS..." << endl;
	MetagenomeTIS.reviseTIS();
	
	cout << "Outputing result..." << endl;
	MetagenomeTIS.resultToFile(resultFile, resultFormat);

	return 0;
}

