#ifndef METAGENOME_H
#define METAGENOME_H

#include <math.h>
#include "TypeDef.h"
#include "SequenceTransform.h"
#include "OftenUsedOperatLib.h"

class Metagenome_T
{
public:
	std::map< Str, std::pair<Str,Str> > IdSeqMap;
	std::map< Str, std::vector<Location_T> > IdLocationMap;
	std::multimap< Str, Str > GenusIdMap;
	
	std::map< Str, std::vector<ORF_T> > GenusORFSetMap;

	void getSeqs( Str& seqsFilename );
	void getLocations( Str& LocationsFilename );
	void getGenusId_from_beginning (Str &seqsFilename, Str &bin_model_file, Str &taxon_map_file);
	void getGenusORFSetMap ();
	
	void outSeqs( Str& seqsFilename );
	void outLocations( Str& LocationsFilename );
	void outGenusId ( Str& GenusIdFilename );
	void outORFSet( Str& ORFSetFilename );

	M_D getMatrix( Str& MatrixFilename);
	void displayMatrix( const Matrix_T< double >& ma, std::ostream& out );
};

class TIS_T:public Metagenome_T
{
public:
	//Settings
	int UPBP, DOWNBP, MAXORDER, ORDER;
	int HaveHeadNumCutoff;
	Set_I STARTS, STOPS;
	
	//
	static const int maximalInterationNum = 15;

	//Paramters to be calculated
	M_D trueTIS, upFalse, downFalse;                              
	int maxCandidateN;
	double pFU, pFD, pT;      
	Ve_D qi;

	static const bool filter_on = true;
	double cutoff;   //жûͷORFUPBPԺһXTGǷcodingֵ
	std::string prioriparameters;

	//Initiate parameters
	void initiateSettings();
	void getprioriParameters( Str& genusName );
	void initiatePWMs( std::vector<ORF_T>& ORFSet ); //ģԤʱ򿪹

	void x2LongestORF( const char* seq, Pa_I_I& location );
	
	//Make prediction
	void reviseTIS_HaveHead_Enough( std::vector<ORF_T>& ORFSet,int HaveHeadNum );     //УͷORF ͷĿ㹻 ѧϰPWM
	void reviseTIS_HaveHead_NotEnough( std::vector<ORF_T>& ORFSet );				  //ͷĿ Ѿѧõgenus
	void reviseTIS_NoHead( std::vector<ORF_T>& ORFSet );
	void reviseTIS();	

	//load and save results                                                                                            
	void resultToFile( Str& resultFile, Str& resultFormat );                                                                                                                              
};

#endif

