/*
File loading and other commonly used function module 
Author: Longshu Yang
Latest update: 2013/11/20
Version: 1.0
*/

#ifndef COMMON_H
#define COMMON_H

#include "TypeDefBase.h"

static Str Base = "ACGT";
static int maxloop = 5000;

//Data Structure

struct ptt_item{//ptt annotation
	Str Strand;
	int begin;
    int end;
	int length;
	int num;
	Str	Gene;
    Str COG;
    Str Product;
};

typedef std::map<Str, ptt_item> Map_Str_ptt;

struct ptt{//all ptt file related information
	Map_Str_ptt anno;
	Map_Str_Str G2S;
	Map_Str_Str P2S;
	Map_I_Str N2S;
	Ve_Str order;
	int all_len;
};

struct threshold{//Thresholds for scanning TSS
	Ve_D ths;//threshold for short intergenic distance
	Ve_D thl;//threshold for long intergenic distance
};

struct sig{
	int wm1,wm2,min,dis,reg,time;
};

typedef std::vector<sig> Ve_sig;

struct Sig{
	Ve_sig para;
	Str Ty;
	int regi,regs;
};


typedef std::vector<std::vector<std::map<char, double> > > Ve_Ve_Map_C_D;

typedef std::vector<std::map<char, double> > Ve_Map_C_D;

typedef std::map<char, double> Map_C_D;

struct sc{//scoring schemes after EM iteration process
	Ve_Ve_D spacer;//spacer lengthes between weight matrices
	Ve_Ve_Map_C_D wm;// weight matrices
	Ve_D dis;//distance between start codon and first WM
	Ve_I min;//minimum spacer lengthes
};

typedef std::map<int, std::map<int, Str> > Map_I_Map_I_Str;

struct all{//to make the .ano file
	Str Species, Title, Num;
	Map_I_Map_I_Str content;
};

//Loading Functions

Str read_in_fna(Str In);//read in fna file

ptt read_in_ptt(Str In);//read in ptt file or rnt file or ano file

//Map_Str_rc read_in_rec(Str In);//read in rec file

Sig read_in_sig(Str In, bool WHI);

Ve_Str read_in_training(Str In);//read in training set

sc read_in_parameters(Str In);//read in scoring schemes calculated

all read_in_info(Str In);//read in .ptt and .rnt for integration 

threshold read_in_threshold(Str In);//read in thresholds for scanning TSS

Map_Str_Str read_in_list(Str In);

//Commonly Used Functions

template <typename T>
void convertFromNumber( std::string &s,T &value){
	 std::ostringstream ss(s);
	 ss<<value;
	 s = ss.str();
}

template <typename S>
void convertFromString(S &value,const std::string &s){
	 std::stringstream ss(s);
	 ss>>value;
}

Ve_Str string_parse(con_Str Line,con_Str Key);

Str double_strand(Str Forward);

char complement(char S);

double gc_content(Str Seq);

Ve_Str kmer(int w,Ve_Str seqs);

Ve_Map_C_D rate(Ve_Map_C_D w, Map_C_D bac);

Map_C_D assign(int a);

Ve_Map_C_D assign(Str Seq);

Ve_Map_C_D score_matrix(Ve_Map_C_D wm);

Str integrate(Str Ptt, Str Rnt, Str Out);

Ve_Str region(int reg, Str DNA, ptt Ptt);

De_I traversal(int i, Ve_I limit);

int dist(Str Synonym, ptt ano);

int out_range(Str Synonym, ptt ano);

Str direction(Str Synonym, ptt ano);

#endif