/*
Sigma Programme for predicting promoters related to a specific sigma factor 
Main function module
Author: Longshu Yang
Latest update: 2015/08/14
Version: 1.0
*/

#include "common.h"
#include "scan.h"
#include "one.h"
#include "two.h"
using namespace std;

int main(int argc, char *argv[]){
	Str Out, Tra, Ano, Fna, Para, Sigma, NC, DNA, Score, Ptt, Rnt, Thr;
	Ve_Str no;
	Map_Str_Str close;
	int reg, len;
	reg = len = 0;
	ptt ano;
	if(argc > 1){
		for(int i = 1; i < argc; i ++){
			//Input arguments
			Str Temp = argv[i];
			if(Temp == "-n")
				NC = argv[i + 1];
			else if(Temp == "-s")
				Para = argv[i + 1];
			/*else if(Temp == "-s1"){
				Sigma = argv[i + 1];
				signal = read_in_sig(Sigma, false);
			}*/
			else if(Temp == "-t")
				Tra = argv[i + 1];
			else if(Temp == "-o")
				Out = argv[i + 1];
			else if(Temp == "-f"){
				Fna = argv[i + 1];
				Fna += NC + ".fna";
				DNA = read_in_fna(Fna);
			}
			else if(Temp == "-a"){
				Ano = argv[i + 1];
				Ano += NC + ".ano";
				ano = read_in_ptt(Ano);
			}
			else if(Temp == "-w")
				Score = argv[i + 1];
			else if(Temp == "-p"){
				Ptt = argv[i + 1];
				Ptt += NC + ".ptt";
				ano = read_in_ptt(Ptt);
			}
			else if(Temp == "-r"){
				Rnt = argv[i + 1];
				Rnt += NC + ".rnt";
			}
			else if(Temp == "-h")
				Thr = argv[i + 1];
			else if(Temp == "-g"){
				Temp = argv[i + 1];
				convertFromString(reg, Temp);
			}
			else if(Temp == "-l"){
				Temp = argv[i + 1];
				convertFromString(len, Temp);
			}
			else if(Temp == "-u"){
				int j = i + 1;
				Temp = argv[j];
				int pos = Temp.find("-");
				while(pos == Str::npos){
					no.push_back(Temp);
					j ++;
					Temp = argv[j];
					pos = Temp.find("-");
				}
			}
			else if(Temp == "-c"){
				int j = i + 1;
				Temp = argv[j];
				int pos = Temp.find("-");
				while(pos == Str::npos){
					if(Temp == "Sigma70" || Temp == "Sigma38" || Temp == "Sigma32" || Temp == "Sigma24")
						close[Temp] = "closed";
					else
						cout<<"The parameter: "<<Temp<<" is not a standard input."
						<<" Please choose parameters from: Sigma70, Sigma38, Sigma32, Sigma24."<<endl;
					j ++;
					Temp = argv[j];
					pos = Temp.find("-");
				}
			}
			//Functional parameters
			/*else if(Temp == "-U"){
				int num = 0;
				ONEEM TSS;
				for(int i = 0; i < signal.para.size(); i ++){
					Str Num;
					convertFromNumber(Num,i);
					Str TSP = Out + NC + "." + signal.Ty + "." + Num + ".tss.par.dat";
					TSS = TSS_pre(signal.para[i], training, signal.Ty, TSP);
				}
			}*/
			else if(Temp == "-T"){
				for(int i = 0; i < 4; i ++){
					int num = 0;
					if(!i)
						Sigma = "Sigma70";
					else if(i == 1)
						Sigma = "Sigma32";
					else if(i == 2)
						Sigma = "Sigma24";
					else
						Sigma = "Sigma38";
					if(i < 3){
						TWOEM TSS;
						Str Pa = Para + Sigma + ".dat";
						Sig signal = read_in_sig(Pa, true);
						Str Tr = Tra + Sigma + ".dna";
						Ve_Str training = read_in_training(Tr);
						for(int i = 0; i < signal.para.size(); i ++){
							Str Num;
							convertFromNumber(Num,i);
							Str TSP = Out + Sigma + "." + Num + ".tss.par.dat";
							TSS = TSS2_pre(signal.para[i], training, Sigma, TSP);
						}
					}
					else{
						ONEEM TSS;
						Str Pa = Para + Sigma + ".dat";
						Sig signal = read_in_sig(Pa, false);
						Str Tr = Tra + Sigma + ".dna";
						Ve_Str training = read_in_training(Tr);
						for(int i = 0; i < signal.para.size(); i ++){
							Str Num;
							convertFromNumber(Num,i);
							Str TSP = Out + Sigma + "." + Num + ".tss.par.dat";
							TSS = TSS_pre(signal.para[i], training, Sigma, TSP);
						}
					}
				}
			}
			else if(Temp == "-S"){
				if(reg <= 0)
					reg = 250;
				if(len <= 0)
					len = 100;
				Out += NC + ".sca.dat";
				bool TITLE = false;
				Ofstream out(Out.data());
				out<<"Sigma\tSynonym\tIntergenic distance\tParallel gene distance\tRelation\tStart site\tFinal score";
				while(no.size() < 4)
					no.push_back("def");
				for(int i = 0; i < 4; i ++){
					if(!i)
						Sigma = "Sigma70";
					else if(i == 1)
						Sigma = "Sigma32";
					else if(i == 2)
						Sigma = "Sigma24";
					else
						Sigma = "Sigma38";
					if(close[Sigma] != "closed"){
						Str Scheme = Score + Sigma + "." + no[i] + ".tss.par.dat";
						sc scheme = read_in_parameters(Scheme);
						Str Th = Thr + Sigma + ".thr.dat";
						threshold thr = read_in_threshold(Th);
						if(!TITLE){
							for(int i = 0; i < scheme.wm.size(); i ++){
								if(!i)
									out<<"\t-10 region WM score\t-10 region WM sequence";//Title
								else
									out<<"\t-35 region WM score\t-35 region WM sequence";//Title
							}
							if(!scheme.min.empty()){
								for(int i = 0; i < scheme.min.size(); i ++){
									int s = scheme.min[i];		
									out<<"\tSpacer";
								}
							}
							out<<endl;
							TITLE = true;
						}
						Ve_pre pred = scan(Sigma, DNA, ano, scheme, reg, len, thr);
						for(int i = 0; i < pred.size(); i ++){
							out<<pred[i].Sigma<<"\t"<<pred[i].Synonym<<"\t"<<pred[i].dis<<"\t"<<pred[i].bound<<"\t"
								<<pred[i].Direction<<"\t"<<pred[i].site<<"\t"<<pred[i].final;
							for(int j = pred[i].WM.size() - 1; j >= 0 ; j --)
								out<<"\t"<<pred[i].wm[j]<<"\t"<<pred[i].WM[j];
							for(int j = 0; j < pred[i].spacer.size(); j ++)
								out<<"\t"<<pred[i].spacer[j];
							out<<endl;
						}
					}
				}
				out.close();
			}
			else if(Temp == "-I"){
				Out += NC + ".ano";
				cout<<integrate(Ptt, Rnt, Out)<<endl;
			}
			/*else if(Temp == "-T"){
				Str List = "F:\\Promoter\\parameters2\\Target.dat";
				Map_Str_Str list = read_in_list(List);
				cout<<test_set(Out,ano,list)<<endl;
			}*/
		}
		return 0;
	}
	else{
		cout<<"Welcome to use SigmaPromoter!!"<<endl
			<<"A novel promoter prediction method based on multiple sigma factors model for bacteria genomes."<<endl
			<<"Developed by Longshu Yang."<<endl
			<<"Copyright: Center for Quantitative Biology, Peking University."<<endl
			<<"Version 1.0. Released at 2015/08/14."<<endl
			<<"This is a brief help file!"<<endl
			<<"1. Functional options:"<<endl
			<<"-I: integrate .ptt and .rnt file into .ano file;"<<endl
			<<"Necessary inputs: -p, -r and -o;"<<endl
			<<"-T: PWM training by EM algorithm;"<<endl
			<<"Necessary inputs: -n, -o, -t and -s;"<<endl
			<<"-S: scanning for sigma factor binding sites;"<<endl
			<<"Necessary inputs: -n, -o, -f, -p (or -a), -w and -h;"<<endl
			<<"Optional inputs: -l, -g, -u and -c."<<endl
			<<"2. Parameters for inputs:"<<endl
			<<"2.1 Inputs with no default value:"<<endl
			<<"-n <NC number> (eg: NC_000913);"<<endl
			<<"-o <output directory>;"<<endl
			<<"-f <.fna file directory>;"<<endl
			<<"-a <.ano file directory>;"<<endl
			<<"-p <.ptt file directory>;"<<endl
			<<"-r <.rnt file directory>;"<<endl
			<<"-h <threshold input file directory>;"<<endl
			<<"-t <Training set sequences directory>;"<<endl
			<<"-w <parameters of scoring scheme file directory>;"<<endl
			<<"-s <file that include sigma factor parameters for position weight matrix>"<<endl
			<<"The file name of these inputs are not required!"<<endl
			<<"2.2 Inputs with default value:"<<endl
			<<"-l <threshold of intergenic distance> (default value is 100);"<<endl
			<<"-g <region length for promoter scanning> (default value is 250)"<<endl
			<<"-u <the chosen number of PWM calculated by user>"<<endl
			<<"if nothing is inputted, the program will utilize the default PWMs,"<<endl
			<<"otherwise four inputted numbers should be seperated by blanks (eg: 1 2 5 26);"<<endl
			<<"-c <the sigma promoters excluded from scanning>" <<endl
			<<"if nothing is inputted, the program will scan for all four sigma promoters,"<<endl
			<<"otherwise inputted sigma promoters should be seperated by blanks (eg: Sigma38 Sigma32 Sigma24)."<<endl;
		return 1;
	}
}
