/*
Promoter scanning module 
Author: Longshu Yang
Latest update: 2013/11/20
Version: 1.0
*/


#include "scan.h"
using namespace std;

//For scanning possible promoters which related to specific sigma factor
Ve_pre scan(Str Sigma, Str DNA, ptt ano, sc sco, int reg, int len, threshold thr){
	Ve_pre result;
	Ve_Str seqs = region(reg, DNA, ano);
	//cout<<seqs[0]<<endl;
	//bool TITLE = false;
	//Ifstream in(Out.data());
	//if(!in)
	//	TITLE = true;
	//in.close();
	//Ofstream out(Out.data(),ios_base::app);
	int start = reg;
	int alt = 1;//all possible spacer choices
	Ve_I alts;//spacer alterations
	for(int i = sco.wm.size() - 1; i >= 0 ; i --)
		start -= sco.wm[i].size();
	if(!sco.min.empty()){
		for(int i = 0; i < sco.min.size(); i ++){
			int s = sco.min[i];		
			//out<<"\tSpacer("<<i<<")";
			start -= s;
			int a = sco.spacer[i].size();
			alt *= a;
			//cout<<alt<<endl;
			alts.push_back(a);
		}
	}
	//if(TITLE)
		//out<<"Sigma\tSynonym\tIntergenic distance\tParallel gene distance\tRelation\tStart site\tFinal score";//Title
	//weight matrix lengthes
	/*for(int i = sco.wm.size() - 1; i >= 0 ; i --){
		start -= sco.wm[i].size();
		if(TITLE){
			if(!i)
				out<<"\t-10 region WM score\t-10 region WM sequence";//Title
			else
				out<<"\t-35 region WM score\t-35 region WM sequence";//Title
		}
		//cout<<sco.wm[i][0]['A']<<endl;
	}
	//minimum spacer lengthes
	if(!sco.min.empty()){
		for(int i = 0; i < sco.min.size(); i ++){
			int s = sco.min[i];		
			//out<<"\tSpacer("<<i<<")";
			if(TITLE)
				out<<"\tSpacer";
			start -= s;
			int a = sco.spacer[i].size();
			alt *= a;
			//cout<<alt<<endl;
			alts.push_back(a);
		}
	}
	if(TITLE)
		out<<endl;*/
	//scanning all genes
	for(int i = 0 ; i < seqs.size(); i ++){
		pre tem;
		tem.Synonym = ano.N2S[i];
		bs best;
		best.final = 0;
		//if(!list[Synonym].empty()){
		//intergenic distance
		tem.dis = dist(tem.Synonym, ano);
		tem.bound = out_range(tem.Synonym, ano);
		tem.Direction = direction(tem.Synonym, ano);
		//cout<<Synonym<<"\t"<<dis<<"\t"<<bound<<endl;
		//LEN to judge whether the intergenic distance is long or short
		bool LEN = false;//default means short
		if(tem.dis >= len)//long
			LEN = true;
		//enumerate all possible spacers
		for(int n = 0; n < alt; n ++){
			int spa = 0;
			De_I sp;
			if(!alts.empty()){
				sp = traversal(n,alts);
				for(int t = 0; t < sp.size(); t ++)
					spa += sp[t];
			}
			//start site (reverse)
			for(int j = 0; j < start - spa; j ++){
				bs temp;
				temp.final = 0;
				int b = j;
				//cout<<"loop: "<<i<<"\t"<<n<<"\t"<<j<<"\t"<<spa<<"\t"<<sp.size()<<endl;
				if(!sp.empty()){
					//sum up spacer scores
					for(int t = 0; t < sp.size(); t ++){
						temp.final += sco.spacer[t][sp[t]];
						//cout<<temp.final<<"\t";
					}
				}
				//sum up wm scores
				for(int k = 0; k < sco.wm.size(); k ++){
					double tp = 0;
					Str Temp = seqs[i].substr(b,sco.wm[k].size());
					for(int l = 0; l < sco.wm[k].size(); l ++)
						tp += sco.wm[k][l][seqs[i][l + b]];
					temp.score.push_back(tp);
					temp.WM.push_back(Temp);
					//cout<<Temp<<"\t"<<temp<<"\t";
					temp.final += tp;
					if(k < sp.size())
						b += sco.wm[k].size() + sp[k] + sco.min[k];
				}
				//if(temp.final>0)
				//	cout<<temp.WM[0]<<"\t"<<temp.WM[1]<<"\t"<<temp.final<<endl;
				//cout<<sum<<endl;
				bool PASS = true;
				if(LEN || tem.Direction == "Div"){
					int last = thr.thl.size() - 1;
					for(int t = 0; t < last; t ++){
						//if(score[t] > thr.thl[t])
						//	cout<<score[t]<<"\t";
						if(temp.score[t] <= thr.thl[t])
							PASS = false;
					}
					if(temp.final <= thr.thl[last])
						PASS = false;
				}
				else{
					int last = thr.ths.size() - 1;
					for(int t = 0; t < last; t ++){
						if(temp.score[t] <= thr.ths[t])
							PASS = false;
					}
					if(temp.final <= thr.ths[last])
						PASS = false;
				}
				if(PASS){
					//check whether the sum score are larger than thresholds
					temp.site = b + sco.wm[sco.wm.size() - 1].size() - reg;
					if(abs(temp.site) < tem.bound && temp.final > best.final){
						best = temp;
						//cout<<tem.Synonym<<"\t"<<best.final<<endl;
						best.sp = sp;
					}
				}
			}
		}
		if(best.final > 0){
			tem.Sigma = Sigma;
			tem.site = best.site;
			tem.final = best.final;
			//cout<<tem.Synonym<<"\t"<<tem.dis<<"\t"<<tem.bound<<"\t"<<tem.site<<endl;
			for(int t = 0; t < best.score.size(); t ++){
				tem.wm.push_back(best.score[t]);
				tem.WM.push_back(best.WM[t]);
			}
			for(int t = 0; t < best.sp.size(); t ++)
				tem.spacer.push_back(best.sp[t] + sco.min[t]);
			result.push_back(tem);
			//cout<<result[0].Synonym<<endl;
		}
		//}
	}
	//out.close();
	cout<<"All promoters regions have been scanned"<<endl;
	return result;
}


